// labeldia.cpp : implementation file
//

#include "stdafx.h"
#include "mfcdemo.h"
#include "labeldia.h"
#include "demotbl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLabelDialog dialog


CLabelDialog::CLabelDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CLabelDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLabelDialog)
	m_ColLabel3D = FALSE;
	m_RowLabel3D = FALSE;
	//}}AFX_DATA_INIT
}

void CLabelDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLabelDialog)
	DDX_Control(pDX, IDC_LABELS_ROWS, m_RowLabels);
	DDX_Control(pDX, IDC_LABELS_COLUMNS, m_ColLabels);
	DDX_Check(pDX, IDC_LABELS_3DCOLS, m_ColLabel3D);
	DDX_Check(pDX, IDC_LABELS_3DROWS, m_RowLabel3D);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLabelDialog, CDialog)
	//{{AFX_MSG_MAP(CLabelDialog)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLabelDialog  
                    
void CLabelDialog::InitializeFrom( CDemoTableControl * aCKTBL )
{                   
	long flags  = aCKTBL->GetFlags();
	cktbl = aCKTBL;
	
   	m_RowLabel3D = (flags&CKTBL_ROWLABEL_3D)!=0;      
	m_ColLabel3D = (flags&CKTBL_COLLABEL_3D)!=0;      
    
}    

void CLabelDialog::ApplyData()
{    
	long mask=0,value=0;
	
	// TODO: Add your control notification handler code here
	      
	cktbl->SetFlagsTo( CKTBL_ROWLABEL_3D, m_RowLabel3D );  
	cktbl->SetFlagsTo( CKTBL_COLLABEL_3D, m_ColLabel3D );  
		      
	mask |= CKTBL_ROWLABEL_MASK;
    switch(m_RowLabels.GetCurSel()) {
    	case 0: value|=CKTBL_ROWLABEL_EMPTY; break;
	   	case 1: value|=CKTBL_ROWLABEL_NUMERIC; break;
 	  	case 2: value|=CKTBL_ROWLABEL_ALPHA; break;  
 	}  
 	
	mask |= CKTBL_COLLABEL_MASK;
    switch(m_ColLabels.GetCurSel()) {
    	case 0: value|=CKTBL_COLLABEL_EMPTY; break;
	   	case 1: value|=CKTBL_COLLABEL_NUMERIC; break;
 	  	case 2: value|=CKTBL_COLLABEL_ALPHA; break;  
 	}  
     	 
   	cktbl->SetFlags( (cktbl->GetFlags() & ~mask) | value);
	cktbl->Invalidate();
}             
/////////////////////////////////////////////////////////////////////////////
// CLabelDialog message handlers

void CLabelDialog::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK(); 
	ApplyData();
}

void CLabelDialog::OnApply()
{
	// TODO: Add your control notification handler code here
	if(UpdateData()) ApplyData();
}

BOOL CLabelDialog::OnInitDialog()
{     
	long flags = cktbl->GetFlags();      
	int sel;
	
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	m_RowLabels.Clear();
	m_RowLabels.AddString( "None" );
	m_RowLabels.AddString( "Numeric" );
	m_RowLabels.AddString( "Alphabetic" );
	
	m_ColLabels.Clear();
	m_ColLabels.AddString( "None" );
	m_ColLabels.AddString( "Numeric" );
	m_ColLabels.AddString( "Alphabetic" );
	
	switch( flags & CKTBL_ROWLABEL_MASK ) {
		case CKTBL_ROWLABEL_EMPTY: 		sel = 0; break;
		case CKTBL_ROWLABEL_NUMERIC: 	sel = 1; break;
		case CKTBL_ROWLABEL_ALPHA: 		sel = 2; break;    
		default: 						sel=0;
	}       
	m_RowLabels.SetCurSel(sel);
	     
	switch( flags & CKTBL_COLLABEL_MASK ) {
		case CKTBL_COLLABEL_EMPTY: 		sel = 0; break;
		case CKTBL_COLLABEL_NUMERIC: 	sel = 1; break;
		case CKTBL_COLLABEL_ALPHA: 		sel = 2; break;    
		default: 						sel=0;
	}       
	m_ColLabels.SetCurSel(sel);
	     
	return TRUE;  // return TRUE  unless you set the focus to a control
}
