#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include "xlib.h"
#include "xrect.h"
#include "icon.h"
#include "animicon.h"
#include "yakFont.h"
#include "yakMouse.h"
#include "yakPal.h"

class star
{
public:
  int x, y, xIncrement, yIncrement, size;
  void initialize(void) {x = 100 + random(100); y = 60 + random(60); size = 5;};
  void advance(void);
  star(void) {initialize();};
};

void star::advance(void)
{
  xIncrement = (x - 150)/5;
  yIncrement = (y-100)/5;
  x+=xIncrement;
  y+=yIncrement;
  size++;
  if ((x < 0) || (x+size > 320)) initialize();
  if ((y < 0) || (y+size > 200)) initialize();
};

extern yakLib myYakLib;
extern yakFont myYakFont;

void stars(void)
{
  randomize();
  icon starIcon, logoIcon;
  animicon shipIcon;
  icon::setZoomTable(64);
  x_set_doublebuffer(200);
  x_text_init();
  myYakFont.use();
  yakPalette myYakPalette("standard.ypl", &myYakLib);
  myYakPalette.put();
  starIcon.load("star.yak", icon::normal, &myYakLib);
  shipIcon.addAll("awayship", icon::normal, &myYakLib);
  logoIcon.load("yicons.yak", icon::normal, &myYakLib);
  int shipX, logoX, y, exit = 0;
  int shipScale=200, logoScale = 1;
  shipX = 50, logoX = 150;
  star stars[10];
  while ((exit != 'Q') && (shipScale > 0))
  {
    x_rect_fill(0,0,320,200,HiddenPageOffs,0);
    for (int starCounter = 0; starCounter < 10; ++starCounter)
    {
      stars[starCounter].advance();
      starIcon.showZoomed(stars[starCounter].x, stars[starCounter].y, HiddenPageOffs, stars[starCounter].size);
    }
    shipScale-=4;
    shipX += 2;
    logoScale += 4;
    logoX -= 2;
    if (shipScale > 1)
      shipIcon.showZoomed(shipX, 20, HiddenPageOffs, shipScale);
    if (logoScale > 1)
      logoIcon.showZoomed(logoX, 20, HiddenPageOffs, logoScale);

    x_page_flip(0,0);
  }
  icon * logoIconPointer = logoIcon.zoomedIcon(logoScale);
  while (exit != 27)
  {
    x_rect_fill(0,0,320,200,HiddenPageOffs,0);
    for (int starCounter = 0; starCounter < 10; ++starCounter)
    {
      stars[starCounter].advance();
      starIcon.showZoomed(stars[starCounter].x, stars[starCounter].y, HiddenPageOffs, stars[starCounter].size);
    }
    logoIconPointer->showMasked(logoX, 20, HiddenPageOffs);
    x_printf(72, 170, HiddenPageOffs, 15, "Press escape to begin demo");
    x_page_flip(0,0);
    if (kbhit())
      exit = getch();
  }
  for (int counter = 0; counter < 25; ++counter)
  {
    myYakPalette.fade(-5);
    myYakPalette.put();
  }
  delete logoIconPointer;
}