#ifndef EVENT.H
#include "event.h"
#endif


void event::advance()
{
  if (thisLine == NULL)
    addCommand(scriptNode::doNothing, 0,0,0,0);
  animactor::advance();
  if (thisFrame->prevFrame == eventIcons[myIconNumber].lastFrame)
    {
    if (spawningActor == NULL)
      remove();			//destroy this copy of the event
    else
       (spawningActor->spawnedActor = NULL);
    delete(this);		//when it's done showing!
    }
}

void event::addAt(int x, int y, int sqx, int sqy) //create a copy of this
{						  //event and put it on
  event * newEvent = new event;		  //the map.  It's destroyed
  if (newEvent == NULL) return;
  newEvent->mapX = x;				  //when its show is over!
  newEvent->mapY = y;
  newEvent->squareX = sqx;
  newEvent->squareY = sqy;
  newEvent->mymap = mymap;
  newEvent->assignEvent(myIconNumber);
  newEvent->spawningActor = NULL;
  newEvent->spawnedActor = NULL;
  newEvent->put(x, y);
}

animicon * event::eventIcons = new animicon[MAX_EVENTS];

void event::loadEvent(int position, char far * filename, yakLib * myYakLib)
{
  event::eventIcons[position].addAll(filename, icon::normal, myYakLib);
}

void event::assignEvent(byte iconNumber, byte identity)
{
  myIconNumber = iconNumber;
  thisFrame = eventIcons[iconNumber].firstFrame;
  if (identity == 255)
    identity = iconNumber;
  myIdentity = identity;
}
