#include "yakfont.h"
#include "xrect.h"
#include "xline.h"
#include "string.h"
#include "conio.h"

void yakFont::load(char * filename, yakLib * myYakLib)
{
  int sizeOfBuffer;
  if (fontData)
    delete fontData;
  if (myYakLib)
  {
    fontData = myYakLib->loadToMem(filename);
    sizeOfBuffer = myYakLib->fileSize(filename);
  }
  else
  {
    ifstream myInStream(filename, ios::binary | ios::in);
    myInStream.seekg(0, ios::end);
    sizeOfBuffer = myInStream.tellg(); //not really!  Just using it!
    fontData = new byte[sizeOfBuffer];
    myInStream.seekg(0);
    myInStream.read(fontData, sizeOfBuffer);
    myInStream.close();
  }
  startChar = *(word *)fontData;
  charHeight = *(byte *)(fontData+2);
  charWidth = *(byte *)(fontData+3);
  numberOfChars = (sizeOfBuffer - 4) / charHeight; //the real numo'Chars
}

void yakFont::registerMe(void)
{
  x_register_userfont(fontData);
}



void yakFont::use(void)
{
  registerMe();
  x_set_font(FONT_USER);
}

void yakFont::save(char * filename)
{
  ofstream myOutStream(filename, ios::binary | ios::in);
  myOutStream.write(fontData, numberOfChars*charHeight + 4);
  myOutStream.close();
}

