#include "yakscrol.h"
#include "yakmouse.h"
#include <string.h>
#include <conio.h>

extern yakMouse mouse;
//yakScroller functions follow------------------------------------------>

void yakScroller::draw(word offset)
{
  yakWindow::draw(offset);
  drawText(offset);
}

word yakScroller::interpretMouseClick(void)
{
  if (mouse.isInBox(x+2, y, x+width-2, y+2))
    lineMove(up, myOffset);
  if (mouse.isInBox(x+2, y+height-2, x+width-2, y+height-1))
    lineMove(down, myOffset);
  yakWindow::interpretMouseClick();
  return 0;
}

word yakScroller::interpretKeyStroke(char myChar)
{
  if (myChar == 0)
  {
    myChar = getch();
    switch(myChar)
    {
      case 72 : lineMove(up, myOffset); break;
      case 80 : lineMove(down, myOffset); break;
//	case 75 : cursor.mapX--; break;
//	case 77 : cursor.mapX++; break;
//	case 71 : cursor.mapY--; cursor.mapX--; break;
      case 73 : pageMove(up, myOffset); break;
//	case 79 : cursor.mapY++; cursor.mapX--; break;
      case 81 : pageMove(down, myOffset); break;
    }
  }
  if (myChar == 27)
    close();
  return 0;
}
char * yakScroller::getLine(word lineNumber)
{
  byte exit = 0;
  byte charsInALine = (width - 5) / CharWidth;
  int counter;
  char * thisLine = myText;
  char * lineCounter; //position of line
  word currentLineNumber = 0; //number of line
  while((*thisLine != 0) && (currentLineNumber != lineNumber))
  {
    exit = 0;
    for (counter = 0, lineCounter = thisLine; counter < charsInALine; ++counter)
    {
      if (*lineCounter == 0x0d)
      {
        thisLine = lineCounter + (((char)*(lineCounter + 1) == (char)0x0a) ? 2 : 1);
        lineCounter = thisLine;
        currentLineNumber++;
        exit = 1;
      }
      if (!exit) ++lineCounter;
    }
    while (!exit)//lineCounter >= thisLine)
    {
      if (*lineCounter == ' ')
      {
	currentLineNumber++;
	thisLine = lineCounter + 1;
	exit = 1;
      }
      else if (*lineCounter == 0)
	return lineCounter;
      else if (lineCounter == thisLine)
      {
	lineCounter = thisLine = thisLine + charsInALine;
	currentLineNumber++;
	exit = 1;
      }
      else
	lineCounter--;
    }
  }
  return thisLine;
}

int yakScroller::lineLength(word lineNumber)
{
  char * thisLine = getLine(lineNumber);
  byte charsInALine = (width - 5) / CharWidth;
  for (int counter = 0; counter <= charsInALine; ++counter)
    if ((* (thisLine + counter) == 0) || (* (thisLine + counter) == 13))
      return(counter);
  for (counter = charsInALine; counter >= 0; --counter)
    if (*(thisLine+counter) == ' ')
      return counter;
  return charsInALine;
}

void yakScroller::drawLine(int lineNumber, int x, int y, word offset)
{
  int charsInALine = (width - 5) / CharWidth;
  char *thisLine = new char[charsInALine];
  int thisLineLength = lineLength(lineNumber);
  strncpy(thisLine, getLine(lineNumber), thisLineLength);
  for (int counter = thisLineLength; counter < charsInALine; ++counter)
    thisLine[counter] = ' ';
  thisLine[charsInALine] = 0;
  x_bgprintf(x, y, offset, textColor, boxColor, "%s", thisLine);
  delete thisLine;
}

void yakScroller::drawText(int lineNumber, int ix, int iy, word offset)
{
  x = ix;
  y = iy;
  byte linesInABox = (height - CharHeight - 5) / CharHeight;
  for(int lineCounter = 0; lineCounter < linesInABox; ++lineCounter)
    drawLine(lineCounter + lineNumber, ix+3, iy+CharHeight+3+lineCounter*CharHeight, offset);
}

void yakScroller::drawText(int lineNumber, word offset)
{
  drawText(lineNumber, x, y, offset);
}

void yakScroller::drawText(word offset)
{
  drawText(position, x, y, offset);
}

void yakScroller::lineMove(direction pageDirection, word offset)
{
  position += (pageDirection == down) ? 1 : -1;
  drawText(offset);
}

void yakScroller::pageMove(direction lineDirection, word offset)
{
  position += (lineDirection == down) ? ((height - 15) / CharHeight) : -((height - 5) / CharHeight);
  if (position < 0) position = 0;
  drawText(offset);
}

void yakScroller::newText(byte * theNewText) //deletes old text!
{
  if (myText)
    delete myText;
  myText = theNewText;
  position = 0;
}

void yakScroller::activate(int x1, int y1, int x2, int y2, word offset, char * theNewText)
{
  width = x2-x1;
  height = y2-y1;
  newText(theNewText);
  activate(x, y, offset);
}

void yakScroller::activate(int ix, int iy, word ioffset)
{
  myOffset = ioffset;
  x = ix; y = iy;
  open();
  char exit = 0;
  while (exit != 27)
  {
    exit = getch();
    interpretKeyStroke(exit);
  }
}
