/****************************************************************************/
/*                   inmoscon.h                                             */
/*                                                                          */
/*  This file contains the Inmos Transputer specific defines.               */
/*  Rename to config.h when compiling for Inmos B004 and compatibles.       */
/*  Provided by Parham Data Products for use on the 8401 card.              */
/*  For more info please contact :                                          */
/*                                                                          */
/*        Wayne Parham [President, Parham Data]                             */
/*        Phone: (918) 663-2131                                             */
/*        Internet: 74224.2176@compuserve.com                               */
/*        Compuserve: 74224,2176                                            */
/*                                                                          */
/*  Based on core from Persistence of Vision Raytracer                      */
/*  Copyright 1993 Persistence of Vision Team                               */
/*  ----------------------------------------------------------------------  */
/*  Copying, distribution and legal info is in the file povlegal.doc which  */
/*  should be distributed with this file. If povlegal.doc is not available  */
/*  or for more info please contact:                                        */
/*                                                                          */
/*       Chris Young  [POV-Team Leader]                                     */
/*       CIS: 76702,1655  Internet: 76702.1655@compuserve.com               */
/*                                                                          */
/* This program is based on the popular DKB raytracer version 2.12.         */
/* DKBTrace was originally written by David K. Buck.                        */
/* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/* The following constants are needed by various POV modules.  Each has     */
/* a default (shown below) which is will be defined in frame.h if you don't */
/* define them here.                                                        */
/*                                                                          */
/* #define EPSILON 1.0e-10               - a small value used for POLY      */
/* #define FILE_NAME_LENGTH 150          - default file name length         */
/* #define HUGE_VAL 1.0e+17              - a really big number              */
/* #define DBL_FORMAT_STRING "%lf"       - the string for scanfs of doubles */
/* #define DEFAULT_OUTPUT_FORMAT  'd'    - the default +f format            */
/* #define RED_RAW_FILE_EXTENSION ".red" - for +fr, extension for red file  */
/* #define GREEN_RAW_FILE_EXTENSION ".grn"  - ditto for the green file      */
/* #define BLUE_RAW_FILE_EXTENSION ".blu"   - ditto again for the blue file */
/* #define FILENAME_SEPARATOR "/"        - The/path/seperation/char         */
/* #define CASE_SENSITIVE_DEFAULT 2     - controls sensitivity in DAT files */
/* #define READ_FILE_STRING "rb"        - special binary (raw, uncooked)    */
/* #define WRITE_FILE_STRING "wb"         modes of fopen()                  */
/* #define APPEND_FILE_STRING "ab"                                          */
/*                                                                          */
/* These routines are required by POV to compute trace times.  The defaults */
/* shown below are defined in most versions of C.  You may redefine them if */
/* your compiler doesn't support these.  If time is completely unsupported  */
/* define them as 0.                                                        */
/*                                                                          */
/* #define START_TIME time(&tstart);                                        */
/* #define STOP_TIME  time(&tstop);                                         */
/* #define TIME_ELAPSED difftime (tstop, tstart);                           */
/*                                                                          */
/* Note difftime can be replaced with #define TIME_ELAPSED (tstop - tstart);*/ 
/* in some cases.                                                           */
/*                                                                          */
/* These are optional routines that POV calls.  You may define them         */
/* or if undefined they will be defined as empty in frame.h.                */
/*                                                                          */
/* #define STARTUP_POVRAY              - first executable statement of main */
/*                                       (useful for initialization)        */
/* #define PRINT_OTHER_CREDITS         - used for people who extend         */
/*                                       the machine specific modules       */
/* #define TEST_ABORT                  - code to test for ^C or abort       */
/*                                       (called on each pixel)             */
/* #define FINISH_POVRAY               - last statement before exiting      */
/* #define COOPERATE                   - called for multi-tasking           */
/* #define COMPILER_VER .compilername  - compiler name and version          */
/* #define CONFIG_MATH                 - useful for machine specific math   */
/* #define DBL double                  - floating point precision           */
/* #define ACOS acos                   - arc cosine of DBL                  */
/* #define SQRT sqrt                   - square root of DBL                 */
/* #define POW pow                     - x to the y power - x, y DBL        */
/* #define COS cos                     - cosine of DBL                      */
/* #define SIN sin                     - sine of DBL                        */
/* #define labs(x) (long) ((x<0)?-x:x) - absolute value of long integer x   */
/* #define max (x,y) ((x<y)?y:x)       - greater of x and y                 */
/*                                                                          */
/* On some systems "sprintf" returns the string rather than the length      */
/* of the string.  If the string is returned, define the following:         */
/*                                                                          */
/* #define STRLN(x) strlen(x)          - string length                      */
/*                                                                          */
/* #define setvbuf(w,x,y,z)            - some systems don't understand      */
/*                                       setvbuf.  If not, just define      */
/*                                       it away  -  it's not critical      */
/*                                       to  the raytracer.   It  just      */
/*                                       buffers disk accesses.             */
/*                                                                          */
/* This macro controls prototyping and is required by POV.  Choose one      */
/* of the two options below or if left undefined it will default to ANSI    */
/* in frame.h                                                               */
/*                                                                          */
/* #define PARAMS (x) x                  - do ANSI prototyping              */
/* #define PARAMS (x) ()                 - do K&R non-ANSI prototyping      */
/*                                                                          */
/* These allow command line vs non-command line versions and alternate      */
/* main routines.  Normally they should be undefined.                       */
/*                                                                          */
/* #define ALTMAIN 1                                                        */
/* #define NOCMDLINE 1                                                      */
/*                                                                          */
/****************************************************************************/

#include <stdarg.h>
#include <stdlib.h>

#define RED_RAW_FILE_EXTENSION   ".r8"  /* PICLAB's "RAW" file format */
#define GREEN_RAW_FILE_EXTENSION ".g8"  /* PICLAB's "RAW" file format */
#define BLUE_RAW_FILE_EXTENSION  ".b8"  /* PICLAB's "RAW" file format */

#define FILENAME_SEPARATOR "\\"         /* DOS file structure uses \  */

#define DEFAULT_OUTPUT_FORMAT   't'

#define TEST_ABORT if (Options & EXITENABLE) if (kbhit()) { Stop_Flag = TRUE; getch(); }

#define PRINT_CREDITS Print_Credits();

#define COMPILER_VER ".93.1a for Inmos T800"

#define MAX_TRACE_LEVEL 5

#define STARTUP_POVRAY Config_Transputer_RAM();

#define TIME_ELAPSED (tstop - tstart);

#define setvbuf(w,x,y,z)

/* Defines for machine-specific PaletteOption settings                      */

#define NORMAL    '0'
#define GREY      'G'
#define HSV       '0'
#define P_332     '3'
#define HICOLOR   'H'           /* 16 bits/pixel "high" color */
#define FULLCOLOR 'T'           /* 24 bits/pixel "true" color */

#ifndef READ_ENV_VAR_BEFORE 
#define READ_ENV_VAR_BEFORE if ((Option_String_Ptr = getenv("POVRAYOPT")) != NULL) read_options(Option_String_Ptr);
#endif
#ifndef READ_ENV_VAR_AFTER
#define READ_ENV_VAR_AFTER     
#endif

void Config_Transputer_RAM(void);
void Print_Credits(void);

