/*
FONTDLG.C
David Mikelson (100141,1006)
26 May 94

Demonstrates how to give the ChooseFont common dialog the BWCC look.
   (And, to get the Sample text to update properly)

The only purpose is to demonstrate the ChooseFontHookProc.
   Error checking, tight code is negligible.

I'm sure this is not the only way, but "It works for me".

Read up on Customizing Common Dialog Templates in the manuals (Borland
   and Microsoft).  I only cover the mechanical part briefly as follows:

	* Use RW to copy the font dialog out of COMMDLG.DLL and paste it
	  into your .RC file. I called my dialog BWCCChooseFont.
	* Give this the class 'bordlg'.
	* Edit the dialog.  Drag all the ugly group boxes and other
	  control you don't want out of the way but don't delete them.
	* Drag the 'Sample' text box off the screen.  You will later
	  hide the unwanted controls in the Hook.
	* Add Borland group boxes.
	* Delete the OK and CANCEL buttons, but recreate them right away
	  using BorButtons.  Be sure the OK button gets an ID of 1 and Cancel 2.
	* Drag the Help (ID=1038) button off the screen.  Create a new
	  BorButton with ID=998.
	* Create a Borland static text box that will be your new Sample
	  text.  In this example, the ID is IDD_MYSAMPLE.

The skeletal stuff in WinMain and WndProc is taken from
   Programming Windows by Charles Petzold.

The font specific things are mine, and anyone is free to use them.


I used Borland's C++4 IDE, small model, smart callbacks
My project file includes the following

	FONTDLG.C
	FONTDLG.DEF
	FONTDLG.RC
	BWCC.LIB

*/


#include <windows.h>
#include <mem.h>
#include <dlgs.h> 		// Identifies the controls on the Windows common dialog templates.
#include <commdlg.h>		// Common dialogs
#include <cderr.h>		// Common dialog errors
#include <bwcc.h>			// BWCC

#define IDD_FONT 100
#define IDD_HELP 998
#define DEFER_UPDATE 101
#define IDD_MYSAMPLE 102

WPARAM wParamDummy;
LPARAM lParamDummy;
LPSTR lpDummy;
HANDLE hInstanceMain;	// For ChooseFont

HFONT hgFont; 				// The font the ChooseFont Hook Proc will use.
LOGFONT lfNormal;			// The font your application might use.

long FAR PASCAL 	WndProc(HWND,WORD,WORD,LONG);
UINT CALLBACK 		ChooseFontHookProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

/*******************************************************************************************
 WinMain
*******************************************************************************************/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{

static char szAppName[]="ChooseFont Demo";
HWND        hwnd;
MSG         msg;
WNDCLASS    wndclass;

lpDummy=lpszCmdParam;

// Force compiler to generate code to load BWCC.DLL
// Does anyone know how to trap a BWCC.DLL not found error?
BWCCGetVersion();

hInstanceMain=hInstance;

if (!hPrevInstance) {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc     = (WNDPROC)WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor         = LoadCursor (NULL, IDC_ARROW);
	wndclass.hbrBackground   = GetStockObject (WHITE_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;
	RegisterClass(&wndclass);
	}

hwnd=CreateWindow(szAppName,
						"BWCC ChooseFont Demo",
						WS_OVERLAPPEDWINDOW,
						CW_USEDEFAULT,
						CW_USEDEFAULT,
						CW_USEDEFAULT,
						CW_USEDEFAULT,
						NULL,
						NULL,
						hInstance,
						NULL);

ShowWindow(hwnd, nCmdShow);
UpdateWindow(hwnd);
while(GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}
return msg.wParam;
}

/**************************************************************************
 WndProc
**************************************************************************/
long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
HDC hdc;
TEXTMETRIC tm;
int cxChar, cyChar;

static int DidChoose;

CHOOSEFONT cf;

switch(message) {

	case WM_CREATE:

      // Make a button on the main window
		hdc=GetDC(hwnd);
		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		ReleaseDC(hwnd,hdc);
		CreateWindow("button","BWCCFont",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
		10,10,11*cxChar,2*cyChar,hwnd,IDD_FONT,hInstanceMain,NULL);
      DidChoose=0; 
		return(0);

	case WM_COMMAND:

		// Fill in CHOOSEFONT structure
		memset(&cf,0,sizeof(CHOOSEFONT));
		cf.lStructSize=sizeof(CHOOSEFONT);
		cf.hwndOwner=hwnd;
		cf.hDC=NULL;
      if (DidChoose==0) {
			// lfNormal would normally contain a fully predefined font so initialization would be more exiting
			lfNormal.lfHeight=NULL;
			lfNormal.lfFaceName[0]=0;
         }
		cf.lpLogFont=&lfNormal;
      cf.nFontType=SCREEN_FONTTYPE;
		cf.Flags=CF_INITTOLOGFONTSTRUCT|CF_FORCEFONTEXIST|CF_EFFECTS|CF_SCREENFONTS;
      cf.Flags=cf.Flags|CF_ENABLETEMPLATE|CF_ENABLEHOOK;
		cf.hInstance=hInstanceMain;
		cf.lpTemplateName="BWCCChooseFont";
		cf.lpfnHook=ChooseFontHookProc;
		cf.rgbColors=RGB(0,0,0);
		// Do the dialog
		if (ChooseFont(&cf)!=0)
			DidChoose=1;

		return(0);

	case WM_DESTROY:
		PostQuitMessage(0);
		return(0);
	}
return DefWindowProc(hwnd, message, wParam, lParam);
}

/******************************************************************************************************************
 ChooseFontHookProc
******************************************************************************************************************/
UINT CALLBACK ChooseFontHookProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
/*

* The first key is the WM_CHOOSEFONT_GETLOGFONT message

* The second key is to give the dialog box enough time to decide what its
	  current font is (with the DEFER_UPDATE trick).  If you try to get
     the font as soon as the user changes something, the sample doesn't
	  actually get updated until the NEXT change.  The sample always
	  lags one change behind the user.  I did not try to understand
	  exactly why this happens, I have a few theories, but no time.

* My DEFER_UPDATE seems a bit of a kludge, but it works.
	  I welcome suggestions regarding cleaner methods.

* Note that I hide the Colors stuff and the strike-out box,
     so I don't process them

*/

LOGFONT lf;

wParamDummy=wParam;
lParamDummy=lParam;

switch(msg) {

	case WM_INITDIALOG:
		// Hide the controls you don't want or have supplied your own controls for (like group boxes)
		// The ID's are defined in <dlgs.h>
		ShowWindow(GetDlgItem(hDlg,psh15),SW_HIDE); 	// Help
		ShowWindow(GetDlgItem(hDlg,grp1),SW_HIDE); 	// Effects
		ShowWindow(GetDlgItem(hDlg,stc4),SW_HIDE); 	// Colors
		ShowWindow(GetDlgItem(hDlg,cmb4),SW_HIDE); 	// Colors
		ShowWindow(GetDlgItem(hDlg,stc6),SW_HIDE); 	// This is a true type font... message
		ShowWindow(GetDlgItem(hDlg,chx1),SW_HIDE); 	// Strikeout
		ShowWindow(GetDlgItem(hDlg,stc5),SW_HIDE); 	// Sample
		ShowWindow(GetDlgItem(hDlg,grp2),SW_HIDE); 	// Sample
		ShowWindow(GetDlgItem(hDlg,psh3),SW_HIDE); 	// Apply

		SetDlgItemText(hDlg,IDD_MYSAMPLE,"My sample text 123");

		PostMessage(hDlg,WM_COMMAND,DEFER_UPDATE,0L);
		return(TRUE);

	case WM_COMMAND:

		switch (wParam) {

			// Process the Borland help button (ID=998) if you want
			// case IDD_HELP:
				// WinHelp(hDlg,szHelpFile,HELP_CONTEXT,SomeContext);
				// return(TRUE);

			case cmb1: // New face name selected
			case cmb2: // New style selected
			case cmb3: // New point size selected

				if (HIWORD(lParam)==CBN_SELCHANGE)
					// CBN_SELCHANGE is sent if an item is selected from the list box
					PostMessage(hDlg,WM_COMMAND,DEFER_UPDATE,0L);
				if (HIWORD(lParam)==CBN_KILLFOCUS)
					// This is in case user manually enters a value rather than selecting it from the list box.
					// Sample updates when user clicks in another control.
					PostMessage(hDlg,WM_COMMAND,DEFER_UPDATE,0L);

				return(FALSE);

			case chx1: // Strikeout check box
			case chx2: // Underline
				PostMessage(hDlg,WM_COMMAND,DEFER_UPDATE,0L);
				return(FALSE);

			case DEFER_UPDATE:
				if (hgFont!=NULL)
					DeleteObject(hgFont);
            // Have the font dialog box tell us what font is descibed
				SendMessage(hDlg,WM_CHOOSEFONT_GETLOGFONT,0,(LONG)(LPSTR)&lf);
            // Create that font
				hgFont=CreateFontIndirect(&lf);
            // Change the sample text to that font
				SendDlgItemMessage(hDlg,IDD_MYSAMPLE,WM_SETFONT,(WPARAM)hgFont,(LPARAM)MAKELONG((WORD)TRUE,0));
				return(TRUE);

			default:

				break;

			}

		break;

	case WM_DESTROY:
		if (hgFont!=NULL)
			DeleteObject(hgFont);
		hgFont=NULL;
		return(FALSE);
	}
return(FALSE);
}

