
                  '''''''''''''''''''''''''''''''''''''''''
                  ' Copyright 1993, 1994, Philip C. Danby '
                  '                                       '
                  '''''''''''''''''''''''''''''''''''''''''
!Do not edit this file except with PED.EXE. Other editors may truncate it.!

Overview
|COVERVIEW
|C
PbArchitect is a set of development tools for Power Basic which emphasize
interface design and operation. Complex Menus and dialog boxes are designed
in a dynamic run time data file called the Command/Data File [CDF].

The CDF is composed of named modules each of which contains the complete
information to define a Menu system or a dialog box. Other modules may
contain only lists of information, which may be changed by the program, such
as:
                Color Information
                Default Data Directories
                Picklists

The CDF is designed in conjunction with the requirements of the program, 
however it will usually use many modules contained in existing CDFs, 
sometimes with minor modifications. PbArchitect contains many useful modules
in the CDFs supplied with it.

Many copies of a program specific CDF may be used so that individual users
may store their particular default conditions. Foreign language versions are
also easily created from the basic CDF.

PbArchitect includes an Interface System Developer which provides the user
with the means to develope rapidly Menu Systems and Dialog Boxes.

PbArchitect also integrates all aspects of the user interface so that the 
programmer is left with little, if any, housekeeping tasks.

PbArchitect also includes:

                A full featured Editor,
                A memo writer with word wrap,
                File storage and selection routines,
                A programmer configurable Color Mapping routine and,
                Many utility routines.


Menus
|CMENUS
|C
The Menu System is configured in the Command/Data File [CDF]. Examples of
the CDF modules used to define menus are given in the Menu Demonstration.

Typical code to implement a Menu System would be:

  DO
    CALL getmodule("MENU", m$(), rm$(), firstch, nextch)
    ec = smartmenu(wparms, m$(), state$, smmode, %CMENU)
    CALL putmodule(m$(), rm$(), firstch, nextch)
    if ec = 27 then choice = -1
    SELECT CASE choice
      CASE 1
        ' call corresponding application
      CASE 2
        .
        .
        .                      
      CASE -1
        EXIT LOOP
    END SELECT
  LOOP


In this example "MENU" is the name given to the menu definition module,
m$() and rm$() are dynamically dimensioned arrays, %CMENU instructs the
routine to color the menu with the colors as set up by the Color Mapping
function.
Extra code is required if any of the menu items are lockable, one line of
code for each lockable item.



Dialog Boxes
|CDIALOG BOXES
|C
Each Dialog Box is defined in the Command/Data File [CDF]. Examples of the
CDF modules used to define Dialog Boxes are given in the Dialog Box
Demonstration.

Dialog Boxes may be called from the program in a variety of ways:

  In its most general form the call is:

           ec = pdialog(di(), "DLGNAME", a$(), v$(), %CDLG)

In this example "DLGNAME" is the name given to the dialog box menu definition
module, a$() and v$() are dynamically dimensioned arrays; a$() is used to 
transfer data in and out of pdialog(), v$() is used to transfer program 
dependent text information for insertion into text displays.

%CDLG instructs the routine to color the Dialog Box with the colors as set up
by the Color Mapping function.

  A simpler form may be used when neither a$() or v$() are needed:

           ec = EasyDialog(di(), "ANOTHERNAME", %CDLG)

For the advanced programmer PbArchitect allows access to two functions, which
are contained within pdialog(), to create fully integrated Dialog Boxes with
almost unlimited configurations.




Interface System Developer
|CINTERFACE SYSTEM DEVELOPER
|C
PbArchitect`s Interface System Developer provides the means to develope, 
quickly and easily, Menu Systems and Dialog Boxes.

It comprises a full screen editor for adding modules to the Command/Data File
[CDF], and a Test routine which highlights any syntax errors in the 
designated module and displays the Menu or Dialog Box in a fully interactive
manner.

A typical session would comprise the following steps:

At the DOS command line type: PBAISD new.cdf        [new.cdf is name of CDF]


                  In editor: type in module name                [MYMODULE]
                               
                             type in module text
                               
                             type in terminator                         []
                               
                            Press Alt-T                        [select Test]            
                               
                              From module name picklist select MYMODULE
                               
                      Syntax Error Message           [only if error present]        
                               
                          Ŀ
                        Editor     Help                         
                                    
                         Read help screen, press Esc
                                                  
                       
                       
       In Editor: correct Syntax or Layout Error
                              
                       Press Alt-R                     [recall module test]
                              
        Module runs, check for layout and key functions
                              
                         Ŀ
                  Layout Error    OK
               
                                 Press Alt-X                      [Exit ISD]    


                         

System Integration
|CSYSTEM INTEGRATION
|C
The PbArchitect system provides:

                    Mouse control
                    Hotkeys defined in smartmenu()
                    Programmer defined Hotkeys
                    User mappable Color Layout
                    25,43 or 50 lines Screen Display

Provided that the program code contains the required initialisation routine
PBAInit() supplied with PbArchitect the above features will work in unison 
without requiring intervention by the programmer.
If a program requires a user interface function not covered by those included
in PbArchitect it will be automatically integrated provided that it uses for
Mouse and Keyboard input the routine poll() and references some global
variables relating to screen output which are initialised by PBAInit().

Editor                         
|CEDITOR
|C
The routine pbaedit() supplied with PbArchitect is a full screen editor
which incorporates the following features:

        Find & Find/Replace
        Go to Line
        Block Marking
        Block Copy, Cut, Paste
        Tab movement of Marked Blocks
        Undo Function, number of actions limited by memory
        Line Delete [Ctrl-Y]
        Extended Character insertion
        User settable Tab Spaces
        Maximum Text Length 32750 characters
        Maximum Line Length 255 characters

The program PBAWRITE.EXE demonstrates all the features of pbaedit().

Memo Writer                       
|CMEMO WRITER
|C
The routine pbamemo() supplied with PbArchitect is a full screen memo
writer with Automatic Word Wrap which incorporates the following features:

        Find & Find/Replace
        Go to Line
        Block Marking
        Block Copy, Cut, Paste
        Undo Function, number of actions limited by memory
        Line Delete [Ctrl-Y]
        Extended Character insertion
        User settable Tab Spaces
        Maximum Text Length 32750 characters
        Maximum Line Length user settable to 78 characters

The program PBAWRITE.EXE demonstrates all the features of pbamemo().

                                              

Line Editor
|CLINE EDITOR
|C
The routine pledit() supplied with PbArchitect is a line editor with the
following features.

        Programmer definable field size
        Scroll mode permitting entry of text longer than field size
        Clear mode clears existing text if first keystroke is printable
        Calculator mode allows entry of arithmetic expressions
        Masks may be used to format entry
        Insert and overstrike mode toggled with Ins key 
        Numeric mode for special handling of formatted decimal input
        Programmer definable exit keys
        Password entry mode

Two special purpose line editor functions are also supplied which handle
Time and Date entry; TimeEdit() and DateEdit(). Both check for data validity.


Utilities
|CUTILITIES
|C
Included with PbArchitect are many utilities, these include:    

String Utilities:

Array2Strg........concatenates elements of a string array with delimiter
                  characters interposed.
Calculators$..... returns stringized value of arithmetic expression.
FmtHex$...........returns Hexadecimal string of input value.
GetEnclosedItem$..returns nth element in string in which each element is
                  enclosed by a given delimiter, eg ^aaa^^bbbb^.
GetStrgElement$...returns nth element in string in which each element is
                  divided by a given delimiter, eg ^aaa^bbbb^.
InsertStrg........inserts one string in another at a given position.
LastName$.........moves last word in string to beginning, can also return
                  last word only.                                        
Ljust$............creates string of n spaces and overwrites input string at
                  left end of string.                      
OutsideQuotes.....finds first occurrence of one string within another 
                  provided that it is not within double quotes.
Rclip$............returns input string with rightmost n characters removed.
Rextract$.........reverse of PowerBasic EXTRACT$, operates from right hand
                  end of string.
Rinstr............reverse of PowerBasic INSTR, operates from right hand end 
                  of string.
Soundex$..........returns Soundex code for input string.
Strg2Array........Breaks string into array determined by delimiters string.
                  Automatically redimensions array upwards as necessary.
SyntaxCheck.......Performs syntax check on arithmetic string. Returns 
                  position of error or TRUE if unmatched braces.

File Utilities
        
ChCurDir..........similar to PowerBasic CHDIR but returns TRUE if path is
                  invalid.
CompFileStamp.....returns value indicating existence of two files and 
                  comparison of their date/time stamps.
DisketteStatus....indicates if diskette drive not ready, diskette write
                  protected or unformatted.
DiskSpace&........returns available space on indicated disk.
File2strg.........reads binary file into string up to 32750 length.
File2strgArray....reads binary file into string array.
GetDefaultDriveLetter$..returns currents drive letter
GetDefaultPath$...returns current drive and path
ReadDir...........similar to PowerBasic DIR$ but also returns time/date stamp.
SetMaxFiles.......set number of files which can be opened at one time.
SetNewPath........sets new drive and path as default, returns TRUE if path
                  invalid.
Strg2file.........writes string to a binary file
StrgArray2file....writes string array to a binary file inserting CRLF
                  delimiters.
StrgIntoOpenFile..writes string into a binary file between two positions
                  in the file. Expands or truncates the file as necessary.
VerifyDrive.......returns TRUE if drive letter invalid or, for diskette,
                  drive not ready.

Screen Display Utilities

ArrayBrowse.......displays string array on screen, uses conventional keys or
                  mouse to scroll, integrated in PbArchitect system.
ArrayView.........displays string array on screen.

Window Utilities

AutoWinRestore....restores last opened window.
CenterBox.........centers window coordinates in screen.
ChangeWin.........user interactive routine to move or resize window.
ChangeWinSize.....redimensions a window.
ClearFrame........clears the screen within a window frame.
DrawBox...........draws a box on the screen in different formats.
DrawFrame.........calls drawbox() to frame a window.
DrawHorizArrows...draws horizontal scroll bar.
DrawVertArrows....draws vertical scroll bar.
InitArrows........initializes parameters for scroll bar routines.
LastWin?..........returns the handle of the last opened window.
WinAvoid..........calculates window coordinates so that the window will not
                  cover another window.                        
Winclear..........clears the window of text
WinMove...........moves widow by one row or one column.
WinOpen...........creates new window handle, stores underlying screen, draws
                  frame as required.
WinParmFetch......returns window coordinates given the window handle.
WinPosition.......checks window coordinates for validity, if not valid will
                  first decrement row and column and then, if necessary, will
                  decrement height and width.
WinResize.........resizes window by one row or one column.
WinRestore........restores text of underlying screen.

GENERAL UTILITIES

ArrayWidth........returns width of longest element in a string array.
ElementWide.......returns width of longest delimiter separated element in 
                  string.
Hibyte............returns high byte of integer.
Hinibble..........returns high nibble of byte.
kbstatus..........returns status codes for shift, ctrtl, alt etc. keys.
Lobyte............returns low byte of integer.
Lonibble..........returns low nibble of byte.
StrgChar2val......returns value of given character in string.
deedah............makes short, two tone sound.
FindNextWord......finds first character of next word in a string.
FindPrevWord......finds first character of previous word in string.
GetLocalColor.....gets color attribute at a given pixel on the screen.
GetProgramName$...gets path and name of currently executing program.
GetProgramPath$...gets path of currently executing program.
KbFlush...........flushes the keyboard buffer.
KbRateDelay(n)....sets typematic delay and rate.
MakeDirArray......creates array of filenames which match a given template.
NumUnlock.........turns off keyboard numlock.
SetBackIntens.....permits use of 16 background colors.
SetColor..........use in place of PowerBasic COLOR statement when using 16
                  background colors.
ShortBeep.........short audible warning
StrgArrayCopy.....copys one string array to another, redimensions target
                  array upwards as necessary
vShortBeep........very short audible warning


