Comment
==================================================================

This section contains the logic for processing IF statements. I'm
writing an interpreter language in MarxMenu. You can add your own
conditionals for IniTyme here.

==================================================================
EndComment

Var
  SearchList
  SearchListNot
  HardwareList
  HardwareRead
  GroupsRead


Procedure ReadGroupList
   if GroupsRead then Return
   if NovConnection > 0
      NovReadGroups(NovLoginName,GroupList)
      SortArray(GroupList)
   endif
   GroupsRead
EndProc


Procedure SetupHardwareList
var C
   if HardwareRead then Return
   AppendArray(HardwareList,DisplayType)
   if ColorScreen
      AppendArray(HardwareList,'COLOR')
   else
      AppendArray(HardwareList,'MONO')
   endif

   C = CpuClass
   if C = 1
      AppendArray(HardwareList,'8086')

   elseif C = 2
      AppendArray(HardwareList,'80286')

   elseif C = 3
      AppendArray(HardwareList,'80386')

   elseif C = 4
      AppendArray(HardwareList,'80486')

   endif

   if EmsInstalled then AppendArray(HardwareList,'EMS')
   if XmsInstalled then AppendArray(HardwareList,'XMS')
   if Mouse then AppendArray(HardwareList,'MOUSE')
   if McpClass > 0 then AppendArray(HardwareList,'MATH')
   SortArray(HardwareList)
   HardwareRead
EndProc


Procedure PushStack (V)
   AppendArray(Stack,V)
EndProc


Procedure PopStack
var X
   if NumberOfElements(Stack) = 0
      Error ('Stack Empty!',LoopIndex)
   endif
   X = Stack[NumberOfElements(Stack)]
   delete(Stack,NumberOfElements(Stack),1)
   Return X
EndProc


Procedure Nugget
var Word P FirstChar
   Trim(IfLine)
   FirstChar = Left(IfLine,1)
   Word = NextWord(IfLine)

   if FirstChar Within('0','9')
      PushStack(Value(Word))

   elseif (FirstChar = '"') or (FirstChar = "'")
      PushStack(Word)

   else
      P = Hash('!' + Word)
      if P <> Nil
         Run P
      else
         Error ('Word "' + Word + '" not Recognized!',LoopIndex)
      endif
   endif

EndProc


Procedure Interpret
   while IfLine > ''
      Nugget
   endwhile
EndProc


Procedure ExecValueOf
var V P St
   V = UpperCase(NextWord(IfLine))
   if Right(V,1) <> '=' then V = V + '='
   P = FindLine(V)
   if P = 0
      PushStack('')
   else
      St = Orig[P]
      delete(St,1,pos('=',St))
      Trim(St)
      PushStack(St)
   endif
EndProc


Procedure MakeSearchList
var P St St2
   if IfLine StartsWith '='
      delete(IfLine,1,1)
      Trim(IfLine)
   endif

   P = Pos(' ',IfLine)
   if P = 0 then P = Length(IfLine) + 1

   St = left(IfLine,P-1)
   delete(IfLine,1,P)

   dispose(SearchList)
   dispose(SearchListNot)

   while St > ''
      St2 = Uppercase(NextWord(St))
      if St2 StartsWith '!'
         delete(St2,1,1)
         AppendArray(SearchListNot,St2)
      else
         AppendArray(SearchList,St2)
      endif
   endwhile
EndProc


Procedure ExecGroups
   ReadGroupList
   MakeSearchList

   Loop SearchListNot
      if PosInSortedList(LoopVal,GroupList) > 0
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      if PosInSortedList(LoopVal,GroupList) > 0
         PushStack True
         Return
      endif
   EndLoop

   PushStack False
EndProc


Procedure ExecHardware
   SetupHardwareList
   MakeSearchList

   Loop SearchListNot
      if PosInSortedList(LoopVal,HardwareList) > 0
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      if PosInSortedList(LoopVal,HardwareList) > 0
         PushStack True
         Return
      endif
   EndLoop

   PushStack False
EndProc


Procedure ExecStation
   PushStack(NovStationAddress)
EndProc


Procedure ExecStations
var S
   if NovConnection > 0
      S = NovStationAddress
   else
      S = %S_STATION%
      if S = ''
         S = %STATION%
      endif
   endif
   MakeSearchList

   if S = ''
      PushStack False
      Return
   endif

   Loop SearchListNot
      if pos(LoopVal,S) > 0
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      if pos(LoopVal,S) > 0
         PushStack True
         Return
      endif
   EndLoop

   PushStack False
EndProc


Procedure ExecNetwork
var N
   if NovConnection > 0
      N = 'NOVELL'
   else
      N = %S_NETWORK%
   endif
   MakeSearchList

   if N = ''
      PushStack False
      Return
   endif

   Loop SearchListNot
      if LoopVal = N
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      if LoopVal = N
         PushStack True
         Return
      endif
   EndLoop

   PushStack False
EndProc


Procedure ExecUsers
var U
   if NovConnection > 0
      U = NovLoginName
   else
      U = %S_USER%
      if U = ''
         U = %USERNAME%
      endif
   endif
   MakeSearchList

   if U = ''
      PushStack False
      Return
   endif

   Loop SearchListNot
      if LoopVal = U
         PushStack False
         Return
      endif
   EndLoop

   Loop SearchList
      if LoopVal = U
         PushStack True
         Return
      endif
   EndLoop

   PushStack False
EndProc


;- Not Supported
Procedure ExecRev
   IfLine = ''
   dispose(Stack)
   PushStack True
EndProc


Procedure ExecPlus
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A + B)
EndProc


Procedure ExecMinus
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A - B)
EndProc


Procedure ExecEqual
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A = B)
EndProc


Procedure ExecNotEqual
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A <> B)
EndProc


Procedure ExecGreater
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A > B)
EndProc


Procedure ExecLess
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A < B)
EndProc


Procedure ExecGreaterEqual
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A >= B)
EndProc


Procedure ExecLessEqual
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A <= B)
EndProc


Procedure ExecAnd
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A and B)
EndProc


Procedure ExecOr
var A B
   Nugget
   B = PopStack
   A = PopStack
   PushStack(A or B)
EndProc


Procedure ExecNot
   Nugget
   PushStack(not PopStack)
EndProc


Procedure ExecUpperCase
   Nugget
   PushStack(UpperCase(PopStack))
EndProc


Procedure ExecLeftParen
var OldParenLevel
   OldParenLevel = ParenLevel
   ParenLevel = ParenLevel + 1
   repeat
      Nugget
   until ParenLevel = OldParenLevel
EndProc


Procedure ExecRightParen
   ParenLevel = ParenLevel - 1
EndProc


Procedure ExecIf
var B
   Interpret

   ;- Multiple conditionals are ANDed

   B = PopStack
   while NumberOfElements Stack > 0
      B = B and PopStack
   endwhile

   if not B
      LoopIndex = GoToList[LoopIndex]
   endif
EndProc


Procedure ExecGoTo
   LoopIndex = GoToList[LoopIndex]
EndProc


Procedure ExecInGroup
var Group
   ReadGroupList
   Group = UpperCase(NextWord(IfLine))
   PushStack(PosInSortedList(Group,GroupList) > 0)
EndProc


Procedure ExecExistFile
   PushStack(ExistFile(UpperCase(NextWord(IfLine))))
EndProc


Procedure ExecExistDir
   PushStack(ExistDir(UpperCase(NextWord(IfLine))))
EndProc


Procedure ExecEnvVar
   PushStack(ReadEnv(UpperCase(NextWord(IfLine))))
EndProc


Procedure ExecCPU
   PushStack(CPUClass)
EndProc


Procedure ExecMathChip
   PushStack(McpClass > 0)
EndProc


Procedure ExecUserName
   PushStack(NovLoginName)
EndProc


Procedure ExecDisplay
var Disp
   Disp = DisplayType

   if Disp = 0
      PushStack 'HERC'

   elseif Disp = 1
      PushStack 'CGA'

   elseif Disp = 3
      PushStack 'EGA'

   elseif Disp = 4
      PushStack 'VGA'

   else
      PushStack ''

   endif
EndProc


Procedure ExecDayOfWeek
var D
   D = DayOfWeek

   if D = 0
      PushStack 'SUN'

   elseif D = 1
      PushStack 'MON'

   elseif D = 2
      PushStack 'TUE'

   elseif D = 3
      PushStack 'WED'

   elseif D = 4
      PushStack 'THU'

   elseif D = 5
      PushStack 'FRI'

   elseif D = 6
      PushStack 'SAT'

   endif
EndProc


Procedure ExecMonth
var D
   D = Month

   if D = 1
      PushStack 'JAN'

   elseif D = 2
      PushStack 'FEB'

   elseif D = 3
      PushStack 'MAR'

   elseif D = 4
      PushStack 'APR'

   elseif D = 5
      PushStack 'MAY'

   elseif D = 6
      PushStack 'JUN'

   elseif D = 7
      PushStack 'JUL'

   elseif D = 8
      PushStack 'AUG'

   elseif D = 9
      PushStack 'SEP'

   elseif D = 10
      PushStack 'OCT'

   elseif D = 11
      PushStack 'NOV'

   elseif D = 12
      PushStack 'DEC'

   endif
EndProc


Procedure SetupLibWords
   HashLevel = 1
   Hash ('!(')           = Loc ExecLeftParen
   Hash ('!)')           = Loc ExecRightParen
   Hash ('!+')           = Loc ExecPlus
   Hash ('!-')           = Loc ExecMinus
   Hash ('!<>')          = Loc ExecNotEqual
   Hash ('!<')           = Loc ExecLess
   Hash ('!>')           = Loc ExecGreater
   Hash ('!<=')          = Loc ExecLessEqual
   Hash ('!>=')          = Loc ExecGreaterEqual
   Hash ('!=')           = Loc ExecEqual
   Hash ('!AND')         = Loc ExecAnd
   Hash ('!OR')          = Loc ExecOr
   Hash ('!NOT')         = Loc ExecNot
   Hash ('!GOTO')        = Loc ExecGoto
   Hash ('!IF')          = Loc ExecIf
   Hash ('!INGROUP')     = Loc ExecInGroup
   Hash ('!GROUPS')      = Loc ExecGroups
   Hash ('!STATIONS')    = Loc ExecStations
   Hash ('!USERS')       = Loc ExecUsers
   Hash ('!NETWORK')     = Loc ExecNetwork
   Hash ('!STATION')     = Loc ExecStation
   Hash ('!USERNAME')    = Loc ExecUserName
   Hash ('!VALUEOF')     = Loc ExecValueOf
   Hash ('!UPPERCASE')   = Loc ExecUpperCase
   Hash ('!EXISTFILE')   = Loc ExecExistFile
   Hash ('!EXISTDIR')    = Loc ExecExistDir
   Hash ('!ENVVAR')      = Loc ExecEnvVar
   Hash ('!READENV')     = Loc ExecEnvVar
   Hash ('!CPU')         = Loc ExecCPU
   Hash ('!MATHCHIP')    = Loc ExecMathChip
   Hash ('!DISPLAY')     = Loc ExecDisplay
   Hash ('!DAYOFWEEK')   = Loc ExecDayOfWeek
   Hash ('!MONTH')       = Loc ExecMonth
   Hash ('!HARDWARE')    = Loc ExecHardWare
   Hash ('!REV')         = Loc ExecRev
EndProc

