// INPUT.C -- Input routines for IPXTEST
// by Allen Brunson  06/01/94


#include <conio.h>     // kbhit()
#include <string.h>    // strcmp(), strcpy(), strlen(), strupr()
#ifdef _MSC_VER        // If a Microsoft compiler
#include <graph.h>     // settextcursor(), settextposition()
#endif
#include "ipxtest.h"   // IPXtest-specific defines


/****************************************************************************/
/*                                                                          */
/***  Global data                                                         ***/
/*                                                                          */
/****************************************************************************/

char cmdStr[MAXCOLS];                              // Command string
byte inputFlag = FALSE;                            // End of input flag

struct COMMAND cmd[CMDTOTAL] =                     // Command strings
  {
    {"B",         cBROADCAST},                     // Broadcast
    {"BROADCAST", cBROADCAST},                     // Broadcast
    {"CLS",       cCLS},                           // Clear screen
    {"D",         cDISPLAY},                       // Display users
    {"DISPLAY",   cDISPLAY},                       // Display users
    {"F",         cFLURRY},                        // Flurry mode
    {"FLURRY",    cFLURRY},                        // Flurry mode
    {"H",         cHELP},                          // Help
    {"HELP",      cHELP},                          // Help
    {"M",         cMESSAGE},                       // Message
    {"MESSAGE",   cMESSAGE},                       // Message
    {"N",         cNAME},                          // Name
    {"NAME",      cNAME},                          // Name
    {"P",         cPING},                          // Ping packet
    {"PING",      cPING},                          // Ping packet
    {"S",         cSTAT},                          // Statistics
    {"STAT",      cSTAT},                          // Statistics
    {"Q",         cQUIT},                          // Quit
    {"QUIT",      cQUIT},                          // Quit
  };


/****************************************************************************/
/*                                                                          */
/***  cmdHelp()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure displays a list of user commands.                            */

void cmdHelp(void)                                 // Begin cmdHelp()
  {
    message("");
    message("Commands:");
    message("BROADCAST, B [message]          Broadcast message to all users");
    message("CLS                             Clear the screen");
    message("DISPLAY, D                      Show known users");
    message("FLURRY, F [ON | OFF | RESET]    Toggle flurry sends, reset count");
    message("HELP, H                         Print this message");
    message("MESSAGE, M [usernum] [message]  Send message to one user");
    message("NAME, N [name]                  Set your name");
    message("PING, P                         Update known users");
    message("STAT, S [RESET]                 Display or reset ECB statistics");
    message("QUIT, Q                         End the program");
    message("");
    message("The text of a received message is interpreted as a command.");
    message("");
    message("Keys:");
    message("F1                              Same as HELP");
    message("F3                              Recall last command line");
    message("Esc                             Clear command line");
    message("");
  }                                                // End cmdHelp()


/****************************************************************************/
/*                                                                          */
/***  cmdProcess()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure processes commands entered by the user.                      */

void cmdProcess(void)                              // Begin cmdProcess()
  {
    word i, j;                                     // Loop variables
    byte iFlag;                                    // Copy of input flag

    if (inputFlag == FALSE) return;                // Return if no input

    iFlag = inputFlag;                             // Save input flag
    inputFlag = FALSE;                             // Clear input flag

    if (strlen(cmdStr) == 0) return;               // Return if zero-length

    j = 0; while (cmdStr[j] == ' ') j++;           // Go past spaces

    for (i = 0; cmdStr[j] != 0 &&                  // Copy first word from
     cmdStr[j] != ' '; i++, j++)                   //  cmdStr to str
      str[i] = cmdStr[j];

    str[i] = 0; strupr(str);                       // str to uppercase

    for (i = 0; i < CMDTOTAL; i++)                 // Loop for all commands
      if (!strcmp(str, cmd[i].str))                // If a match is found
        switch (cmd[i].code)                       // Decision on code
          {
            case cBROADCAST:                       // Broadcast
              if (iFlag == 2) return;              // Ignore remote requests
              sendBroadcast();                     // Call sendBroadcast()
              return;

            case cCLS:                             // CLS
              vidCLS();                            // Call vidCLS()
              return;

            case cDISPLAY:                         // Display
              userDisplay();                       // Display users
              return;

            case cFLURRY:                          // Flurry
              sendFlurryMode();                    // Set flurry mode
              return;

            case cHELP:                            // Help
              cmdHelp();                           // Display command help
              return;

            case cMESSAGE:                         // Message
              if (iFlag == 2) return;              // Ignore remote requests
              sendMessage();                       // Call sendMessage()
              return;

            case cNAME:                            // Name
              setName();                           // Set user name
              return;

            case cPING:                            // Ping
              sendPing();                          // Send ping packet
              return;

            case cSTAT:                            // Statistics
              statDisplay();                       // Display statistics
              return;

            case cQUIT:                            // Quit
              endProgram = TRUE;                   // Set endProgram flag
              return;
          }

    if (iFlag == 1)                                // If not a remote command
      {
        message("");
        message("Unrecognized command.  "          // Display this message
         "Press F1 for list.");                    //  if no match found
        message("");
      }
  }                                                // End cmdProcess()


/****************************************************************************/
/*                                                                          */
/***  getKeys()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure processes one key of user input at a time.  When Enter is
pressed, it copies the command string to cmdStr.                            */

void getKeys(void)                                 // Begin getKeys()
  {
    static char inputStr[MAXCOLS];                 // Input string
    static char inputStrOld[MAXCOLS];              // Previous string
    static char inputLen;                          // Input length

    word key;                                      // Key value

    if (!kbhit()) return;                          // Return if no keys

    key = getch();                                 // Get the key
    if (!key) key = 0x7500 + getch();              // Get "special" keys

    if (key == 0x754D) key = (word) ' ';           // Right arrow to space

    switch(key)                                    // Decision on key
      {
        case 0x753B:                               // F1 key
          strcpy(cmdStr, "H");                     // Set "help" string
          inputFlag = TRUE;                        // Input is ready
          return;

        case 0x753D:                               // F3 key
          strcpy(inputStr, inputStrOld);           // Copy old inputStr
          inputLen = strlen(inputStr);             // Set new input length
          iCol = inputLen + 2;                     // Set new column
          cursorOff();                             // Turn off cursor
          gotoxy(2, iRow);                         // Go to line start
          cprintf(inputStr);                       // Print string
          gotoxy(iCol, iRow);                      // Update cursor pos
          cursorOn();                              // Turn on cursor
          return;

        case 0x000D:                               // Enter (fall thru to ESC)
          strcpy(cmdStr, inputStr);                // Copy string to cmdStr
          strcpy(inputStrOld, inputStr);           // Save for F3 use
          inputFlag = TRUE;                        // Input is ready

        case 0x001B:                               // Esc
          iCol = 2;                                // Go to left column
          cursorOff();                             // Turn off cursor
          gotoxy(iCol, iRow);                      // Cursor to left column
          cprintf(strBlank);                       // Print blank string
          gotoxy(iCol, iRow);                      // Cursor to left column
          cursorOn();                              // Turn on cursor
          inputStr[0] = 0;                         // Clear out inputStr
          inputLen = 0;                            // Clear input length
          return;

        case 0x0008: case 0x754B:                  // Backspace, left arrow
          if (iCol <= 2) return;                   // Return if at left side
          iCol--;                                  // Go back one column
          gotoxy(iCol, iRow);                      // Position cursor
          putch(' ');                              // Destroy old character
          gotoxy(iCol, iRow);                      // Position cursor
          inputLen--;                              // Subtract one key
          inputStr[inputLen] = 0;                  // Remove it from string
          return;

        default:                                   // Any other key
          if (key < 32 || key > 254) return;       // Throw away non-ASCIIs
          if (iCol >= cols - 1) return;            // Return if too far right
          putch(key); iCol++;                      // Put key on screen
          inputStr[inputLen] = (char) key;         // Put key in string
          inputLen++; inputStr[inputLen] = 0;      // Terminate string
          return;
      }                                            // End switch()
  }                                                // End getKeys()
