// IPXTEST.C -- Main source file for IPXTEST
// by Allen Brunson  06/01/94


#include "ipxtest.h"         // IPXtest-specific defines
#include "ipxcfg.h"          // IPXLIB configuration defines


/****************************************************************************/
/*                                                                          */
/***  Global data                                                         ***/
/*                                                                          */
/****************************************************************************/

byte endProgram = FALSE;                           // End program flag
char str[100];                                     // Scratch string


/****************************************************************************/
/*                                                                          */
/***  main()                                                              ***/
/*                                                                          */
/****************************************************************************

This is the program's main procedure.                                       */

byte main(void)                                    // Begin main()
  {
    demoStart();                                   // Start up subsystems

    while (!endProgram)                            // Main program loop
      {
        getKeys();                                 // Get input keys
        cmdProcess();                              // Process commands
        while (ipxRecvChk()) recvPacket();         // Process packets
        sendFlurry();                              // Send flurry packets
        sendErr();                                 // Check for send errors
      }

    demoStop();                                    // Stop subsystems

    return FALSE;                                  // Return errorlevel 0
  }                                                // End main()
