// IPXTEST.H -- Defines for IPXtest, a demo program for the IPX routines
// by Allen Brunson  06/01/94


#ifdef _MSC_VER                  // If a Microsoft compiler
#pragma warning (disable:4018)   // Disable erroneous signed/unsigned warning
#ifndef M_I86SM                  // If not small model
#error IPXtest designed for the SMALL memory model
#endif
#endif

#ifdef __TURBOC__                // If a Borland compiler
#ifndef __SMALL__                // If not small model
#error IPXtest designed for the SMALL memory model
#endif
#endif

#include "ipx.h"                 // IPXLIB defines
#include "ipxcfg.h"              // IPXLIB configuration defines


/****************************************************************************/
/*                                                                          */
/***  General definitions                                                 ***/
/*                                                                          */
/****************************************************************************/

#ifndef  TRUEFALSE                                 // If TRUEFALSE not set
#define  TRUEFALSE                                 // Define it
#define  FALSE               0                     // Boolean false
#define  OFF                 0                     //  defines
#define  NO                  0
#define  TRUE                1                     // Boolean true
#define  ON                  1                     //  defines
#define  YES                 1
#endif

#ifndef  BYTE                                      // If BYTE not yet defined
#define  BYTE                                      // Set definition
typedef  unsigned char byte;                       // Typedef byte type
#endif
#ifndef  WORD                                      // If WORD not yet defined
#define  WORD                                      // Set definition
typedef  unsigned int  word;                       // Typedef word type
#endif


//#define  DEBUG                                   // Un-comment for DEBUG


/****************************************************************************/
/*                                                                          */
/***  Macros                                                              ***/
/*                                                                          */
/****************************************************************************/

#ifdef _MSC_VER                                    // If a Microsoft compiler
#define  cursorOn()  _settextcursor(0x0707)        // Turn cursor on
#define  cursorOff() _settextcursor(0x2000)        // Turn cursor off
#define gotoxy(col, row) \
  _settextposition((int) row, (int) col)           // gotoxy() macro
#else                                              // If a Borland compiler
#define  cursorOn()  _setcursortype(_NORMALCURSOR) // Turn cursor on
#define  cursorOff() _setcursortype(_NOCURSOR)     // Turn cursor off
#endif


/****************************************************************************/
/*                                                                          */
/***  Network data definitions                                            ***/
/*                                                                          */
/****************************************************************************/

#define NAMELEN            12                       // Length of name string
#define MSGLEN             70                       // Max message length
#define USERTOTAL          30                       // Total users

#define SIGNATURE      0x913F                       // Packet signature

#define pPING          0x3001                       // Ping packet
#define pPINGRESPONSE  0x3002                       // Ping response
#define pBROADCAST     0x3003                       // Broadcast message
#define pMESSAGE       0x3004                       // Directed message
#define pFLURRY        0x3005                       // Flurry packet

struct IPXTESTPKT                                   // IPXTEST packet
  {
    word signature;                                 // Signature word
    word type;                                      // Packet type
    word ipxRecvMax;                                // Receive ECB stat
    word ipxSendMax;                                // Send ECB stat
    char name[NAMELEN + 1];                         // Name string
    char msg[MSGLEN + 1];                           // Message string
  };

struct USER                                         // Info on one user
  {
    byte inUse;                                     // struct in use or not
    word ipxRecvMax;                                // Receive ECB stat
    word ipxSendMax;                                // Send ECB stat
    struct IPXADDRFULL addr;                        // Address of user
    char name[NAMELEN + 1];                         // Name of user
  };


/****************************************************************************/
/*                                                                          */
/***  Network data structure                                              ***/
/*                                                                          */
/****************************************************************************

If the define DEBUG at the top of this file is TRUE, then IPXTEST will use
the following structure as the IPXLIB memory block.  This is useful for
viewing the contents of IPX structures during debugging.  If DEBUG is
FALSE, then a block of malloc()'ed memory will be used instead.             */

struct IPXDATA                                     // IPX data structure
  {
    #if    IPXRECVCNT                              // If receive count >= 1
    struct ECB         recvECB[IPXRECVCNT];        // Receive ECBs
    struct IPXPKTHDR   recvHdr[IPXRECVCNT];        // Receive packet headers
    #if    IPXDATASIZE                             // If IPXDATASIZE >= 1
    byte   recvBuf[IPXRECVCNT][IPXDATASIZE];       // Receive buffers
    #endif
    struct IPXEVENT    recvQueue[IPXRECVCNT];      // Receive event queue
    #endif
    #if    IPXSENDCNT                              // If send count >= 1
    struct ECB         sendECB[IPXSENDCNT];        // Send ECBs
    struct IPXPKTHDR   sendHdr[IPXSENDCNT];        // Send packet headers
    #if    IPXDATASIZE                             // If IPXDATASIZE >= 1
    byte   sendBuf[IPXSENDCNT][IPXDATASIZE];       // Send buffers
    #endif
    struct IPXEVENT    sendQueue[IPXSENDCNT];      // Send event queue
    #endif
  };


/****************************************************************************/
/*                                                                          */
/***  Command definitions                                                 ***/
/*                                                                          */
/****************************************************************************/

#define CMDTOTAL    19                             // Cmd total, plus dupes

#define cBROADCAST   1                             // Broadcast message
#define cCLS         2                             // Clears the screen
#define cDISPLAY     3                             // Displays known users
#define cFLURRY      4                             // Flurry mode
#define cHELP        5                             // Help
#define cMESSAGE     6                             // Targeted message
#define cNAME        7                             // Set name
#define cPING        8                             // Send ping packet
#define cSTAT        9                             // Statistics
#define cQUIT       10                             // Quit program

struct COMMAND                                     // Command structure
  {
    char *str;                                     // Command string
    word code;                                     // Command code
  };


/****************************************************************************/
/*                                                                          */
/***  Color and screen definitions                                        ***/
/*                                                                          */
/****************************************************************************/


#define  cBACKGRND      1                          // Background color
#define  cFOREGRND      7                          // Foreground color

#define  MAXCOLS 100                               // Max screen columns


/****************************************************************************/
/*                                                                          */
/***  Global data definitions                                             ***/
/*                                                                          */
/****************************************************************************/

extern byte endProgram;                            // End program flag
extern char str[100];                              // Scratch string

extern char cmdStr[MAXCOLS];                       // Command string
extern byte inputFlag;                             // End of input flag

extern byte cols, rows;                            // Screen size
extern byte iCol, iRow;                            // Input window cursor pos
extern byte mCol, mRow;                            // Main window cursor pos
extern char strBlank[MAXCOLS + 1];                 // Blank line string

extern struct USER user[USERTOTAL];                // User info


/****************************************************************************/
/*                                                                          */
/***  Function declarations                                               ***/
/*                                                                          */
/****************************************************************************/

// INPUT.C                                         // Input processing

void cmdHelp(void);                                // Displays help message
void cmdProcess(void);                             // Processes commands
void getKeys(void);                                // Collects keyboard input


// NETWORK.C                                       // High-level IPX funcs

void netStart(void);                               // Sets up network stuff
void netStop(void);                                // Stops network stuff
void recvBroadcast(void);                          // Processes broadcasts
void recvMessage(void);                            // Processes messages
void recvPacket(void);                             // Processes incoming pkts
void recvPing(void);                               // Processes pings
void recvPingResponse(void);                       // Processes ping response
void sendBroadcast(void);                          // Sends broadcast
void sendErr(void);                                // Checks for send errors
void sendFlurry(void);                             // Sends "flurry" packets
void sendFlurryMode(void);                         // Sets flurry mode
void sendMessage(void);                            // Sends message
void sendPing(void);                               // Sends ping packet
void setName(void);                                // Sets user name
void statDisplay(void);                            // Displays statistics
void userClear(void);                              // Clears user table
void userDisplay(void);                            // Displays known users
void userSave(void);                               // Saves info on user


// PROCESS.C                                       // Misc processing

void demoStart(void);                              // Starts up subsystems
void demoStop(void);                               // Stops subsystems
word err(word error);                              // Displays error messages


// VIDEO.C                                         // Video routines

void message(char *str);                           // Displays screen message
void vidCLS(void);                                 // Clears the screen
void vidScroll(void);                              // Scrolls main window
void vidStart(void);                               // Starts up video stuff
void vidStop(void);                                // Stops video stuff
