// IPXUTIL.C -- IPX utility routines
// by Allen Brunson  06/01/94


#ifdef __TURBOC__            // If a Borland compiler
#include <mem.h>             // memcpy(), memset()
#else                        // If a Microsoft compiler
#include <memory.h>          // memcpy(), memset()
#endif

#include <stdio.h>           // sprintf()
#include "ipx.h"             // IPXLIB defines


/****************************************************************************/
/*                                                                          */
/***  ipxAddrBrd()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure sets the node address and immediate address fields of an
IPXADDRFULL structure to FFFFFFFFFFFFh, making it suitable for broadcasting
packets to all addresses on one network segment.                            */

void ipxAddrBrd(struct IPXADDRFULL *ipxAddr)       // Begin ipxAddrBrd()
  {
    memset(&ipxAddr->node, 0xFF, 6);               // Set node address
    memset(&ipxAddr->immedAddr, 0xFF, 6);          // Set immediate address
  }                                                // End ipxAddrBrd()


/****************************************************************************/
/*                                                                          */
/***  ipxAddrCmp()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure compares the network, node, and socket numbers of two
IPXADDRFULL structures.  It returns FALSE if the two addresses are equal,
-1 if the first is less than the second, or 1 if the first is greater than
the second.                                                                 */

int ipxAddrCmp(struct IPXADDRFULL *ipxAddr1,       // Begin ipxAddrCmp()
 struct IPXADDRFULL *ipxAddr2)
  {
    word i;                                        // Loop counter
    byte *addr1;                                   // First pointer
    byte *addr2;                                   // Second pointer

    addr1 = (byte *) ipxAddr1;                     // Point at the two
    addr2 = (byte *) ipxAddr2;                     //  series of bytes

    for (i = 0; i < 12; i++)                       // Loop for each byte
      {
        if (addr1[i] < addr2[i]) return -1;        // If less than
        if (addr1[i] > addr2[i]) return  1;        // If greater than
      }

    return FALSE;                                  // All bytes were the same
  }                                                // End ipxAddrCmp()


/****************************************************************************/
/*                                                                          */
/***  ipxAddrCpy()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure copies the contents of one IPXADDRFULL structure to another. */

void ipxAddrCpy(struct IPXADDRFULL *ipxAddrDst,    // Begin ipxAddrCpy()
 struct IPXADDRFULL *ipxAddrSrc)
  {
    memcpy(ipxAddrDst, ipxAddrSrc,                 // Copy contents
     sizeof (struct IPXADDRFULL));
  }                                                // End ipxAddrCpy()


/****************************************************************************/
/*                                                                          */
/***  ipxAddrStr()                                                        ***/
/*                                                                          */
/****************************************************************************

This procedure accepts a pointer to an IPXADDRFULL structure and a pointer
to a string and fills the string with a text representation of the network
and node address.  The string should contain at least 22 bytes.  It returns
a pointer to the string.                                                    */

char *ipxAddrStr(char *str,                        // Begin ipxAddrStr()
 struct IPXADDRFULL *ipxAddr)
  {
    sprintf(str,                                   // Format output string

     "%02X%02X%02X%02X:%02X%02X%02X%02X%02X%02X",  // Format string

     ipxAddr->net[0], ipxAddr->net[1],             // Net address
     ipxAddr->net[2], ipxAddr->net[3],

     ipxAddr->node[0], ipxAddr->node[1],           // Node address
     ipxAddr->node[2], ipxAddr->node[3],
     ipxAddr->node[4], ipxAddr->node[5]);

    return str;                                    // Return string pointer
  }                                                // End ipxAddrStr()


/****************************************************************************/
/*                                                                          */
/***  ipxAddrStrLong()                                                    ***/
/*                                                                          */
/****************************************************************************

This procedure accepts a pointer to an IPXADDRFULL structure and a string
and fills the string with a text representation of all four components of
the address.  The string should contain at least 40 bytes.                  */

char *ipxAddrStrLong(char *str,                    // Begin ipxAddrStrLong()
 struct IPXADDRFULL *ipxAddr)
  {
    sprintf(str,                                   // Format output string

     "%02X%02X%02X%02X:%02X%02X%02X%02X%02X%02X:"  // Format string
     "%02X%02X:%02X%02X%02X%02X%02X%02X",

     ipxAddr->net[0], ipxAddr->net[1],             // Net address
     ipxAddr->net[2], ipxAddr->net[3],

     ipxAddr->node[0], ipxAddr->node[1],           // Node address
     ipxAddr->node[2], ipxAddr->node[3],
     ipxAddr->node[4], ipxAddr->node[5],

     ipxAddr->socket & 0x00FF,                     // Socket, swapped from
     ipxAddr->socket >> 8,                         //  hi-lo order

     ipxAddr->immedAddr[0], ipxAddr->immedAddr[1], // Immediate address
     ipxAddr->immedAddr[2], ipxAddr->immedAddr[3],
     ipxAddr->immedAddr[4], ipxAddr->immedAddr[5]);

    return str;                                    // Return string pointer
  }                                                // End ipxAddrStrLong()
