// PROCESS.C -- Miscellaneous routines for IPXTEST
// by Allen Brunson  06/01/94


#include <conio.h>     // getch()
#include <stdio.h>     // sprintf()
#include "ipxtest.h"   // IPXtest-specific defines


/****************************************************************************/
/*                                                                          */
/***  demoStart()                                                         ***/
/*                                                                          */
/****************************************************************************

This procedure starts up the various subsystems and displays opening
messages.                                                                   */

void demoStart(void)                               // Begin demoStart()
  {
    vidStart();                                    // Start video

    message("IPXTEST -- Test program for IPXLIB"); // Display opening
    message("by Allen Brunson  v0.20  06/01/94");  //  messages
    message("");
    message("Press F1 for help");                  // Display help message
    message("");                                   //  reminder

    netStart();                                    // Start up net stuff
  }                                                // End demoStart()


/****************************************************************************/
/*                                                                          */
/***  demoStop()                                                          ***/
/*                                                                          */
/****************************************************************************

This procedure shuts down the various subsystems.                           */

void demoStop(void)                                // Begin demoStop()
  {
    netStop();                                     // Shut down IPXLIB

    message("");                                   // Print a blank line
    message(                                       // Display final message
     "Program finished.  Press a key to exit.");
    getch();                                       // Get a key

    vidStop();                                     // Reset screen
  }


/****************************************************************************/
/*                                                                          */
/***  err()                                                               ***/
/*                                                                          */
/****************************************************************************

This procedure displays an error message for each of the possible IPXLIB
errors.                                                                     */

word err(word error)                               // Begin err()
  {
    switch (error)                                 // Decision on error
      {
        case ipxeNOERR:                            // No error
          return error;                            // Return

        case TRUE:                                 // TRUE
          return error;                            // Return

        case ipxeNOIPX:                            // IPX not loaded
          message("IPX driver not loaded.");
          return error;

        case ipxeIPXNOTSTARTED:                    // ipxStart() not called
          message("IPX not started.");
          return error;

        case ipxeIPXSTARTED:                       // ipxStart() called twice
          message("IPX is already started.");
          return error;

        case ipxeBADCOMMPARMS:                     // Bad ipxStart() parms
          message("Improper communication parameters.");
          return error;

        case ipxeMEMTOOSMALL:                      // Memory block too small
          message("IPX memory block is too small.");
          return error;

        case ipxeSOCKETTABLEFULL:                  // Socket table full
          message("No free IPX sockets.");
          return error;

        case ipxeSOCKETOPEN:                       // Socket already open
          message("Selected socket is in use.");
          return error;

        case ipxeSOCKETNOTOPEN:                    // Socket not open
          message("Socket isn't open.");
          return error;

        case ipxeNOFREESENDECB:                    // No free send ECBs
          message("No free send ECBs.");
          return error;

        case ipxeRECVCANCEL:                       // Receive event canceled
          message("Receive event was canceled.");
          return error;

        case ipxeSENDCANCEL:                       // Send was canceled
          message("Send event was canceled.");
          return error;

        case ipxeRECVPKTTOOBIG:                    // Received packet too big
          message("Received packet was too big for buffer.");
          return error;

        case ipxeSENDPKTBAD:                       // Sent packet bad
          message("Sent packet was malformed.");
          return error;

        case ipxeSENDBADROUTE:                     // Can't send packet
          message("Couldn't deliver packet.");
          return error;

        case ipxeSENDNETFAIL:                      // Hardware failure
          message("Hardware or network failure!");
          return error;

        default:                                   // Unknown error
          sprintf(str, "Unknown error %d.", error);
          message(str);
          return error;
      }
  }                                                // End err()
