// VIDEO.C -- Video routines for IPXTEST
// by Allen Brunson  06/01/94


#ifdef _MSC_VER        // If a Microsoft compiler
#include <graph.h>     // _settextcursor(), _settextcolor()
#include <memory.h>    // memset()
#else                  // If a Borland compiler
#include <mem.h>       // memset()
#endif

#include <conio.h>     // cputs(), gettextinfo()
#include <string.h>    // strlen()
#include "ipxtest.h"   // IPXtest-specific defines


/****************************************************************************/
/*                                                                          */
/***  Screen data                                                         ***/
/*                                                                          */
/****************************************************************************/

byte cols, rows;                                   // Screen size
byte iCol, iRow;                                   // Input window cursor pos
byte mCol, mRow;                                   // Main window cursor pos

char strBlank[MAXCOLS + 1];                        // Blank line string


/****************************************************************************/
/*                                                                          */
/***  message()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure prints a message to the upper screen window.                 */

void message(char *str)                            // Begin message()
  {
    if (strlen(str) > cols - 2)                    // If string is too
      str[cols - 2] = 0;                           //  long, truncate it

    cursorOff();                                   // Turn off cursor

    if (mRow == rows - 1) vidScroll();             // Scroll if at bottom

    gotoxy(mCol, mRow); cputs(str); mRow++;        // Print string

    gotoxy(iCol, iRow);
    cursorOn();                                    // Turn on cursor
  }                                                // End message()


/****************************************************************************/
/*                                                                          */
/***  vidCLS()                                                            ***/
/*                                                                          */
/****************************************************************************

This procedure clears the upper window.                                     */

void vidCLS(void)                                  // Begin vidCLS()
  {
    word i;                                        // Loop counter

    cursorOff();                                   // Turn off the cursor

    for (i = 2; i <= (unsigned) rows - 2; i++)     // Loop for all rows
      {
        gotoxy(2, i);                              // Go to a row
        cputs(strBlank);                           // Blank it
      }

    gotoxy(iCol, iRow);                            // Go to input window
    cursorOn();                                    // Turn on cursor

    mCol = 2; mRow = 2;                            // Set new position
  }                                                // End vidCLS()


/****************************************************************************/
/*                                                                          */
/***  vidScroll()                                                         ***/
/*                                                                          */
/****************************************************************************

This procedure scrolls the main text window up one row.                     */

void vidScroll(void)                               // Begin vidScroll()
  {
    #ifdef __TURBOC__                              // If a Borland compiler

    word buf[MAXCOLS - 2];                         // Screen buffer
    word i;                                        // Loop counter

    for (i = 2; i <= rows - 3; i++)                // Loop for all rows in
      {                                            //  window except last
        gettext(2, i+1, cols - 1, i+1, buf);       // Get a row
        puttext(2, i, cols - 1, i, buf);           // Print it one row up
      }

    gotoxy(2, rows - 2); cputs(strBlank);          // Blank line at bottom

    mRow--;                                        // Move up one row

    #else                                          // If a Microsoft compiler

    vidCLS();                                      // Just clear the screen

    #endif
  }                                                // End vidScroll()


/****************************************************************************/
/*                                                                          */
/***  vidStart()                                                          ***/
/*                                                                          */
/****************************************************************************

This procedure sets up the screen.                                          */

void vidStart(void)                                // Begin vidStart()
  {
    word row, col;                                 // Screen pos
    #ifdef __TURBOC__                              // If a Borland compiler
    struct text_info textInfo;                     // Screen info struct
    #else                                          // If a Microsoft compiler
    struct _videoconfig vconfig;
    #endif

    #ifdef __TURBOC__                              // If a Borland compiler
    textbackground(cBACKGRND);                     // Set background color
    textcolor(cFOREGRND);                          // Set foreground color
    gettextinfo(&textInfo);                        // Get screen info
    rows = textInfo.screenheight;                  // Save rows
    cols = textInfo.screenwidth;                   // Save cols
    clrscr();                                      // Clear the screen
    #else                                          // If a Microsoft compiler
    _getvideoconfig(&vconfig);                     // Get screen info
    rows = (word) vconfig.numtextrows;             // Saven rows
    cols = (word) vconfig.numtextcols;             // Save cols
    _clearscreen(_GCLEARSCREEN);                   // Clear the screen
    #endif
       
    cursorOff();                                   // Turn off cursor

    if (cols > MAXCOLS) cols = MAXCOLS;            // Clip col count

    iRow = rows; iCol = 2;                         // Set starting input pos
    mRow = 2;    mCol = 2;                         // Set main window pos

    memset(strBlank, ' ', cols - 2);               // Fill it with spaces

    row = 1; col = 1;  gotoxy(col, row);           // Start at upper left
    putch(218);                                    // Draw upper left corner
    for ( ; col < cols - 1; col++) putch(196);     // Draw top line
    putch(191);                                    // Draw upper right corner

    for (row = 2, col = 1; row < rows - 1; row++)  // Loop to draw sides
      {
        gotoxy(col, row); putch(179);              // Draw left side
        gotoxy(cols, row); putch(179);             // Draw right side
      }

    gotoxy(col, row); putch(192);                  // Draw lower left corner
    for ( ; col < cols - 1; col++) putch(196);     // Draw bottom line
    putch(217);                                    // Draw lower right corner

    cprintf(">");                                  // Print input prompt

    gotoxy(iCol, iRow);                            // Go to input window
    cursorOn();                                    // Turn on cursor
  }                                                // End vidStart()


/****************************************************************************/
/*                                                                          */
/***  vidStop()                                                           ***/
/*                                                                          */
/****************************************************************************

This procedure restores the screen to its original state.                   */

void vidStop(void)                                 // Begin vidStop()
  { 
    #ifdef _MSC_VER                                // If Microsoft compiler
    _clearscreen(_GCLEARSCREEN);                   // Clear the screen
    #else                                          // If Borland compiler
    clrscr();                                      // Clear the screen
    #endif
    cursorOn();                                    // Set normal cursor
  }                                                // End vidStop()
