/********************************************************************
 * PC installer (aldsetup) control file for PM 5.0 Trial Version 1.44mb Disks
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldusTVDirectory" "C:\PM5TV"


/********   DBUILD SECTION  ***********/



DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     284720  CHECKDATE,
   PMTV_144.CTL      11371,
   README.WRI        23168,
   PM5PRINT.WRI       2432,
   READTHIS.TXT       2882,
   GRAPHIC.TIF       10892  "PM5TV",
   ALDCLP5.DL~      133001  "PM5TV"  CHECKDATE  VITAL,
   ALDFS.DL~         66399  "PM5TV"  CHECKDATE  VITAL,
   ALDIM3.DL~       213616  "PM5TV"  CHECKDATE  VITAL,
   ALDWPLS.DL~      160912  "PM5TV"  CHECKDATE  VITAL,
   ALDPLS2.DL~      136208  "PM5TV"  CHECKDATE  VITAL,
   PICTWMF.DL~      115368  "PM5TV"  CHECKDATE  VITAL,
   PRXLNGST.DL~       6144  "PM5TV"  CHECKDATE  VITAL,
   ALDVM.DL~         84286  "PM5TV"  CHECKDATE  VITAL,
   ALDFONTA.FO~      22512  "PM5TV"  CHECKDATE  VITAL,
   ALDFONTB.FO~      17776  "PM5TV"  CHECKDATE  VITAL,
   ALDFONTE.FO~      30896  "PM5TV"  CHECKDATE  VITAL,
   ALDFONTF.FO~      32672  "PM5TV"  CHECKDATE  VITAL,
   TEXT.TX~           1492  "PM5TV",
   PM5SHORT.HL~      55348  "PM5TV\USENGLSH"  VITAL,
   ALDCLP5R.RS~      18432  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDFSRES.RS~       4272  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDIM3RS.RS~       5888  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   TRAKVALS.BI~        730  "PM5TV\USENGLSH"  CHECKDATE
   }


DISK "(2)"
   {
   (C)ALDUS.'93         62,
   ALDUKN.BP~        32313  "PM5TV\UKENGLSH"  CHECKDATE  VITAL,
   ALDUKN00.VP~     258048  "PM5TV\UKENGLSH"  CHECKDATE  VITAL,
   ALDUKN.NF~           65  "PM5TV\UKENGLSH"  CHECKDATE  VITAL,
   PM5.HL~          459929  "PM5TV\USENGLSH"  VITAL,
   MAI.DL~           88640  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   PRXLNGST.RS~       3072  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.BP~        32319  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.MS~         1024  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN00.VP~     339968  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.NF~           66  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ALDUSN.UD~         1024  "PM5TV\USENGLSH"  CHECKDATE,
   DROPCAP.AD~       19968  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   KEYLINE.AD~       18944  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   NUMPARAS.AD~      20992  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   PAGESORT.AD~      76120  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   PUBINFO.AD~       11776  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   LIBLOADR.AD~       7168  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   LIBRARY.PA~      125952  "PM5TV\USENGLSH\ADDITION"  CHECKDATE,
   CHREXPC.TB~        3811  "WINDOWS"  NOREPLACE,
   CHRIMPC.TB~        3785  "WINDOWS"  NOREPLACE,
   PANOSE.DA~       135483  "WINDOWS"  NOREPLACE,
   PCDLIB.DL~        84672  "WINDOWS"  CHECKDATE,
   PCDIMP.HL~         3559  "WINDOWS"  CHECKDATE,
   TWAIN.DL~         22944  "WINDOWS"  CHECKDATE,
   PXENGWIN.DL~     236734  "WINDOWS"  CHECKDATE,
   ALDLEARN.DL~      29184  "WINDOWS"  CHECKDATE
   }


DISK "(3)"
   {
   (C)ALDUS.'93         62,
   PM5part1.12~     1556480  "PM5TV"  VITAL,
   PM5TV.EX~         24064  "PM5TV"  VITAL,
   PM5RESTV.RS~     261808  "PM5TV\USENGLSH"  VITAL,
   ALDVMRES.RS~       5120  "PM5TV\USENGLSH"  CHECKDATE  VITAL,
   ASCIIEXP.FL~       2896  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   TEIMP.FL~         68416  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   TEXTIMP.FL~       18384  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   EPSIMP.FL~       104885  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   RTFIMP.FL~        31424  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   EXCELIMP.FL~      62096  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   PICTIMP.FL~        6956  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   WMFIMP.FL~         4461  "PM5TV\USENGLSH\FILTERS"  CHECKDATE,
   CGENERAL.PP~       8006  "PM5TV\USENGLSH\PPD4"  CHECKDATE,
   GENERAL.PP~        8855  "PM5TV\USENGLSH\PPD4"  CHECKDATE
   }


DISK "(4)"
   {
   (C)ALDUS.'93         62,
   PSCRIPT.DRV      138594,
   UNIDRV.DLL        77841,
   UNIDRV.HLP        45107,
   HPPCL5MS.DRV     113705,
   PRINTER.TXT        2608,
   OEMSETUP.INF        288,
   courb.fo_          8118,
   coure.fo_          8612,
   courf.fo_         11021,
   license.txt        4046,
   serifb.fo_        18777,
   serife.fo_        21454,
   seriff.fo_        27241,
   smallb.fo_        10928,
   smalle.fo_        12501,
   smallf.fo_        10489,
   sserifb.fo_       18968,
   sserife.fo_       21643,
   sseriff.fo_       27627,
   symbolb.fo_       19890,
   symbole.fo_       21296,
   symbolf.fo_       27198,
   PM5part2.12~     1208448  "PM5TV"  VITAL
   }


/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/


DIALOG AldusLocation "OK" "Cancel" 
{
	CAPTION "Aldus PageMaker 5.0 Trial Version Location"
	TEXT
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus PageMaker 5.0 Trial"
	"Version files."
	" "
	"If this is the directory you want, click OK."
	}
}

DIALOG BuffersWarning "&Continue" "&Exit"
{
	CAPTION "Low BUFFERS setting"
	TEXT
	{
	"Aldus Setup has detected that the BUFFERS setting in your "
	"CONFIG.SYS file is below 20.  You can successfully install "
	"with the current settings, but the installation process may"
	"be slowed considerably.  Increasing the value of this setting"
	"and rebooting your computer will speed up the installation time."
	}
}

DIALOG PrintInfo "&OK"
{
	CAPTION "Must install Drivers"
	TEXT
	{
	"If you will be using a PostScript printer with PageMaker"
	"or a HP LaserJet III, please install the drivers from the"
	"last disk of the set.  If newer versions of the drivers"
	"are available, use them instead."
	" "
	"The Windows Control Panel will start when you click"
	"OK."
	}
}

DIALOG AldusGroup "&Continue"
{
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus Setup program has created the Aldus"
	"group window."
	" "
	"Aldus PageMaker 5.0 Trial Version has been added"
	"to the Aldus Group.  To start this application "
	"double-click on the program icon."
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been"
	"successfully installed."
	}
}

DIALOG MoreInfo "&OK"
{
	CAPTION "Installer Diagnostics"
	TEXT
	{
	" "
	"You may now exit this program or choose to read the Aldus"
	"PageMaker 5.0 READTHIS.TXT file, which has been added to the" 
	"View menu.  You may also choose to examine other information"
	"provided from the Diagnostics or View menus in Aldus Setup."
	" "
	"Thank you for purchasing Aldus PageMaker 5.0. Your installation"
	"is complete.  Please fill out and send in your registration card."
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/
GETALDDIR PM5TVDir AldusLocation
GETBOOTDRIVE BootDrive
SET ExeInstalled "FALSE"
SET PrinterDrivers "FALSE"
SET Serialize "FALSE"
SET FullInstallation "FALSE"
GETWINDIR WinDir
GETWINSYSDIR WinSysDir

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
IF BufferAmount LT 20 
	{
	DISPLAY BuffersWarning BufferResponse
	IF  BufferResponse EQS "&Exit" 
		{
		EXIT
		}
	} 

}   /** End PROLOGUE **/

PACKAGE InstallEverything "Install Trial Version (7MB)" SELECTED
	{
	/**** Package Initializations *****/

	GETALDDIR PM5TVDir AldusLocation
	
	CONCAT PM5TVDir "USENGLSH" EngDir	 
	CONCAT PM5TVDir "UKENGLSH" UKDir	 
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT EngDir "PPD4" APPD4Dir

	/**** File Subdirectory Assignments *****/

	FILES PM5TVDir     
		{
		README.WRI
		PM5PRINT.WRI
		GRAPHIC.TIF
		ALDCLP5.DL~
		ALDFS.DL~
		ALDIM3.DL~
		ALDWPLS.DL~
		ALDPLS2.DL~
		PICTWMF.DL~
		PRXLNGST.DL~
		ALDVM.DL~
		ALDFONTA.FO~
		ALDFONTB.FO~
		ALDFONTE.FO~
		ALDFONTF.FO~
		TEXT.TX~
		PM5part1.12~
		PM5part2.12~
		PM5TV.EX~
		}

	FILES UkDir
		{
		ALDUKN.BP~  
		ALDUKN00.VP~
		ALDUKN.NF~  
		}

	FILES EngDir
		{
		PM5SHORT.HL~
		ALDCLP5R.RS~
		ALDFSRES.RS~
		ALDIM3RS.RS~
		TRAKVALS.BI~
		PM5.HL~
		MAI.DL~
		PRXLNGST.RS~
		ALDUSN.BP~
		ALDUSN.MS~
		ALDUSN00.VP~
		ALDUSN.NF~
		ALDUSN.UD~
		PM5RESTV.RS~
		ALDVMRES.RS~
		}
	

	FILES AFiltDir
		{
		ASCIIEXP.FL~
		TEIMP.FL~
		TEXTIMP.FL~
		EPSIMP.FL~
		RTFIMP.FL~
		EXCELIMP.FL~
		PICTIMP.FL~
		WMFIMP.FL~
		}

	FILES AADDitionDir
		{
		DROPCAP.AD~
		KEYLINE.AD~
		NUMPARAS.AD~
		PAGESORT.AD~
		PUBINFO.AD~
		LIBLOADR.AD~
		LIBRARY.PA~
		}

	FILES WinDir
		{
		CHREXPC.TB~
		CHRIMPC.TB~
		PANOSE.DA~
		PCDLIB.DL~
		PCDIMP.HL~
		TWAIN.DL~
		PXENGWIN.DL~
		ALDLEARN.DL~
		}			    

	FILES APPD4Dir
		{
		CGENERAL.PP~
		GENERAL.PP~
		}

	/**** end File Subdirectory Assignments ****/



	/**** INI Settings ****/

	ALDUSINI
		{
		"Bullets" "Bullet1" "149,12,18,Times New Roman",
		"Bullets" "Bullet2" "110,12,18,Wingdings",
		"Bullets" "Bullet3" "111,12,18,Wingdings",
		"Bullets" "Bullet4" "168,12,2,Symbol",
		"Bullets" "Bullet5" "214,12,18,Symbol"
		} 

	WININI
		{
		"Aldus"	"PM5LangDirTV" "USENGLSH"
		}

	/*** Oninstall initializations ***/

	SET ExeInstalled "TRUE"
	SET PrinterDrivers "TRUE"
	SET FullInstallation "TRUE"
	CONCAT PM5TVDir "PM5TV.exe" FullPMName
	CONCAT PM5TVDir "README.WRI" ReadMeName		    
	CONCAT PM5TVDir "PM5PRINT.WRI" PrintMeName		    
	CONCAT WinDir "WRITE.EXE" WriteIconName		    

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		ASSEMBLE "PM5TVAPP.EXE"
			{
			PM5PART1.12~
			PM5PART2.12~
			}		      

		ADDPROGRAMITEM "PM5 Trial Version" FullPMName "PageMaker 5.0 Trial Version" FullPMName 0
		ADDPROGRAMITEM "PM5 Trial Version" ReadMeName "PM5.0 Trial Version ReadMe" WriteIconName 0	
		ADDPROGRAMITEM "PM5 Trial Version" PrintMeName "Important Printer Info" WriteIconName 0	


		WINDOWSMENU PM5TVDir "READTHIS.TXT" "&READTHIS.TXT" 



		}	/** End Oninstall **/

	}	/***** END PageMaker Easy Install *****/



PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	/***  Stuff to be done after all other ONINSTALL's are completed ***/

	CONCAT WinDir "CONTROL.EXE" WinCtl	
	CONCAT WinDir "CONTROL.EXE" WinCtl	

	ONINSTALL
		{
		IF ExeInstalled EQS "FALSE"
			{
	        	DISPLAY SucNoRead
			}

		IF PrinterDrivers EQS "TRUE"
			{
			CD WinDir
			DISPLAY PrintInfo    
			LAUNCH WinCtl "Printers"    
			DISPLAY AldusGroup
			DISPLAY SucRead 
			}

		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/
