Unit Bigmatri;
{by T. Fulton CIS:[100015,565]}
{24 July 1993}

Interface
uses Wintypes,Winprocs,wintools;

type
    LongType=record
    case word of
     0:(Ptr:^byte);
     1:(Long:Longint);
     2:(Lo:word;Hi:word);
    end;

    tricolor=record
             blue:byte;
             green:byte;
             red:byte;
             end;

    pixel=record
       case word of
       0:(bit8:byte);
       1:(bit24:tricolor);
       end;

{This object is a 2-D matrix of bytes, allocated on global heap}
largebytematrix=object
  ArrayHandle:Thandle;
  maxcols,maxrows:longint;
  ArrayAddr:longtype;
  constructor init(c,r:longint;var ok:boolean);
  {col=0..maxcols-1}
  {row=0..maxrows-1}
  function put(col,row:longint;value:byte):boolean;
  function get(col,row:longint):byte;
  function fill(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function bias(firstcol,firstrow,lastcol,lastrow:word;value:integer):boolean;
  function scale(firstcol,firstrow,lastcol,lastrow:word;value:real):boolean;
  function cmin(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function cmax(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function kodalith(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function threshold(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function invert(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
  function bitplane(firstcol,firstrow,lastcol,lastrow:word;whichbit:byte):boolean;
  function nbits(firstcol,firstrow,lastcol,lastrow:word;whichbit:byte):boolean;
  function xpandgray(firstcol,firstrow,lastcol,lastrow:word;
                         minvalue,maxvalue:byte):boolean;
  function vertmirror:boolean;
  function horzmirror:boolean;
  procedure stats(firstcol,firstrow,lastcol,lastrow:word;
                  var minimum,maximum:byte;var avg:real);
  destructor done;virtual;
end;


LonglongintType=record
    case word of
     0:(Ptr:^longint);
     1:(Long:Longint);
     2:(Lo:word;Hi:word);
    end;

{This object is a 2-D matrix of longint (4 byte integer)
  allocated on global heap}
Largelongintmatrix=object
  ArrayHandle:Thandle;
  maxcols,maxrows:longint;
  ArrayAddr:longlonginttype;
  constructor init(c,r:longint;var ok:boolean);
  {col=0..maxcols-1}
  {row=0..maxrows-1}
  function put(col,row:longint;value:longint):boolean;
  function get(col,row:longint):longint;
(*  function fill(firstcol,firstrow,lastcol,lastrow:word;value:longint):boolean;*)
  procedure stats(firstcol,firstrow,lastcol,lastrow:word;
                 var minimum,maximum,avg:single);

  destructor done;virtual;
end;

LongsingleType=record
    case word of
     0:(Ptr:^single);
     1:(Long:Longint);
     2:(Lo:word;Hi:word);
    end;

{This object is a 2-D matrix of singles (4 byte floating pt.)
  allocated on global heap}
Largesinglematrix=object
  ArrayHandle:Thandle;
  maxcols,maxrows:longint;
  ArrayAddr:longsingletype;
  constructor init(c,r:longint;var ok:boolean);
  {col=0..maxcols-1}
  {row=0..maxrows-1}
  function put(col,row:longint;value:single):boolean;
  function get(col,row:longint):single;
  function fill(firstcol,firstrow,lastcol,lastrow:word;value:single):boolean;
  procedure stats(firstcol,firstrow,lastcol,lastrow:word;
                 var minimum,maximum,avg:single);
  destructor done;virtual;
end;

LargeBitarray=object
  arrayhandle:Thandle;
  maxcols,maxrows:longint;
  arrayaddr:longtype;
  bytes_per_row:longint;
  function byteno(col,row:longint):longint;
  function bitno(col,row:longint):byte;
  constructor init(c,r:longint;var ok:boolean);
  function put(col,row:longint;on:boolean):boolean;
  function get(col,row:longint):boolean;
  destructor done;virtual;
  end;

implementation

constructor largebytematrix.init(c,r:longint;var ok:boolean);
var Arraysize:longint;
begin
  Arraysize:=c*r;
  ArrayHandle:=GlobalAlloc(gmem_moveable or gmem_zeroInit,arraysize);
  maxcols:=c;
  maxrows:=r;
  ok:=Arrayhandle>0;
  ArrayAddr.long:=0;
end;

destructor largebytematrix.done;
begin
 GlobalFree(ArrayHandle);
 arrayhandle:=0;
end;

function largebytematrix.put(col,row:longint;value:byte):boolean;
{The handle arrayhandle must be locked and unlocked before and
  after calling this function}
var start,toaddr:longtype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=(((row)*maxcols) + (col));
  toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  toaddr.ptr^:=value;
  put:=true;
  end else put:=false;
end;

function largebytematrix.get(col,row:longint):byte;
var start,toaddr:longtype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=(((row)*maxcols)+(col));
  toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  get:=toaddr.ptr^;
  end else get:=0;
end;

procedure largebytematrix.stats(firstcol,firstrow,lastcol,lastrow:word;
                                var minimum,maximum:byte;var avg:real);
var col,row,row_holder,offset_holder:longint;
    start,toaddr:longtype;
    temp:byte;
begin
  arrayaddr.ptr:=globallock(arrayhandle);
  maximum:=0;
  minimum:=255;
  avg:=0.0;
  row_holder:=firstrow*maxcols;
  for row:=firstrow to lastrow do
  begin
    start.long:=row_holder + firstcol;
    for col:=firstcol to lastcol do
    begin
      toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if temp < minimum then minimum:=temp;
      if temp > maximum then maximum:=temp;
      avg:=avg + temp;
      start.long:=succ(start.long);
    end;
    row_holder:=row_holder + maxcols;
  end;
  avg:=avg/((lastcol-firstcol +1)*(lastrow-firstrow +1));
  globalunlock(arrayhandle);
end;

function largebytematrix.fill(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
    start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      toaddr.ptr^:=value;
    end;
  end;
  globalunlock(arrayhandle);
  fill:=true
  end
  else fill:=false;
end;

function largebytematrix.bias(firstcol,firstrow,lastcol,lastrow:word;value:integer):boolean;
var col,row,rowholder:longint;
     temp:integer;
     orig:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
      begin
        start.long:=rowholder+col;
        toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
        toaddr.lo:=start.lo;
        orig:=toaddr.ptr^;
        temp:=orig+value;
        if temp >255 then temp:=255;
        if temp <0 then temp:=0;
        orig:=temp;
        toaddr.ptr^:=orig;
      end;{row}
  end;{col}
  globalunlock(arrayhandle);
  bias:=true
  end
  else bias:=false;
end;

function largebytematrix.scale(firstcol,firstrow,lastcol,lastrow:word;value:real):boolean;
var col,row,rowholder:longint;
     temp:integer;
     orig:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
      begin
        start.long:=rowholder+col;
        toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
        toaddr.lo:=start.lo;
        orig:=toaddr.ptr^;
        temp:=trunc(value*orig);
        if temp >255 then temp:=255;
        if temp <0 then temp:=0;
        orig:=temp;
        toaddr.ptr^:=orig;
      end;{row}
  end;{col}
  globalunlock(arrayhandle);
  scale:=true
  end
  else scale:=false;
end;



function largebytematrix.cmin(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
      begin
        start.long:=rowholder+col;
        toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
        toaddr.lo:=start.lo;
        temp:=toaddr.ptr^;
        if temp < value then temp:=value;
        toaddr.ptr^:=temp;
     end;
  end;
  globalunlock(arrayhandle);
  cmin:=true
  end
  else cmin:=false;
end;

function largebytematrix.cmax(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if temp > value then temp:=value;
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  cmax:=true
  end
  else cmax:=false;
end;

function largebytematrix.bitplane(firstcol,firstrow,lastcol,lastrow:word;whichbit:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

function getbit(var target:byte;whichbit:byte):boolean;
var subject:integer absolute target;
    mask:integer;
begin
  mask:=$80 shr whichbit;
  if target AND mask =mask
    then getbit:=true
    else getbit:=false;
end;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if getbit(temp,whichbit) then temp:=255
      else temp:=0;
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  bitplane:=true
  end
  else bitplane:=false;
end;

function largebytematrix.nbits(firstcol,firstrow,lastcol,lastrow:word;whichbit:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^ shr whichbit;
      temp:=temp shl whichbit;
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  nbits:=true
  end
  else nbits:=false;
end;


function largebytematrix.kodalith(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if temp > value then temp:=255
      else if temp < value then temp:=0;
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  kodalith:=true
  end
  else kodalith:=false;
end;

function largebytematrix.threshold(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if temp < value then temp:=0;
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  threshold:=true
  end
  else threshold:=false;
end;

function largebytematrix.Invert(firstcol,firstrow,lastcol,lastrow:word;value:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=toaddr.ptr^;
      if temp >= value then temp:=255 AND (NOT temp);
      toaddr.ptr^:=temp;
    end;
  end;
  globalunlock(arrayhandle);
  invert:=true
  end
  else invert:=false;
end;

function largebytematrix.Xpandgray(firstcol,firstrow,lastcol,lastrow:word;
                                   minvalue,maxvalue:byte):boolean;
var col,row,rowholder:longint;
     temp:byte;
     value:byte;
     scaler:real;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  scaler:=255/(maxvalue-minvalue);
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
       start.long:=rowholder+col;
       toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
       toaddr.lo:=start.lo;
       temp:=toaddr.ptr^;
       if temp < minvalue then temp:=0
       else if temp > maxvalue then temp:=255
       else temp:=trunc(scaler*(temp-minvalue));
       value:=temp;
       toaddr.ptr^:=value;
    end;
  end;
 globalunlock(arrayhandle);
 xpandgray:=true
 end
  else xpandgray:=false;
end;

function largebytematrix.VertMirror:boolean;
var col,row:longint;
     temp1,temp2:byte;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for col:=0 to (maxcols div 2)-1 do
    for row:=0 to maxrows-1 do
    begin
      temp1:=get(maxcols-col-1,row);
      temp2:=get(col,row);
      put(maxcols-col-1,row,temp2);
      put(col,row,temp1);
    end;
  globalunlock(arrayhandle);
  vertmirror:=true
  end
  else vertmirror:=false;
end;


function largebytematrix.HorzMirror:boolean;
var col,row:longint;
     temp1,temp2:byte;
     start,toaddr:longtype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=0 to (maxrows div 2)-1 do
    for col:=0 to maxcols-1 do
    begin
      temp1:=get(col,maxrows-row - 1);
      temp2:=get(col,row);
      put(col,maxrows-row - 1,temp2);
      put(col,row,temp1);
    end;
  globalunlock(arrayhandle);
  horzmirror:=true
  end
  else horzmirror:=false;
end;

procedure setbit(var target:byte;bitnum:integer);
var mask:integer;
    subject: integer absolute target;
begin
  mask:= $80 shr bitnum;
  target:=target or mask
end;

procedure clearbit(var target:byte;bitnum:integer);
var subject:integer absolute target;
    mask:integer;
begin
  mask:= not($80 shr bitnum);
  subject:=subject and mask
end;

procedure putbit(var target:byte;whichbit:byte;on:boolean);
begin
  if on then setbit(target,whichbit)
  else clearbit(target,whichbit);
end;

function getbit(var target:byte;whichbit:byte):boolean;
var subject:integer absolute target;
    mask:integer;
begin
  mask:=$80 shr whichbit;
  if target AND mask =mask
    then getbit:=true
    else getbit:=false;
end;


constructor largesinglematrix.init(c,r:longint;var ok:boolean);
var Arraysize:longint;
begin
  Arraysize:=c*r*4;
  ArrayHandle:=GlobalAlloc(gmem_moveable or gmem_zeroInit,arraysize);
  maxcols:=c;
  maxrows:=r;
  ok:=Arrayhandle>0;
  ArrayAddr.long:=0;
end;

destructor largesinglematrix.done;
begin
 GlobalFree(ArrayHandle);
 arrayhandle:=0;
end;

function largesinglematrix.put(col,row:longint;value:single):boolean;
var start,toaddr:longsingletype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=row*maxcols*4 + col*4;
  toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  toaddr.ptr^:=value;
  put:=true;
  end else put:=false;
end;

(* new method*)
function largesinglematrix.get(col,row:longint):single;
var start,toaddr:longsingletype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=row*maxcols*4 + col*4;
  toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  get:=toaddr.ptr^;
  end else get:=0.0;
end;

procedure largesinglematrix.stats(firstcol,firstrow,lastcol,lastrow:word;
                                var minimum,maximum,avg:single);
var col,row:longint;
    start,toaddr:longsingletype;
    temp,count:single;
begin
  arrayaddr.ptr:=globallock(arrayhandle);
  maximum:=-1.0e+31;
  minimum:=1.0e+31;
  avg:=0.0;
  count:=0.0;
  for row:=firstrow to lastrow do
  begin
    for col:=firstcol to lastcol do
    begin
      temp:=get(col,row);
      count:=count +1.0;
      if temp < minimum then minimum:=temp;
      if temp > maximum then maximum:=temp;
      avg:=avg + temp;
    end;{col}
  end;{row}
  avg:=avg/count;
  globalunlock(arrayhandle);
end;

function largesinglematrix.fill(firstcol,firstrow,lastcol,lastrow:word;value:single):boolean;
var col,row,rowholder:longint;
    start,toaddr:longsingletype;

begin
  arrayaddr.ptr:=globallock(arrayhandle);
  if arrayaddr.ptr <> nil then
  begin
  for row:=firstrow to lastrow do
  begin
    for col:=firstcol to lastcol do
    begin
      put(col,row,value);
    end;
  end;
  globalunlock(arrayhandle);
  fill:=true
  end
  else fill:=false;
end;

constructor largelongintmatrix.init(c,r:longint;var ok:boolean);
var Arraysize:longint;
begin
  Arraysize:=c*r*4;
  ArrayHandle:=GlobalAlloc(gmem_moveable or gmem_zeroInit,arraysize);
  maxcols:=c;
  maxrows:=r;
  ok:=Arrayhandle>0;
  ArrayAddr.long:=0;
end;

destructor largelongintmatrix.done;
begin
 GlobalFree(ArrayHandle);
 arrayhandle:=0;
end;

function largelongintmatrix.put(col,row:longint;value:longint):boolean;
var start,toaddr:longlonginttype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=row*maxcols*4 + col*4;
  toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  toaddr.ptr^:=value;
  put:=true;
  end else put:=false;
end;

(* new method*)
function largelongintmatrix.get(col,row:longint):longint;
var start,toaddr:longlonginttype;
begin
  if ((col <= maxcols-1) AND (row<=maxrows-1)) then
  begin
  start.long:=row*maxcols*4 + col*4;
  toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  get:=toaddr.ptr^;
  end else get:=0;
end;

procedure largelongintmatrix.stats(firstcol,firstrow,lastcol,lastrow:word;
                                var minimum,maximum,avg:single);
var col,row,temp:longint;
    start,toaddr:longlonginttype;
    count:single;
begin
  arrayaddr.ptr:=globallock(arrayhandle);
  maximum:=-1.0e+31;
  minimum:=1.0e+31;
  avg:=0.0;
  count:=0.0;
  for row:=firstrow to lastrow do
  begin
    for col:=firstcol to lastcol do
    begin
      temp:=get(col,row);
      count:=count +1.0;
      if temp < minimum then minimum:=temp;
      if temp > maximum then maximum:=temp;
      avg:=avg + temp;
    end;{col}
  end;{row}
  avg:=avg/count;
  globalunlock(arrayhandle);
end;


function LargeBitarray.byteno(col,row:longint):longint;
begin
  byteno:=(row)*bytes_per_row + (col+8) div 8 -1;
end;

function LargeBitarray.bitno(col,row:longint):byte;
begin
  bitno:=col-8*(col div 8);
end;

constructor LargeBitarray.init(c,r:longint;var ok:boolean);
var Arraysize:longint;
begin
  bytes_per_row:=(c+7) div 8;
  Arraysize:=r*bytes_per_row;
  ArrayHandle:=GlobalAlloc(gmem_moveable or gmem_zeroInit,arraysize);
  maxcols:=8*bytes_per_row;
  maxrows:=r;
  ok:=Arrayhandle>0;
  ArrayAddr.long:=0;
end;

destructor LargeBitarray.done;
begin
 GlobalFree(ArrayHandle);
 arrayhandle:=0;
end;

function LargeBitarray.put(col,row:longint;on:boolean):boolean;
var start,toaddr:longtype;
    temp:byte;
begin
  start.long:=byteno(col,row);
  toaddr.hi:=arrayaddr.hi + (start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  move(toaddr.ptr^,temp,1);
  putbit(temp,bitno(col,row),on);
  move(temp,toaddr.ptr^,1);
  put:=true;
end;

function LargeBitarray.get(col,row:longint):boolean;
var start,toaddr:longtype;
    value:byte;
begin
  start.long:=byteno(col,row);
  toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
  toaddr.lo:=start.lo;
  move(toaddr.ptr^,value,1);
  get:=getbit(value,bitno(col,row));
end;


end.
