{5 Sept. '93}
unit BMProcess;
{by T. Fulton CIS:[100015,565]}
{created 3 September}

interface

uses    Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory,Wintypes, Winprocs, WinDOS,WinCrt, Strings,
        imwpc,uprint,wintools,ostring,bigmatri,bmputils,dispdib,wgraphics,
        center3,mystatus,bscrolw;

type shortstring=array[0..20] of char;
type
  PBMProcess=^TBMProcess;
  TBMProcess=object(TBitScrollWindow)
   ProcessHistory:array[0..1023] of char;
   valbuffer,promptstr1,promptstr2:shortstring;
   rT:array[0..255] of real;
   statusdialog:PStatus;
   redchange,greenchange,bluechange:integer;

   highpass_method,lowpass_method,dip_method,emboss_method:integer;
   constructor Init(AParent:PWindowsObject;AFileName:Pchar;
                    thepixelwidth,thepixelheight:word);
   procedure lookuptable(lut:luttype);

   function GetUserByte(prompt1,prompt2:shortstring):byte;
   procedure CMGrabVideo(var Msg:TMessage);virtual cm_first
                                            + cm_Grab;
   procedure ImportFile(var Msg:Tmessage);virtual cm_first
                                             + cm_ImportFile;
   procedure ExportFile(var Msg:Tmessage);virtual cm_first
                                             + cm_ExportFile;
   procedure colorcomponent(color:integer);

   procedure GrayPalette(var Msg:Tmessage);virtual cm_first
                                           + cm_GrayPalette;
    Procedure RainbowPalette(var msg:Tmessage);virtual cm_first
                                            + cm_RainbowPalette;
    Procedure GreenPalette(var msg:Tmessage);virtual cm_first
                                            + cm_GreenPalette;
    procedure BrPalette(var Msg:Tmessage);virtual cm_first
                                            + cm_brPalette;
    procedure DmPalette(var Msg:Tmessage);virtual cm_first
                                            + cm_dmPalette;
    procedure PalAdjust(var Msg:Tmessage);virtual cm_first
                                            + cm_Paladjust;
    procedure RedComponent(var Msg:TMessage);virtual cm_first
                                            + cm_RedComponent;
    procedure GreenComponent(var Msg:TMessage);virtual cm_first
                                            + cm_GreenComponent;
    procedure BlueComponent(var Msg:TMessage);virtual cm_first
                                            + cm_BlueComponent;
    procedure ExtractY(var Msg:TMessage);virtual cm_first
                                            + cm_ExtractY;
    procedure ExtractQ(var Msg:TMessage);virtual cm_first
                                         + cm_ExtractI;
    procedure ExtractI(var Msg:TMessage);virtual cm_first
                                            + cm_ExtractQ;
    procedure UpdatePalette(var Msg:Tmessage);virtual cm_first
                                            + cm_UpdatePalette;
    procedure RestorePalette(var Msg:Tmessage);virtual cm_first
                                            + cm_RestorePalette;
    procedure GrayScale(var msg:Tmessage);virtual cm_first +
                                          cm_grayscale;
    procedure NegPalette(var Msg:Tmessage);virtual cm_first
                                            + cm_NegPalette;
    procedure ShowRectangle(var msg:Tmessage);virtual cm_first
                                              + cm_showrect;
    procedure CutoutRectangle(var msg:Tmessage);virtual cm_first
                                                + cm_cutout;
    procedure MatrixFill(var Msg:Tmessage);virtual cm_First
                                           + cm_Fillconst;
    procedure MatrixBias(var Msg:Tmessage);virtual cm_First
                                           + cm_Bias;
    procedure MatrixScale(var Msg:Tmessage);virtual cm_First
                                           + cm_scale;
    procedure MatrixCmin(var Msg:Tmessage);virtual cm_First
                                           + cm_CMin;
    procedure MatrixCmax(var Msg:Tmessage);virtual cm_First
                                           + cm_CMax;
    procedure MatrixInvert(var Msg:Tmessage);virtual cm_First
                                           + cm_Invert;
    procedure MatrixThreshold(var Msg:Tmessage);virtual cm_First
                                           + cm_threshold;
    procedure MatrixBitPlane(var Msg:Tmessage);virtual cm_First
                                           + cm_bitplane;
    procedure MatrixNBits(var Msg:Tmessage);virtual cm_First
                                           + cm_Nbits;
    procedure MatrixXpandGray(var Msg:Tmessage);virtual cm_First
                                           + cm_xpandgray;
    procedure MatrixStrHist(var Msg:Tmessage);virtual cm_First
                                           + cm_strhist;
    procedure MatrixHistEqual(var Msg:Tmessage);virtual cm_First
                                           + cm_histequal;
    procedure MatrixHistLocal(var Msg:Tmessage);virtual cm_First
                                           + cm_histlocal;
    procedure MatrixGrayMap(var Msg:Tmessage);virtual cm_first
                                           + cm_graymap;
    procedure MatrixKodalith(var Msg:Tmessage);virtual cm_First
                                           + cm_Kodalith;
    procedure Matrixhighpass(var Msg:Tmessage);virtual cm_First
                                           + cm_highpass;
    procedure MatrixEdges(var Msg:Tmessage);virtual cm_First
                                           + cm_edges;
    procedure MatrixEmboss(var Msg:Tmessage);virtual cm_First
                                           + cm_emboss;
    procedure MatrixSobelH(var Msg:Tmessage);virtual cm_First
                                           + cm_sobelH;
    procedure MatrixSobelV(var Msg:Tmessage);virtual cm_First
                                           + cm_sobelV;
    procedure MatrixSobelHV(var Msg:Tmessage);virtual cm_First
                                           + cm_sobelHV;
    procedure MatrixLogarithm(var Msg:Tmessage);virtual cm_First
                                           + cm_log;
    procedure MatrixSmooth(var Msg:Tmessage);virtual cm_First
                                           + cm_smooth;
    procedure MatrixBlur(var Msg:Tmessage);virtual cm_First
                                           + cm_blur;
    procedure MatrixDip(var Msg:Tmessage);virtual cm_First
                                           + cm_dip;
    procedure MatrixVertSmth(var Msg:Tmessage);virtual cm_First
                                           + cm_vertsmth;
    procedure MatrixHorzSmth(var Msg:Tmessage);virtual cm_First
                                           + cm_horzsmth;
    procedure Matrixlowpass(var Msg:Tmessage);virtual cm_First
                                           + cm_lowpass;
    procedure MatrixMedian(var Msg:Tmessage);virtual cm_First
                                           + cm_Median;
    procedure MatrixRotate(var Msg:Tmessage);virtual cm_First
                                           + cm_rotate;
    procedure MatrixShear(var Msg:Tmessage);virtual cm_First
                                           + cm_shear;
    procedure MatrixVertMirror(var Msg:Tmessage);virtual cm_First
                                           + cm_vertmirror;
    procedure MatrixHorzMirror(var Msg:Tmessage);virtual cm_First
                                           + cm_horzmirror;
    procedure MatrixTranslate(var Msg:Tmessage);virtual cm_First
                                           + cm_translate;
    procedure MatrixDither4(var msg:Tmessage);virtual cm_first
                                            + cm_dither4;
    procedure MatrixDither3(var msg:Tmessage);virtual cm_first
                                            + cm_dither3;
     procedure MatrixHalftone(var msg:Tmessage);virtual cm_first
                                            + cm_halftone;
    procedure MatrixDith16(var msg:Tmessage);virtual cm_first
                                            + cm_dith16;
     procedure MatrixDithDiff(var msg:Tmessage);virtual cm_first
                                            + cm_dithdiff;
    procedure MatrixZoom(var Msg:Tmessage);virtual cm_First
                                           + cm_zoom;
    procedure MatrixHistogram(var Msg:Tmessage);virtual cm_First
                                           + cm_histo;
    procedure MatrixPixelate(var Msg:Tmessage);virtual cm_First
                                           + cm_Pixelate;
    procedure ShowHistory(var Msg:Tmessage);virtual cm_first
                                           + cm_ShowHistory;

    procedure MatrixFFT(var Msg:TMessage);virtual cm_first
                                           + cm_FFT;

end;
{****************Dialog objects definitions**********************}

PByteDlg=^TByteDlg;
TByteDlg=object(TCenteredInputDialog)
function canclose:boolean;virtual;
end;


PXpandDlg=^TXpandDlg;
TXpandDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure SetupWindow;virtual;
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PZoomDlg=^TZoomDlg;
TZoomDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure SetupWindow;virtual;
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PhighpassDlg=^ThighpassDlg;
ThighpassDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PlowpassDlg=^TlowpassDlg;
TlowpassDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PDipDlg=^TDipDlg;
TDipDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PEmbossDlg=^TEmbossDlg;
TEmbossDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PHistoryDlg=^THistoryDlg;
THistoryDlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure SetUpWindow;virtual;
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

{******************TWindows*****************************************}

PPalAdjWindow = ^PalAdjWindow;
 PaladjWindow = object(TWindow)
   sbred,sbgreen,sbblue: PScrollBar;
   redstat,greenstat,bluestat : PStatic;
   redtext,greentext,bluetext : Pstatic;
   constructor Init(AParent: PWindowsObject; ATitle: PChar);
   procedure SetupWindow; virtual;
   procedure HandleSBredMsg(var Msg: TMessage);
        virtual id_First + id_sbred;
   procedure HandleSBgreenMsg(var Msg: TMessage);
        virtual id_First + id_sbgreen;
   procedure HandleSBblueMsg(var Msg: TMessage);
        virtual id_First + id_sbblue;
   procedure OK(var msg:TMessage);virtual id_first + id_okbtn;
 end;

var cstring:array[0..11] of char;

 {**********IMPLEMENTATION**************}

 implementation

 function TByteDlg.canclose:boolean;
 var oktoclose:boolean;
     dummy,errorpos:integer;
 begin
   oktoclose:=TInputDialog.canclose;
   if oktoclose then
   begin
     val(buffer,dummy,errorpos);
     oktoclose:=(errorpos=0) and ( dummy >= 0) and (dummy <= 255)
   end
   else
    messagebeep(0);
   canclose:=oktoclose;
  end;

  constructor PalAdjWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var tempbtn:Pbutton;

begin
  TWindow.Init(AParent, ATitle);
  attr.style:=ws_popupwindow or ws_caption or ws_visible;
  with Attr do
  begin
    X := 20;
    Y := 20;
    W := 400;
    H := 150;
  end;
  SBred := New(PScrollBar,
    Init(@Self, id_sbred, 130, 20, 220, 10, True));
  redstat := New(PStatic,
    Init(@Self, id_redstat, '   ', 360, 15, 50, 17, 0));
  redtext := New(PStatic,
    Init(@Self, id_redtext, 'red change', 10, 15, 120, 25, 0));
  SBgreen := New(PScrollBar,
    Init(@Self, id_sbgreen, 130, 45, 220, 10, True));
  greenstat := New(PStatic,
    Init(@Self, id_redstat, '   ', 360, 40, 40, 17, 0));
    greentext := New(PStatic,
    Init(@Self, id_greentext, 'green change', 10, 40, 120, 25, 0));
  SBblue := New(PScrollBar,
    Init(@Self, id_sbblue, 130, 70, 220, 10, True));
  bluestat := New(PStatic,
    Init(@Self, id_redstat, '   ', 360, 65, 30, 17, 0));
    bluetext := New(PStatic,
    Init(@Self, id_bluetext, 'blue change', 10, 65, 120, 25, 0));
    tempbtn:=New(Pbutton,init(@self,id_okbtn,'Set colors',150,100,90,20,false));
end;


{ Create scrollbar and static controls; set range of scrollbar }
procedure PalAdjWindow.SetupWindow;
begin
  TWindow.SetupWindow;
  sbred^.SetRange(-255,255);
  sbgreen^.SetRange(-255,255);
  sbblue^.SetRange(-255,255);
  Str(0, cString);
  redstat^.SetText(cString);
  Str(0, cString);
  greenstat^.SetText(cString);
  Str(0, cString);
  bluestat^.SetText(cString);

end;

procedure PalAdjWindow.HandlesbredMsg(var Msg: TMessage);
begin
  Str(sbred^.GetPosition:3, cString);
  redstat^.SetText(cString);
  PBMProcess(parent)^.redchange:=sbred^.getposition;
end;

procedure PalAdjWindow.HandlesbgreenMsg(var Msg: TMessage);
begin
  Str(sbgreen^.GetPosition:3, cString);
  greenstat^.SetText(cString);
  PBMProcess(parent)^.greenchange:=sbgreen^.getposition;
end;

procedure PalAdjWindow.HandlesbblueMsg(var Msg: TMessage);
begin
  Str(sbblue^.GetPosition:3, cString);
  bluestat^.SetText(cString);
  PBMProcess(parent)^.bluechange:=sbblue^.getposition;
end;

procedure PalAdjWindow.OK(var msg:TMessage);
var i,temp:integer;
begin
 for i := 0 to Pred(PBMProcess(parent)^.PalSize) do
     With PBMProcess(parent)^.ActiveLogPal^do
       begin
       With palPalEntry[i] do
        begin
        temp:=pered + PBMProcess(parent)^.redchange;
        if temp >255 then temp:=255;
        if temp <0 then temp:=0;
        pered:=temp;
        temp:=pegreen + PBMProcess(parent)^.greenchange;
        if temp >255 then temp:=255;
        if temp <0 then temp:=0;
        pegreen:=temp;
        temp:=peblue + PBMProcess(parent)^.bluechange;
        if temp >255 then temp:=255;
        if temp <0 then temp:=0;
        peblue:=temp;
        peFlags := pc_NoCollapse;
       end;
     end;
  PBMProcess(parent)^.HactivePal := CreatePalette(PBMProcess(parent)^.ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
  closewindow;
end;

constructor TXpandDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TXpandDlg.SetUpWindow;
var tempstr:string[15];
begin
  TDialog.SetUpWindow;
  str(PBMProcess(parent)^.minlevel:5,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed1,wm_settext,0,longint(@buffer));
  str(PBMProcess(parent)^.maxlevel:5,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed2,wm_settext,0,longint(@buffer));
end;

procedure TXpandDlg.Ok(var msg:Tmessage);
var valcode:integer;

begin
  buffer[0]:=chr(0);
  SendDlgItemMessage(hwindow,id_ed1,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PBMProcess(parent)^.minlevel,valcode);
  SendDlgItemMessage(hwindow,id_ed2,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PBMProcess(parent)^.maxlevel,valcode);
  TDialog.Ok(msg);
end;

constructor TZoomDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TZoomDlg.SetUpWindow;
var tempstr:string[15];
begin
  TDialog.SetUpWindow;
  str(PBMProcess(parent)^.horzscale:5:2,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed1,wm_settext,0,longint(@buffer));
  str(PBMProcess(parent)^.vertscale:5:2,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed2,wm_settext,0,longint(@buffer));
  if PBMProcess(parent)^.interpolate then
       SendDlgItemMessage(hwindow,id_chkbox1,bm_setcheck,1,0)
  else SendDlgItemMessage(hwindow,id_chkbox1,bm_setcheck,0,0);
end;

procedure TZoomDlg.Ok(var msg:Tmessage);
var valcode:integer;

begin
  buffer[0]:=chr(0);
  SendDlgItemMessage(hwindow,id_ed1,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PBMProcess(parent)^.horzscale,valcode);
  SendDlgItemMessage(hwindow,id_ed2,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PBMProcess(parent)^.vertscale,valcode);
  if  SendDlgItemMessage(hwindow,id_chkbox1,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.interpolate:=true
     else PBMProcess(parent)^.interpolate:=false;
  TDialog.Ok(msg);
end;

constructor ThighpassDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure ThighpassDlg.Ok(var msg:Tmessage);

begin
  if  SendDlgItemMessage(hwindow,id_rad1,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.highpass_method:=1
  else if  SendDlgItemMessage(hwindow,id_rad2,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.highpass_method:=2
  else if  SendDlgItemMessage(hwindow,id_rad3,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.highpass_method:=3;
  TDialog.Ok(msg);
end;

constructor TLowpassDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TLowpassDlg.Ok(var msg:Tmessage);

begin
  if  SendDlgItemMessage(hwindow,id_rad1,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.lowpass_method:=1
  else if  SendDlgItemMessage(hwindow,id_rad2,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.lowpass_method:=2
  else if  SendDlgItemMessage(hwindow,id_rad3,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.lowpass_method:=3;
  TDialog.Ok(msg);
end;

constructor TDipDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TDipDlg.Ok(var msg:Tmessage);

begin
  if  SendDlgItemMessage(hwindow,id_rad1,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.Dip_method:=1
  else if  SendDlgItemMessage(hwindow,id_rad2,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.Dip_method:=2
  else if  SendDlgItemMessage(hwindow,id_rad3,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.Dip_method:=3;
  TDialog.Ok(msg);
end;

constructor TEmbossDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TEmbossDlg.Ok(var msg:Tmessage);

begin
  if  SendDlgItemMessage(hwindow,id_rad1,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=1
  else if  SendDlgItemMessage(hwindow,id_rad2,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=2
  else if  SendDlgItemMessage(hwindow,id_rad3,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=3
  else if  SendDlgItemMessage(hwindow,id_rad4,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=4
  else if  SendDlgItemMessage(hwindow,id_rad5,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=5
  else if  SendDlgItemMessage(hwindow,id_rad6,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=6
  else if  SendDlgItemMessage(hwindow,id_rad7,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=7
  else if  SendDlgItemMessage(hwindow,id_rad8,bm_Getcheck,0,0) =1 then
     PBMProcess(parent)^.emboss_method:=8;
  TDialog.Ok(msg);
end;

constructor THistoryDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure THistoryDlg.SetUpWindow;
var tempstr:string[15];
begin
  TDialog.SetUpWindow;
  SendDlgItemMessage(hwindow,id_ed1,wm_settext,0,
               longint(@PBMProcess(parent)^.ProcessHistory));
end;

procedure THistoryDlg.Ok(var msg:Tmessage);

begin
  TDialog.Ok(msg);
end;

{************************* Child Window Procedures***********************}
constructor TBMProcess.Init(AParent:PWindowsObject;AFileName:Pchar;
                                  thepixelwidth,thepixelheight:word);
begin
  TBitscrollWindow.init(AParent,AFileName,thepixelwidth,thepixelheight);
  statusdialog:=nil;
  ProcessHistory[0]:=#0;
end;

procedure TBMProcess.ImportFile(var Msg:Tmessage);

var
   TheFile: Text;
   row,col,locol,lorow,hicol,hirow:longint;
   temp:byte;
   value,lovalue,hivalue,scalefactor,tbias:real;

begin
  if Application^.ExecDialog(New(PFileDialog, Init(@Self, PChar(sd_FileOpen),
      StrCopy(FileName, '*.dat')))) = id_Ok then
  begin
    Assign(TheFile, FileName);
    {$I-}
    Reset(TheFile);
    {$I+}
    if IOResult = 0 then
    begin
      hivalue:=-1.0e+31;
      lovalue:=1.0e+31;
      hicol:=0;
      hirow:=0;
      locol:=10000;
      lorow:=10000;
      with bitmaparray do
      begin
        arrayaddr.ptr:=globallock(arrayhandle);
        setcursor(loadcursor(0,idc_wait));
        while not eof(thefile) do
        begin
          Readln(TheFile, row,col,value);
          if value > hivalue then hivalue:=value;
          if value < lovalue then lovalue:=value;
          if row > hirow then hirow:=row;
          if row < lorow then lorow:=row;
          if col > hicol then hicol:=col;
          if col < locol then locol:=col;
        end;
        Reset(TheFile);
        tbias:=0.0-lovalue;
        scalefactor:=255.0/(hivalue-lovalue);
        while not eof(thefile) do
        begin
          Readln(TheFile, row,col,value);
          temp:=trunc(scalefactor*(value-tbias));
          if temp > 255 then temp:=255;
          if temp < 0 then temp:=0;
          put(col,row,temp);
        end;
        globalunlock(arrayhandle);
      end;{with}
      setcursor(loadcursor(0,idc_arrow));
      bmpcreate;
      Adjustscroller;
      Close(TheFile);
    end;
  end
end;

procedure TBMProcess.ExportFile(var Msg:Tmessage);

type filenametype=array[0..fsPathname] of char;
var
   afile:filenametype;
   TheFile: Text;
   row,col:longint;
   value:byte;
   temp:real;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  if Application^.ExecDialog(New(PfileDialog,Init(@Self,Pchar(sd_FileSave),Afile)))
     =id_ok then
  begin
    Assign(TheFile,afile);
    Rewrite(TheFile);
    if IOResult = 0 then
    begin
      with bitmaparray do
      begin
        arrayaddr.ptr:=globallock(arrayhandle);
        setcursor(loadcursor(0,idc_wait));
        for col:=0 to maxcols-1 do
          for row:=0 to maxrows-1 do
          begin
            temp:=3.5*get(col,row);
            writeln(TheFile, row,' ',col,' ',temp:5:1);
          end;
        globalunlock(arrayhandle);
      end;{with}
      setcursor(loadcursor(0,idc_arrow));
      bmpcreate;
      Adjustscroller;
      Close(TheFile);
    end;
  end
end;



function TBMProcess.GetUserByte(prompt1,prompt2:shortstring):byte;
var temp:byte;
    code:integer;

begin
  valbuffer[0]:=#0;
  Application^.ExecDialog(New(PByteDlg,init(@self,prompt1,prompt2,
    valbuffer,sizeof(valbuffer))));
  val(valbuffer,temp,code);
  getuserbyte:=temp;
end;

procedure TBMProcess.Lookuptable(lut:luttype);
var row,col:longint;
    start,toaddr:longtype;
    temp:integer;
    value:byte;

begin
  with bitmaparray do
  begin
    arrayaddr.ptr:=globallock(arrayhandle);
    for col:=firstcol to lastcol do
    for row:=firstrow to lastrow do
    begin
      start.long:=row*maxcols+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=lut[toaddr.ptr^];
      if temp < 0 then temp:=0
        else if temp > 255 then temp:=255;
      value:=temp;
      toaddr.ptr^:=value;
    end;
  end;
  globalunlock(bitmaparray.arrayhandle);
end;{lookuptable}


procedure TBMProcess.ShowRectangle(var msg:Tmessage);

begin
  dragdc:=GetDC(hwindow);
  oldbrush:=selectObject(dragdc,GetStockObject(hollow_brush));
  setROP2(dragdc,r2_not);
  rectangle(dragdc,ptbeg.x,ptbeg.y,ptend.x,ptend.y);
  setrop2(dragdc,r2_black);
  releaseDC(hwindow,dragdc);
end;

Procedure TBMProcess.UpdatePalette(var msg:Tmessage);
var
  i : integer;

begin
  if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
        rgbred:=pered;
        rgbgreen:=pegreen;
        rgbblue:=peblue;
        peFlags := pc_NoCollapse;
        end;
       end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;{UpdatePalette}


procedure TBMProcess.RestorePalette(var Msg:Tmessage);
begin
  CopyDIBPalette(bitmapinfo^,palsize);
  InvalidateRect(hwindow,nil,true);
end;


Procedure TBMProcess.GrayPalette(var msg:Tmessage);
var
  i : integer;
  temp:byte;

begin
  if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
      (*  temp:=trunc((30*rgbred + 59*rgbgreen +11*rgbblue) div 100);
        if temp > 255 then temp:=255;
      *)
        pered:=i;
        peblue:=i;
        pegreen:=i;
        peFlags := pc_NoCollapse;
        end;
       end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;

Procedure TBMProcess.RainbowPalette(var msg:Tmessage);
var
  i : integer;
  temp:byte;

begin
  if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to (Pred(PalSize) div 4) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
        pered:=255-4*i;
        peblue:=0;
        pegreen:=i*2;
        peFlags := pc_NoCollapse;
        end;
       end;
   for i := Pred(PalSize) div 4 to Pred(palsize) div 2 do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
        pered:=0;
        peblue:=0;
        pegreen:=i*2;
        peFlags := pc_NoCollapse;
        end;
       end;
    for i := Pred(PalSize) div 2 to Pred(palsize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
        pered:=0;
        peblue:=2*(i-Pred(PalSize) div 2);
        pegreen:=pred(palsize)-i*2;
        peFlags := pc_NoCollapse;
        end;
       end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;

Procedure TBMProcess.GreenPalette(var msg:Tmessage);
var
  i : integer;
  temp:byte;

begin
  if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i],Bitmapinfo^.bmicolors[i]  do
        begin
        pered:=0;
        peblue:=0;
        pegreen:=i;
        peFlags := pc_NoCollapse;
        end;
       end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;


Procedure TBMProcess.BrPalette(var msg:Tmessage);
var
  i : integer;
  temp:integer;

begin
  if HactivePal <> 0 then {get rid of previous palette}
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i] do
        begin
        temp:=pered + 10;
        if temp > 255 then temp:=255;
        pered:=temp;
        temp:=pegreen + 10;
        if temp > 255 then temp:=255;
        pegreen:=temp;
        temp:=peblue + 10;
        if temp > 255 then temp:=255;
        peblue:=temp;
        peFlags := pc_NoCollapse;
       end;
     end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;

Procedure TBMProcess.DmPalette(var msg:Tmessage);
var
  i : integer;
  temp:integer;

begin
  if HactivePal <> 0 then {get rid of previous palette}
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i] do
        begin
        temp:=pered - 10;
        if temp <0 then temp:=0;
        pered:=temp;
        temp:=pegreen - 10;
        if temp < 0 then temp:=0;
        pegreen:=temp;
        temp:=peblue - 10;
        if temp < 0 then temp:=0;
        peblue:=temp;
        peFlags := pc_NoCollapse;
       end;
     end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;

Procedure TBMProcess.NegPalette(var msg:Tmessage);
var
  i : integer;
  temp:integer;

begin
  if HactivePal <> 0 then {get rid of previous palette}
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
  for i := 0 to Pred(PalSize) do
     With ActiveLogPal^do
       begin
       With palPalEntry[i] do
        begin
        temp:=255-pered;
        if temp <0 then temp:=0;
        pered:=temp;
        temp:=255-pegreen;
        if temp < 0 then temp:=0;
        pegreen:=temp;
        temp:=255-peblue;
        if temp < 0 then temp:=0;
        peblue:=temp;
        peFlags := pc_NoCollapse;
       end;
     end;
  HactivePal := CreatePalette(ActiveLogPal^);
  InvalidateRect(hwindow,nil,true);
end;


Procedure TBMProcess.PalAdjust(var msg:Tmessage);
var
  optionwnd:PWindow;
  i : integer;
  temp:integer;

begin
  redchange:=0;
  greenchange:=0;
  bluechange:=0;
  if HactivePal <> 0 then {get rid of previous palette}
  begin
     DeleteObject(HactivePal);
     HactivePal := 0;
   end;
  optionwnd:=New(PPalAdjWindow,init(@self,'Palette Adjust'));
  Application^.MakeWindow(optionwnd);

end;

procedure TBMProcess.colorcomponent(color:integer);
var col,row,rowholder:longint;
    start,toaddr:longtype;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
 bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  with bitmapinfo^,bitmaparray do
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      case color of
      clr_red:toaddr.ptr^:=bmicolors[toaddr.ptr^].rgbred;
      clr_green:toaddr.ptr^:=bmicolors[toaddr.ptr^].rgbgreen;
      clr_blue:toaddr.ptr^:=bmicolors[toaddr.ptr^].rgbblue;
      end;
    end;{col}
  end;{row}
  end;{with}
  globalunlock(bitmaparray.arrayhandle);
end;{colorcomponent}

procedure TBMProcess.RedComponent(var Msg:Tmessage);

var   i:integer;
      value:byte;
      temp:longint;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  colorcomponent(clr_red);
    for i:=0 to pred(palsize) do
    with bitmapinfo^.bmicolors[i] do
    begin
      rgbred:=i;
      rgbgreen:=0;
      rgbblue:=0;
    end;
    CopyDIBPalette(bitmapinfo^,palsize);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'RedComponent ');
   strcat(processhistory,#13#10);
end;

procedure TBMProcess.GreenComponent(var Msg:Tmessage);

var   i:integer;
      value:byte;
      temp:longint;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  colorcomponent(clr_green);
    for i:=0 to pred(palsize) do
    with bitmapinfo^.bmicolors[i] do
    begin
      rgbred:=0;
      rgbgreen:=i;
      rgbblue:=0;
    end;
    CopyDIBPalette(bitmapinfo^,palsize);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'GreenComponent ');
   strcat(processhistory,#13#10);
end;

procedure TBMProcess.BlueComponent(var Msg:Tmessage);

var   i:integer;
      value:byte;
      temp:longint;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  colorcomponent(clr_blue);
    for i:=0 to pred(palsize) do
    with bitmapinfo^.bmicolors[i] do
    begin
      rgbred:=0;
      rgbgreen:=0;
      rgbblue:=i;
    end;
    CopyDIBPalette(bitmapinfo^,palsize);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'BlueComponent ');
   strcat(processhistory,#13#10);
end;

procedure TBMProcess.ExtractY(var Msg:Tmessage);

var   col,row,rowholder:longint;
      i:integer;
      value:byte;
      temp,red,green,blue:longint;
      start,toaddr:longtype;



begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  with bitmapinfo^,bitmaparray do
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      red:=bmicolors[toaddr.ptr^].rgbred;
      green:=bmicolors[toaddr.ptr^].rgbgreen;
      blue:=bmicolors[toaddr.ptr^].rgbblue;
      temp:=trunc((299*red +
                   587*green +
                   114*blue) div 1000);
      if temp > 255 then temp:=255;
      value:=temp;
      toaddr.ptr^:=value;
    end;{col}
  end;{row}
  end;{with}

    globalunlock(bitmaparray.arrayhandle);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'Y component ');
   strcat(processhistory,#13#10);
end;

procedure TBMProcess.ExtractI(var Msg:Tmessage);

var   col,row,rowholder:longint;
      i:integer;
      value:byte;
      temp,red,green,blue:longint;
      start,toaddr:longtype;



begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  with bitmapinfo^,bitmaparray do
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      red:=bmicolors[toaddr.ptr^].rgbred;
      green:=bmicolors[toaddr.ptr^].rgbgreen;
      blue:=bmicolors[toaddr.ptr^].rgbblue;
      temp:=trunc((153000 + 596*red -275*green -321*blue) div 1200);
      if temp > 255 then temp:=255;
      if temp < 0 then temp:=0;
      value:=temp;
      toaddr.ptr^:=value;
    end;{col}
  end;{row}
  end;{with}

    globalunlock(bitmaparray.arrayhandle);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'I component ');
   strcat(processhistory,#13#10);

end;

procedure TBMProcess.ExtractQ(var Msg:Tmessage);

var   col,row,rowholder:longint;
      i:integer;
      value:byte;
      temp,red,green,blue:longint;
      start,toaddr:longtype;



begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  with bitmapinfo^,bitmaparray do
  begin
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      red:=bmicolors[toaddr.ptr^].rgbred;
      green:=bmicolors[toaddr.ptr^].rgbgreen;
      blue:=bmicolors[toaddr.ptr^].rgbblue;
      temp:=trunc((153000 + 212*red -523*green + 311*blue) div 1200);
      if temp > 255 then temp:=255;
      if temp < 0 then temp:=0;
      value:=temp;
      toaddr.ptr^:=value;
    end;{col}
  end;{row}
  end;{with}

    globalunlock(bitmaparray.arrayhandle);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'Q component ');
   strcat(processhistory,#13#10);

end;


procedure TBMProcess.MatrixFill(var Msg:Tmessage);

var x:byte;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
      strcopy(promptstr1,'Fill constant');
      strcopy(promptstr2,'0 <= x <=255');
      x:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        if bitmaparray.fill(firstcol,firstrow,lastcol,lastrow,x) then
        begin
          bmpcreate;
          Adjustscroller;
        end;
        setcursor(loadcursor(0,idc_arrow));
    strcat(processhistory,'Fill ');
    strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixBias(var Msg:Tmessage);

var   bias:integer;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    bias:=0;
    strcopy(promptstr1,'Bias');
      strcopy(promptstr2,'0 <= x <=255');
      bias:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.bias(firstcol,firstrow,lastcol,lastrow,bias);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
    strcat(processhistory,'Bias ');
    strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixScale(var Msg:Tmessage);

var   scale:real;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    scale:=0.0;
    strcopy(promptstr1,'Scale');
      strcopy(promptstr2,'0 <= x <=255');
      scale:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.put(pixelwidth div 2,pixelheight div 2,255);
(*        bitmaparray.scale(firstcol,firstrow,lastcol,lastrow,scale);*)
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
    strcat(processhistory,'Scale ');
    strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixCmin(var Msg:Tmessage);

var   minvalue:byte;

begin
(*
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  *)
    minvalue:=0;
    strcopy(promptstr1,'Cmin');
    strcopy(promptstr2,'minimum value');
    minvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.cmin(firstcol,firstrow,lastcol,lastrow,minvalue);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
    strcat(processhistory,'Cmin ');
    strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixCmax(var Msg:Tmessage);

var   maxvalue:byte;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    maxvalue:=0;
    strcopy(promptstr1,'Cmax');
      strcopy(promptstr2,'maximum value');
      maxvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.cmax(firstcol,firstrow,lastcol,lastrow,maxvalue);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
    strcat(processhistory,'Cmax ');
    strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixThreshold(var Msg:Tmessage);

var   minvalue:byte;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    minvalue:=0;
    strcopy(promptstr1,'Threshold');
      strcopy(promptstr2,'0 <= x <=255');
      minvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.threshold(firstcol,firstrow,lastcol,lastrow,minvalue);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'Threshold ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixBitplane(var Msg:Tmessage);

var   whichbit:byte;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    whichbit:=1;
    strcopy(promptstr1,'Bitplane slice');
      strcopy(promptstr2,'1 <= x <=8');
      whichbit:=GetUserByte(promptstr1,promptstr2);
        whichbit:=8-whichbit;
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.bitplane(firstcol,firstrow,lastcol,lastrow,whichbit);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'Bitplane ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixNBits(var Msg:Tmessage);

var   numofbits:byte;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  numofbits:=1;
  strcopy(promptstr1,'N bits/pixel');
  strcopy(promptstr2,'1 <= x <=8');
  numofbits:=GetUserByte(promptstr1,promptstr2);
  numofbits:=8-numofbits;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.nbits(firstcol,firstrow,lastcol,lastrow,numofbits);
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
  strcat(processhistory,'NBits ');
  strcat(processhistory,#13#10);
end;



procedure TBMProcess.MatrixInvert(var Msg:Tmessage);

var   minvalue:byte;
begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    minvalue:=0;
    strcopy(promptstr1,'Invert');
      strcopy(promptstr2,'Threshold 0 <= x <=255');
      minvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.invert(firstcol,firstrow,lastcol,lastrow,minvalue);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'Invert ');
 strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixXpandGray(var Msg:Tmessage);



begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  Application^.ExecDialog(New(PXpandDlg,init(@self,Pchar('Xpanddlg'),selection)));
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.xpandgray(firstcol,firstrow,lastcol,lastrow,minlevel,maxlevel);
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
 strcat(processhistory,'Xpandgray ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixStrHist(var Msg:Tmessage);

var   newmin,newmax,minvalue:byte;
      i: Integer;
      stepval,stepsize:real;
      lut:luttype;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    minvalue:=0;
    strcopy(promptstr1,'Stretch Histogram');
      strcopy(promptstr2,'Histogram threshold');
      minvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
        i:=-1;
        repeat
        i:=i+1
        until (realhisto[i] > minvalue) or (i=254);
        repeat
        i:=i+1
        until (realhisto[i] > minvalue) or (i=255);
        newmin:=i;
        i:=256;
        repeat
        i:=i-1;
        until (realhisto[i] > minvalue) or (i=1);
        repeat
        i:=i-1;
        until (realhisto[i] > minvalue) or (i=0);
        newmax:=i;
        stepsize:=255.0/(newmax-newmin +1);
        stepval:=0.0;
        for i:=0 to newmin-1 do
        lut[i]:=0;
        for i:=newmax +1 to 255 do
        lut[i]:=0;
        for i:=newmin to newmax do
        begin
          lut[i]:=trunc(stepval);
          stepval:=stepval + stepsize;
           if stepval > 255.0 then stepval:=255.0;
        end;
        lookuptable(lut);

        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'StrHist ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixHistEqual(var Msg:Tmessage);

var
      lut:luttype;
      totalnum:real;
      i,width,height:longint;
      col,row:word;
      temp:byte;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  calchist;
  rT[0]:=realhisto[0];
  for i:=1 to 255 do
    rT[i]:=rT[i-1] + realhisto[i];
  for i:=0 to 255 do
  begin
    temp:=trunc(255*rT[i]);
    if temp > 255 then temp:=255;
    if temp < 0 then temp:=0;
    lut[i]:=temp
  end;
  lookuptable(lut);
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
 strcat(processhistory,'HistEqual ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixHistLocal(var Msg:Tmessage);
var
  col,row,longwidth,sizeimage:longint;
  blocksize,halfwidth,i,j:integer;
  norm:real;
  temp: Integer;
  ok:boolean;
  tempstr:string[10];

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  blocksize:=0;
  longwidth:=pixelwidth;
  sizeimage:=longwidth*pixelheight;
    strcopy(promptstr1,'Histogram Equalize');
      strcopy(promptstr2,'Block size');
      blocksize:=GetUserByte(promptstr1,promptstr2);
      norm:=255/sqr(blocksize);
      halfwidth:=blocksize div 2;
      setcursor(loadcursor(0,idc_wait));
      tempbitmap.init(pixelwidth,pixelheight,ok);
      with bitmaparray do
      begin
        arrayaddr.ptr:=globallock(arrayhandle);
        tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
        col:=firstcol + halfwidth;
        row:=firstrow + halfwidth;
        str(maxrows:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' rows');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Histogram equalize');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current row');
        while row <= lastrow-halfwidth do
        begin
          str(row:5,tempstr);
          strpcopy(buffer,tempstr);
          statusdialog^.update3(buffer);
          for i:=0 to 255 do
          realhisto[i]:=0.0;
          for i:=-halfwidth to halfwidth do
            for j:=-halfwidth to halfwidth do
              realhisto[get(col+i,row+j)]:=realhisto[get(col+i,row+j)] + 1.0;
          while col <= lastcol-blocksize do
          begin
            if col > (firstcol + halfwidth) then
            begin
              for j:=-halfwidth to halfwidth do
              begin
                realhisto[get(col-1-halfwidth,row+j)]:=
                         realhisto[get(col-1-halfwidth,row+j)] - 1.0;
                realhisto[get(col+halfwidth,row+j)]:=
                         realhisto[get(col+halfwidth,row+j)] + 1.0;
              end;{for}
            end;{if col}
           rT[0]:=norm*realhisto[0];
           if rT[0] < 0.0 then rT[0]:=0.0;
           if rT[0] > 255.0 then rT[0]:=255.0;
           for i:=1 to get(col,row) do
           begin
             rT[i]:=rT[i-1] + norm * realhisto[i];
             if rT[i] > 255.0 then rT[i]:=255.0;
           end;
           temp:=trunc(rT[get(col,row)]);
           if temp >255 then temp:=255;
           if temp < 0 then temp:=0;

           tempbitmap.put(col,row,temp);
          col:=succ(col)
          end;{while col}
          col:=firstcol;
          row:=succ(row);
        end;{while row};
      statusdialog^.closewindow;
     statusdialog:=nil;
      hmove(tempbitmap.arrayaddr.ptr,bitmaparray.arrayaddr.ptr,sizeimage);
      globalunlock(arrayhandle);
      end;{with bitmaparray}
      globalunlock(tempbitmap.arrayhandle);
      tempbitmap.done;
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Histo Local ');
  strcat(processhistory,#13#10);
end;{Histo Local}

procedure TBMProcess.MatrixGrayMap(var Msg:Tmessage);

var   midpoint,value:byte;
      i: Integer;
      stepval,stepsize:real;
      lut:luttype;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    strcopy(promptstr1,'Map Gray levels');
      strcopy(promptstr2,'Output value for input of 127');
      midpoint:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
        stepval:=midpoint/127.0;
        for i:=0 to 127 do
          lut[i]:=trunc(i*stepval);
        stepval:=(255-midpoint)/127.0;
        for i:=128 to 255 do
          lut[i]:=midpoint + trunc((i-127)*stepval);
        lookuptable(lut);

        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'Graymap ');
 strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixKodalith(var Msg:Tmessage);

var   minvalue:byte;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    minvalue:=0;
    strcopy(promptstr1,'Kodalith');
      strcopy(promptstr2,'Threshold value');
      minvalue:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        bitmaparray.kodalith(firstcol,firstrow,lastcol,lastrow,minvalue);
        setcursor(loadcursor(0,idc_arrow));
        bmpcreate;
    Adjustscroller;
 strcat(processhistory,'Kodalith ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.Matrixhighpass(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;
      pta,ptb,ptc,ptd,pte,ptf,ptg,pth,pti:integer;
      tempstr:string[15];

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
    Application^.ExecDialog(New(PHighpassDlg,init(@self,Pchar('Highpassdlg'),selection)));
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' columns');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('High Pass');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');

     for col:=firstcol + 1 to lastcol-1 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);

       row:=firstrow;
       ptd:=get(col-1,row);pte:=get(col,row);ptf:=get(col+1,row);
       ptg:=get(col-1,row+1);pth:=get(col,row+1);pti:=get(col+1,row+1);
       row:=row+1;
       while row < lastrow do
       begin
         pta:=ptd;ptb:=pte;ptc:=ptf;
         ptd:=ptg;pte:=pth;ptf:=pti;
         ptg:=get(col-1,row+1);
         pth:=get(col,row+1);
         pti:=get(col+1,row+1);
         case highpass_method of
         (*
         1:temp:=10*pte-pta-ptb-ptc-ptd-ptf-ptg-pth-pti;
         2:temp:=9*pte-pta-ptb-ptc-ptd-ptf-ptg-pth-pti;
         3:temp:=8*pte-pta-ptb-ptc-ptd-ptf-ptg-pth-pti;
         *)
         1:temp:=9*pte-pta-ptb-ptc-ptd-ptf-ptg-pth-pti;
         2:temp:=5*pte-ptb-ptd-ptf-pth;
         3:temp:=5*pte+pta-2*ptb+ptc-2*ptd-2*ptf+ptg-2*pth+pti;

         end;{case}
         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
         row:=row+1;
       end;{while row}
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;

    temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);

   tempbitmap.done;

   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
   strcat(processhistory,'High Pass ');
   strcat(processhistory,#13#10);
end;{highpass}


procedure TBMProcess.MatrixEdges(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp,pta,ptb,ptc,ptd,pte,ptf,ptg,pth,pti:integer;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for col:=firstcol + 1 to lastcol-1 do
     begin
       row:=firstrow;
       ptd:=get(col-1,row);pte:=get(col,row);ptf:=get(col+1,row);
       ptg:=get(col-1,row+1);pth:=get(col,row+1);pti:=get(col+1,row+1);
       row:=row+1;
       while row < lastrow do
       begin
         pta:=ptd;ptb:=pte;ptc:=ptf;
         ptd:=ptg;pte:=pth;ptf:=pti;
         ptg:=get(col-1,row+1);
         pth:=get(col,row+1);
         pti:=get(col+1,row+1);
         temp:=abs(ptb-pth)+abs(ptd-ptf)+abs(pta-pti)+abs(ptg-ptc);
         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
         row:=row+1;
       end;{while row}
     end;{col}
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Edges ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixEmboss(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp,pta,ptb,ptc,ptd,pte,ptf,ptg,pth,pti:longint;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   Application^.ExecDialog(New(PEmbossDlg,init(@self,Pchar('Embossdlg'),selection)));
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for col:=firstcol + 1 to lastcol-1 do
     begin
       row:=firstrow;
       ptd:=get(col-1,row);pte:=get(col,row);ptf:=get(col+1,row);
       ptg:=get(col-1,row+1);pth:=get(col,row+1);pti:=get(col+1,row+1);
       row:=row+1;
       while row < lastrow do
       begin
         pta:=ptd;ptb:=pte;ptc:=ptf;
         ptd:=ptg;pte:=pth;ptf:=pti;
         ptg:=get(col-1,row+1);
         pth:=get(col,row+1);
         pti:=get(col+1,row+1);
         case emboss_method of
         1:temp:=128 + ptg-ptc;
         2:temp:=128 + ptd-ptf;
         3:temp:=128 + pta-pti;
         4:temp:=128 + ptb-pth;
         5:temp:=128 + ptc-ptg;
         6:temp:=128 + ptf-ptd;
         7:temp:=128 + pti-pta;
         8:temp:=128 + pth-ptb;
         end;{case}
         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
         row:=row+1;
       end;{while row}
     end;{col}
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Emboss ');
  strcat(processhistory,#13#10);
end;{emboss}



procedure TBMProcess.MatrixSmooth(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;

begin

  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;

   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for col:=firstcol+1 to lastcol-1 do
       for row:=firstrow + 1 to lastrow-1 do
       begin
         temp:=(get(col,row-1) +
              get(col,row+1) +
              get(col-1,row) +
              get(col+1,row))
              div 4;

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Smooth ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixBlur(var Msg:Tmessage);

var   shift,i:integer;
      col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;

begin

  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;

  shift:=0;
  strcopy(promptstr1,'Blur');
  strcopy(promptstr2,'Number of pixels to blur');
  shift:=GetUserByte(promptstr1,promptstr2);
         tempbitmap.init(pixelwidth,pixelheight,ok);
         with bitmaparray do
         begin
           arrayaddr.ptr:=globallock(arrayhandle);
           tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
           setcursor(loadcursor(0,idc_wait));

           for row:=firstrow + 1 to lastrow-1 do
           begin
             for col:=firstcol+1 to lastcol-1-shift do
             begin
               temp:=0;
               for i:=0 to shift do
                 temp:=temp + get(col+i,row);
               temp:=temp div (shift+1);
               if temp > 255 then temp:=255;
               if temp < 0 then temp:=0;
               value:=temp;
               tempbitmap.put(col,row,value);
             end;{col}
           end;{row}
           temp2bitmap;
           globalunlock(arrayhandle);
         end;{with}
       globalunlock(tempbitmap.arrayhandle);
       tempbitmap.done;
       setcursor(loadcursor(0,idc_arrow));
       bmpcreate;
       Adjustscroller;
       strcat(processhistory,'Blur ');
       strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixSobelH(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;
      tempstr:string[10];


begin

  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;

   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' cols');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Sobel horizontal');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');
     for col:=firstcol+1 to lastcol-1 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
       for row:=firstrow + 1 to lastrow-1 do
       begin
         temp:=(get(col-1,row+1) +
                2*get(col,row+1) +
                2*get(col+1,row+1) -
                get(col-1,row-1) -
                2*get(col,row-1) -
                get(col+1,row-1));

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'SobelH ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixSobelV(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;
      tempstr:string[10];



begin

  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;

   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' cols');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Sobel vertical');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));

     for col:=firstcol+1 to lastcol-1 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
       for row:=firstrow + 1 to lastrow-1 do
       begin
         temp:=(get(col-1,row-1) -
                get(col+1,row-1) +
                2*get(col-1,row) -
                2*get(col+1,row) +
                2*get(col-1,row+1) -
                get(col+1,row+1));

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'SobelV ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixSobelHV(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;
      tempstr:string[15];


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' cols');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Sobel both');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');

     for col:=firstcol+2 to lastcol-2 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
       for row:=firstrow + 2 to lastrow-2 do
       begin
         temp:=(-2*get(col-2,row-2) -
                2*get(col-1,row-2) +
                3*get(col,row-2) +
                4*get(col+1,row-2) +
                2*get(col+2,row-2) -
                4*get(col-2,row-1) -
                4*get(col-1,row-1) +
                2*get(col,row-1) +
                4*get(col+1,row-1) +
                2*get(col+2,row-1) -
                get(col-2,row) -
                2*get(col+1,row) -
                get(col+2,row) +
                2*get(col-2,row+1) +
                4*get(col-1,row+1) -
                2*get(col+1,row+1) -
                2*get(col+2,row+1) +
                get(col-2,row+2) +
                2*get(col-1,row+2) -
                2*get(col+1,row+2) -
                get(col+2,row+2)) div 3;

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'SobelHV ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixDip(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      pta,ptb,ptc:real;
      ok:boolean;
      tempstr:string[10];

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   Application^.ExecDialog(New(PDipDlg,init(@self,Pchar('Dipdlg'),selection)));
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' columns');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Dip');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');
     for col:=firstcol to lastcol-1 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
       for row:=firstrow to lastrow-1 do
       begin
         pta:=get(col,row);
         ptb:=get(col+1,row);
         ptc:=get(col,row+1);
         case dip_method of
         1:temp:=8*trunc(sqrt(sqr(ptb-pta) + sqr(ptc-pta)));
         2:temp:=trunc(ptb-pta) + 128;
         3:temp:=trunc(ptc-pta) + 128;
         end;
         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}

   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Dip ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixLogarithm(var Msg:Tmessage);

var   i:integer;
      lut:luttype;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     setcursor(loadcursor(0,idc_wait));
        for i:=0 to 255 do
          lut[i]:=trunc(45*ln(1 + i));
        lookuptable(lut);
     globalunlock(arrayhandle);
   end;{with}

   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Logarithm ');
  strcat(processhistory,#13#10);
end;



procedure TBMProcess.MatrixVertSmth(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for col:=firstcol to lastcol do
       for row:=firstrow + 1 to lastrow-1 do
       begin
         temp:=(get(col,row-1) +
              get(col,row) +
              get(col,row+1))
              div 3;

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Vert smth ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixHorzSmth(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp:longint;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for col:=firstcol+1 to lastcol-1 do
       for row:=firstrow to lastrow do
       begin
         temp:=(get(col-1,row) +
              get(col,row) +
              get(col+1,row))
              div 3;

         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
       end;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Horz smth ');
  strcat(processhistory,#13#10);
end;



procedure TBMProcess.Matrixlowpass(var Msg:Tmessage);

var   col,row:longint;
      value:byte;
      temp,pta,ptb,ptc,ptd,pte,ptf,ptg,pth,pti:integer;
      ok:boolean;
      tempstr:string[10];

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  Application^.ExecDialog(New(PLowpassDlg,init(@self,Pchar('LowPassdlg'),selection)));
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' columns');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Low Pass');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');

     for col:=firstcol + 1 to lastcol-1 do
     begin
      str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);

       row:=firstrow;
       ptd:=get(col-1,row);pte:=get(col,row);ptf:=get(col+1,row);
       ptg:=get(col-1,row+1);pth:=get(col,row+1);pti:=get(col+1,row+1);
       row:=row+1;
       while row < lastrow do
       begin
         pta:=ptd;ptb:=pte;ptc:=ptf;
         ptd:=ptg;pte:=pth;ptf:=pti;
         ptg:=get(col-1,row+1);
         pth:=get(col,row+1);
         pti:=get(col+1,row+1);
         case lowpass_method of
         1:temp:=(pta+ptb+ptc+ptd+pte+ptf+ptg+pth+pti) div 9;
         2:temp:=(pta+ptb+ptc+ptd+2*pte+ptf+ptg+pth+pti) div 10;
         3:temp:=(pta+2*ptb+ptc+2*ptd+4*pte+2*ptf+ptg+2*pth+pti) div 16;
         end;{case}
         if temp > 255 then temp:=255;
         if temp < 0 then temp:=0;
         value:=temp;
         tempbitmap.put(col,row,value);
         row:=row+1;
       end;{while row}
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
 strcat(processhistory,'Low Pass ');
 strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixMedian(var Msg:Tmessage);

var   col,row:longint;
      j,k:byte;
      thisvalue:byte;
      neighbors:array[1..9] of byte;
      ok:boolean;
      tempstr:string[15];


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   tempbitmap.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     str(maxcols:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' cols');
     setcursor(loadcursor(0,idc_wait));
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                     init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Median filter');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current column');
     while statusdialog^.continue do
     begin
     for col:=firstcol +1 to lastcol-1 do
     begin
       str(col:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
      for row:=firstrow + 1 to lastrow-1 do
       begin
         neighbors[1]:=get(col-1,row-1);
         neighbors[2]:=get(col,row-1);
         neighbors[3]:=get(col+1,row-1);
         neighbors[4]:=get(col-1,row);
         neighbors[5]:=get(col,row);
         neighbors[6]:=get(col+1,row);
         neighbors[7]:=get(col-1,row+1);
         neighbors[8]:=get(col,row+1);
         neighbors[9]:=get(col+1,row+1);
         for j:=2 to 9 do
         begin
           thisvalue:=neighbors[j];
           k:=j-1;
           while (thisvalue < neighbors[k]) and (k>0) do
           begin
             neighbors[k+1]:=neighbors[k];
             k:=k-1;
           end;{while}
           neighbors[k+1]:=thisvalue
         end;{for j}
       tempbitmap.put(col,row,neighbors[5]);
      end;{for row}
     end;{col}
     statusdialog^.closewindow;
     statusdialog:=nil;
     end;{while}
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
 strcat(processhistory,'Median ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixDither4(var msg:Tmessage);
{Bayer ordered dither array}

type dithermatrix=array[0..3,0..3] of byte;
const dith4matrix:dithermatrix=(
       (1,9,3,11),(13,5,15,7),(4,12,2,10),
       (16,8,14,6));

var  col,row,rowholder:longint;
     value:byte;
     start,toaddr:longtype;

function scale(pixval:word):word;
begin
  scale:=trunc(pixval*0.062745)
end;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
      begin
        start.long:=rowholder+col;
        toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
        toaddr.lo:=start.lo;
        if (dith4matrix[row mod 4,col mod 4] < ((toaddr.ptr^) shr 4))
        then toaddr.ptr^:=255
        else toaddr.ptr^:=0;
      end;
  end;
   globalunlock(arrayhandle);
 end;{with}
 setcursor(loadcursor(0,idc_arrow));
 bmpcreate;
 Adjustscroller;
 strcat(processhistory,'Dither4 ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixDither3(var msg:Tmessage);

type dithermatrix=array[0..2,0..2] of byte;

const dith3matrix:dithermatrix=(
       (3,7,5),(6,1,2),(9,4,8));
var
     col,row,rowholder:longint;
     value:byte;
     start,toaddr:longtype;

function scale(pixval:word):word;
begin
  scale:=trunc(pixval*0.035294)
end;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
      begin
        start.long:=rowholder+col;
        toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
        toaddr.lo:=start.lo;
        if (dith3matrix[row mod 3,col mod 3] <
               (trunc((toaddr.ptr^)*0.035294)))
        then toaddr.ptr^:=255
        else toaddr.ptr^:=0;
      end;
  end;
   globalunlock(arrayhandle);
 end;{with}
 setcursor(loadcursor(0,idc_arrow));
 bmpcreate;
 Adjustscroller;
 strcat(processhistory,'Dither3 ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixHalftone(var msg:Tmessage);

type halftonetype=array[0..2,0..2] of byte;

const halftonematrix:halftonetype=(
       (168,224,112),(28,0,84),(140,56,196));
var  i,j:integer;
     col,row:longint;
     value,temp:byte;


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for col:=firstcol to lastcol-2 do
    for row:=firstrow to lastrow-2 do
    begin
      if (((row-1) mod 3 =0) and ((col-1) mod 3 =0)) then
      begin
      temp:=get(col,row);
      for i:=0 to 2 do
        for j:=0 to 2 do
        begin
          if (halftonematrix[i,j] < temp)
          then value:=255
          else value:=0;
          put(col+i,row+j,value);
        end;
      end;
    end;
 globalunlock(arrayhandle);
 end;{with}
 setcursor(loadcursor(0,idc_arrow));
 bmpcreate;
 Adjustscroller;
 strcat(processhistory,'Halftone ');
 strcat(processhistory,#13#10);
end;


procedure TBMProcess.MatrixDithDiff(var msg:Tmessage);


var  i,j:integer;
     sizeimage,col,row,longwidth:longint;
     value:byte;
     ed:array[1..500] of integer;
     e:array[1..4] of integer;
     ef,h,temp:integer;
     ok:boolean;



begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  tempbitmap.init(pixelwidth,pixelheight,ok);
  longwidth:=pixelwidth;
  sizeimage:=longwidth*pixelheight;
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
  for col:=0 to maxcols-1 do ed[col]:=0;
  row:=0;
  while row < maxrows do
  begin
    ef:=0;
    for col:=0 to maxcols-1 do
    begin
      temp:=get(col,row) + ef + ed[col];
      if temp < 0 then temp:=0;
      if temp > 255 then temp:=255;
      value:=temp;
      put(col,row,value);
      if value < 127 then
      begin
        tempbitmap.put(col,row,0)
      end
      else
      begin
        tempbitmap.put(col,row,255);
      end;
      temp:=get(col,row)-tempbitmap.get(col,row);
      h:=temp div 2;
      e[1]:=(7*h) shr 3;
      e[2]:=h-e[1];
      h:=temp-h;
      e[3]:=(5*h) shr 3;
      e[4]:=e[3];
      h:=e[3];
      ef:=e[1];
      if col < maxcols-1 then ed[col+1]:=e[2];
      if col = 0 then
        ed[col]:=e[3]
        else ed[col]:=ed[col] + e[3];
      if col > 0 then ed[col-1]:=ed[col-1] + e[4];
    end;{for col}
  row:=row+1;
  ef:=0;
  for col:=maxcols-1 downto 0 do
   begin
      temp:=get(col,row) + ef + ed[col];
      if temp < 0 then temp:=0;
      if temp > 255 then temp:=255;
      value:=temp;
      put(col,row,value);
      if value < 127 then
      begin
        tempbitmap.put(col,row,0)
      end
      else
      begin
        tempbitmap.put(col,row,255);
      end;
      temp:=get(col,row)-tempbitmap.get(col,row);
      h:=temp div 2;
      e[1]:=(7*h) shr 3;
      e[2]:=h-e[1];
      h:=temp-h;
      e[3]:=(5*h) shr 3;
      e[4]:=e[3];
      h:=e[3];
      ef:=e[1];
      if col >0 then ed[col-1]:=e[2];
      if col = maxcols-1 then
        ed[col]:=e[3]
        else ed[col]:=ed[col] + e[3];
      if col < maxcols-1 then ed[col+1]:=ed[col+1] + e[4];
    end;{for col}
  row:=row+1;

  end;{while}
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
  hmove(tempbitmap.arrayaddr.ptr,bitmaparray.arrayaddr.ptr,
           SizeImage);
  globalunlock(bitmaparray.arrayhandle);
  globalunlock(tempbitmap.arrayhandle);
  end;{with}
  tempbitmap.done;
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
 strcat(processhistory,'DithDiff ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixDith16(var Msg:Tmessage);
var
  oldbitmap:Hbitmap;
  i,bitcount:integer;
  longwidth,col,row:longint;
  srccol,srcrow,destrow,destcol: word;
  DCHandle,memdc: HDC;
  BitsPtr: Pointer;
  ok,on:boolean;
  temp:integer;

procedure nodot;
begin
  mono_bitmaparray.put(destcol,destrow,false);
end;

procedure onedot;
begin
  mono_bitmaparray.put(destcol+1,destrow+1,true);
end;

procedure twodot;
begin
  onedot;
  mono_bitmaparray.put(destcol+2,destrow+1,true);
end;

procedure threedot;
begin
  Twodot;
  mono_bitmaparray.put(destcol+2,destrow+2,true);
end;

procedure fourdot;
begin
  Threedot;
  mono_bitmaparray.put(destcol+1,destrow+2,true);
end;

procedure fivedot;
begin
  Fourdot;
  mono_bitmaparray.put(destcol,destrow+1,true);
end;

procedure sixdot;
begin
  Fivedot;
  mono_bitmaparray.put(destcol+1,destrow,true);
end;

procedure sevendot;
begin
  Sixdot;
  mono_bitmaparray.put(destcol,destrow+2,true);
end;

procedure Eightdot;
begin
  Sevendot;
  mono_bitmaparray.put(destcol+2,destrow,true);
end;

procedure Ninedot;
begin
  Eightdot;
  mono_bitmaparray.put(destcol+1,destrow+3,true);
end;

procedure Tendot;
begin
  Ninedot;
  mono_bitmaparray.put(destcol+3,destrow+1,true);
end;

procedure Elevendot;
begin
  Tendot;
  mono_bitmaparray.put(destcol+2,destrow+3,true);
end;

procedure Twelvedot;
begin
  Elevendot;
  mono_bitmaparray.put(destcol+3,destrow+2,true);
end;

procedure Thirteendot;
begin
  Twelvedot;
  mono_bitmaparray.put(destcol,destrow+3,true);
end;

procedure Fourteendot;
begin
  Thirteendot;
  mono_bitmaparray.put(destcol,destrow,true);
end;

procedure Fiveteendot;
begin
  Fourteendot;
  mono_bitmaparray.put(destcol+3,destrow,true);
end;

procedure Sixteendot;
begin
  Fiveteendot;
  mono_bitmaparray.put(destcol+3,destrow+3,true);
end;


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  bitcount:=1;
  mono_bitmapinfosize := SizeOf(TBitmapInfoHeader) + ((1 shl bitCount) * SizeOf(TRGBQuad));
  mono_BitmapInfo := MemAlloc(mono_bitmapinfosize);
  with mono_bitmapinfo^ do
  begin
    bmiheader.bisize:=40;
    bmiHeader.biBitCount:=1;
    bmiHeader.biplanes:=1;
    bmiheader.biCompression:=0;
    bmiheader.bixpelspermeter:=0;
    bmiheader.biypelspermeter:=0;
    bmiheader.biclrused:=0;
    bmiheader.biclrimportant:=0;
    newpixelwidth:=pixelwidth*4;
    newpixelheight:=pixelheight*4;
    longWidth := (NewPixelWidth +7) div 8;
    longwidth:=4*((longwidth + 3) div 4);
    pixelwidth:=8*longwidth;
    pixelheight:=newpixelheight;
    bmiheader.biwidth:=pixelwidth;
    bmiHeader.biHeight:=pixelheight;
    bmiHeader.biSizeImage := longWidth * NewPixelHeight;
    mono_PalSize := 1 shl bmiHeader.biBitCount;
    for i:=0 to 1 do
    begin
      bmicolors[i].rgbred:=i*255;
      bmicolors[i].rgbgreen:=i*255;
      bmicolors[i].rgbblue:=i*255;
    end;{for}
  end;{with mono_bitmapinfo}
  freemem(ActiveLogPal,totpalsize);
  totpalsize:=sizeof(TlogPalette) + pred(mono_palsize)*sizeof(TpaletteEntry);
  getmem(activelogpal,totpalsize);
  CopyDIBPalette(mono_BitMapInfo^,mono_palsize);
  GlobalCompact(-1);
  setcursor(loadcursor(0,idc_wait));
  mono_bitmaparray.init(pixelwidth,pixelheight,ok);
  with mono_bitmaparray do
  begin
    arrayaddr.ptr:=globallock(arrayhandle);
    bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
    srccol:=0;
    srcrow:=0;
    destcol:=0;
    destrow:=0;
    while srcrow < bitmaparray.maxrows-1 do
    begin
      while srccol < bitmaparray.maxcols-1 do
      begin
        temp:=(1+bitmaparray.get(srccol,srcrow)) div 16;
        case temp of
         0:nodot;
         1:onedot;
         2:twodot;
         3:threedot;
         4:fourdot;
         5:fivedot;
         6:sixdot;
         7:sevendot;
         8:eightdot;
         9:ninedot;
        10:tendot;
        11:elevendot;
        12:twelvedot;
        13:thirteendot;
        14:fourteendot;
        15:fiveteendot;
        16:sixteendot;
        end;{case}
        srccol:=srccol+1;
        destcol:=destcol+4;
      end;{while srccol}
      srccol:=0;
      destcol:=0;
      srcrow:=srcrow+1;
      destrow:=destrow+4;
    end;{while srcrow}
    globalunlock(arrayhandle);
    globalunlock(bitmaparray.arrayhandle);
  end;{with mono_bitmaparray}
  bitmaparray.done;
  dchandle:=createdc('Display',nil,nil,nil);
  BitsPtr := GlobalLock(mono_bitmaparray.arrayhandle);
  UnrealizeObject(HactivePal);                        {!!}
  OldPal := SelectPalette(dchandle,HactivePal,false); {!!}
  RealizePalette(dchandle);                     {!!}
  if NewBitmaphandle <>0 then deleteobject(newbitmaphandle);
  NewBitmapHandle :=
    CreateDIBitmap(dchandle, mono_BitmapInfo^.bmiHeader, cbm_Init, BitsPtr,
      mono_BitmapInfo^, dib_rgb_colors);
  SelectPalette(dchandle,OldPal,false);         {!!}
  deleteDC(dchandle);
  bitmaphandle:=newbitmaphandle;
  setcursor(loadcursor(0,idc_arrow));
  adjustscroller;
  bitmap_mono:=true;
 strcat(processhistory,'Dith16 ');
 strcat(processhistory,#13#10);
end;{dith16}

procedure TBMProcess.MatrixPixelate(var Msg:Tmessage);
var
  col,row:longint;
  temp,blocksize,i,j:integer;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  blocksize:=0;
  strcopy(promptstr1,'Pixelate');
  strcopy(promptstr2,'Block size');
  blocksize:=GetUserByte(promptstr1,promptstr2);
      setcursor(loadcursor(0,idc_wait));
      with bitmaparray do
      begin
        arrayaddr.ptr:=globallock(arrayhandle);
        col:=firstcol;
        row:=firstrow;
        while row <= lastrow-blocksize do
        begin
          while col <= lastcol-blocksize do
          begin
           temp:=get(col,row);
           for i:=0 to blocksize-1 do
             for j:=0 to blocksize-1 do
              put(col+i,row+j,temp);
          col:=col+blocksize
          end;{while col}
          col:=firstcol;
          row:=row+blocksize;
        end;{while row};
      globalunlock(arrayhandle);
      end;{with bitmaparray}
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Pixelate ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixZoom(var Msg:Tmessage);

var   col,row:longint;
      sizeimage,longwidth:longint;
      thisvalue:byte;
      ok:boolean;
      dheight,dwidth,swidth,sheight,spixelcolnum,spixelrownum:longint;
      spixelcoladdr,spixelrowaddr,rowdelta,coldelta,AandB,CandD:real;
      temp,pta,ptb,ptc,ptd:integer;
      tempstr:string[15];

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  swidth:=abs(lastcol-firstcol) +1;
  sheight:=abs(lastrow-firstrow) +1;
  Application^.ExecDialog(New(PZoomDlg,init(@self,Pchar('Zoomdlg'),selection)));
  dwidth:=trunc(horzscale*swidth + 0.5);
  longwidth:=(((dwidth*8) + 31) div 32)*4;
  dheight:=trunc(vertscale*sheight + 0.5);
  sizeimage:=longwidth*dheight;
  tempbitmap.init(longwidth,dheight,ok);
  if ok then
  begin
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     str(dheight:5,tempstr);
     strPcopy(buffer,tempstr);
     strcat(buffer,' rows');
     if statusdialog=nil then
     begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
     end;
     statusdialog^.beginstatus('Zoom');
     statusdialog^.update1(buffer);
     statusdialog^.update2('Current row');
     for row:=0 to dheight-1 do
     begin
       str(row:5,tempstr);
       strpcopy(buffer,tempstr);
       statusdialog^.update3(buffer);
       spixelrowaddr:=row/vertscale;
       spixelrownum:=trunc(spixelrowaddr);
       rowdelta:=spixelrowaddr-spixelrownum;
       spixelrownum:=spixelrownum + firstrow;
       for col:=0 to dwidth-1 do
       begin
         spixelcoladdr:=col/horzscale;
         spixelcolnum:=trunc(spixelcoladdr);
         coldelta:=spixelcoladdr-spixelcolnum;
         spixelcolnum:=spixelcolnum + firstcol;
         if interpolate then
         begin
           if (((spixelcolnum+1) <(swidth+firstcol-1)) and ((spixelrownum+1) < (sheight+firstrow-1))) then
           begin
            pta:= get(spixelcolnum,spixelrownum);
            ptb:= get(spixelcolnum+1,spixelrownum);
            ptc:= get(spixelcolnum,spixelrownum+1);
            ptd:= get(spixelcolnum+1,spixelrownum+1);
           end
           else
           begin
            ptb:=pta;
            ptc:=pta;
            ptd:=pta;
           end;{if spixel...}
           AandB:=coldelta*(ptb-pta) + pta;
           CandD:=coldelta*(ptd-ptc) + ptc;
           temp:=trunc(0.5 + AandB +
           (CandD - AandB)*rowdelta);
           if temp > 255 then temp:=255;
           if temp < 0 then temp:=0;
           thisvalue:=temp;
         end
         else {not interpolate}
           thisvalue:=get(spixelcolnum,spixelrownum);
         tempbitmap.put(col,row,thisvalue);
       end;{for col}
     end;{for row}
     statusdialog^.closewindow;
     statusdialog:=nil;
     globalunlock(arrayhandle);

   end;{with bitmaparray}

   bitmaparray.done;

   pixelwidth:=longwidth;
   pixelheight:=dheight;
   BitmapInfo^.bmiHeader.biWidth:=pixelwidth;
   BitmapInfo^.bmiHeader.biHeight:=pixelheight;
   BitmapInfo^.bmiHeader.biSizeImage:=sizeimage;
   firstcol:=0;
   firstrow:=0;
   lastcol:=pixelwidth-1;
   lastrow:=pixelheight-1;
   ptbeg.x:=0;
   ptbeg.y:=0;
   ptend.x:=pixelwidth-1;
   ptend.y:=pixelheight-1;

   globalcompact(-1);
   bitmaparray.init(pixelwidth,dheight,ok);
   if ok then
   begin
   bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
   tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
   hmove(tempbitmap.arrayaddr.ptr,bitmaparray.arrayaddr.ptr,
           SizeImage);
   globalunlock(bitmaparray.arrayhandle);
   globalunlock(tempbitmap.arrayhandle);
   end;{if bitmap.init ok}
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  end{if tempbitmap.init}
     else
        MessageBox(Hwindow,'Could not create temp buffer',
               'Too big ?',mb_iconExclamation or mb_ok);
   strcat(processhistory,'Zoom ');
   strcat(processhistory,#13#10);
end;{zoom}



procedure TBMProcess.MatrixVertMirror(var Msg:Tmessage);

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.vertmirror;
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
 strcat(processhistory,'VertMirror ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixHorzMirror(var Msg:Tmessage);

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.horzmirror;
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
 strcat(processhistory,'HorzMirror ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixRotate(var Msg:Tmessage);

var   i,j,sizeimage,longwidth:longint;
      initialwidth,initialheight,finalwidth,finalheight:integer;
      temp:byte;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   with bitmaparray do
   begin
   initialwidth:=maxcols;
   initialheight:=maxrows;
   finalwidth:=initialheight;
   finalheight:=initialwidth;
   longwidth:=(((finalwidth*8) + 31) div 32)*4;
   sizeimage:=longwidth*finalheight;
   tempbitmap.init(longwidth,finalheight,ok);
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     for j:=0 to finalheight-1 do
       for i:=0 to finalwidth-1 do
       begin
         tempbitmap.put(finalwidth-i-1,finalheight-j-1,get(j,initialheight-i-1));
       end;
  end;{with}
  bitmaparray.done;

   pixelwidth:=longwidth;
   pixelheight:=finalheight;
   BitmapInfo^.bmiHeader.biWidth:=pixelwidth;
   BitmapInfo^.bmiHeader.biHeight:=pixelheight;
   BitmapInfo^.bmiHeader.biSizeImage:=pixelheight*longwidth;
   bitmaparray.init(pixelwidth,finalheight,ok);

   bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
   tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
   hmove(tempbitmap.arrayaddr.ptr,bitmaparray.arrayaddr.ptr,
           SizeImage);
   globalunlock(bitmaparray.arrayhandle);
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
 strcat(processhistory,'Rotate ');
 strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixTranslate(var Msg:Tmessage);

var   col,row:longint;
      shift,srcol:integer;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
   shift:=0;
   strcopy(promptstr1,'Shift');
      strcopy(promptstr2,'Input a shift (+/- pixels):');
    shift:=GetUserByte(promptstr1,promptstr2);
      setcursor(loadcursor(0,idc_wait));
     tempbitmap.init(pixelwidth,pixelheight,ok);
     with bitmaparray do
     begin
      arrayaddr.ptr:=globallock(arrayhandle);
      tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
      for col:=firstcol+1 to lastcol-1 do
       for row:=firstrow + 1 to lastrow-1 do
       begin
         srcol:=col-shift;
         if srcol < 0 then srcol:=lastcol-(shift-col);
         if srcol > lastcol then srcol:=firstcol + col-shift-lastcol;
         tempbitmap.put(col,row,get(srcol,row));
       end;
     temp2bitmap;
     globalunlock(arrayhandle);
   end;{with}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Translate ');
  strcat(processhistory,#13#10);
end;



procedure TBMProcess.MatrixShear(var Msg:Tmessage);

var   row,col,sizeimage,longwidth:longint;
      initialwidth,initialheight,finalwidth,finalheight:integer;
      maxshift,partshift,dx,theta:real;
      wholeshift:integer;
      temparray:array[0..1500] of byte;
      temp:byte;
      ok:boolean;
      InputText: array[0..5] of Char;
      ErrorPos: Integer;
      tempstr:string[10];


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  theta:=0.0;
  Str(theta:5:3, InputText);
  if Application^.ExecDialog(New(PInputDialog,
     Init(@Self, 'Shear Angle ', 'Input an angle in degrees:',
     InputText, SizeOf(InputText)))) = id_Ok then
  begin
    Val(InputText, theta, ErrorPos);
    if ErrorPos = 0 then
    begin
    theta:=2*pi*theta;
    with bitmaparray do
    begin
    initialwidth:=maxcols;
    initialheight:=maxrows;
    maxshift:=maxrows * sin(theta/360.0)/cos(theta/360.0);
    finalwidth:=initialwidth + trunc(maxshift + 0.5);
    finalheight:=initialheight;
    longwidth:=(((finalwidth*8) + 31) div 32)*4;
    sizeimage:=longwidth*finalheight;
    tempbitmap.init(longwidth,finalheight,ok);
    arrayaddr.ptr:=globallock(arrayhandle);
    tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
    str(maxrows:5,tempstr);
    strPcopy(buffer,tempstr);
    strcat(buffer,' rows');
    if statusdialog=nil then
    begin
      statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                    init(@self,statusid))));
    end;
    statusdialog^.beginstatus('Shear');
    statusdialog^.update1(buffer);
    statusdialog^.update2('Current row');

    setcursor(loadcursor(0,idc_wait));
    for row:=0 to maxrows do
    begin
      str(row:5,tempstr);
      strpcopy(buffer,tempstr);
      statusdialog^.update3(buffer);
      dx:=row*sin(theta/360.0)/cos(theta/360.0);
      wholeshift:=trunc(dx);
      partshift:=dx-wholeshift;
      for col:=0 to wholeshift do
        temparray[col]:=0;
      for col:=wholeshift to finalwidth do
        temparray[col]:=bitmaparray.get(col-wholeshift,row);
      for col:=1 to finalwidth do
        tempbitmap.put(col,row,trunc(temparray[col-1]*(1.0-partshift)
                                     + temparray[col]*partshift));
    end;{for row}
    statusdialog^.closewindow;
    statusdialog:=nil;
  end;{with}
  bitmaparray.done;

   pixelwidth:=longwidth;
   pixelheight:=finalheight;
   BitmapInfo^.bmiHeader.biWidth:=pixelwidth;
   BitmapInfo^.bmiHeader.biHeight:=pixelheight;
   BitmapInfo^.bmiHeader.biSizeImage:=pixelheight*longwidth;
   bitmaparray.init(pixelwidth,finalheight,ok);

   bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
   tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
   hmove(tempbitmap.arrayaddr.ptr,bitmaparray.arrayaddr.ptr,
           SizeImage);
   globalunlock(bitmaparray.arrayhandle);
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
  Adjustscroller;
 strcat(processhistory,'Shear ');
 strcat(processhistory,#13#10);
 end;{if pinputdialog}
 end;{if errorpos=0}
end;{Shear}

procedure TBMProcess.CutoutRectangle(var msg:Tmessage);

var   col,row:longint;
      longwidth:longint;
      dwidth,dheight,destcol,destrow:integer;
      thisvalue:byte;
      ok:boolean;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  dwidth:= abs((lastcol-firstcol)) + 1;
  dheight:=abs((lastrow-firstrow)) +1;
  tempbitmap.init(dwidth,dheight,ok);
   if ok then
   begin
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
     tempbitmap.arrayaddr.ptr:=globallock(tempbitmap.arrayhandle);
     setcursor(loadcursor(0,idc_wait));
     destcol:=0;
     destrow:=0;
     for col:=firstcol to lastcol do
     begin
       for row:=firstrow to lastrow do
       begin
         thisvalue:=get(col,row);
         tempbitmap.put(destcol,destrow,thisvalue);
         destrow:=destrow+1
       end;
       destrow:=1;
       destcol:=destcol+1
     end;
   end;{with bitmaparray}
   bitmaparray.done;
   longwidth:=(((dwidth*8) +31) div 32)*4;
   pixelwidth:=longwidth;
   pixelheight:=dheight;
   firstcol:=0;
   firstrow:=0;
   lastcol:=pixelwidth-1;
   lastrow:=pixelheight-1;
   ptbeg.x:=0;
   ptbeg.y:=0;
   ptend.x:=pixelwidth-1;
   ptend.y:=pixelheight-1;
   bitmapinfo^.bmiheader.biheight:=pixelheight;
   bitmapinfo^.bmiheader.biwidth:=pixelwidth;
   bitmapinfo^.bmiheader.bisizeImage:=pixelheight*pixelwidth;
   globalcompact(-1);
   bitmaparray.init(pixelwidth,pixelheight,ok);
   with bitmaparray do
   begin
     arrayaddr.ptr:=globallock(arrayhandle);
   for col:=0 to maxcols-1 do
     for row:=0 to maxrows-1 do
     begin
       thisvalue:=tempbitmap.get(col,row);
       put(col,row,thisvalue);
     end;
   globalunlock(arrayhandle);
   end;{with bitmaparray}
   globalunlock(tempbitmap.arrayhandle);
   tempbitmap.done;
   setcursor(loadcursor(0,idc_arrow));
   bmpcreate;
   Adjustscroller;
   strcat(processhistory,'Cutout ');
   strcat(processhistory,#13#10);
 end;{if ok}
end;{CutoutRectangle}

procedure TBMProcess.ShowHistory(var Msg:TMessage);

begin
  Application^.ExecDialog(New(PHistoryDlg,init(@self,'ShowHistory',selection)));
end;

procedure TBMProcess.MatrixHistogram(var Msg:Tmessage);

var
     dchandle:hdc;
     col,row:longint;
     histomax,histoavg,totalnum:real;

      i,temp:integer;
      ok:boolean;


begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  calchist;
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for col:=firstcol to lastcol do
    for row:=firstrow to lastrow do
    begin
      temp:=get(col,row);
    end;
    globalunlock(arrayhandle);
  end;
  totalnum:=(lastrow-firstrow+1)*(lastcol-firstcol+1);
  histomax:=0;
  histoavg:=0;
  for i:=0 to 255 do
  begin
    if realhisto[i] >histomax then histomax:=realhisto[i];
    histoavg:=histoavg + realhisto[i];
  end;
  histoavg:=histoavg/256.0;
  for i:=1 to 256 do
  begin
    Theplot[i,1]:=i;
    Theplot[i,2]:=realhisto[i-1];
  end;
  x1wld:=-50;
  x2wld:=300;
  y1wld:=0;
  y2wld:=(histoavg + 3*histomax)/4.0;
  DCHandle := GetDC(Hwindow);
  DrawAxis(dchandle);
  Drawpolygon(dchandle,Theplot,0,256);
  releaseDC(hwindow,dchandle);
  setcursor(loadcursor(0,idc_arrow));
end;

procedure TBMProcess.Grayscale(var Msg:Tmessage);

var   col,row,rowholder:longint;
      i:integer;
      value:byte;
      temp:longint;
      start,toaddr:longtype;

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));

  with bitmapinfo^,bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for row:=firstrow to lastrow do
  begin
    rowholder:=row*maxcols;
    for col:=firstcol to lastcol do
    begin
      start.long:=rowholder+col;
      toaddr.hi:=arrayaddr.hi +(start.hi*ofs(AHIncr));
      toaddr.lo:=start.lo;
      temp:=trunc((30*bmicolors[toaddr.ptr^].rgbred +
                   59*bmicolors[toaddr.ptr^].rgbgreen +
                   11*bmicolors[toaddr.ptr^].rgbblue) div 100);
      if temp > 255 then temp:=255;
      value:=temp;
      toaddr.ptr^:=value;
    end;{col}
  end;{row}
  globalunlock(arrayhandle);
  end;{with}
  for i:=0 to pred(palsize) do
  with bitmapinfo^.bmicolors[i] do
  begin
    rgbred:=i;
    rgbgreen:=i;
    rgbblue:=i;
  end;
  CopyDIBPalette(bitmapinfo^,palsize);
  setcursor(loadcursor(0,idc_arrow));
  bmpcreate;
  Adjustscroller;
  strcat(processhistory,'Grayscale ');
  strcat(processhistory,#13#10);
end;

procedure TBMProcess.MatrixFFT(var Msg:Tmessage);

var   col,row,rowholder:longint;
      i:integer;
      value:byte;
      temp:longint;
      start,toaddr:longtype;
      ok:boolean;
      tempsingle:largesinglematrix;
      localmin,localmax,localavg:single;
      tempstr:string[10];

procedure DoFFT;

type pwrtype=singlearray;
     smallcomplex=record
                   r,i:single;
                   end;

var
    pwrarray:pwrtype;
    FFTrealMatrix,FFTimagMatrix,pwrmatrix:largesinglematrix;

    scale,bias:single;
    minval,maxval:single;
    minimum,maximum:byte;
    avg:real;
    temppwr:single;
    code,i,sign:integer;
    temprealarray,tempimagarray:singlearray;
    errorio:byte;
    reply:char;
    col,row,outrow,outcol:longint;
    ok:boolean;

begin{dofft}
  str(256:5,tempstr);
  strPcopy(buffer,tempstr);
  strcat(buffer,' rows');
  if statusdialog=nil then
  begin
    statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                  init(@self,statusid))));
  end;
  statusdialog^.beginstatus('FFT2D');
  statusdialog^.update1(buffer);
  statusdialog^.update2('Current row');

  FFTrealMatrix.init(256,256,ok);
  FFTimagMatrix.init(256,256,ok);

  PWRmatrix.init(256,256,ok);
  fftrealmatrix.arrayaddr.ptr:=globallock(fftrealmatrix.arrayhandle);
  fftimagmatrix.arrayaddr.ptr:=globallock(fftimagmatrix.arrayhandle);
  pwrmatrix.arrayaddr.ptr:=globallock(pwrmatrix.arrayhandle);
  bitmaparray.stats(firstcol,firstrow,lastcol,lastrow,minimum,maximum,avg);
  outrow:=0;
    sign:=1;
    for row:=firstrow to (firstrow + 255) do
    begin
      str(row:5,tempstr);
      strpcopy(buffer,tempstr);
      statusdialog^.update3(buffer);
      for col:=firstcol to (firstcol + 255) do
      begin
        temprealarray[col-firstcol]:=sign*(bitmaparray.get(col,row) - avg);
        tempimagarray[col-firstcol]:=0.0;
        sign:=-sign
      end;{col}
      sign:=-sign;

      FFT(temprealarray,tempimagarray,256,8,true);

      for outcol:=0 to 255 do
      begin
        FFTrealmatrix.put(outcol,outrow,temprealarray[outcol]);
        FFTimagmatrix.put(outcol,outrow,tempimagarray[outcol]);
      end;{outcol}
      outrow:=outrow + 1;
    end;{for row}
    str(256:5,tempstr);
    strPcopy(buffer,tempstr);
    strcat(buffer,' columns');
    statusdialog^.update1(buffer);
    statusdialog^.update2('Current column');
    maxval:=-100.0;
    minval:=10000.0;
    for col:=0 to 255 do
    begin
      str(col:5,tempstr);
      strpcopy(buffer,tempstr);
      statusdialog^.update3(buffer);
      for row:=0 to 255 do
      begin
        temprealarray[row]:=FFTrealmatrix.get(col,row);
        tempimagarray[row]:=FFTimagmatrix.get(col,row);
      end;{for col}
      FFT(temprealarray,tempimagarray,256,8,true);

      for row:=0 to 255 do
      begin
        temppwr:=ln(1+sqrt(sqr(temprealarray[row]) + sqr(tempimagarray[row])));
        if temppwr > maxval then
          maxval:=temppwr;
        pwrmatrix.put(col,row,temppwr);
      end;{row}
    end;{col}
    statusdialog^.closewindow;
    statusdialog:=nil;
    scale:=255.0/maxval;
    bias:=minval;
    for row:=0 to 255 do
    for col:=0 to 255 do
    begin
      bitmaparray.put(col,row,
         lo(trunc(scale * pwrmatrix.get(col,row))));
(*
      bitmaparray.put(col+127,row+127,
         lo(trunc(scale * pwrmatrix.get(col,127-row))));
      bitmaparray.put(col,row+127,
         lo(trunc(scale * pwrmatrix.get(127-col,127-row))));
      bitmaparray.put(col+127,row,
         lo(trunc(scale * pwrmatrix.get(col,row))));
      bitmaparray.put(col,row,
         lo(trunc(scale * pwrmatrix.get(127-col,row))));
*)
    end;{col}

  globalunlock(fftrealmatrix.arrayhandle);
  globalunlock(fftimagmatrix.arrayhandle);
  globalunlock(pwrmatrix.arrayhandle);
  fftrealmatrix.done;
  fftimagmatrix.done;
  pwrmatrix.done;
end;{DoFFT}

begin
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  setcursor(loadcursor(0,idc_wait));
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  dofft;
    globalunlock(bitmaparray.arrayhandle);
    setcursor(loadcursor(0,idc_arrow));
    bmpcreate;
    Adjustscroller;
   strcat(processhistory,'FFT ');
   strcat(processhistory,#13#10);
end;{MatrixFFT}

procedure TBMProcess.CMGrabVideo(var Msg:TMessage);
{$S-}

var dchandle,memdc:hdc;
    oldhandle:hbitmap;
    bitspointer:pointer;
    i:integer;
    msgrec:Tmsg;
    status2:byte;
    bitmap_seg,bitmap_ofs:word;

procedure monitor;

begin
  set_grab;
  repeat
    readreg($01,status2);
    status2:=status2 and $40;
  until status2=$40;
  setaddress($0000);
  bitmap_seg:=seg(bitspointer^);
  bitmap_ofs:=ofs(bitspointer^);
  getvram(65280,bitmap_seg,bitmap_ofs);
end;{Monitor}


begin
  setreset(1);
  setreset(0);
  setpal;
  clr_videnable;
  delay(1000);
  clr_grab;
  setaddress($0000);
  clrgenlock;

  dchandle:=getdc(hwindow);
  memdc:=createcompatibledc(dchandle);
  OldPal := SelectPalette(DCHandle,HactivePal,false); {!!}
  UnrealizeObject(HactivePal);                        {!!}
  RealizePalette(DCHandle);                     {!!}

  clr_videnable;
  monitoron:=true;
  bitspointer:=globallock(bitmaparray.arrayhandle);
  bitmap_seg:=seg(bitspointer^);
  bitmap_ofs:=ofs(bitspointer^) + 65280;
  if bitmaphandle <>0 then deleteobject(bitmaphandle);
  BitmapHandle :=
  CreateDIBitmap(DCHandle, BitmapInfo^.bmiHeader, cbm_Init, Bitspointer,
  BitmapInfo^, dib_rgb_colors);
  oldhandle:=selectobject(memdc,bitmaphandle);
(*  bitblt(dchandle,0,0,256,255,memdc,0,0,srccopy);*)
  displaydib(bitmapinfo,bitspointer,displaydib_begin);

  repeat
    set_grab;
    repeat
      readreg($01,status2);
      status2:=status2 and $40;
    until status2=$40;
    setaddress($0000);
    getvramd(65280,bitmap_seg,bitmap_ofs);
    displaydib(bitmapinfo,bitspointer,displaydib_nopalette or displaydib_nowait);
{
    setDIBits(dchandle,bitmaphandle,0,255,bitspointer,bitmapinfo^,dib_rgb_colors);
    bitblt(dchandle,0,0,256,255,memdc,0,0,srccopy);
}
    if peekmessage(msgrec,hwindow,wm_mousefirst,wm_mouselast,pm_remove) then
    begin
      translatemessage(msgrec);
      dispatchmessage(msgrec);
    end;
  until keypressed or (not monitoron);

  displaydib(nil,nil,displaydib_end);
  capture(bitspointer);
  if bitmaphandle <>0 then deleteobject(bitmaphandle);
  BitmapHandle :=
  CreateDIBitmap(DCHandle, BitmapInfo^.bmiHeader, cbm_Init, Bitspointer,
  BitmapInfo^, dib_rgb_colors);
  oldhandle:=selectobject(memdc,bitmaphandle);
  bitblt(dchandle,0,0,256,255,memdc,0,0,srccopy);
  GlobalUnlock(bitmaparray.arrayhandle);
  releasedc(hwindow,dchandle);
  selectobject(memdc,oldhandle);
  deletedc(memdc);
  SelectPalette(DCHandle,OldPal,false);         {!!}
  {$S+}

end;{grab}
end.
