{BMPTLKIT, an MDI image (bitmap) processing application}
{by Tom Fulton, CIS:[100015,565]}
{5 September 1993}

{based on the Borland Demo program BSCRLAPP.PAS}
{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Demo program                                 }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}
{ This is an adaptation of the demo program BSCRLAPP.PAS included
  with Turbo Pascal for Windows.  The changes to this program allow
  a 256 color bitmap to be displayed with the appropriate colors.
  This is a "trial and error" attempt.  There may well be API calls
  that should be made that aren't being made as well as techniques that
  accomplish the same thing in an easier manner. }
{ Modifications by Pat Ritchey, CIS:[70007,4660]  }


{ 14 Oct-removed stack checking to reduce code segment size}
{ added dip ,rainbow palette, cutout now resets processing rectangle}
{16-23 Oct created Bigarray unit, ImportFile}
{30-10-92 added histogram equalization,pixelate, and bitplane}
{9 Nov added Sobel,translate}
{12 November created new wgraphics,mathutils}
{16 November added blur}
{18 add range checking dialog}
{21 automated yiq2rgb, added ln(input) transform, entropy}
{17 July 1993 added GIF read]
{21 July '93 created descendant of TBitscrollWindow object BMProcess}
{3 Sept. '93 added emboss }
{5 Sept. '93 added 24 bit <-> 3 X 8 bit decomposition and combination}
{List of files:
bscrolw.pas
bmproces.pas
bmputils.pas
bigmatri.pas
bmptlkit.pas
center3.pas
dispdib.pas
imwpc.pas
mathutils.pas
mystatus.pas
c:\tpw\docdemos\ostring.pas
uprint.pas
wintools.pas
wgraphics.pas
bmptlkit.res
printer.res
status.res
getvram.obj
getvramd.obj
bmptlkit.doc
bmptlkit.exe
readme.1st
}

program Bmptlkit;

{$R Bmptlkit.RES}

uses    bmputils,Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory,
        WinTypes,WinProcs,WinDos,Strings,
        mystatus,bmprocess;

const A_dd=1;
      S_ub=2;
      M_ul=3;
      D_iv=4;
      A_nd=5;
      O_r =6;
      X_or=7;
      M_in=8;
      M_ax=9;
      A_ve=10;
      C_mp=11;
      M_sk=12;
      O_vr=13;

type

  { Declare TMDIFileApp, a TApplication descendant }
  TMDIFileApp = object(TApplication)
    procedure InitMainWindow; virtual;
    procedure InitInstance; virtual;
  end;

  { Declare TMDIFileWindow, a TMDIWindow descendant }
  PMDIFileWindow = ^TMDIFileWindow;
  TMDIFileWindow = object(TMDIWindow)
    inlines:array[0..9] of captiontype;
    childcount:integer;
    childnumsel:integer;
    procedure SetupWindow; virtual;
    procedure NewFile(var Msg: TMessage);
      virtual cm_First + cm_MDIFileNew;
    procedure OpenFile(var Msg: TMessage);
      virtual cm_First + cm_MDIFileOpen;
    procedure About(var msg:Tmessage);
      virtual cm_first + cm_about;
    function GetChildSel(promptstr:pchar):integer;virtual;
    procedure BmpOPBmp(operator:integer);
    procedure AddChildren(var Msg:TMessage);
       virtual cm_first + cm_AddChildren;
     procedure SubChildren(var Msg:TMessage);
       virtual cm_first + cm_SubChildren;
     procedure MulChildren(var Msg:TMessage);
       virtual cm_first + cm_MulChildren;
    procedure DivChildren(var Msg:TMessage);
       virtual cm_first + cm_DivChildren;
    procedure ANDChildren(var Msg:TMessage);
       virtual cm_first + cm_ANDChildren;
    procedure ORChildren(var Msg:TMessage);
       virtual cm_first + cm_ORChildren;
    procedure XORChildren(var Msg:TMessage);
       virtual cm_first + cm_XORChildren;
    procedure MINchildren(var Msg:TMessage);
       virtual cm_first + cm_MINChildren;
    procedure MAXChildren(var Msg:TMessage);
       virtual cm_first + cm_MAXChildren;
    procedure AVEchildren(var Msg:TMessage);
       virtual cm_first + cm_AVEChildren;
    procedure CompareChildren(var Msg:TMessage);
       virtual cm_first + cm_CompareChildren;
    procedure MaskChildren(var Msg:TMessage);
       virtual cm_first + cm_MaskChildren;
    procedure OverlayChildren(var Msg:TMessage);
       virtual cm_first + cm_OverlayChildren;
    procedure CopyPalette(var Msg:TMessage);
       virtual cm_first + cm_CopyPalette;
    procedure YIQ2RGB(var Msg:TMessage);
       virtual cm_first + cm_YIQ2RGB;
    procedure Comb24(var Msg:TMessage);
       virtual cm_first + cm_Comb24;
    procedure Decomp24(var Msg:TMessage);
       virtual cm_first + cm_Decomp24;

    procedure Animate(var Msg:TMessage);
       virtual cm_first + cm_animate;
  end;

{***************Dialogs**********************}
  PChildDlg=^TChildDlg;
  TChildDlg=object(TDialog)
    setpointer:Pchar;
    buffer:array[0..20] of char;
    constructor init(Aparent:PWindowsObject;atitle:pchar;
        promptstr:pchar;P:Pchar);
    procedure SetupWindow;virtual;
    procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
  end;

{**********Dialogs****************}

constructor TChildDlg.init(Aparent:PWindowsObject;atitle:pchar;
    promptstr:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
  strcopy(buffer,promptstr);
end;

procedure TChildDlg.SetUpWindow;
 var i:integer;



begin
  TDialog.SetUpWindow;

  SendDlgItemMessage(hwindow,id_static,wm_settext,0,longint(@buffer));
  for i:=0 to  PMDIFileWindow(parent)^.childcount do
  begin
    SendDlgItemMessage(hwindow,id_listbox,lb_addstring,0,
              longint(@PMDIFileWindow(parent)^.inlines[i]));
  end;
end;

procedure TChildDlg.Ok(var msg:Tmessage);

begin
  PMDIFileWindow(parent)^.childnumsel:=SendDlgItemMessage(hwindow,id_listbox,lb_GetCurSel,0,0);
  TDialog.Ok(msg);
end;


function TMDIFileWindow.GetChildSel(promptstr:pchar):integer;

var i:integer;
    selection:array[0..80] of char;

 procedure countchild(achild:PwindowsObject);far;
 begin
   inc(childcount);
   inlines[childcount]:=PBMProcess(achild)^.captionbuffer;
 end;

 begin
   childcount:=-1;
   foreach(@countchild);

   Application^.execdialog(new(PChilddlg,init(@self,'ChildDlg',promptstr,selection)));
   GetChildSel:=childnumsel;
 end;

{ Respond to "New" command by constructing, creating, and setting up a
  new TFileWindow MDI child }
procedure TMDIFileWindow.NewFile(var Msg: TMessage);
begin
  Application^.MakeWindow(New(PBMProcess,Init(@Self,'NEW',256,255)));
end;

procedure TMDIFileWindow.SetupWindow;
begin
  TMDIWindow.SetupWindow;
  MenuItems(Disable);
end;

{ Respond to "Open" command by constructing, creating, and setting up a
  new TFileWindow MDI child }

procedure TMDIFileWindow.OpenFile(var Msg: TMessage);
var
  FileName: array[0..fsPathName] of Char;

begin
  if Application^.ExecDialog(New(PFileDialog, Init(@Self, PChar(sd_FileOpen),
      StrCopy(FileName, '*.bmp')))) = id_Ok then
      begin
      Application^.MakeWindow(New(PBMProcess,Init(@Self,Filename,256,255)));
      end;
end;

procedure TMDIFileWindow.About(var msg:Tmessage);
var P:Pdialog;
begin
  Application^.ExecDialog(new(Pdialog,init(@self,'About')));
end;

procedure TMDIFileWindow.BmpOPBmp(operator:integer);
var firstchild,secondchild,thirdchild:PWindowsObject;
    num,temp1,temp2,temp3:integer;
    srccol,srcrow,destrow,destcol:longint;
    rowmax,colmax:longint;

function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('First input');
  firstchild:=firstthat(@isSelected);
  num:=getchildsel('Second input');
  secondchild:=firstthat(@isSelected);
  num:=getchildsel('Output');
  thirdchild:=firstthat(@isSelected);
  rowmax:=whichmax(PBMProcess(firstchild)^.bitmaparray.maxrows,
                   PBMProcess(secondchild)^.bitmaparray.maxrows);
  colmax:=whichmax(PBMProcess(firstchild)^.bitmaparray.maxcols,
                   PBMProcess(secondchild)^.bitmaparray.maxcols);
  with PBMProcess(firstchild)^ do
  begin
    with bitmaparray do
    begin
      arrayaddr.ptr:=globallock(arrayhandle);
      PBMProcess(secondchild)^.bitmaparray.arrayaddr.ptr:=
         globallock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
      PBMProcess(thirdchild)^.bitmaparray.arrayaddr.ptr:=
         globallock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);

      for srcrow:=0 to rowmax-1 do
      begin
        for srccol:=0 to colmax-1 do
        begin
          temp1:=get(srccol,srcrow);
          temp2:=PBMProcess(secondchild)^.bitmaparray.get(srccol,srcrow);
          case operator of
          A_dd:temp3:=temp1 + temp2;
          S_ub:temp3:=temp1-temp2;
          M_ul:temp3:=temp1*temp2;
          D_iv:if temp2 > 0 then
                 temp3:=temp1 div temp2
                 else temp3:=255;
          A_nd:temp3:= temp1 AND temp2;
          O_r: temp3:=temp1 OR temp2;
          X_or:temp3:=temp1 XOR temp2;
          M_in:temp3:=whichmin(temp1,temp2);
          M_ax:temp3:=whichmax(temp1,temp2);
          A_ve:temp3:=(temp1+temp2) div 2;
          C_mp:temp3:=abs(temp1-temp2);
          M_sk:if temp2 >0 then temp3:=temp1 else temp3:=0;
          O_vr:if temp2 > 0 then temp3:=temp2 else temp3:=temp1;
          end;
          if temp3>255 then temp3:=255;
          if temp3 <0 then temp3:=0;
          PBMProcess(thirdchild)^.bitmaparray.put(srccol,srcrow,temp3);
        end;
      end;
      globalunlock(arrayhandle);
    end;{with bitmaparray}
  end;{with PBMProcess}
  globalunlock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);
  with PBMProcess(thirdchild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with thirdchild}
end;{BmpOPBmp}

procedure TMDIFileWindow.AddChildren(var Msg: TMessage);
begin
  BmpOPBmp(A_dd);
end;{addchildren}

procedure TMDIFileWindow.SubChildren(var Msg: TMessage);
begin
  BmpOPBmp(S_ub);
end;{subchildren}

procedure TMDIFileWindow.MulChildren(var Msg: TMessage);
begin
  BmpOPBmp(M_ul);
end;{mulchildren}

procedure TMDIFileWindow.DivChildren(var Msg: TMessage);
begin
  BmpOPBmp(D_iv);
end;{divchildren}

procedure TMDIFileWindow.ANDChildren(var Msg: TMessage);
begin
  BmpOPBmp(A_nd);
end;{ANDchildren}

procedure TMDIFileWindow.ORChildren(var Msg: TMessage);
begin
  BmpOPBmp(O_r);
end;{ORchildren}

procedure TMDIFileWindow.XORChildren(var Msg: TMessage);
begin
  BmpOPBmp(X_or);
end;{XORchildren}

procedure TMDIFileWindow.MINChildren(var Msg: TMessage);
begin
  BmpOPBmp(M_in);
end;{MINchildren}

procedure TMDIFileWindow.MAXChildren(var Msg: TMessage);
begin
  BmpOPBmp(M_ax);
end;{MAXchildren}

procedure TMDIFileWindow.AVEChildren(var Msg: TMessage);
begin
  BmpOPBmp(A_ve);
end;{AVEchildren}

procedure TMDIFileWindow.CompareChildren(var Msg: TMessage);
begin
  BmpOPBmp(C_mp);
end;{Comparechildren}

procedure TMDIFileWindow.MaskChildren(var Msg: TMessage);
begin
  BmpOPBmp(M_sk);
end;{Maskchildren}

procedure TMDIFileWindow.OverlayChildren(var Msg: TMessage);
begin
  BmpOPBmp(O_vr);
end;{Overlaychildren}

procedure TMDIFileWindow.CopyPalette(var Msg: TMessage);
var firstchild,secondchild:PWindowsObject;
    num:integer;
    i:byte;

function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('Source');
  firstchild:=firstthat(@isSelected);
  num:=getchildsel('Destination');
  secondchild:=firstthat(@isSelected);
  with PBMProcess(secondchild)^ do
  begin
    for i:=0 to pred(palsize) do
    begin
      with Bitmapinfo^.bmicolors[i] do
      begin
        rgbred:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbred;
        rgbgreen:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbgreen;
        rgbblue:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbblue;
      end;{with bitmapinfo}
    end;{for i}
  end;{with PBMProcess}
  with PBMProcess(secondchild)^ do
  begin
    CopyDIBPalette(bitmapinfo^,palsize);
    bmpcreate;
    adjustscroller;
  end;{with}
end;{CopyPalette}

procedure TMDIFileWindow.YIQ2RGB(var Msg: TMessage);
var firstchild,secondchild,thirdchild,fourthchild:PWindowsObject;
    num,y,i,q,r,g,b:longint;
    col,row:longint;
    buffer:array[0..20] of char;
      tempstr:string[15];


function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('Y component');
  firstchild:=firstthat(@isSelected);
  num:=getchildsel('I component');
  secondchild:=firstthat(@isSelected);
  num:=getchildsel('Q component');
  thirdchild:=firstthat(@isSelected);
  fourthchild:=New(PBMProcess,init(@self,'YIQ',
               PBMProcess(firstchild)^.pixelwidth,
               PBMProcess(firstchild)^.pixelheight));
  Application^.makewindow(fourthchild);
  PBMProcess(firstchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(firstchild)^.bitmaparray.arrayhandle);
  PBMProcess(secondchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  PBMProcess(thirdchild)^.bitmaparray.arrayaddr.ptr:=
         globallock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);
  PBMProcess(fourthchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(fourthchild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_wait));
  with PBMProcess(fourthchild)^ do
  begin
    for i:=0 to pred(palsize) do
    begin
      with Bitmapinfo^.bmicolors[i] do
      begin
        rgbred:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbred;
        rgbgreen:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbgreen;
        rgbblue:=PBMProcess(firstchild)^.bitmapinfo^.bmicolors[i].rgbblue;
      end;{with bitmapinfo}
    end;{for i}
    CopyDIBPalette(bitmapinfo^,palsize);
  end;{with PBMProcess}
  PBMProcess(fourthchild)^.oldpal:=
        selectpalette(PBMProcess(fourthchild)^.dragdc,
        PBMProcess(fourthchild)^.HactivePal,false);
  unrealizeobject(PBMProcess(fourthchild)^.HactivePal);
  realizepalette(PBMProcess(fourthchild)^.dragdc);
  with PBMProcess(firstchild)^ do
  begin
    str(bitmaparray.maxrows:5,tempstr);
    strPcopy(buffer,tempstr);
    strcat(buffer,' rows');
    if statusdialog=nil then
    begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                     init(@self,statusid))));
    end;
    statusdialog^.beginstatus('YIQ2RGB');
    statusdialog^.update1(buffer);
    statusdialog^.update2('Current row');
      for row:=0 to bitmaparray.maxrows do
      begin
        str(row:5,tempstr);
        strpcopy(buffer,tempstr);
        statusdialog^.update3(buffer);
        for col:=0 to bitmaparray.maxcols do
        begin
          Y:=bitmaparray.get(col,row);
          I:=PBMProcess(thirdchild)^.bitmaparray.get(col,row);
          Q:=PBMProcess(secondchild)^.bitmaparray.get(col,row);
          r:=(10000*Y +  956*(12*I-1530) + 620*(12*Q-1530)) div 10000;
          g:=(10000*Y -272*(12*I-1530) - 647*(12*Q-1530)) div 10000;
          b:=(10000*Y -1108*(12*I-1530) + 1705*(12*Q-1530)) div 10000;
          if r> 255 then r:=255;
          if r < 0 then r:=0;
          if g> 255 then g:=255;
          if g < 0 then g:=0;
          if b> 255 then b:=255;
          if b < 0 then b:=0;
          PBMProcess(fourthchild)^.bitmaparray.put(col,row,
          GetNearestPaletteIndex(PBMProcess(fourthchild)^.HActivePal,RGB(r,g,b)));
        end;
      end;
    statusdialog^.closewindow;
    statusdialog:=nil;
  globalunlock(bitmaparray.arrayhandle);
  end;{with}
  globalunlock(PBMProcess(fourthchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_arrow));
  with PBMProcess(fourthchild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with fourthchild}
end;{YIQ2RGB}

procedure TMDIFileWindow.Comb24(var Msg: TMessage);

var firstchild,secondchild,thirdchild,fourthchild:PWindowsObject;
    num,r,g,b,longwidth:longint;
    col,row:longint;
    buffer:array[0..20] of char;
      tempstr:string[15];


function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('Red component');
  firstchild:=firstthat(@isSelected);
  num:=getchildsel('Green component');
  secondchild:=firstthat(@isSelected);
  num:=getchildsel('Blue component');
  thirdchild:=firstthat(@isSelected);
  fourthchild:=New(PBMProcess,init(@self,'RGB24bit',
               PBMProcess(firstchild)^.pixelwidth * 3,
               PBMProcess(firstchild)^.pixelheight));
  Application^.makewindow(fourthchild);
  PBMProcess(firstchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(firstchild)^.bitmaparray.arrayhandle);
  PBMProcess(secondchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  PBMProcess(thirdchild)^.bitmaparray.arrayaddr.ptr:=
         globallock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);
  PBMProcess(fourthchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(fourthchild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_wait));
  with PBMProcess(fourthchild)^ do
  begin
    freemem(bitmapinfo,bitmapinfosize);
    bitmapinfosize:=sizeof(TBitmapinfoheader);
    bitmapinfo:=memalloc(bitmapinfosize);
    with bitmapinfo^.bmiheader do
    begin
      biBitCount:=24;
      longWidth := (((PBMProcess(firstchild)^.pixelwidth * 24) + 31) div 32) * 4;
      biSizeImage := longWidth * PixelHeight;
      bisize:=40;
      biplanes:=1;
      biCompression:=0;
      bixpelspermeter:=0;
      biypelspermeter:=0;
      biclrused:=0;
      biclrimportant:=0;
      biwidth:=PBMProcess(firstchild)^.pixelwidth;
      biheight:=pixelheight;
    end;
  (*  pixelwidth:=longwidth;*)
  end;{with PBMProcess}

  PBMProcess(fourthchild)^.oldpal:=
        selectpalette(PBMProcess(fourthchild)^.dragdc,
        PBMProcess(fourthchild)^.HactivePal,false);
  unrealizeobject(PBMProcess(fourthchild)^.HactivePal);
  realizepalette(PBMProcess(fourthchild)^.dragdc);

  with PBMProcess(firstchild)^ do
  begin
    str(bitmaparray.maxrows:5,tempstr);
    strPcopy(buffer,tempstr);
    strcat(buffer,' rows');
    if statusdialog=nil then
    begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                     init(@self,statusid))));
    end;
    statusdialog^.beginstatus('Comb24');
    statusdialog^.update1(buffer);
    statusdialog^.update2('Current row');
      for row:=0 to bitmaparray.maxrows do
      begin
        str(row:5,tempstr);
        strpcopy(buffer,tempstr);
        statusdialog^.update3(buffer);
        for col:=0 to bitmaparray.maxcols do
        begin
          r:=bitmaparray.get(col,row);
          g:=PBMProcess(secondchild)^.bitmaparray.get(col,row);
          b:=PBMProcess(thirdchild)^.bitmaparray.get(col,row);

          PBMProcess(fourthchild)^.bitmaparray.put(col*3,row,r);
          PBMProcess(fourthchild)^.bitmaparray.put(col*3 + 1,row,g);
          PBMProcess(fourthchild)^.bitmaparray.put(col*3 + 2,row,b);
        end;
      end;
    statusdialog^.closewindow;
    statusdialog:=nil;
  globalunlock(bitmaparray.arrayhandle);
  end;{with}
  globalunlock(PBMProcess(fourthchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(thirdchild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_arrow));
  with PBMProcess(fourthchild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with fourthchild}
end;{Comb24}

procedure TMDIFileWindow.Decomp24(var Msg: TMessage);

var sourcechild,redchild,greenchild,bluechild:PWindowsObject;
    num,r,g,b,longwidth:longint;
    col,row:longint;
    buffer:array[0..20] of char;
      tempstr:string[15];


function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('24 bit source');
  sourcechild:=firstthat(@isSelected);
  longwidth:=(((PBMProcess(sourcechild)^.pixelwidth * 8)+31) div 32) *4;
  redchild:=New(PBMProcess,init(@self,'Red',
               longwidth,PBMProcess(sourcechild)^.pixelheight));
  Application^.makewindow(redchild);
  greenchild:=New(PBMProcess,init(@self,'Green',
               longwidth,PBMProcess(sourcechild)^.pixelheight));
  Application^.makewindow(greenchild);
  bluechild:=New(PBMProcess,init(@self,'Blue',
               longwidth,PBMProcess(sourcechild)^.pixelheight));
  Application^.makewindow(bluechild);

  PBMProcess(sourcechild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(sourcechild)^.bitmaparray.arrayhandle);
  PBMProcess(redchild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(redchild)^.bitmaparray.arrayhandle);
  PBMProcess(greenchild)^.bitmaparray.arrayaddr.ptr:=
         globallock(PBMProcess(greenchild)^.bitmaparray.arrayhandle);
  PBMProcess(bluechild)^.bitmaparray.arrayaddr.ptr:=
      globallock(PBMProcess(bluechild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_wait));
  with PBMProcess(redchild)^ do
  begin
    str(bitmaparray.maxrows:5,tempstr);
    strPcopy(buffer,tempstr);
    strcat(buffer,' rows');
    if statusdialog=nil then
    begin
       statusdialog:=Pstatus(Application^.makewindow(New(Pstatus,
                     init(@self,statusid))));
    end;
    statusdialog^.beginstatus('Decomp24');
    statusdialog^.update1(buffer);
    statusdialog^.update2('Current row');
      for row:=0 to bitmaparray.maxrows do
      begin
        str(row:5,tempstr);
        strpcopy(buffer,tempstr);
        statusdialog^.update3(buffer);
        for col:=0 to bitmaparray.maxcols do
        begin
          bitmaparray.put(col,row,
           PBMProcess(sourcechild)^.bitmaparray.get(col*3,row));
          PBMProcess(greenchild)^.bitmaparray.put(col,row,
            PBMProcess(sourcechild)^.bitmaparray.get(col*3+1,row));
          PBMProcess(bluechild)^.bitmaparray.put(col,row,
            PBMProcess(sourcechild)^.bitmaparray.get(col*3+2,row));
        end;
      end;
    statusdialog^.closewindow;
    statusdialog:=nil;
  globalunlock(bitmaparray.arrayhandle);
  end;{with}
  globalunlock(PBMProcess(greenchild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(bluechild)^.bitmaparray.arrayhandle);
  globalunlock(PBMProcess(sourcechild)^.bitmaparray.arrayhandle);
  SetCursor(LoadCursor(0,idc_arrow));
  with PBMProcess(redchild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with redchild}
  with PBMProcess(greenchild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with greenchild}
  with PBMProcess(bluechild)^ do
  begin
    bmpcreate;
    adjustscroller;
  end;{with bluechild}
end;{Decomp24}



procedure TMDIFileWindow.Animate(var Msg: TMessage);
var firstchild,secondchild:PWindowsObject;
    num,temp1,temp2,temp3,width,height:integer;
    i:byte;
    dchandle,memdc:hdc;
    oldhandle:hbitmap;
    bitspointer1,bitspointer2:pointer;
    msgrec:Tmsg;

function isSelected(achild:PBMProcess):boolean;far;
begin
  isSelected:=(PBMProcess(achild)^.captionbuffer=inlines[num]);
end;

begin
  num:=Getchildsel('Source');
  firstchild:=firstthat(@isSelected);
  num:=getchildsel('Destination');
  secondchild:=firstthat(@isSelected);
  dchandle:=getdc(PBMProcess(firstchild)^.hwindow);
  with PBMProcess(firstchild)^ do
  begin
  memdc:=createcompatibledc(dchandle);
  oldpal:=selectpalette(dchandle,hactivepal,false);
  unrealizeobject(hactivepal);
  realizepalette(dchandle);
  bitspointer1:=globallock(bitmaparray.arrayhandle);
  bitspointer2:=globallock(PBMProcess(secondchild)^.bitmaparray.arrayhandle);
  PBMProcess(firstchild)^.bitmaphandle:=
      createDIBitmap(dchandle,bitmapinfo^.bmiheader,
       cbm_init,bitspointer1,bitmapinfo^,dib_rgb_colors);
  oldhandle:=selectobject(memdc,bitmaphandle);
  bitblt(dchandle,0,0,pixelwidth,pixelheight,memdc,0,0,srccopy);
  monitoron:=true;
  repeat
    setDIBits(dchandle,bitmaphandle,
      0,pixelwidth,bitspointer1,
      bitmapinfo^,dib_rgb_colors);
    bitblt(dchandle,0,0,width,height,memdc,0,0,srccopy);
    if peekmessage(msgrec,hwindow,wm_mousefirst,wm_mouselast,pm_remove) then
    begin
      translatemessage(msgrec);
      dispatchmessage(msgrec);
    end;
    setDIBits(dchandle,bitmaphandle,0,pixelwidth,
             bitspointer2,bitmapinfo^,dib_rgb_colors);;
    bitblt(dchandle,0,0,pixelwidth,pixelheight,memdc,0,0,srccopy);
  until not monitoron;
  releasedc(hwindow,dchandle);
  selectobject(memdc,oldhandle);
  deletedc(memdc);
  end;{with}
end;{Animate}

{ Construct the TMDIFileApp's MainWindow of type TMDIFileWindow,
  loading its menu }
procedure TMDIFileApp.InitMainWindow;
begin
  MainWindow := New(PMDIFileWindow, Init(bsa_name,
    LoadMenu(HInstance, 'Commands')));
  PMDIFileWindow(MainWindow)^.ChildMenuPos := 7;

end;

{ Initialize each MS-Windows application instance, loading an
  accelerator table }
procedure TMDIFileApp.InitInstance;
begin
  TApplication.InitInstance;
  if Status = 0 then
  begin
    HAccTable := LoadAccelerators(HInstance, 'FileCommands');
    if HAccTable = 0 then
      Status := em_InvalidWindow;
  end;
end;

{ Declare a variable of type TFileApp }
var
  MDIFileApp : TMDIFileApp;



{ Run the FileApp }
begin
  MDIFileApp.Init('MDIFileApp');
(*  sndPlaySound('e:\windows\hi.wav',snd_async);*)
 (* messagebeep(mb_iconasterisk);*)
  MDIFileApp.Run;
  MDIFileApp.Done;
end.
