Unit bmputils;

{by T. Fulton CIS:[100015,565]}
{21 July 1993}

Interface
uses
        Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory,
        Wintypes,Winprocs,WinDos,wintools,bigmatri;

const
  cm_about        = 801;
  cm_AddChildren  = 802;
  cm_SubChildren  = 803;
  cm_MulChildren = 804;
  cm_DivChildren  = 805;
  cm_ANDchildren  = 806;
  cm_ORchildren   = 807;
  cm_XORchildren  = 808;
  cm_Minchildren  = 809;
  cm_Maxchildren  = 810;
  cm_Avechildren  = 811;
  cm_Comparechildren = 812;
  cm_MaskChildren = 813;
  cm_OverlayChildren = 814;
  cm_CopyPalette  = 815;
  cm_YIQ2RGB      = 816;
  cm_animate      = 817;
  cm_Comb24       = 818;
  cm_Decomp24     = 819;
  cm_FileSave     =24333;
  cm_FilePrint    =24339;
  cm_Refresh      = 300;
  cm_Fillconst    = 301;
  cm_Bias         = 302;
  cm_scale        = 303;
  cm_cmin         = 304;
  cm_cmax         = 305;
  cm_Threshold    = 307;
  cm_Invert       = 306;
  cm_Xpandgray    = 308;
  cm_StrHist      = 309;
  cm_Kodalith     = 310;

  cm_highpass     = 311;
  cm_Edges        = 312;
  cm_smooth       = 313;
  cm_lowpass      = 314;
  cm_Median       = 315;
  cm_vertmirror   = 316;
  cm_horzmirror   = 317;
  cm_rotate       = 318;
  cm_zoom         = 319;
  cm_dither4      = 320;
  cm_dither3      = 321;
  cm_halftone     = 322;
  cm_dith16       = 323;
  cm_dithdiff     = 324;
  cm_cutout       = 325;
  cm_graymap      = 326;
  cm_pixelate     = 327;
  cm_fft          = 328;
  cm_vertsmth     = 329;
  cm_horzsmth     = 330;
  cm_dip          = 331;
  cm_ImportFile   = 332;
  cm_ExportFile   = 333;
  cm_Shear        = 334;
  cm_HistEqual    = 336;
  cm_bitplane     = 337;
  cm_HistLocal    = 338;
  cm_Translate    = 339;
  cm_SobelH       = 340;
  cm_SobelV       = 341;
  cm_SobelHV      = 342;
  cm_blur         = 343;
  cm_NBits        = 344;
  cm_log          = 345;
  cm_test         = 350;
  cm_ChangeTitle  = 351;
  cm_Fullscreen   = 352;
  cm_Emboss       = 353;
  cm_Options      = 400;
  cm_histo        = 502;
  cm_ShowRect     = 503;
  cm_ShowHistory  = 504;
  cm_ShowStat     = 505;
  cm_DispPalette  = 626;
  cm_Graypalette  = 627;
  cm_Brpalette    = 628;
  cm_Dmpalette    = 629;
  cm_Paladjust    = 630;
  cm_NegPalette   = 631;
  cm_RainbowPalette= 632;
  cm_GreenPalette = 633;
  cm_RedComponent = 651;
  cm_GreenComponent = 652;
  cm_BlueComponent = 653;
  cm_ExtractY     = 654;
  cm_ExtractI     = 655;
  cm_extractQ     = 656;
  cm_UpdatePalette =649;
  cm_RestorePalette =650;
  cm_Grayscale    = 701;
  cm_Grab         = 901;  {!!!}
  id_listbox      = 101;
  id_static       = 102;
  id_Group1       = 101;
  id_rad1         = 102;
  id_rad2         = 103;
  id_rad3         = 104;
  id_rad4         = 105;
  id_group2       = 201;
  id_rad5         = 202;
  id_rad6         = 203;
  id_rad7         = 204;
  id_rad8         = 205; {!!!}
  id_okbtn        = 106;
  id_ed1          = 101;
  id_ed2          = 102;
  id_chkbox1      = 103;
  id_sbred        = 101;
  id_sbgreen      = 102;
  id_sbblue       = 103;
  id_redstat      = 104;
  id_greenstat    = 105;
  id_bluestat     = 106;
  id_redtext      = 107;
  id_greentext    = 108;
  id_bluetext     = 109;
  id_mintext      = 101;
  id_maxtext      = 102;
  id_averagetext  = 103;
  id_entropytext  = 104;
  id_minstat      = 105;
  id_maxstat      = 106;
  id_averagestat  = 107;
  id_entropystat  = 108;
  bsa_name='BMP Toolkit';

  Imagecount:integer=0;
  clr_red=1;
  clr_green=2;
  clr_blue=3;


type
  onebyte=array[1..1] of byte;
  plotarray=array[1..260,1..2] of real;
(*  shortstring=array[0..20] of char;*)
  captiontype=array [0..fsPathName +2{': '} + 12{' '} + 1{#0}] of Char;
  singlearray=array[0..255] of single;
  luttype=array[0..255] of byte;

type
TDataSubBlock = record
		Size: byte;     { size of the block -- 0 to 255 }
		Data: array[1..255] of byte; { the data }
	end;
TLogicalScreenDescriptor = record
	ScreenWidth: word;              { logical screen width }
	ScreenHeight: word;  { logical screen height }
	PackedFields: byte;     { packed fields - see below }
	BackGroundColorIndex: byte;     { index to global color table }
	AspectRatio: byte;      { actual ratio = (AspectRatio + 15) / 64 }
end;

const
{ logical screen descriptor packed field masks }
	lsdGlobalColorTable = $80;  { set if global color table follows L.S.D. }
	lsdColorResolution = $70;               { Color resolution - 3 bits }
	lsdSort = $08;                                                  { set if global color table is sorted - 1 bit }
	lsdColorTableSize = $07;

type
	TColorItem = record     { one item a a color table }
		Red: byte;
		Green: byte;
		Blue: byte;
	end;

	TColorTable = array[0..255] of TColorItem;      { the color table }

const
	ImageSeperator: byte = $2C;

type
	TImageDescriptor = record
		Seperator: byte;                         { fixed value of ImageSeperator }
		ImageLeftPos: word; {Column in pixels in respect to left edge of logical screen }
		ImageTopPos: word;{row in pixels in respect to top of logical screen }
		ImageWidth: word;       { width of image in pixels }
		ImageHeight: word;      { height of image in pixels }
		PackedFields: byte; { see below }
	end;

const
	{ image descriptor bit masks }
		idLocalColorTable = $80; { set if a local color table follows }
		idInterlaced = $40;                      { set if image is interlaced }
		idSort = $20;                                            { set if color table is sorted }
		idReserved = $0C;                                { reserved - must be set to $00 }
		idColorTableSize = $07;  { size of color table as above }

	Trailer: byte = $3B;    { indicates the end of the GIF data stream }

const
	ExtensionIntroducer: byte = $21;

type
	TExtensionBlock = record
		Introducer: byte;                               { fixed value of ExtensionIntroducer }
		ExtensionLabel: byte;
		BlockSize: byte;
	end;

	PCodeItem = ^TCodeItem;
	TCodeItem = record
		Code1, Code2: byte;
	end;

const
	MAXCODES = 4095;        { the maximum number of different codes 0 inclusive }


type
  TMenuState = (Enable, Disable);

procedure delay(count:longint);
function whichmin(a,b:longint):longint;
function whichmax(a,b:longint):longint;
procedure fft(var realarray,imagarray:singlearray;
              n,pwrof2:word;forwrd:boolean);
procedure GetBitmapData(var TheFile: File;
  ABitsHandle: Thandle; BitsByteSize: Longint);
function GetGIFData(var TheFile: File;
  ABitsHandle: Thandle; Abitmaparray:largebytematrix;
  Abitmapinfo:PBitmapinfo;LogicalScreen: TLogicalScreenDescriptor):pchar;

procedure MenuI;
procedure MenuItems(State: TMenuState);
procedure IncImages;
Procedure DecImages;

implementation

procedure MenuI;
Begin
  MenuItems(Disable);
end;


procedure delay(count:longint);

var i,j:longint;
begin
for i:=0 to count do
 j:=i+1;
end;

function whichmin(a,b:longint):longint;
begin
 if a<b then whichmin:=a else whichmin:=b;
end;

function whichmax(a,b:longint):longint;
begin
  if a>b then whichmax:=a else whichmax:=b
end;

procedure fft(var realarray,imagarray:singlearray;
              n,pwrof2:word;forwrd:boolean);

{ returns result in realarray,imagarray,n=2^pwrof2 }


type twopowertype=array[1..10] of word;
const twopi = 6.283185307179;
      twopower:twopowertype=(2,4,8,16,32,64,128,256,512,1024);
var i,l,k,n2,nu,nu1:word;
    sign:integer;
    scale,treal,timag,p,pj,arg,c,s,partarg:double;

(*
replaced with precalculated array twopower[1..n]
function twopower(n:word):word;
var i,tp:word;
begin
    tp:=1;
    for i:=1 to n do
      tp:=tp*2;
      twopower:=tp;
end;{twopower}
*)

function bitrev(j,nu:word):word;
var i,j1,j2,k:word;
begin
  j1:=j;
  k:=0;
  for i:=1 to nu do
  begin
    j2:=j1 div 2;
    k:=k*2+(j1-2*j2);
    j1:=j2;
  end;{for}
  bitrev:=k;
end;{bitrev}

begin {fft}

  sign:=-1;
  if forwrd then sign:=1;
  partarg:=twopi*sign/n;
  scale:=sqrt(1.0/n);
  nu:=pwrof2;
  n2:=n div 2;
  nu1:=nu-1;
  k:=0;

  for l:=1 to nu do
  begin
    while k<n do
    begin
      for i:=1 to  n2 do
      begin
        p:=bitrev(k div twopower[nu1],nu);
        arg:=partarg*p;
        c:=cos(arg);
        s:=sin(arg);
        treal:=realarray[k+n2]*c+imagarray[k+n2]*s;
        timag:=imagarray[k+n2]*c-realarray[k+n2]*s;
        realarray[k+n2]:=realarray[k]-treal;
        imagarray[k+n2]:=imagarray[k]-timag;
        realarray[k]:=realarray[k]+treal;
        imagarray[k]:=imagarray[k]+timag;
        k:=k+1;
      end;{for}
    k:=k+n2;
    end;{while}
    k:=0;
    nu1:=nu1-1;
    n2:=n2 div 2;
  end;{for}

  k:=0;
  while k<n do
  begin
    i:=bitrev(k,nu);
    if i>k then
    begin
      treal:=realarray[k];
      timag:=imagarray[k];
      realarray[k]:=realarray[i];
      imagarray[k]:=imagarray[i];
      realarray[i]:=treal;
      imagarray[i]:=timag;
    end;{if}
    k:=k+1;
  end;{while}

(*depending on application may save time by not scaling here
  for i:=0 to n-1 do
  begin
    realarray[i]:=scale*realarray[i];
    imagarray[i]:=scale*imagarray[i];
  end;{for}
*)
  end;{fft}

{ Copys the bitmap bit data from the file into memory. Since
  copying cannot cross a segment (64K) boundary, we are forced
  to do segment arithmetic to compute the next segment.  Created
  a LongType type to simplify the process. }

procedure GetBitmapData(var TheFile: File;
  ABitsHandle: Thandle; BitsByteSize: Longint);

var
  bits:longtype;

begin
  Bits.Ptr := GlobalLock(Abitshandle);
  hRead(thefile,bits.ptr,bitsbytesize);
  GlobalUnlock(Abitshandle);
end;{getbitmapdata}

function GetGIFData(var TheFile: File;ABitsHandle: Thandle;
  Abitmaparray:largebytematrix;Abitmapinfo:PBitmapinfo;
   LogicalScreen: TLogicalScreenDescriptor):pchar;

var
  errormsg:Pchar;
  GlobalColorTable: TColorTable;     { global color table }
  LocalColorTable: TColorTable;      { local color table }
  ImageDescriptor: TImageDescriptor; { image descriptor }
  UseLocalColors: boolean;  { true if local colors in use }
  Interlaced: boolean;      { true if image is interlaced }
  LZWCodeSize: byte;
  ImageData: TDataSubBlock;     { variable to store incoming gif data }
  TableSize: word;              { number of entrys in the color table }
  i,BitsLeft, BytesLeft: integer;{ bits left in byte - bytes left in block }
  BadCodeCount: word;          { bad code counter }
  CurrCodeSize: integer;       { Current size of code in bits }
  ClearCode: integer;          { Clear code value }
  EndingCode: integer;         { ending code value }
  Slot: word;              { position that the next new code is to be added }
  TopSlot: word;      { highest slot position for the current code size }
  HighCode: word;     { highest code that does not require decoding }
  NextByte: integer;  { the index to the next byte in the datablock array }
  CurrByte: byte;     { the current byte }
  DecodeStack: array[0..MAXCODES] of byte; { stack for the decoded codes }
  Prefix: array[0..MAXCODES] of word;    { array for code prefixes }
  Suffix: array[0..MAXCODES] of byte;    { array for code suffixes }
  LineBuffer: array[0..2048] of byte; { array for buffer line output }
  CurrentX, CurrentY: integer;        { current screen locations }
  Status: word;
  interlacepass:byte;

  function Power(A, N: real): real;     { returns A raised to the power of N }
  begin
   Power := exp(N * ln(A));
  end;

  procedure ReadSubBlock;
  begin
    blockread(TheFile,ImageData.Size, sizeof(ImageData.Size)); { get the data block size }
    if ImageData.Size = 0 then errormsg:='emptyblock'; { check for empty block }
    blockread(TheFile,ImageData.Data, ImageData.Size);   { read in the block }
    NextByte := 1;      { reset next byte }
    BytesLeft := ImageData.Size;  { reset bytes left }
  end;

  function NextCode: word; { returns a code of the proper bit size }
  const
  CodeMask: array[0..12] of longint = (  { bit masks for use with Next code }
	0,
	$0001, $0003,
	$0007, $000F,
	$001F, $003F,
	$007F, $00FF,
	$01FF, $03FF,
	$07FF, $0FFF);

  var
  Ret: longint;  { temporary return value }
  begin {nextcode}
   if BitsLeft = 0 then     { any bits left in byte ? }
   begin  { any bytes left }
    if BytesLeft <= 0 then   { if not get another block }
    ReadSubBlock;
    CurrByte := ImageData.Data[NextByte]; { get a byte }
    inc(NextByte);                        { set the next byte index }
    BitsLeft := 8;                        { set bits left in the byte }
    dec(BytesLeft);                       { decrement the bytes left counter }
   end;{any bytes}
   ret := CurrByte shr (8 - BitsLeft);    { shift off any previosly used bits}
   while CurrCodeSize > BitsLeft do       { need more bits ? }
   begin
    if BytesLeft <= 0 then                { any bytes left in block ? }
    ReadSubBlock;                         { if not read in another block }
    CurrByte := ImageData.Data[NextByte]; { get another byte }
    inc(NextByte);                        { increment NextByte counter }
    ret := ret or (CurrByte shl BitsLeft);{ add the remaining bits to the return value }
    BitsLeft := BitsLeft + 8;             { set bit counter }
    dec(BytesLeft);                { decrement bytesleft counter }
   end;{while currcodesize}
   BitsLeft := BitsLeft - CurrCodeSize;  { subtract the code size from bitsleft }
   ret := ret and CodeMask[CurrCodeSize];{ mask off the right number of bits }
   NextCode := ret;
  end;{nextcode}

  { this procedure actually decodes the
  	GIF image }
  procedure Decode;
  var
  SP: integer; { index to the decode stack }
      bits:longtype;
      TempOldCode, OldCode: word;
      BufCnt: word;           { line buffer counter }
      Code, C: word;
      CurrBuf: word;  { line buffer index }

  procedure drawline;
  var i:integer;
      bits:longtype;

  begin
    abitmaparray.arrayaddr.ptr:= GlobalLock(Abitshandle);
    for i:=0 to imagedescriptor.imagewidth do
    begin
      Abitmaparray.put(i,
        ImageDescriptor.ImageHeight-currenty-1,linebuffer[i]);
    end;
    GlobalUnlock(Abitshandle);
      inc(currenty);
      if InterLaced then     { Interlace support }
      begin
       case InterlacePass of
       0: CurrentY := CurrentY + 7;
       1: CurrentY := CurrentY + 7;
       2: CurrentY := CurrentY + 3;
       3: CurrentY := CurrentY + 1;
       end;{case}
       if CurrentY >= ImageDescriptor.ImageHeight then
       begin
        inc(InterLacePass);
        case InterLacePass of
        1: CurrentY := 4;
        2: CurrentY := 2;
        3: CurrentY := 1;
        end;{case}
       end;{currenty >=im..}
      end;{if interlaced}
  end;{drawline}

   { local procedure that decodes a code and puts it on the decode stack }
  procedure DecodeCode(var Code: word);
  begin
   while Code > HighCode do { rip thru the prefix list placing suffixes }
   begin                    { onto the decode stack }
    DecodeStack[SP] := Suffix[Code]; { put the suffix on the decode stack }
    inc(SP);                         { increment decode stack index }
    Code := Prefix[Code];            { get the new prefix }
   end;{while code}
   DecodeStack[SP] := Code;        { put the last code onto the decode stack }
   inc(SP);                        { increment the decode stack index }
  end;{DecodeCode}

  begin {Decode}
   blockread(TheFile,LZWCodeSize, sizeof(byte));{ get minimum code size }
   if not (LZWCodeSize in [2..9]) then
     errormsg:='bad code size';    { valid code sizes 2-9 bits }
   CurrCodeSize := succ(LZWCodeSize); { set the initial code size }
   ClearCode := 1 shl LZWCodeSize;    { set the clear code }
   EndingCode := succ(ClearCode);     { set the ending code }
   HighCode := pred(ClearCode);       { set the highest code not needing decoding }
   BytesLeft := 0;                    { clear other variables }
   BitsLeft := 0;
   CurrentX := 0;
   CurrentY := 0;
   OldCode := 0;
   SP := 0;
   BufCnt := ImageDescriptor.ImageWidth; { set the Image Width }
   CurrBuf := 0;
(*   bits.ptr:=globallock(ABitshandle);*)
   C := NextCode;            { get the initial code - should be a clear code }
   while C <> EndingCode do  { main loop until ending code is found }
   begin
    if C = ClearCode then   { code is a clear code - so clear }
    begin
     CurrCodeSize := LZWCodeSize + 1;{ reset the code size }
     Slot := EndingCode + 1;         { set slot for next new code }
     TopSlot := 1 shl CurrCodeSize;  { set max slot number }
     while C = ClearCode do
    	C := NextCode;    { read until all clear codes gone - shouldn't happen }
     if C = EndingCode then
     begin
      Errormsg:='Bad code';   { ending code after a clear code }
      exit;              { this also should never happen }
     end;{if c=ending}
     if C >= Slot { if the code is beyond preset codes then set to zero }
      then c := 0;
     OldCode := C;
     DecodeStack[sp] := C; { output code to decoded stack }
     inc(SP);              { increment decode stack index }
    end{c=clear}
    else   { the code is not a clear code or an ending code so it must }
    begin  { be a code code - so decode the code }
     Code := C;
     if Code < Slot then     { is the code in the table? }
     begin
      DecodeCode(Code);      { decode the code }
      if Slot <= TopSlot then
      begin                      { add the new code to the table }
       Suffix[Slot] := Code;     { make the suffix }
       PreFix[slot] := OldCode;  { the previous code - a link to the data }
       inc(Slot);                { increment slot number }
       OldCode := C;             { set oldcode }
      end;{if slot<topslot}
      if Slot >= TopSlot then { have reached the top slot for bit size }
      begin                   { increment code bit size }
       if CurrCodeSize < 12 then { new bit size not too big? }
       begin
        TopSlot := TopSlot shl 1;  { new top slot }
        inc(CurrCodeSize)          { new code size }
       end{ if currcode}
       else
   	Errormsg:='geBitSizeOverflow' { encoder made a boo boo }
      end;{if slot >= topslot}
     end{code < topslot}
     else
     begin           { the code is not in the table }
      if Code <> Slot then                    { code is not the next available slot }
      Errormsg:='geBadCode';  { so error out }
      { the code does not exist so make a new entry in the code table
      and then translate the new code }
      TempOldCode := OldCode;  { make a copy of the old code }
      while OldCode > HighCode do { translate the old code and place it }
      begin                                   { on the decode stack }
       DecodeStack[SP] := Suffix[OldCode]; { do the suffix }
       OldCode := Prefix[OldCode];         { get next prefix }
      end;{while oldcode}
      DecodeStack[SP] := OldCode;     { put the code onto the decode stack }
  																{ but DO NOT increment stack index }
      { the decode stack is not incremented because because we are only
      translating the oldcode to get the first character }
      if Slot <= TopSlot then
      begin                 { make new code entry }
       Suffix[Slot] := OldCode;                 { first char of old code }
       Prefix[Slot] := TempOldCode; { link to the old code prefix }
       inc(Slot);                   { increment slot }
      end;{if slot <= topslot}
      if Slot >= TopSlot then { slot is too big }
      begin                   { increment code size }
       if CurrCodeSize < 12 then
       begin
        TopSlot := TopSlot shl 1;  { new top slot }
        inc(CurrCodeSize)          { new code size }
       end{if currcodesize}
       else
    	Errormsg:='geBitSizeOverFlow'
      end;{if slot >=topslot}
      DecodeCode(Code); { now that the table entry exists decode it }
      OldCode := C;     { set the new old code }
     end;{else code <> table}
    end;{code is a code}
    { the decoded string is on the decode stack so pop it off and put it
    into the line buffer }
    while SP > 0 do
    begin
     dec(SP);
     linebuffer[currbuf]:=decodestack[sp];
     inc(currbuf);
     dec(bufcnt);
     if BufCnt = 0 then  { is the line full ? }
     begin
       drawline;
       CurrBuf := 0;
       BufCnt := ImageDescriptor.ImageWidth;
     end; {if bufcnt}
    end;{while sp}
    C := NextCode;  { get the next code and go at is some more }
   end;{while c <> ending code} { now that wasn't all that bad was it? }
(*   globalunlock(Abitshandle);*)

  end;

begin {GetGIFdata}
  if LogicalScreen.PackedFields and lsdGlobalColorTable = lsdGlobalColorTable then
  begin
   TableSize := trunc(Power(2,(LogicalScreen.PackedFields and lsdColorTableSize)+1));
		blockread(TheFile,GlobalColorTable, TableSize*sizeof(TColorItem)); { read Global Color Table }
  end
  else
  ErrorMsg:=('no global color');
  blockread(TheFile,ImageDescriptor, sizeof(ImageDescriptor)); { read image descriptor }
  if ImageDescriptor.Seperator <> ImageSeperator then
    errormsg:='Image preceded';                    { verify that it is the descriptor }
  if ImageDescriptor.PackedFields and idLocalColorTable = idLocalColorTable then
  begin  { if local color table }
   TableSize := trunc(Power(2,(ImageDescriptor.PackedFields and idColorTableSize)+1));
   blockread(Thefile,LocalColorTable, TableSize*sizeof(TColorItem)); { read Local Color Table }
   UseLocalColors := True;
  end
  else
   UseLocalColors := false;
  if not UseLocalColors then
  begin
    for i:=0 to Tablesize-1 do
    begin
      with Abitmapinfo^.bmicolors[i] do
      begin
         rgbred:=GlobalColorTable[i].red;
         rgbgreen:=GlobalColorTable[i].green;
         rgbblue:=GlobalColorTable[i].blue;
      end;{with}
    end;{for}
  end{not local}
  else
  begin
    for i:=0 to Tablesize-1 do
    begin
      with Abitmapinfo^.bmicolors[i] do
      begin
         rgbred:=LocalColorTable[i].red;
         rgbgreen:=LocalColorTable[i].green;
         rgbblue:=LocalColorTable[i].blue;
      end;{with}
    end;{for}
  end;{else}
  if ((ImageDescriptor.PackedFields and idInterlaced) = idInterlaced) then
  begin
   Interlaced := true;
   InterlacePass := 0;
  end
  else
  begin
    interlaced:=false;
    interlacepass:=0;
  end;

  Decode;

  getGIFdata:=errormsg;
end;{getGIFdata}

procedure MenuItems(State: TMenuState);

procedure ModifyCommand(Command: Word);
var
  NewState: Word;
begin
  NewState := mf_ByCommand;
  if State = Enable then Inc(NewState, mf_Enabled)
  else Inc(NewState, mf_Disabled + mf_Grayed);
  EnableMenuItem(PWindow(Application^.MainWindow)^.Attr.Menu, Command,
    NewState);
end;

begin
  ModifyCommand(cm_FilePrint);
  ModifyCommand(cm_FileSave);
  ModifyCommand(cm_FileSaveAs);
  ModifyCommand(cm_ArrangeIcons);
  ModifyCommand(cm_TileChildren);
  ModifyCommand(cm_CascadeChildren);
  ModifyCommand(cm_CloseChildren);
  ModifyCommand(cm_EditCut);
  ModifyCommand(cm_EditCopy);
  ModifyCommand(cm_EditPaste);
  ModifyCommand(cm_EditDelete);
  ModifyCommand(cm_EditClear);
  ModifyCommand(cm_EditUndo);
  ModifyCommand(cm_EditFind);
  ModifyCommand(cm_EditReplace);
  ModifyCommand(cm_EditFindNext);
  ModifyCommand(cm_ShowHistory);
  ModifyCommand(cm_ShowStat);
  ModifyCommand(cm_Refresh);
  ModifyCommand(cm_Cutout);
  ModifyCommand(cm_Fillconst);
  ModifyCommand(cm_Bias);
  ModifyCommand(cm_scale);
  ModifyCommand(cm_cmin);
  ModifyCommand(cm_cmax);
  ModifyCommand(cm_threshold);
  ModifyCommand(cm_invert);
  ModifyCommand(cm_xpandgray);
  ModifyCommand(cm_Graymap);
  ModifyCommand(cm_strhist);
  ModifyCommand(cm_kodalith);
  ModifyCommand(cm_Histequal);
  ModifyCommand(cm_bitplane);
  ModifyCommand(cm_histlocal);
  ModifyCommand(cm_highpass);
  ModifyCommand(cm_NBits);
  ModifyCommand(cm_log);
  ModifyCommand(cm_translate);
  ModifyCommand(cm_edges);
  ModifyCommand(cm_smooth);
  ModifyCommand(cm_lowpass);
  ModifyCommand(cm_Vertsmth);
  ModifyCommand(cm_Horzsmth);
  ModifyCommand(cm_SobelH);
  ModifyCommand(cm_SobelV);
  ModifyCommand(cm_SobelHV);
  ModifyCommand(cm_Dip);
  ModifyCommand(cm_FFT);
  ModifyCommand(cm_median);
  ModifyCommand(cm_vertmirror);
  ModifyCommand(cm_horzmirror);
  ModifyCommand(cm_blur);
  ModifyCommand(cm_rotate);
  ModifyCommand(cm_Shear);
  ModifyCommand(cm_zoom);
  ModifyCommand(cm_Pixelate);
  ModifyCommand(cm_dither4);
  ModifyCommand(cm_dither3);
  ModifyCommand(cm_dith16);
  ModifyCommand(cm_halftone);
  ModifyCommand(cm_dithdiff);
  ModifyCommand(cm_brpalette);
  ModifyCommand(cm_dmpalette);
  ModifyCommand(cm_paladjust);
  ModifyCommand(cm_updatepalette);
  ModifyCommand(cm_restorepalette);
  ModifyCommand(cm_histo);
  ModifyCommand(cm_showrect);
  ModifyCommand(cm_disppalette);
  ModifyCommand(cm_graypalette);
  ModifyCommand(cm_RainbowPalette);
  ModifyCommand(cm_GreenPalette);
  ModifyCommand(cm_NegPalette);
  ModifyCommand(cm_Redcomponent);
  ModifyCommand(cm_Greencomponent);
  ModifyCommand(cm_Bluecomponent);
  ModifyCommand(cm_ExtractY);
  ModifyCommand(cm_ExtractI);
  ModifyCommand(cm_ExtractQ);
  ModifyCommand(cm_Grab);
  ModifyCommand(cm_grayscale);

  ModifyCommand(cm_AddChildren);
  ModifyCommand(cm_SubChildren);
  ModifyCommand(cm_MulChildren);
  ModifyCommand(cm_DivChildren);
  ModifyCommand(cm_ANDchildren);
  ModifyCommand(cm_ORchildren);
  ModifyCommand(cm_XORchildren);
  ModifyCommand(cm_Minchildren);
  ModifyCommand(cm_Maxchildren);
  ModifyCommand(cm_Avechildren);
  ModifyCommand(cm_Comparechildren);
  ModifyCommand(cm_MaskChildren);
  ModifyCommand(cm_OverlayChildren);
  ModifyCommand(cm_CopyPalette);
  ModifyCommand(cm_ImportFile);
  ModifyCommand(cm_ExportFile);
  ModifyCommand(cm_YIQ2RGB);
  ModifyCommand(cm_Animate);

end;

procedure IncImages;
begin
  if ImageCount = 0 then MenuItems(Enable);
  Inc(ImageCount);
end;

procedure DecImages;
begin
  Dec(ImageCount);
  if ImageCount = 0 then MenuItems(Disable);
end;
end.