unit bscrolw;
{T. Fulton CIS:[100015,565]{
{24 July 1993}
{ Based on BSCRLAPP.PAS by Pat Ritchey, CIS:[70007,4660]  }
{ 14 Oct 92-removed stack checking to reduce code segment size}
{ 14 Oct 92 added dip ,rainbow palette, cutout now resets processing rectangle}
{16-23 Oct 92 created Bigarray unit, ImportFile}
{30-Nov-92 added histogram equalization,pixelate, and bitplane}
{9 Nov 92 added Sobel,translate}
{12 Nov 92 created new wgraphics,mathutils}
{16 Nov 92 added blur}
{18 Nov 92 add range checking dialog}
{21 Nov 92 automated yiq2rgb, added ln(input) transform, entropy}
{17 Jul 1993 added GIF read by B. Berry [76555,167]}
{17 Jul 93 created descendant of TBitScrollWindow object BMProcess}
{23 Jul 93 added 24 bit bitmap load and display}

interface

uses    Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory, WinTypes, WinProcs, WinDos,WinCrt, Strings,
        uprint,wintools,ostring,bigmatri,bmputils,dispdib,wgraphics,
        mathutils,center3;

{gif}
const LargestCode=4095;
      Tablesize=5003;
      msg24bit='24 bit image, decompose to 3 X 8 bit images first';

type codeentry=record
               priorcode:integer;
               codeid:integer;
               addedchar:byte;
               end;
     registers=record
           case integer of
           0:(ax,bx,cx,dx,bp,si,ds,es,flags:word);
           1:(al,ah,bl,bh,cl,ch,dl,dh:byte);
           end;


     Bytefile=File of byte;
{gif}

type
(*
  PSaveBMP2GIF=^TSaveBMP2GIF;
  TSaveBMP2GIF=object(TSaveGIF)
  function getbyte:integer;
  procedure putbyte(b:integer);
  end;
*)

  PScrollWindow = ^TBitScrollWindow;
  TBitScrollWindow = object(TWindow)
  {**VARIABLES**}
    FileName: array[0..fsPathName] of Char;
    CaptionBuffer:captiontype;
    BitmapHandle: HBitmap;
    IconizedBits: HBitmap;
    oldbrush:HBrush;
    NewBitmapHandle: THandle;      {!!}
    oldpal:Hpalette;
    dragdc:hdc;
    ClientRect:Trect;
    BitmapInfo,mono_bitmapinfo: PBitmapInfo;
    bitmapinfosize,mono_bitmapinfosize:word;
    ActiveLogPal:PLogPalette;
    bitmaparray,tempbitmap:largebytematrix;
    bit24maparray:largelongintmatrix;
    mono_bitmaparray:largebitarray;
    realhisto:array[0..255] of real;
    Palsize,mono_palsize:integer;
    TotPalsize:word;
    HactivePal : hPalette;               {!!}

    IconImageValid: Boolean;
    PixelHeight, PixelWidth,NewPixelwidth,NewPixelheight: Word;
    firstcol,firstrow,lastcol,lastrow:word;
    Mode: Longint;
    bits:longtype;
    minlevel,maxlevel:byte;
    min,max:byte;
    average,entropy:real;
    horzscale,vertscale:real;
    symbolsize,printscale:integer;
    x1wld,x2wld,y1wld,y2wld,scalex,scaley:real; {current world coords}
    Xk0, Yk0, Xk1, Yk1, Xk2, Yk2, xk3,yk3:integer;
    ThePen,dashedpen,oldpen:hpen;
    Theplot:plotarray;
    zoom,cutting,pasting,capturing,blocking:boolean;
    interpolate,windowing,showpos,monitoron:boolean;
    bitmap_mono:boolean;
    ptbeg,ptend:Tpoint;
    selection:array[0..79] of char;
    buffer:array[0..19] of char;
    {**METHODS**}
    constructor Init(AParent:PWindowsObject;AFileName:Pchar;
                    thepixelwidth,thepixelheight:word);
    procedure SetupWindow;virtual;
    destructor Done; virtual;
    function GetClassName : PChar; virtual;
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;

    procedure temp2bitmap;

    function  CMFileOpen(AFileName:Pchar):boolean;virtual;
    procedure CMFileSave(var Msg:Tmessage);virtual cm_First
                                           + cm_FileSave;
    procedure CMFilePrint(var Msg:Tmessage);virtual cm_First
                                            + cm_FilePrint;


    function canclose:boolean;virtual;
    procedure WMSize(var Msg: TMessage); virtual wm_First
                                         + wm_Size;
    procedure AdjustScroller;
    procedure Refresh(var Message: Tmessage);virtual cm_first
                                             + cm_refresh;
    procedure FullScreen(var Message:Tmessage);virtual cm_first
                                             + cm_Fullscreen;
    procedure Options(var Message: TMessage); virtual
      cm_first + cm_Options;

    procedure WMLbuttondown(var msg:Tmessage);virtual wm_first
                                              + wm_Lbuttondown;
    procedure WMRbuttondown(var msg:Tmessage);virtual wm_first
                                              + wm_Rbuttondown;
    procedure WMRbuttonup(var msg:Tmessage);virtual wm_first
                                              + wm_Rbuttonup;
    procedure WMLbuttonDblClk(var msg:Tmessage);virtual wm_first
                                              + wm_LbuttonDblClk;
    procedure WMLbuttonup(var msg:Tmessage);virtual wm_first
                                            + wm_Lbuttonup;
    procedure WMMousemove(var msg:Tmessage);virtual wm_first
                                            + wm_MouseMove;
    function BMPCreate:boolean;

    function LoadBitmapFile(Name: PChar): Boolean;
    Procedure CopyDIBPalette(var bmi : TBitMapInfo;
                                     palettesize:integer); {!!}
    function OpenDIB(var TheFile: File): Boolean;
    function OpenGIF(var TheFile: File): Boolean;
    function NewDIB(thepixelwidth,thepixelheight:integer):boolean;
    function windowx(wldx:real):integer;virtual;
    function windowy(wldy:real):integer;virtual;
    procedure DrawAxis(aDC:HDC);virtual;
    procedure DrawPolygon(aDC:hdc;aplot:plotarray;
                          line,numofpoints : integer);virtual;
    procedure CalcHist;
    procedure ShowStat(var Msg:Tmessage);virtual cm_first
                                           + cm_ShowStat;
    procedure DispPalette(var Msg:Tmessage);virtual cm_first
                                            + cm_DispPalette;

  end;



{****************Dialog objects definitions**********************}


Pnewdibdlg=^Tnewdibdlg;
Tnewdibdlg=object(TCenteredDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure SetupWindow;virtual;
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;

PPrintDlg=^Tprintdlg;
Tprintdlg=object(TDialog)
 setpointer:Pchar;
 constructor init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
 procedure Ok(var msg:Tmessage);virtual id_first + id_ok;
end;


{******************TWindows*****************************************}
POptionwindow=^TOptionWindow;
 TOptionWindow=object(TWindow)
    rad1,rad2,rad3,rad4,rad5,rad6,rad7,rad8:PRadioButton;
    Group1,group2:PGroupBox;
    constructor init(Aparent:PWindowsObject;atitle:pchar);
    procedure SetupWindow;virtual;
    procedure HandleGroup1Msg(var Msg:TMessage);virtual id_first + id_group1;
     procedure HandleGroup2Msg(var Msg:TMessage);virtual id_first + id_group2;
    procedure Ok(var msg:Tmessage);virtual id_first + id_okbtn;
 end;



 PShowStatWindow = ^ShowstatWindow;
 ShowstatWindow = object(TWindow)
   mintext,maxtext,averagetext,entropytext : Pstatic;
   minstat,maxstat,averagestat,entropystat : Pstatic;
   constructor Init(AParent: PWindowsObject; ATitle: PChar);
   procedure SetupWindow; virtual;
   procedure OK(var msg:TMessage);virtual id_first + id_okbtn;
 end;

 var buffer:array[0..10] of char;

{**********IMPLEMENTATION**************}

implementation


constructor TOptionWindow.init(Aparent:PWindowsObject;atitle:pchar);
 var tempbtn:PButton;
  begin
    TWindow.init(Aparent,atitle);
    attr.style:=ws_popupwindow or ws_caption or ws_visible;
    attr.x:=100;
    attr.y:=100;
    attr.w:=300;
    attr.h:=200;
    Group1:=New(PGroupBox,init(@self,id_group1,'Mouse',
                0,0,150,135));
    rad1:=New(PRadioButton,init(@self,id_rad1,'Zoom',
                 10,20,85,24,group1));
    rad2:=New(PRadioButton,init(@self,id_rad2,'Cutting',
               10,45,85,24,group1));
    rad3:=New(PRadioButton,init(@self,id_rad3,'Pasting',
               10,70,85,24,group1));
    rad4:=New(PRadioButton,init(@self,id_rad4,'Windowing',
               10,95,120,24,group1));
    Group2:=New(PGroupBox,init(@self,id_group2,'Print scale',
                150,0,200,135));
    rad5:=New(PRadioButton,init(@self,id_rad5,'None',
                 160,20,85,24,group2));
    rad6:=New(PRadioButton,init(@self,id_rad6,'Screen',
               160,45,85,24,group2));
    rad7:=New(PRadioButton,init(@self,id_rad7,'Maximize',
               160,70,95,24,group2));
    tempbtn:=New(PButton,init(@self,id_okbtn,'OK',
                              235,150,40,24,false));
  end;

  procedure TOptionWindow.SetUpWindow;
  begin
    TWindow.SetUpWindow;
    if PScrollWindow(parent)^.zoom then rad1^.setcheck(1);
    if PScrollWindow(parent)^.cutting then rad2^.setcheck(1);
    if PScrollWindow(parent)^.pasting then rad3^.setcheck(1);
    if PScrollWindow(parent)^.windowing then rad4^.setcheck(1);
    case Pscrollwindow(parent)^.printscale of
    1:rad5^.setcheck(1);
    2:rad6^.setcheck(1);
    3:rad7^.setcheck(1);
    end;
  end;

  procedure TOptionWindow.Ok(var msg:TMessage);
  begin
    closewindow;
  end;

  procedure TOptionWindow.HandleGroup1Msg(var Msg:TMessage);
  begin
  if rad1^.GetCheck <>0 then
  begin
     PScrollWindow(parent)^.zoom:=true;
     PScrollWindow(parent)^.cutting:=false;
     PScrollWindow(parent)^.pasting:=false;
     PScrollWindow(parent)^.windowing:=false;
  end;
  if rad2^.GetCheck <>0 then
  begin
   PScrollWindow(parent)^.cutting:=true;
   PScrollWindow(parent)^.zoom:=false;
   PScrollWindow(parent)^.pasting:=false;
    PScrollWindow(parent)^.windowing:=false;
  end;
  if rad3^.GetCheck <>0 then
  begin
    PScrollWindow(parent)^.pasting:=true;
    PScrollWindow(parent)^.zoom:=false;
    PScrollWindow(parent)^.cutting:=false;
     PScrollWindow(parent)^.windowing:=false;
  end;
  if rad4^.GetCheck <>0 then
  begin
    PScrollWindow(parent)^.pasting:=false;
    PScrollWindow(parent)^.zoom:=false;
    PScrollWindow(parent)^.cutting:=false;
     PScrollWindow(parent)^.windowing:=true;
  end;
end;

procedure TOptionWindow.HandleGroup2Msg(var msg:Tmessage);
 begin
   if rad5^.getcheck <>0 then PscrollWindow(parent)^.printscale:=1;
   if rad6^.getcheck <>0 then PscrollWindow(parent)^.printscale:=2;
   if rad7^.getcheck <>0 then PscrollWindow(parent)^.printscale:=3;
 end;


constructor ShowStatWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var tempbtn:Pbutton;

begin
  TWindow.Init(AParent, ATitle);
  attr.style:=ws_popupwindow or ws_caption or ws_visible;
  with Attr do
  begin
    X := 20;
    Y := 20;
    W := 200;
    H := 200;
  end;
  minstat := New(PStatic,
    Init(@Self, id_minstat, '   ', 140, 15, 50, 17, 0));
  maxstat := New(PStatic,
    Init(@Self, id_maxstat, '   ', 140, 40, 50, 17, 0));
  averagestat := New(PStatic,
    Init(@Self, id_averagestat, '   ', 140, 70, 50, 17, 0));
  entropystat := New(PStatic,
    Init(@Self, id_entropystat, '   ', 140, 100, 70, 17, 0));
  mintext := New(PStatic,
    Init(@Self, id_mintext, 'Minimum', 10, 15, 80, 17, 0));
  maxtext := New(PStatic,
    Init(@Self, id_maxtext, 'Maximum', 10, 40, 80, 17, 0));
  averagetext := New(PStatic,
    Init(@Self, id_averagetext, 'Average', 10, 70, 90, 25, 0));
  entropytext := New(PStatic,
    Init(@Self, id_entropytext, 'Bits/pixel', 10, 100, 90, 25, 0));
    tempbtn:=New(Pbutton,init(@self,id_okbtn,'OK',75,150,50,20,false));
end;

procedure ShowStatWindow.SetupWindow;
begin
  TWindow.SetupWindow;
  Str(Pscrollwindow(parent)^.min:3,buffer);
  minstat^.SetText(buffer);
  Str(Pscrollwindow(parent)^.max:3, buffer);
  maxstat^.SetText(buffer);
  Str(Pscrollwindow(parent)^.average:4:1, buffer);
  averagestat^.SetText(buffer);
  Str(Pscrollwindow(parent)^.entropy:4:2, buffer);
  entropystat^.SetText(buffer);
end;

procedure ShowStatWindow.Ok(var msg:TMessage);
begin
  closewindow;
end;


constructor TNewDIBDlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TCenteredDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure TNewDIBDlg.SetUpWindow;
var
   tempstr:string[15];
begin
  TCenteredDialog.SetUpWindow;
  str(PScrollWindow(parent)^.newpixelwidth:5,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed1,wm_settext,0,longint(@buffer));
  str(PScrollWindow(parent)^.newpixelheight:5,tempstr);
  strPcopy(buffer,tempstr);
  SendDlgItemMessage(hwindow,id_ed2,wm_settext,0,longint(@buffer));
end;

procedure TNewDIBDlg.Ok(var msg:Tmessage);
var
    valcode:integer;

begin
  buffer[0]:=chr(0);
  SendDlgItemMessage(hwindow,id_ed1,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PScrollWindow(parent)^.newpixelwidth,valcode);
  SendDlgItemMessage(hwindow,id_ed2,wm_Gettext,19,Longint(@buffer));
  if strlen(buffer) > 0 then val(buffer,PScrollWindow(parent)^.newpixelheight,valcode);
  TCenteredDialog.Ok(msg);
end;

constructor Tprintdlg.init(Aparent:PWindowsObject;atitle:pchar;P:Pchar);
begin
  TDialog.init(Aparent,atitle);
  Setpointer:=p;
end;

procedure Tprintdlg.Ok(var msg:Tmessage);

begin
  if  SendDlgItemMessage(hwindow,id_rad1,bm_Getcheck,0,0) =1 then
     PScrollWindow(parent)^.printscale:=1
  else if  SendDlgItemMessage(hwindow,id_rad2,bm_Getcheck,0,0) =1 then
     PScrollWindow(parent)^.printscale:=2
  else if  SendDlgItemMessage(hwindow,id_rad3,bm_Getcheck,0,0) =1 then
     PScrollWindow(parent)^.printscale:=3;
  TDialog.Ok(msg);
end;

{************************* Child Window Procedures***********************}


procedure TBitScrollWindow.WMLButtonDown(var Msg:Tmessage);

var localbitmaphdl,oldbits1,oldbits2:Hbitmap;
    bitspointer:pointer;
    memdc1,memdc2:hdc;
    TheRect:Trect;
    result:longint;

    begin
    monitoron:=false;
    if (zoom or cutting or windowing) and capturing then
    begin
     if not blocking then
     begin
        blocking:=true;
        dragdc:=GetDC(hwindow);
        oldpal:=selectpalette(dragdc,HactivePal,false);
        unrealizeobject(HactivePal);
        realizepalette(dragdc);
        ptbeg.x:=msg.Lparamlo;
        ptbeg.y:=msg.Lparamhi;
        if ptbeg.x <1 then ptbeg.x:=1;
        if ptbeg.x > pixelwidth then ptbeg.x:=pixelwidth;
        if ptbeg.y <1 then ptbeg.y:=1;
        if ptbeg.y > pixelheight then ptbeg.y:=pixelheight;
        ptend.x:=ptbeg.x;
        ptend.y:=ptbeg.y;
        oldbrush:=SelectObject(dragdc,GetStockObject(hollow_brush));
        SetROP2(dragdc,r2_not);
        rectangle(dragdc,ptbeg.x,ptbeg.y,ptend.x,ptend.y);
      end;
     end {zoom}
     else
     if pasting then
     begin

       if OpenClipBoard(hwindow) then
       begin
         localbitmaphdl:=GetClipBoardData(cf_bitmap);
         if localbitmaphdl <> 0 then
         begin
           dragdc:=getdc(hwindow);
           oldpal:=selectpalette(dragdc,HactivePal,false);
           unrealizeobject(HactivePal);
           realizepalette(dragdc);
           memdc1:=CreateCompatibleDC(dragdc);
           memdc2:=CreateCompatibleDC(dragdc);
           oldbits1:=SelectObject(memdc1,localbitmaphdl);
           oldbits2:=SelectObject(memdc2,BitMaphandle);
           BitBlt(memdc2,msg.Lparamlo,msg.Lparamhi,
                  pixelwidth,pixelheight,memdc1,0,0,srccopy);
           SelectObject(memdc1,oldbits1);
           SelectObject(memdc2,oldbits2);
           deleteDC(memdc1);
           deleteDC(memdc2);

           bitspointer:=GlobalLock(bitmaparray.arrayhandle);
              result:=GetDIBits(dragdc,bitmaphandle,0,pixelheight,
                                bitspointer,BitMapInfo^,DIB_RGB_Colors);
            GlobalUnlock(bitmaparray.arrayhandle);
           releasedc(hwindow,dragdc);
         end;
         CloseClipboard;
       end;
       InvalidateRect(Hwindow,nil,true);
     end;{pasting}
    end;{WMLButtonDown}

    procedure TBitScrollWindow.WmRButtondown(var msg:TMessage);
    begin
      monitoron:=false;
      if not showpos then
      begin
      showpos:=true;
      dragdc:=GetDC(hwindow);
        oldpal:=selectpalette(dragdc,HactivePal,false);
        unrealizeobject(HactivePal);
         setcursor(loadcursor(hinstance,'crosscursor'));
      GetClientRect(hwindow,clientrect);
      end;
    end;

    procedure TBitScrollWindow.WmRButtonup(var msg:TMessage);
    begin
      showpos:=false;
      SelectPalette(dragdc,oldpal,false);
      ReleaseDC(hwindow,dragDC);
      SetCursor(LoadCursor(0, idc_arrow));
      InvalidateRect(hwindow,nil,true);
    end;

    procedure TBitScrollWindow.WMLButtonDblClk(var Msg:Tmessage);

    begin
      GetClientRect(hwindow,clientrect);
      if not capturing then
      begin
        capturing:=true;
        setcapture(hwindow);
        setcursor(loadcursor(hinstance,'crosscursor'));
      end
    end;{WMLButtonDblClk}


    procedure TBitScrollWindow.WMMouseMove(var Msg:TMessage);

    var thestring:tostring;
        tempy:integer;

    begin
      if blocking then
      begin
        rectangle(dragdc,ptbeg.x,ptbeg.y,ptend.x,ptend.y);
        ptend.x:=msg.Lparamlo;
        ptend.y:=msg.Lparamhi;
        rectangle(dragdc,ptbeg.x,ptbeg.y,ptend.x,ptend.y);
      end;
      if showpos then
      begin
        with bitmaparray do
        begin
        arrayaddr.ptr:=globallock(arrayhandle);
        settextalign(dragdc,ta_right or ta_bottom);
        thestring.init(15);
        thestring.addinteger(msg.lparamlo,3);
        thestring.addstring(',');
        tempy:=maxrows-msg.lparamhi;
        if tempy < 0 then tempy:=0;
        thestring.addinteger(tempy,3);
        thestring.addstring(' ');
        thestring.addinteger(bitmaparray.get(msg.lparamlo,tempy),3);
        textout(dragdc,clientrect.right,clientrect.bottom,thestring.pchar,
               strlen(thestring.pchar));
        settextalign(dragdc,ta_left);
        thestring.done;
        globalunlock(arrayhandle);
        end;{with}
      end;
    end;

    procedure TBitScrollWindow.WMLButtonUp(var msg:TMessage);
    var  MemDC1:hdc;
        localbitmaphdl:Hbitmap;
        bitspointer:pointer;
        result,longwidth:longint;
        temp:word;


    begin
      if not blocking then exit
      else
      begin
        ClipCursor(nil);
        blocking:=false;
        capturing:=false;
        showpos:=false;
        rectangle(dragdc,ptbeg.x,ptbeg.y,ptend.x,ptend.y);
        SetROP2(dragdc,r2_black);
        ptend.x:=msg.Lparamlo;
        ptend.y:=msg.Lparamhi;
        if ptend.x > pixelwidth then ptend.x:=pixelwidth;
        if ptend.y > pixelheight then ptend.y:=pixelwidth;
        SetCursor(LoadCursor(0,idc_wait));
        if zoom then
        begin
          GetClientRect(Hwindow,clientrect);
          stretchblt(dragDC,0,0,clientrect.right,clientrect.bottom,
                   dragdc,ptbeg.x,ptbeg.y,(ptend.x-ptbeg.x),
                   (ptend.y-ptbeg.y),srccopy);
        end;{zoom}
        if cutting then
        begin
          memdc1:=CreateCompatibleDC(dragdc);
          localbitmaphdl:=CreateCompatibleBitmap(dragdc,
            abs(ptend.x-ptbeg.x),abs(ptend.y-ptbeg.y));
          if localbitmaphdl <>0 then
          begin
            selectobject(memdc1,localbitmaphdl);
            stretchblt(memdc1,0,0,abs(ptend.x-ptbeg.x),abs(ptend.y-ptbeg.y),
                       dragdc,ptbeg.x,ptbeg.y,abs(ptend.x-ptbeg.x),
                       abs(ptend.y-ptbeg.y),srccopy);
            if OpenClipBoard(hwindow) then
            begin
              EmptyClipboard;
              SetClipBoardData(cf_bitmap,localbitmaphdl);
              CloseClipBoard;
            end;
          end;{localbitmaphdl}
          deleteDC(memdc1);
        end;{if cutting}
        if windowing then
        begin
          firstcol:=ptbeg.x;
          lastrow:=pixelheight-ptbeg.y;
          lastcol:=ptend.x;
          firstrow:=pixelheight-ptend.y;
          if lastrow < firstrow then
          begin
            temp:=lastrow;
            lastrow:=firstrow;
            firstrow:=temp;
          end;
          if firstrow < 0 then firstrow:=0;
          if lastrow > pixelheight-1 then lastrow:=pixelheight-1;
          if firstcol < 0 then firstcol:=0;
          if lastcol > pixelwidth-1 then lastcol:=pixelwidth-1;
        end;
        SelectPalette(dragdc,oldpal,false);
        ReleaseDC(hwindow,dragDC);
        SetCursor(LoadCursor(0, idc_arrow));
        releasecapture;
      end;
    end;

function TBitScrollWindow.BMPCreate:boolean;
var dchandle:hdc;
    bitspointer:pointer;

begin

  if bitmapinfo^.bmiheader.bibitcount <=8 then
   Bitspointer := GlobalLock(bitmaparray.arrayhandle)
   else  Bitspointer := GlobalLock(bitmaparray.arrayhandle);
  if bitspointer <> nil then
  begin
   DCHandle := CreateDC('Display', nil, nil, nil);

  UnrealizeObject(HactivePal);                        {!!}
  OldPal := SelectPalette(DCHandle,HactivePal,false); {!!}
  RealizePalette(DCHandle);                     {!!}

  SetCursor(LoadCursor(0,idc_wait));
  NewBitmapHandle :=
  CreateDIBitmap(DCHandle, BitmapInfo^.bmiHeader, cbm_Init, Bitspointer,
  BitmapInfo^, dib_rgb_colors);
  SetCursor(LoadCursor(0,idc_arrow));
  SelectPalette(DCHandle,OldPal,false);         {!!}
  DeleteDC(DCHandle);
  GlobalUnlock(bitmaparray.arrayhandle);

  if NewBitmapHandle <> 0 then
  begin
    if BitmapHandle <> 0 then DeleteObject(BitmapHandle);
    BitmapHandle := NewBitmapHandle;
    bmpcreate:=true;
  end
  else
   bmpcreate:=false;
  end;{bitspointer}

end;




(*
procedure TBitScrollWindow.MatrixPoint(prompt1,prompt2,history:pchar;
                                    action:actiontype);
var x:byte;

begin
      strcopy(promptstr1,'Fill constant');
      strcopy(promptstr2,'0 <= x <=255');
      x:=GetUserByte(promptstr1,promptstr2);
        setcursor(loadcursor(0,idc_wait));
        if bitmaparray.fill(firstcol,firstrow,lastcol,lastrow,x) then
        begin
          bmpcreate;
          Adjustscroller;
        end;
        setcursor(loadcursor(0,idc_arrow));
    strcat(processhistory,'Fill ');
    strcat(processhistory,#13#10);
end;
*)

procedure TBitScrollWindow.temp2bitmap;
var col,row:longint;
begin
  for row:=firstrow+1 to lastrow-1 do
      for col:=firstcol+1 to lastcol-1 do
      begin
        bitmaparray.put(col,row,tempbitmap.get(col,row));
      end;
end;




function TBitScrollWindow.windowx(wldx:real):integer;
begin
  windowx:=trunc((wldx-x1wld)*scalex + xk0);
end;

function TBitScrollWindow.windowy(wldy:real):integer;
begin
  windowy:=trunc(yk0-(wldy-y1wld)*scaley)
end;

procedure TBitScrollWindow.DrawAxis(aDC:HDC);
var
  MaxExponentX, MaxExponentY,
  NDiff, X2, Y2, Ys, Xs,npoints,i,width : integer;
  xleftos,xrightos,ytopos,ybottomos:integer;
  Difference, Number, S, Fract,delta : real;
  textprop:TTextMetric;

begin { DrawAxis }
  GetClientRect(hwindow,clientrect);
    Xk3 := clientrect.right;
    Yk3 := clientrect.bottom;
  xleftos:=xk3 div 8;
  xrightos:=xk3 div 8;
  ytopos:=yk3 div 8;
  ybottomos:=yk3 div 8;
  xk0 := xleftOS;
  Yk0 := Yk3 - ybottomOS;
  Yk1 := ytopOS;
  Xk1 := Xk0;
  Yk2 := Yk0;
  Xk2 := Xk3 - xrightOS;
  scalex:=(xk2-xk1)/(x2wld-x1wld);
  scaley:=(yk0-yk1)/(y2wld-y1wld);

  SetBkMode(aDC,opaque);
  rectangle(adc,xk1,yk1,xk2,yk2);
  DrawLine(aDC,Xk0,yk0,xk1,yk1);
  DrawLine(aDC,xk0,yk0,xk2+1,yk2);
  DrawLine(adc,xk2,yk0,xk2,yk1);
  if (abs(Yk0 - Yk1) >= 35) and (abs(Xk2 - Xk1) >= 150) then
  begin
    DrawLine(aDC,Xk0, Yk0, Xk0 - 4, Yk0);
    DrawLine(aDC,Xk0, Yk0, Xk0, Yk0 + 4);
    Delta := (Yk2-yk1);
    npoints:=5;
    GetTextMetrics(aDC,textprop);
    width:=4*Textprop.tmAveCharWidth div 3;
      if abs(y2wld) > abs(y1wld) then
        MaxExponentY := GetExponent(y2wld)
      else
        MaxExponentY := GetExponent(y1wld);
      DrawNum(adc,xk0-4*width, Yk0 + 1, MaxExponentY, y1wld);
      if MaxExponentY <> 0 then
        DrawExponent(adc,xk0-6*width, yk1-2*width, MaxExponentY);
    Ys := Yk0;
    Difference := (y2wld - y1wld) / NPoints;
    dashedpen:=createpen(ps_dash,1,0);

    for I := 1 to NPoints do
    begin
        Ys:=yk0 - trunc((i*delta)/npoints);
      if (Ys > 13) then
      begin
        Number := y1wld + I * Difference;
        DrawLine(aDC,xk0, Ys, Xk0 - 4, Ys);
          oldpen:=selectobject(aDC,dashedpen);
          drawline(aDC,xk0,ys,xk2,ys);
          selectobject(aDC,oldpen);
          DrawNum(adc,xk0-4*width, Ys + 1, MaxExponentY, Number);
      end;
    end;
    deleteobject(dashedpen);
    deleteobject(oldpen);
      if abs(x2wld) > abs(x1wld) then
        MaxExponentX := GetExponent(x2wld)
      else
        MaxExponentX := GetExponent(x1wld);
      DrawNum(adc,Xk0-10, (9*Yk0+yk3) div 10, MaxExponentX, x1wld);
      if MaxExponentX <> 0 then
        DrawExponent(adc,Xk2 - 5,(4*Yk0 +yk3) div 5, MaxExponentX);
    Delta := abs(Xk2-xk1);
    Npoints:=6;
    Xs := Xk0 - 1;
    Difference := (x2wld - x1wld) / NPoints;
    dashedpen:=createpen(ps_dash,1,0);
    for I := 1 to NPoints do
    begin
      xs:=xk0 + trunc((i*delta)/npoints);
      if (Xs < Xk2-14) then
      begin
        Number := x1wld + I * Difference;
        DrawLine(aDC,Xs, Yk0, Xs, Yk0 + 4);
          oldpen:=selectobject(aDC,dashedpen);
          drawline(aDC,xs,yk0,xs,yk1);
          selectobject(aDC,oldpen);
          DrawNum(adc,Xs - 14, (9*Yk0 + yk3) div 10, MaxExponentX, Number);
      end;
      DrawNum(adc,xk2-14,(9*yk0 + yk3) div 10,MaxExponentX,x2wld);
    end;
    deleteobject(dashedpen);
    deleteobject(oldpen);
  end;
  setbkmode(adc,transparent);
end; { DrawAxis }

procedure TBitScrollWindow.DrawPolygon(aDC:hdc;aplot:plotarray;Line,numofpoints : integer);
var
  I, X1, X2, Y1, Y2:integer;


procedure drawcross(x,y:integer);
begin
  drawline(aDC,x-(7*symbolsize) div 10,y-(7*symbolsize) div 10,x+(7*symbolsize) div 10,y+(7*symbolsize) div 10);
  drawline(aDC,x-(7*symbolsize) div 10,y+(7*symbolsize) div 10,x+(7*symbolsize) div 10,y-(7*symbolsize) div 10);
end;

procedure WldRectangle(x1,y1,x2,y2:real);
begin
  setbkmode(adc,opaque);
  rectangle(adc,windowx(x1),windowy(y1),windowx(x2),windowy(y2));
  setbkmode(adc,transparent);
end;

begin { DrawPolygon }
  symbolsize:=4;
  x1:=windowx(0);
  y1:=windowy(Aplot[1,2]);
  drawcross(x1,y1);
(*  wldrectangle(0,y1,1,0);*)

  for i:=2 to 255 do
  begin
    x2:=windowx(i);
    y2:=windowy(aplot[i,2]);
    drawcross(x2,y2);
    if (line >= 0) then
      drawline(adc,x1,y1,x2,y2);

(*    wldrectangle(i-1,y2,i,0);*)
    x1:=x2;
    y1:=y2
  end;
end; { DrawPolygon }

procedure TBitScrollWindow.CalcHist;

var i,temp:byte;
    row,col,width,height,totalnum:longint;
begin
(*
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  *)
  for i:=0 to 255 do
    realhisto[i]:=0.0;
  with bitmaparray do
  begin
  arrayaddr.ptr:=globallock(arrayhandle);
  for col:=firstcol to lastcol do
    for row:=firstrow to lastrow do
    begin
      temp:=get(col,row);
      realhisto[temp]:=realhisto[temp] + 1;
    end;
    globalunlock(arrayhandle);
  end;{with}
  width:=lastcol-firstcol+1;
  height:=lastrow-firstrow+1;
  totalnum:= width*height;
  for i:=0 to 255 do
    realhisto[i]:=realhisto[i]/totalnum;
end;


procedure TBitScrollWindow.ShowStat(var Msg:TMessage);
var totalnum,row,col,width,height:longint;
    i,temp:byte;


begin
(*
  if bitmapinfo^.bmiheader.bibitcount > 8 then
  begin
    MessageBox(Hwindow,msg24bit,
               'Error',mb_iconExclamation or mb_ok);
    exit
  end;
  *)
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  setcursor(loadcursor(0,idc_wait));
  calchist;
  with bitmaparray do
  begin
    width:=lastcol-firstcol+1;
    height:=lastrow-firstrow+1;
    totalnum:=width*height;
    max:=0;
    min:=255;
    average:=0;
    for col:=firstcol to lastcol do
      for row:=firstrow to lastrow do
      begin
        temp:=get(col,row);
        if temp <min then min:=temp;
        if temp > max then max:=temp;
        average:=average + temp;
      end;
    globalunlock(arrayhandle);
    average:=average/(totalnum);
    entropy:=0.0;
    for i:=0 to 255 do
    begin
      if realhisto[i] > 1.0e-6 then
        entropy:=entropy - 1.441*realhisto[i]*(ln(realhisto[i]));
    end;
  end;{with}
  Application^.MakeWindow(New(PShowStatWindow,init(@self,'Statistics')));
  setcursor(loadcursor(0,idc_arrow));
end;{ShowStat}



{ Constructor for a TBitScrollWindow, sets scroll styles and constructs
  the Scroller object.  Also sets the Mode based on whether the display
  is monochrome (two-color) or polychrome. }

constructor TBitScrollWindow.Init(AParent:PWindowsObject;AFileName:Pchar;
                                  thepixelwidth,thepixelheight:word);
var
  DCHandle: HDC;

begin
  TWindow.Init(AParent,Afilename);
  Attr.Style := Attr.Style or ws_VScroll or ws_HScroll;
  BitmapHandle := 0;
  HactivePal := 0;                {!!}

  IconImageValid := False;
  capturing:=false;
  blocking:=false;
  zoom:=false;
  cutting:=false;
  pasting:=false;
  windowing:=true;
  showpos:=false;
  bitmap_mono:=false;
  interpolate:=false;
  minlevel:=0;
  maxlevel:=255;
  printscale:=1;

  newpixelwidth:=thepixelwidth;
  newpixelheight:=thepixelheight;
  Scroller := New(PScroller, Init(@Self, 1, 1, 200, 200));
  DCHandle := CreateDC('Display', nil, nil, nil);
  IconizedBits := CreateCompatibleBitmap(DCHandle, 64, 64);
  if GetDeviceCaps(DCHandle, numColors) < 3 then Mode := notSrcCopy
  else Mode := srcCopy;
  DeleteDC(DCHandle);
  if (strcomp(Afilename,'NEW') =0)  or (not CMFileOpen(Afilename))
  then
  begin
    if (strcomp(Afilename,'NEW') =0) then
       Application^.ExecDialog(New(PNewDIBDlg,init(@self,Pchar('NewDIBdlg'),selection)));
    NewDIB(newpixelwidth,newpixelheight);
    AdjustScroller;
    IconImageValid:=false;
    strcopy(filename,AFilename);
  end;
  attr.x:=0;
  attr.y:=0;
  attr.w:=pixelwidth + getsystemmetrics(sm_cxvscroll)+ 2*getsystemmetrics(sm_cxframe);
  attr.h:=pixelheight + getsystemmetrics(sm_cxhscroll) + 2*getsystemmetrics(sm_cyframe);
  ptbeg.x:=0;
  ptbeg.y:=0;
  ptend.x:=pixelwidth-1;
  ptend.y:=pixelheight-1;
  firstcol:=0;
  firstrow:=0;
  lastcol:=pixelwidth-1;
  lastrow:=pixelheight-1;

  horzscale:=1.0;
  vertscale:=1.0;
end;

procedure TBitScrollWindow.Setupwindow;
begin
  TWindow.setupwindow;
  IncImages;
  setwindowtext(hwindow,captionbuffer);
end;

{ Change the class name to the application name. }

function TBitScrollWindow.GetClassName : PChar;
begin
  GetClassName := bsa_Name;
end;

{ Allow the iconic picture to be drawn from the client area. }

procedure TBitScrollWindow.GetWindowClass(var WndClass: TWndClass);
begin
  TWindow.GetWindowClass(WndClass);
  WndClass.style := WndClass.style or cs_dblclks;
  WndClass.hIcon := 0; { Client area will be painted by the app. }
end;

destructor TBitScrollWindow.Done;
begin
  TWindow.Done;
  decimages;
end;

{ If the the 'Open...' menu item is selected, then, using
  the current TFileDlgRec we prompt the user for a new bitmap
  file.  If the user selects one and it is one that we can
  read, we display it in the window and change the window's
  caption to reflect the new bitmap file.  It should be noted
  that we save the old TFileDlgRec just in case we are unable
  to display the bitmap.  This allows us to restore the old
  search criteria. }

function TBitScrollWindow.CMFileOpen(AFileName:Pchar):boolean;
var
  TempName: array[0..fsPathName] of Char;

begin
    if LoadBitmapFile(Afilename) then
    begin
      StrCopy(FileName, Afilename);
      cmfileopen:=true;
    end
    else cmfileopen:=false;
end;



procedure TBitScrollWindow.CMFileSave(var Msg:Tmessage);

type filenametype=array[0..fsPathname] of char;

var Afile:filenametype;
    ext,extptr:pchar;

procedure SaveFile(Filename:filenametype);

var TheFile:file;
    TestWin30Bitmap,filesize,zeroes,offsettobits:longint;
    ident:array[0..1] of char;
    Bits: LongType;


begin
  testwin30bitmap:=40;
  ident:='BM';
  zeroes:=$0000;
  if not bitmap_mono then
  begin
    offsettobits:=bitmapinfosize + sizeof(TBitmapFileheader);
    filesize:=bitmapinfosize+14+bitmapinfo^.bmiheader.bisizeimage;
  end
  else
  begin
    offsettobits:=mono_bitmapinfosize + sizeof(TBitmapFileheader);
    filesize:=mono_bitmapinfosize+14 + mono_bitmapinfo^.bmiheader.bisizeimage;
  end;
  Assign(TheFile,filename);
  Rewrite(TheFile,1);
  blockwrite(TheFile,ident,2);
  blockwrite(TheFile,filesize,sizeof(filesize));
  blockwrite(TheFile,zeroes,4);
  blockwrite(TheFile,offsettobits,4);
  if not bitmap_mono then
     blockwrite(TheFile,Bitmapinfo^,bitmapinfosize)
   else  blockwrite(TheFile,mono_Bitmapinfo^,mono_bitmapinfosize);
  Bits.Ptr := GlobalLock(bitmaparray.arrayhandle);
  hwrite(Thefile,bits.ptr,filesize);
  GlobalUnlock(bitmaparray.arrayhandle);
  close(Thefile);
end;{Save BMP file}


procedure SaveGIFfile(filename:pchar);far;
var afile:pchar;
    bits:longtype;
    x,y:longint;
        Signature    : Array[0..5] of Byte;            {GIF signature}
    SDescriptor  : Array[1..7] of byte;            {screen descriptor}
    ColorMap     : Array[0..2,0..255] of byte;     {RGB color map}
    IDescriptor  : Array[1..10] of byte;           {image descriptor}

    GifFile      : ByteFile;                       {output file}
    Debugger     : Boolean;
    GifTerminator: Byte;                           {';' GIF terminator}


Function GetByte:Integer;
      {Called by the LZW compression routines, GetByte produces
       a byte representing the color value of a pixel on the screen.
       The byte is packaged as the low byte of a word (integer).
       GetByte uses the global variables X and Y to keep track of
       its position on the screen.}

      Begin
        If X<pixelwidth-2
          Then
            Begin
              X:=X+1;
              writeln('x =',x:4);
              GetByte:=bitmaparray.Get(X,Y);
            End
          Else
            Begin
              If Y<pixelheight-2
                Then
                  Begin
                    Y:=Y+1;
                    X:=0;
                    writeln('y= ',y:4);
                    GetByte:=bitmaparray.Get(X,Y);
                  End
                Else
                  Begin
                    GetByte:=(-1);
                  End;
            End;
      End;{getbyte}

  Procedure PutByte(B:Integer);
    {Called by the LZW compression routines, PutByte sends a byte
     of data to the forming GIF file.  The first byte sent by the LZW
     compression routings is the 'Minimum Code Size', next byte is
     the block size, then the bytes forming the data block, the next
     block size byte, next block data bytes, etc.  The byte is accepted
     from the compression routines as the low byte of an integer.}

   Var
      ByteNum: Byte;
    Begin
      ByteNum:=Lo(B);
      Write(GifFile,ByteNum);
    End;


procedure GetAllRGBPalette;
var i:integer;
begin
  with ActiveLogPal^ do
  begin
  for i:=0 to palsize-1 do
    with palPalentry[i] do
    begin
      colormap[0,i]:=pered;
      colormap[1,i]:=pegreen;
      colormap[2,i]:=peblue;
    end;{with}
  end;{with}
end;

(*
Procedure InitializeTable(MinCodeSize: Byte);
  Var I: Integer;
  begin
    CodeSize:=  Succ(MinCodeSize);
    ClearCode:= 1 Shl MinCodeSize;
    EOFCode:=   Succ(ClearCode);
    FreeCode:=  Succ(EOFCode);
    MaxCode:=   1 Shl CodeSize;
    For I:=0 to Pred(TableSize) do CodeTable^[I].CodeID:=0;
  end;   { Procedure InitializeTable }

*)
(*
Procedure FlushBuffer(N: Integer);
  Var I: Integer;
  begin
    PutByte(N);
    For I:=0 to Pred(N) do PutByte(CodeBuffer[I]);
  end;   { Procedure FlushBuffer }
*)
(*
Procedure WriteCode(theCode: Integer);far;
begin
  ByteOffset:= BitOffset Shr 3;
  BitsLeft:=   BitOffset And 7;
  If ByteOffset>=254 then
  begin
    FlushBuffer(ByteOffset);
    CodeBuffer[0]:=CodeBuffer[ByteOffset];
    BitOffset:=BitsLeft;
    ByteOffset:=0;
  end;
  If BitsLeft>0 then
  Inline(
      $8B/$46/<theCODE      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02)      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}


  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(theCode);
      CodeBuffer[ByteOffset+1]:= Hi(theCode);
    end;
  BitOffset:=BitOffset+CodeSize;

end;   { Procedure WriteCode }
*)

{ ---------------------------------------------------------------------------
  NOTE: For simplicity, CompressGIF does not test MinCodeSize for valid
        values (in [2..9]), primarily since I was too lazy. As mentioned,
        the "customary" value seems to be 4.

        "While True" and "GoTo Break" are used to parallel the C coding of
        "For (;;)" and "break".
  --------------------------------------------------------------------------- }

Function CompressGIF(MinCodeSize: Byte): Integer;
Label Break;
type
 codeTabletype=array[0..tablesize] of codeentry;
     tablepointer=^codeTabletype;

var
   CodeTable:TablePointer;
   CodeBuffer:Array[0..259] of Byte;
   i:integer;
   CodeSize,ClearCode,
   EOFCode,MinCode,
   BitOffset,
   MaxCode,
   FreeCode,PrefixCode,
   SuffixChar,
   Hx,        D:  Integer;
   BitsLeft,ByteOffset: Integer;
   CmpError:Integer;

Function SuffixCharEqualGetByte: Integer;
    begin
      SuffixChar:=GetByte;
      SuffixCharEqualGetByte:=SuffixChar;
    end;   { Function SuffixCharEqualGetByte }

Procedure FlushBuffer(N: Integer);
  Var I: Integer;
  begin
    PutByte(N);
    For I:=0 to Pred(N) do PutByte(CodeBuffer[I]);
  end;   { Procedure FlushBuffer }

begin {compress}
    CmpError:=0; CompressGIF:=CmpError;
    New(CodeTable);
    PutByte(MinCodeSize); BitOffset:=0;
  (* InitializeTable(MinCodeSize);*)
  CodeSize:=  Succ(MinCodeSize);
    ClearCode:= 1 Shl MinCodeSize;
    EOFCode:=   Succ(ClearCode);
    FreeCode:=  Succ(EOFCode);
    MaxCode:=   1 Shl CodeSize;
    For I:=0 to Pred(TableSize) do CodeTable^[I].CodeID:=0;

(*    WriteCode(ClearCode);*)

    ByteOffset:= BitOffset Shr 3;
  BitsLeft:=   BitOffset And 7;
  If ByteOffset>=254 then
  begin
    FlushBuffer(ByteOffset);
    CodeBuffer[0]:=CodeBuffer[ByteOffset];
    BitOffset:=BitsLeft;
    ByteOffset:=0;
  end;
  If BitsLeft>0 then
  begin
  writeln('writing clearcode');
  Inline(
      $8B/$46/<clearcode      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02);      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}


   end
  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(clearCode);
      CodeBuffer[ByteOffset+1]:= Hi(clearCode);
    end;
  BitOffset:=BitOffset+CodeSize;

    SuffixChar:=GetByte;
    If SuffixChar>=0 then
      begin
        PrefixCode:=SuffixChar;
        While SuffixCharEqualGetByte>=0 do
          begin
            Hx:=(PrefixCode Xor (SuffixChar Shl 5)) mod TableSize;
            D:=1;
            While True do
              begin
                If CodeTable^[Hx].CodeID=0 then
                  begin
                  (*  WriteCode(PrefixCode);*)
  ByteOffset:= BitOffset Shr 3;
  BitsLeft:=   BitOffset And 7;
  If ByteOffset>=254 then
  begin
    FlushBuffer(ByteOffset);
    CodeBuffer[0]:=CodeBuffer[ByteOffset];
    BitOffset:=BitsLeft;
    ByteOffset:=0;
  end;
  If BitsLeft>0 then
  begin
  writeln('writing prefixcode');
  Inline(
      $8B/$46/<prefixcode      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02);      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}
   
   end

  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(prefixCode);
      CodeBuffer[ByteOffset+1]:= Hi(prefixCode);
    end;
  BitOffset:=BitOffset+CodeSize;

                    D:=FreeCode;
                    If FreeCode<=LargestCode then
                      begin
                        CodeTable^[Hx].PriorCode:= PrefixCode;
                        CodeTable^[Hx].AddedChar:= SuffixChar;
                        CodeTable^[Hx].CodeID:=    FreeCode;
                        FreeCode:=                 Succ(FreeCode);
                      end;
                    If D=MaxCode then
                      If CodeSize<12 then
                        begin
                          CodeSize:=Succ(CodeSize); MaxCode:=MaxCode Shl 1;
                        end
                      else
                        begin
                         (* WriteCode(ClearCode);*)

                         ByteOffset:= BitOffset Shr 3;
                         BitsLeft:=   BitOffset And 7;
                         If ByteOffset>=254 then
                         begin
                          FlushBuffer(ByteOffset);
                          CodeBuffer[0]:=CodeBuffer[ByteOffset];
                          BitOffset:=BitsLeft;
                          ByteOffset:=0;
                         end;
  If BitsLeft>0 then
  Inline(
      $8B/$46/<clearcode      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02)      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}


  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(clearCode);
      CodeBuffer[ByteOffset+1]:= Hi(clearCode);
    end;
  BitOffset:=BitOffset+CodeSize;

(*                          InitializeTable(MinCodeSize);*)
                       CodeSize:=  Succ(MinCodeSize);
                       ClearCode:= 1 Shl MinCodeSize;
                       EOFCode:=   Succ(ClearCode);
                       FreeCode:=  Succ(EOFCode);
                       MaxCode:=   1 Shl CodeSize;
                        For I:=0 to Pred(TableSize) do CodeTable^[I].CodeID:=0;
                    end;
                    PrefixCode:=SuffixChar;
                    GoTo Break;
                  end;
                If (CodeTable^[Hx].PriorCode=PrefixCode) and
                   (CodeTable^[Hx].AddedChar=SuffixChar) then
                  begin
                    PrefixCode:=CodeTable^[Hx].CodeID;
                    GoTo Break;
                  end;
                Hx:=Hx+D; D:=D+2;
                If Hx>=TableSize then Hx:=Hx-TableSize;
              end;
Break:
          end;
        If SuffixChar<>-1 then
          begin
            CmpError:=SuffixChar; CompressGIF:=CmpError; Exit;
          end;
       (* WriteCode(PrefixCode);*)

       ByteOffset:= BitOffset Shr 3;
  BitsLeft:=   BitOffset And 7;
  If ByteOffset>=254 then
  begin
    FlushBuffer(ByteOffset);
    CodeBuffer[0]:=CodeBuffer[ByteOffset];
    BitOffset:=BitsLeft;
    ByteOffset:=0;
  end;
  If BitsLeft>0 then
  Inline(
      $8B/$46/<prefixcode      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02)      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}


  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(prefixCode);
      CodeBuffer[ByteOffset+1]:= Hi(prefixCode);
    end;
  BitOffset:=BitOffset+CodeSize;

      end
    else
      If SuffixChar<>-1 then
        begin
          CmpError:=SuffixChar; CompressGif:=CmpError; Exit;
        end;
   (* WriteCode(EOFCode);*)

   ByteOffset:= BitOffset Shr 3;
  BitsLeft:=   BitOffset And 7;
  If ByteOffset>=254 then
  begin
    FlushBuffer(ByteOffset);
    CodeBuffer[0]:=CodeBuffer[ByteOffset];
    BitOffset:=BitsLeft;
    ByteOffset:=0;
  end;
  If BitsLeft>0 then
  Inline(
      $8B/$46/<EOFcode      {     mov   ax,<Code[bp]       ; Ax:=Code;           }
      /$31/$D2           {     xor   dx,dx              ; Dx:=0;              }
      /$8B/$0E/>BITSLEFT {     mov   cx,[>BitsLeft]     ; Cx:=BitsLeft;       }
      /$49               {A1:  dec   cx                 ; count a bit         }
      /$7C/$06           {     jl    A2                 ; ( do cx shifts )    }
      /$D1/$E0           {     shl   ax,1               ; shift bit into carry}
      /$D1/$D2           {     rcl   dx,1               ; shift carry into Dx }
      /$EB/$F7           {     jmp short A1             ; continue            }
      /$BE/>CODEBUFFER   {A2:  mov   si,>CodeBuffer     ; point to CodeBuffer }
      /$8B/$1E/>BYTEOFFSET{     mov   bx,[>ByteOffset]   ; index to ByteOffset}
      /$08/$00           {     or    [si+bx],al         ; OR low eight bits   }
      /$88/$60/$01       {     mov   [si+bx+1],ah       ;   move next 16 bits }
      /$88/$50/$02)      {     mov   [si+bx+2],dl       ;  to ByteOffset +1,+2}


  else
    begin
      CodeBuffer[ByteOffset]:=   Lo(eofCode);
      CodeBuffer[ByteOffset+1]:= Hi(eofCode);
    end;
  BitOffset:=BitOffset+CodeSize;

    If BitOffset>0 then FlushBuffer((BitOffset+7) div 8);
    FlushBuffer(0);
    Dispose(CodeTable);
  end;   { Function CompressGIF }


Procedure SaveDescriptor(var Thefile:bytefile);
Var
 I,J                 :Integer;
 Pixel      :Byte;
 Begin
   For I:=0 to 5 do Write(GifFile,Signature[I]);
   For I:=1 to 7 do Write(Giffile,SDescriptor[I]);
   For J:=0 to palsize-1 do
   For I:=0 to 2 do Write(GifFile,ColorMap[I,J]);
   For I:=1 to 10 do Write(GifFile,IDescriptor[I]);
 End;{savedescriptor}


Procedure SetGifDescriptor;
    {sets the gif signature 'Signature[0..5]', screen
     descriptor array 'SDescriptor[1..7]', and global color
     map as follows:
       Signature = GIF87a as six bytes
       Screen Descriptor as seven bytes:

             bits
         7 6 5 4 3 2 1 0  Byte #
        +---------------+
        |               |  1
        +-Screen Width -+      Raster width in pixels (LSB first)
        |               |  2
        +---------------+
        |               |  3
        +-Screen Height-+      Raster height in pixels (LSB first)
        |               |  4
        +-+-----+-+-----+      M = 1, Global color map follows Descriptor
        |M|  cr |0|pixel|  5   cr+1 = # bits of color resolution
        +-+-----+-+-----+      pixel+1 = # bits/pixel in image (bit 3 of word 5 reserved)
        |   background  |  6   background=Color index of screen background
        +---------------+          (color is defined from the Global color
        |0 0 0 0 0 0 0 0|  7        map or default map if none specified)
        +---------------+

       Global Color Map has 3*GetMaxColor bytes.

    }

    Const
      GIF87a: Array[0..5] of Byte = (71,73,70,56,55,97);


    Var
      I,J                       :Integer;
      CR,Pixel                  :Byte;
      Regs: Registers;
    Begin
      {*** SCREEN DESCRIPTOR ******************************}

      {Signature}
      For I:=0 to 5 do
        Signature[I]:=GIF87a[I];

      {Screen Width}
      SDescriptor[1]:=(pixelwidth) Mod 256;
      SDescriptor[2]:=(pixelwidth) Div 256;

      {Screen Height}
      SDescriptor[3]:=(pixelheight) Mod 256;
      SDescriptor[4]:=(pixelheight) Div 256;


      SDescriptor[5]:=0;

      {M=1}
      SDescriptor[5]:=SDescriptor[5] OR 128; {1000000}

      {CR+1=bits color resolution}
      CR:=7;
      SDescriptor[5]:=SDescriptor[5] OR (CR shl 4);

      {Pixel+1=bits per pixel in image}
      Pixel:=7;
      SDescriptor[5]:=SDescriptor[5] OR Pixel;

      {Background color}
      SDescriptor[6]:=0;         {set as black}

      {Reserved}
      SDescriptor[7]:=0;


      {****** Global Color Map *********************}
      GetAllRGBPalette;

      {*** IMAGE DESCRIPTOR *****************************}

      {ImageSepChar ',' }
      IDescriptor[1]:=Ord(',');

      {Image Left}
      IDescriptor[2]:=0 mod 256;
      IDescriptor[3]:=0 div 256;

      {Image Top}
      IDescriptor[4]:=0 mod 256;
      IDescriptor[5]:=0 div 256;

      {Image Width}
      IDescriptor[6]:=(pixelwidth) mod 256;
      IDescriptor[7]:=(pixelwidth) div 256;

      {Image Height}
      IDescriptor[8]:=(pixelheight) mod 256;
      IDescriptor[9]:=(pixelheight) div 256;

      {ImageSpecByte}
        IDescriptor[10]:=0;
      {M=1 local color map follows, use 'pixel'}
      {M=0 use global color map, ignore 'pixel'}
        {IDescriptor[10]:=IDescriptor[10] OR 128;} {10000000}
      {I=0 formatted in sequential order}
      {I=1 formatted in interlaced order}
        {IDescriptor[10]:=IDescriptor[10] OR 64;}  {01000000}
      {Pixel+1=bits per pixel for this image}
        pixel:=7;
        IDescriptor[10]:=IDescriptor[10] OR Pixel;
    End;{setgifdescriptor}

begin {Marker}

  x:=0;y:=0;
  GifTerminator:=$3b;
  Assign(GIFFile,filename);
  Rewrite(GIFFile);
  SetGIFDescriptor;
  SaveDescriptor(GIFfile);
  bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
  CompressGIF(8);
  globalunlock(bitmaparray.arrayhandle);
  Close(GIFfile);

end;{SaveGIFfile}

begin
  if Application^.ExecDialog(New(PfileDialog,Init(@Self,Pchar(sd_FileSave),Afile)))
     =id_ok then
  begin
    extptr:=strscan(afile,'.');
    extptr:=strUpper(extptr);
  if (strcomp(extptr,'.BMP')=0) then
    SaveFile(Afile)
    else SaveGIFfile(afile)
  end;
end;

procedure TBitScrollWindow.CMFilePrint(var Msg:TMessage);
var N,pagewidth:integer;
    scale:real;
    dc,memdc:HDC;
    oldbitmap:Hbitmap;
    bitspointer:pointer;

begin
  Application^.ExecDialog(New(PPrintDlg,init(@self,Pchar('Printdlg'),selection)));

  if (BitMapHandle <>0) and PrnStart(FileName) then
  begin
    N:=GetDeviceCaps(Pdc,rastercaps);
    pagewidth:=GetDeviceCaps(Pdc,horzres);
    if (N and rc_BitBlt) <> rc_BitBlt then
    MessageBox(Hwindow,'Device does not support bitmaps',
               'Error',mb_iconExclamation or mb_ok)
    else
    begin
      bitspointer:=globallock(bitmaparray.arrayhandle);
      dc:=GetDC(Hwindow);
      case printscale of
      1: bitblt(pdc,0,0,pixelwidth,pixelheight,memdc,0,0,srccopy);
      2:scale:=getdevicecaps(pdc,logpixelsx) div getdevicecaps(dc,logpixelsx);
      3:scale:=pagewidth div pixelwidth;
      end;
      releaseDC(Hwindow,dc);
      setstretchbltmode(pdc,coloroncolor);
      if (printscale <>1) then StretchDIBits(Pdc,0,0,trunc(scale*pixelwidth),trunc(scale*pixelheight),
                 0,0,pixelwidth,pixelheight,bitspointer,
                 bitmapinfo^,dib_rgb_colors,srccopy);
      Newpage;
      globalunlock(bitmaparray.arrayhandle);
    end;
    Prnstop
  end;

end;{CMFilePrint}


function TBitScrollWindow.canclose:boolean;
begin
  if HactivePal <> 0 then DeleteObject(HactivePal);   {!!}
  HactivePal := 0;                              {!!}
  if BitmapHandle <> 0 then
  begin
    DeleteObject(BitmapHandle);
    if bitmaparray.arrayhandle <> 0 then bitmaparray.done;
    if bitmapinfo <> nil then FreeMem(BitmapInfo, bitmapinfosize);
    if activelogpal <> nil then FreeMem(ActiveLogPal,TotPalsize);
  end;
  if bitmap_mono then
  begin
    if mono_bitmaparray.arrayhandle <> 0 then mono_bitmaparray.done;
    if mono_bitmapinfo <> nil then freemem(mono_bitmapinfo,mono_bitmapinfosize);
  end;
end;


{ Adjust the Scroller range so that the the origin is the
  upper-most scrollable point and the corner is the
  bottom-most. }

procedure TBitScrollWindow.AdjustScroller;
begin
  GetClientRect(HWindow, ClientRect);
  with ClientRect do
    Scroller^.SetRange(PixelWidth - (right - left),
      PixelHeight - (bottom - top));
  Scroller^.ScrollTo(0, 0);
  InvalidateRect(HWindow, nil, True);
end;

{ Reset scroller range. }

procedure TBitScrollWindow.Refresh(var Message:TMessage);
begin
 InvalidateRect(HWindow, nil, True);
end;

procedure TBitScrollWindow.Fullscreen(var Message:TMessage);
var bitspointer:pointer;
begin
  bitspointer:=globallock(bitmaparray.arrayhandle);
  displaydib(bitmapinfo,bitspointer,0);
  globalunlock(bitmaparray.arrayhandle);
end;


procedure TBitScrollWindow.Options(var Message: TMessage);
var optionwnd:PWindow;

begin
  optionwnd:=New(POptionWindow,init(@self,'Options'));
  Application^.MakeWindow(optionwnd);
end;


procedure TBitScrollWindow.WMSize(var Msg: TMessage);
var
  DC, MemDC1, MemDC2: HDC;
  OldBitmap1, OldBitmap2: HBitmap;
  OldCursor: HCursor;
begin
  TWindow.WMSize(Msg);
  Scroller^.AutoOrg := not (Msg.wParam = sizeIconic);
  if not (Msg.WParam = sizeIconic) then AdjustScroller
  else if not IconImageValid and (BitmapHandle <> 0) then
  begin
    DC := GetDC(HWindow);
    MemDC1 := CreateCompatibleDC(DC);
    MemDC2 := CreateCompatibleDC(DC);
    ReleaseDC(HWindow, DC);
    OldBitmap1 := SelectObject(MemDC1, IconizedBits);
    OldBitmap2 := SelectObject(MemDC2, BitmapHandle);
    OldCursor := SetCursor(LoadCursor(0, idc_Wait));
    StretchBlt(MemDC1, 0, 0, Msg.lParamLo, Msg.lParamHi, MemDC2,
      0, 0, PixelWidth, PixelHeight, SrcCopy);
    SetCursor(OldCursor);
    SelectObject(MemDC1, OldBitmap1);
    SelectObject(MemDC2, OldBitmap2);
    DeleteDC(MemDC1);
    DeleteDC(MemDC2);
    IconImageValid := True;
  end;
end;



Procedure TBitScrollWindow.CopyDIBPalette(var bmi : TBitMapInfo;palettesize:integer);  {!!}
var
  i : integer;
begin
  if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
{$R-}
  for i := 0 to Pred(PaletteSize) do
     With ActiveLogPal^ do
       begin
       palNumEntries := PaletteSize;
       palVersion := $0300;
       With palPalEntry[i],bmi.bmicolors[i] do
        begin
        peRed := rgbRed;
        peBlue := rgbBlue;
        peGreen := rgbGreen;
        peFlags := pc_NoCollapse;
        end;
       end;
  HactivePal := CreatePalette(ActiveLogPal^);
{$R+}
end;{copydib}

procedure TBitScrollWindow.DispPalette(var Msg:Tmessage);

var i,x,y,dx,dy:integer;
    Abrush:Hbrush;
    OldPalette:Hpalette;
    DCHandle:HDC;

function PaletteIndex(W: Word): TColorRef;
begin
  PaletteIndex := $01000000 or W;
end;

begin
  DChandle:=GetDC(Hwindow);
  OldPalette := SelectPalette(DCHandle, HactivePal, False);
  UnRealizeObject(HactivePal);
  RealizePalette(DCHandle);
  GetClientRect(HWindow,ClientRect);
  i:=0;
  x:=0;
  y:=0;
  dx:=clientrect.right div 16;
  dy:=clientrect.bottom div 16;
  ABrush := CreateSolidBrush(PaletteIndex(i));
    OldBrush := SelectObject(DCHandle, ABrush);
  while i < palsize do
  begin
    Rectangle(DCHandle, x * dx, y * dy, (x+1) * dx, (y+1) * dy);

    i:=i+1;
    x:=x+1;
    if x > 15 then
    begin
      x:=0;
      y:=y+1;
    end;
  end;
  SelectObject(DCHandle, OldBrush);
    DeleteObject(ABrush);
  SelectPalette(DCHandle, OldPalette, False);
  ReleaseDC(HWindow, DCHandle);
end;{dispPalette}

{ Attempt to open a Windows 3.0 device independent bitmap }

function TBitScrollWindow.OpenDIB(var TheFile: File): Boolean;

type Ttriplet=record
          rgbred:byte;
          rgbgreen:byte;
          rgbblue:byte;
          end;
var
  bitCount: Word;
  i:integer;
  longWidth,srccol,destcol,
  temp,temp1,temp2,temp3,minvalue,maxvalue: Longint;
  ok:boolean;
  triplet:Ttriplet;

begin
  OpenDIB := True;
  Seek(TheFile, 28);
  BlockRead(TheFile, bitCount, SizeOf(bitCount));
  if bitCount <= 8 then
    bitmapinfosize := SizeOf(TBitmapInfoHeader) + ((1 shl bitCount) * SizeOf(TRGBQuad))
  else  bitmapinfosize := SizeOf(TBitmapInfoHeader);

  BitmapInfo := MemAlloc(bitmapinfosize);
  Seek(TheFile, SizeOf(TBitmapFileHeader));
  BlockRead(TheFile, BitmapInfo^, bitmapinfosize);
  NewPixelWidth := BitmapInfo^.bmiHeader.biWidth;
  NewPixelHeight := BitmapInfo^.bmiHeader.biHeight;
  if bitcount <=8 then  PalSize := 1 shl (BitmapInfo^.bmiHeader.biBitCount)
  else Palsize:=256;
  TotPalsize := Sizeof(TLogPalette)+Pred(PalSize)*Sizeof(TPaletteEntry);
  GetMem(ActiveLogPal,TotPalsize);
(*
  with bitmapinfo^.bmiheader do
  begin
   writeln('bibitcount',bibitcount);
   writeln('bisizeimage',bisizeimage);
   writeln('bisize',bisize);
   writeln('biclrused',biclrused);
   writeln('biclrimportant',biclrimportant);
   writeln('biwidth',biwidth);
   writeln('biheight',biheight);
   readln;
 end;
*)
  if bitcount <=8 then CopyDIBPalette(BitMapInfo^,palsize)
  else
  begin
     if HactivePal <> 0 then {get rid of palette from previous bitmap }
     begin
     DeleteObject(HactivePal);
     HactivePal := 0;
     end;
     with bitmapinfo^.bmiheader do
     begin
      biclrused:=0;
      biclrimportant:=0;
      bibitcount:=24;
    end;

{$R-}
     for i := 0 to Pred(PalSize) do
     With ActiveLogPal^ do
     begin
       palNumEntries := PalSize;
       palVersion := $0300;
       With palPalEntry[i] do
        begin
        peRed := i;
        peBlue := i;
        peGreen := i;
        peFlags := pc_NoCollapse;
        end;
     end;
  HactivePal := CreatePalette(ActiveLogPal^);
{$R+}
  end;{bitcount >8}

  longWidth := (((NewPixelWidth * bitCount) + 31) div 32) * 4;
  BitmapInfo^.bmiHeader.biSizeImage := longWidth * NewPixelHeight;
  GlobalCompact(-1);
  bitmaparray.init(longwidth,newpixelheight,ok);
  GetBitmapData(TheFile, bitmaparray.arrayhandle, BitmapInfo^.bmiHeader.biSizeImage);
  PixelWidth := NewPixelWidth;
  PixelHeight := NewPixelHeight;
(*
  if bitcount >8 then
  begin
    bit24maparray.init(longwidth div 3,newpixelheight,ok);
    bitmaparray.arrayaddr.ptr:=globallock(bitmaparray.arrayhandle);
    bit24maparray.arrayaddr.ptr:=globallock(bit24maparray.arrayhandle);
    for row:=0 to bit24maparray.maxrows-1 do
    begin
      srccol:=0;
      for destcol:=0 to bit24maparray.maxcols-1 do
      begin
        temp1:=bitmaparray.get(srccol,row);
        temp2:=bitmaparray.get(srccol+1,row);
        temp3:=bitmaparray.get(srccol+2,row);
        temp:=temp3 shl 16 + temp2 shl 8 + temp1;
        bit24maparray.put(destcol,row,temp);
        srccol:=srccol + 3;
      end;{destcol}
    end;{row}
    globalunlock(bitmaparray.arrayhandle);
    globalunlock(bit24maparray.arrayhandle);
    bitmaparray.done;
  end;{if bitcount >8}
*)
   if bmpcreate then opendib:=true
   else
   OpenDIB := False;


end;

function TBitScrollWindow.OpenGIF(var TheFile: File): Boolean;

var
  LogicalScreen:TLogicalScreenDescriptor;
  bitCount: Word;
  longWidth: Longint;
  ok:boolean;
  errormsg:pchar;

begin
  OpenGIF := True;
  bitCount:= 8;
  bitmapinfosize := SizeOf(TBitmapInfoHeader) + ((1 shl bitCount) * SizeOf(TRGBQuad));
  BitmapInfo := MemAlloc(bitmapinfosize);
  BitmapInfo^.bmiHeader.biBitCount:=bitcount;
  PalSize := 1 shl (BitmapInfo^.bmiHeader.biBitCount);
  TotPalsize := Sizeof(TLogPalette)+Pred(PalSize)*Sizeof(TPaletteEntry);
  GetMem(ActiveLogPal,TotPalsize);
  blockread(TheFile,LogicalScreen,sizeof(LogicalScreen));
  longWidth := ((((LogicalScreen.screenwidth) * bitCount) + 31) div 32) * 4;
  with bitmapinfo^ do
  begin
      longWidth := (((LogicalScreen.screenwidth * bitCount) + 31) div 32) * 4;
      bmiHeader.biSizeImage := longWidth * LogicalScreen.screenheight;
      bmiheader.bisize:=40;
      bmiheader.biplanes:=1;
      bmiheader.biCompression:=0;
      bmiheader.bixpelspermeter:=0;
      bmiheader.biypelspermeter:=0;
      bmiheader.biclrused:=0;
      bmiheader.biclrimportant:=256;
      bmiheader.biwidth:=longwidth;
      bmiheader.biheight:=LogicalScreen.screenheight;
  end;
  NewPixelWidth := BitmapInfo^.bmiHeader.biWidth;
  NewPixelHeight := BitmapInfo^.bmiHeader.biHeight;


  GlobalCompact(-1);
  bitmaparray.init(longwidth,newpixelheight,ok);
  if ok then errormsg:=GetGifData(TheFile,bitmaparray.arrayhandle,bitmaparray,
     bitmapinfo,LogicalScreen)
    else writeln('init not successful');
  (*if errormsg <>nil then MessageBox(HWindow, ErrorMsg, bsa_Name, mb_Ok);*)
  CopyDIBPalette(BitMapInfo^,palsize);
  PixelWidth := NewPixelWidth;
  PixelHeight := NewPixelHeight;
  if bmpcreate then opengif:=true
  else
    OpenGIF := False;
end;

function TBitScrollWindow.NewDIB(thepixelwidth,thepixelheight:integer): Boolean;
var
  i,bitCount: Word;
  longWidth: Longint;
  ok:boolean;

begin
  setcursor(loadcursor(0,idc_wait));
  bitCount := 8;
    bitmapinfosize := SizeOf(TBitmapInfoHeader) + ((1 shl bitCount) * SizeOf(TRGBQuad));
    bitmapInfo := MemAlloc(bitmapinfosize);
    with bitmapinfo^ do
    begin
      bmiHeader.biBitCount:=bitcount;
      longWidth := (((thePixelWidth * bitCount) + 31) div 32) * 4;
      bmiHeader.biSizeImage := longWidth * thePixelHeight;
      bmiheader.bisize:=40;
      bmiheader.biplanes:=1;
      bmiheader.biCompression:=0;
      bmiheader.bixpelspermeter:=0;
      bmiheader.biypelspermeter:=0;
      bmiheader.biclrused:=0;
      bmiheader.biclrimportant:=0;
      bmiheader.biwidth:=longwidth;
      bmiheader.biheight:=thepixelheight;
    end;
    PalSize := 1 shl (BitmapInfo^.bmiHeader.biBitCount);
    TotPalsize := Sizeof(TLogPalette)+Pred(PalSize)*Sizeof(TPaletteEntry);
    GetMem(ActiveLogPal,TotPalsize);
{$R-}
    for i:=0 to pred(palsize) do
      with bitmapinfo^.bmicolors[i] do
      begin
        rgbred:=i;
        rgbgreen:=i;
        rgbblue:=i
      end;
{$R+}
    CopyDIBPalette(BitMapInfo^,palsize);

    GlobalCompact(-1);
    bitmaparray.init(longwidth,thepixelheight,ok);
    PixelWidth := longwidth;
    PixelHeight := thePixelHeight;
    bmpcreate;
    setcursor(loadcursor(0,idc_arrow));
end;


{ Test if the passed file is a Windows 3.0 DI bitmap and if so read it.
  Report errors if unable to do so. Adjust the Scroller to the new
  bitmap dimensions. }

function TBitScrollWindow.LoadBitmapFile(Name: PChar): Boolean;
type Theader=record
             signature:array[0..2] of char;
             version:array[0..2] of char;
             end;

var
  TheFile: File;
  TestWin30Bitmap: Longint;
  ErrorMsg: PChar;
  OldCursor: HCursor;
  Header:Theader;
  iocode:integer;

begin
  ErrorMsg := nil;
  OldCursor := SetCursor(LoadCursor(0, idc_Wait));
  Assign(TheFile, Name);
  {$I-}
  Reset(TheFile, 1);
  {$I+}
  iocode:=ioresult;
  if iocode = 0 then
  begin
    blockread(TheFile,header,sizeof(header));
    if header.signature='GIF' then
    begin
       if OpenGIF(TheFile) then
       begin
	AdjustScroller;
	IconImageValid := False;
       end
       else ErrorMsg := 'Unable to load GIF from file';
    end{if GIF}
    else
    begin {if bmp}
      Seek(TheFile, 14);
      BlockRead(TheFile, TestWin30Bitmap, SizeOf(TestWin30Bitmap));
      if TestWin30Bitmap = 40 then
        if OpenDIB(TheFile) then
        begin
          AdjustScroller;
          IconImageValid := False;
        end
        else ErrorMsg := 'Unable to create Windows 3.0 bitmap from file'
      else errormsg:='No a windows 3.0 bitmap file';
    end;{if BMP}
    Close(TheFile);
  end {if ioresult=0}
  else
    ErrorMsg := 'Cannot open bitmap file';
  SetCursor(OldCursor);
  if ErrorMsg = nil then LoadBitmapFile := True else
  begin
    if iocode <> 2 then MessageBox(HWindow, ErrorMsg, bsa_Name, mb_Ok);
    LoadBitmapFile := False;
  end;
end;

{ Responds to an incoming "paint" message by redrawing the bitmap.  (The
  Scroller's BeginView method, which sets the viewport origin relative
  to the present scroll position, has already been called. )  }


procedure TBitScrollWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);


var
  MemoryDC: HDC;
  OldBitmapHandle: THandle;
   widthstr,heightstr,colorstr:array[0..4] of char;

begin
  StrCopy(CaptionBuffer, AnsiLower(FileName));
  str(pixelwidth,widthstr);
  str(pixelheight,heightstr);
  if not bitmap_mono then str((bitmapinfo^.bmiheader.bibitcount),colorstr)
  else  str((mono_bitmapinfo^.bmiheader.bibitcount),colorstr);
  strcat(CaptionBuffer,' ');
  strcat(captionBuffer,widthstr);
  strcat(captionbuffer,'X');
  strcat(captionbuffer,heightstr);
  strcat(captionbuffer,'X');
  strcat(captionbuffer,colorstr);
  setwindowtext(hwindow,captionbuffer);

  if BitmapHandle <> 0 then
  begin
    MemoryDC := CreateCompatibleDC(PaintDC);
    UnrealizeObject(HactivePal);
    {win 3.1 mods}
    OldPal := SelectPalette(PaintDC,HactivePal,false);  {!!}
    RealizePalette(PaintDC);                      {!!}

    if IsIconic(HWindow) then
      OldBitmapHandle := SelectObject(MemoryDC, IconizedBits)
    else
    begin
      OldBitmapHandle := SelectObject(MemoryDC, BitmapHandle);
      if Mode = srcCopy then
      begin
	SetBkColor(PaintDC, GetNearestColor(PaintDC, $800000));
	SetTextColor(PaintDC, $FFFFFF);
      end;
    end;
    BitBlt(PaintDC, 0, 0, PixelWidth, PixelHeight, MemoryDC, 0, 0,
      Mode);
    SelectPalette(PaintDC,oldpal,false);
    SelectObject(MemoryDC, OldBitmapHandle);
    DeleteDC(MemoryDC);
  end;

end;
end.
