Unit Center3;
{**************************************************************************}
{*    Center   by Daniel Thomas  CIS 72301,2164                           *}
{*                                                                        *}
{*  This code is hereby donated to the public domain.  Enjoy.             *}
{*                                                                        *}
{*  This unit contains a procedure, CenterPopup, which will center a      *}
{*  Popup window (i.e. a dialog) in it's parent's window.  If it won't    *}
{*  fit inside the parent's window, then it will be centered on top of    *}
{*  the parent.                                                           *}
{*                                                                        *}
{*  Also, if the dialog would be positioned off the screen, it is forced  *}
{*  within the visible screen.                                            *}
{*                                                                        *}
{*  There are a few descendant objects - tCenteredDialog and              *}
{*  tCenteredInputDialog - that make using it a snap.  Just replace an    *}
{*  occurrance of pDialog with pCenteredDialog, and you've got a centered *}
{*  dialog!                                                               *}
{**************************************************************************}

{**************************************************************************}
{*		Updated 1/17/93 by Mark Woolfson 											  *}
{*			- Fixed a problem that caused a fully maximized Parent Window	  *}
{*				to cause the variables that were of type "word" to go out of  *}
{*				range and cause a run-time error.									  *}
{*                                                                        *}
{*			- Another problem was that if the parent window could not fit 	  *}
{*				the dialog, the dialog was never placed in any set position   *}
{*				so I changed the SetLocation calls to one call which will	  *}
{*				center the Dialog on the screen, or in the parent window area *}
{*				depending on the size of the parent window.						  *}
{*																								  *}
{*			- Added TCenteredWindow Object.											  *}
{*				Just Specify the Width and Height Of the Window in the Init   *}
{*          constructor and the unit will make the appropriate changes to *}
{*				the window and center it on the screen.  You can start your   *}
{*				own applications in the middle of the SCREEN!					  *}
{*																								  *}
{*			* If anyone makes any updates to this, please forward E-Mail to  *}
{*				to me please. 71477,1066.												  *}
{**************************************************************************}

Interface

USES  WinTypes, WinProcs, Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory;

Type
  PInteger=^Integer;

  PCenteredDialog=^TCenteredDialog;
  TCenteredDialog=object(TDialog)
		Procedure SetupWindow; virtual;
  end;

  PCenteredInputDialog=^TCenteredInputDialog;
  TCenteredInputDialog=object(TInputDialog)
		Procedure SetupWindow; virtual;
  end;

  PCenteredWindow=^TCenteredWindow;
  TCenteredWindow=object(TWindow)
		W, H: Integer;

		Constructor Init(AParent:PWindowsObject; ATitle:PChar; Width, Height:Integer);
		Procedure SetupWindow; virtual;
  end;

Procedure CenterPopup(aPopup,aParent: hWnd);
Procedure WindowPopup(aPopup: hWnd; Width, Height:Integer);

Implementation

Procedure CenterPopup(aPopup,aParent: hWnd);

var
	PopupR,ParentR  : TRect;
	ScreenW,ScreenH : Integer;
	x,y,
	PopupW,PopupH,
	ParentW,ParentH : LongInt;

	procedure SetupValues(Wnd: hWnd; var R: tRect; var W,H : LongInt);
	begin
		GetWindowRect(Wnd,R);
		if (R.Right - R.Left) > ScreenW then W := ScreenW
		else W := R.Right-R.Left;
		if (R.Bottom - R.Top) > ScreenH then H := ScreenH
		else H := R.Bottom-R.Top;
	end; {SetupValues}

	procedure SetLocation;

	begin
		if (PopupW > ParentW) or (PopupH > ParentH) then begin
			x := (ScreenW div 2) - (PopupW div 2);
			y := (ScreenH div 2) - (PopupH div 2);
		end
		else begin
			x := ParentR.Left + (ParentW div 2) - (PopupW div 2);
			y := ParentR.Top + (ParentH div 2) - (PopupH div 2);
		end;
	end;

begin {CenterPopup}
	PopupW  := 0;
	PopupH  := 0;
	ParentW := 0;
	ParentH := 0;

	ScreenW := GetSystemMetrics(sm_CXScreen);
	ScreenH := GetSystemMetrics(sm_CYScreen);
	SetupValues(aPopup,PopupR,PopupW,PopupH);
	SetupValues(aParent,ParentR,ParentW,ParentH);
	SetLocation;
	MoveWindow(aPopup,x,y,PopupW,PopupH,false);
end; {CenterPopup}


Procedure WindowPopup(aPopup: hWnd; Width, Height:Integer);

var
	PopupR 			 : TRect;
	PopupW, PopupH	 : Integer;
	ScreenW,ScreenH : Integer;
	x,y				 : Integer;

begin {WindowPopup}
	{Screen Width and Height are found}
	ScreenW := GetSystemMetrics(sm_CXScreen);
	ScreenH := GetSystemMetrics(sm_CYScreen);

	{Your Window Rectangle Parameters are found}
	GetWindowRect(aPopup,PopupR);

	{Width and Height are set}
	if Width = 0 then PopupW  := PopupR.Right - PopupR.Left
	else PopupW := Width;
	if Height = 0 then PopupH  := PopupR.Bottom - PopupR.Top
	else PopupH := Height;

	{Screen coordinates are set for the window with}
	{ respect to the screen.}
	x := (ScreenW div 2) - (PopupW div 2);
	y := (ScreenH div 2) - (PopupH div 2);

	{Window is moved}
	MoveWindow(aPopup, x, y, PopupW, PopupH, false);
end; {WindowPopup}


procedure TCenteredDialog.SetupWindow;

begin
  TDialog.SetupWindow;
  CenterPopup(HWindow, Parent^.HWindow);
end;

procedure TCenteredInputDialog.SetupWindow;

begin
  TDialog.SetupWindow;
  CenterPopup(HWindow, Parent^.HWindow);
end;


constructor TCenteredWindow.Init(AParent:PWindowsObject; ATitle:PChar;
											Width, Height:Integer);

begin
	TWindow.Init(AParent, ATitle);
	W := Width;
	H := Height;
end;

procedure TCenteredWindow.SetupWindow;

begin
  TWindow.SetupWindow;
  WindowPopup(HWindow, W, H);
end;

end.
