{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$V+}
{$F+}
Unit imwpc;
{by T. Fulton CIS:[100015,565]}
{July 1993}

interface


const iobase=$240;
      datareg=$01;
      addrlo=$02;
      addrhi=$03;
      vram=$04;
      pram=$05;
      ctl_stat=$06;

type regs8031=array[0..47] of byte;
(*
                record
                controls,
                status,
                setup,
                null3,
                null4,
                null5,
                null6,
                null7,
                whitelevel,
                blacklevel,
                overlaylevel,
                videolevel,
                retries,
                nulld,
                versiontrue,
                versioncpl,
                intlinel,
                intlineh,
                intsyncl,
                intsynch,
                intblankl,
                intblankh,
                intequall,
                intequalh,
                intvsyncl,
                intvsynch,
                intactive,
                intequaln,
                intvsyncn,
                intvblankn,
                null1e,
                null1f,
                extdelayl,
                extdelayh,
                extsyncl,
                extsynch,
                extblankl,
                extblankh,
                extequall,
                extequalh,
                extvsyncl,
                extvsynch,
                extactive,
                extequaln,
                extvblankn,
                extcamdlyl,
                extcamdlyh:byte;
              end;
*)

var defaultregs:regs8031;


PROCEDURE SetBit(VAR Target; BitNum : byte);

PROCEDURE ClearBit(VAR Target; BitNum : byte);


procedure GetVram(nsamp,destseg,destofs:word);

procedure GetVramD(nsamp,destseg,destofs:word);
 {starts at destofs + nsamp and decrements destination address}

procedure SetAddress(address:word);

procedure ReadReg(regnum:byte;var result:byte);

procedure WriteReg(regnum,regval:byte);

procedure Clr_videnable;

procedure Clr_continuous;

procedure Clr_grab;

procedure Set_videnable;

procedure Set_grab;

procedure SetReset(rst:byte);

procedure SetPAL;

procedure SetGenLock;

procedure ClrGenlock;

procedure capture(bitspointer:pointer);

implementation

PROCEDURE SetBit(VAR Target; BitNum : byte);

VAR
  Subject : byte ABSOLUTE Target;
  Mask    : byte;

BEGIN
  Mask := 1 SHL BitNum;
  Subject := Subject OR Mask
END;


PROCEDURE ClearBit(VAR Target; BitNum : byte);

VAR
  Subject : byte ABSOLUTE Target;
  Mask    : byte;

BEGIN
  Mask := NOT(1 SHL BitNum);
  Subject := Subject AND Mask
END;

procedure GetVram(nsamp,destseg,destofs:word);external;
{$L Getvram.obj}

procedure GetVramD(nsamp,destseg,destofs:word);external;
{$L GetvramD.obj}


procedure SetAddress(address:word);
begin
  port[iobase+addrlo]:=(address and $00ff);
  port[iobase+addrhi]:=(address shr 8);
  port[iobase+addrlo]:=(address and $00ff);
end;

procedure ReadReg(regnum:byte;var result:byte);

var status1,status2:byte;

begin
  status1:=port[iobase+ctl_stat] and $40; (*bit 6 only *)
  port[iobase]:=regnum;
  repeat
    status2:=port[iobase + ctl_stat]
  until ((status2 and $40) <> status1);
  result:=port[iobase + datareg];
end;

procedure WriteReg(regnum,regval:byte);

var status1,status2:byte;

begin
  port[iobase + datareg]:=regval;
  status1:=port[iobase + ctl_stat] and $40;
  port[iobase]:=regnum + $80;
  repeat
    status2:=port[iobase + ctl_stat]
  until ((status2 and $40) <> status1);
end;

procedure Clr_videnable;

var temp:byte;

begin
  readreg($00,temp);
  clearbit(temp,7);
  writereg($00,temp);
end;

procedure Clr_continuous;
var temp:byte;
begin
  readreg($00,temp);
  clearbit(temp,5);
  writereg($00,temp);
end;

procedure Clr_grab;

var temp:byte;

begin
  readreg($00,temp);
  clearbit(temp,6);
  writereg($00,temp);
end;

procedure Set_videnable;

var temp:byte;

begin
  readreg($00,temp);
  setbit(temp,7);
  writereg($00,temp);
end;

procedure Set_grab;

var temp:byte;

begin
  readreg($00,temp);
  setbit(temp,6);
  writereg($00,temp);
end;

procedure SetReset(rst:byte);

begin
  if rst=1 then
  begin
    port[iobase+ctl_stat]:=$00;
    port[iobase+ctl_stat]:=$80;
    port[iobase+ctl_stat]:=$00;
  end;
  if rst=0 then
  begin
    port[iobase+ctl_stat]:=$40;
    port[iobase+ctl_stat]:=$C0;
    port[iobase+ctl_stat]:=$40;
    port[iobase+ctl_stat]:=$00;
  end;
end;{Setreset}

procedure SetPAL;
var i:integer;

begin
  defaultregs[0]:=$81;
  defaultregs[1]:=$41;
  defaultregs[2]:=2;
  defaultregs[8]:=220;
  defaultregs[9]:=110;
  defaultregs[10]:=100;
  defaultregs[11]:=93;
  defaultregs[12]:=0;
  defaultregs[13]:=0;
  defaultregs[14]:=$10;
  defaultregs[15]:=$F0;
  defaultregs[16]:=$80;
  defaultregs[17]:=$02;
  defaultregs[18]:=$2F;
  defaultregs[19]:=$00;
  defaultregs[20]:=$6E;
  defaultregs[21]:=$00;
  defaultregs[22]:=$17;
  defaultregs[23]:=$00;
  defaultregs[24]:=$11;
  defaultregs[25]:=$01;
  defaultregs[26]:=$FF;
  defaultregs[27]:=$05;
  defaultregs[28]:=$05;
  defaultregs[29]:=$1E;
  defaultregs[30]:=$00;
  defaultregs[31]:=$00;
  defaultregs[32]:=$01;
  defaultregs[33]:=$00;
  defaultregs[34]:=$2F;
  defaultregs[35]:=$00;
  defaultregs[36]:=$6E;
  defaultregs[37]:=$00;
  defaultregs[38]:=$17;
  defaultregs[39]:=$00;
  defaultregs[40]:=$11;
  defaultregs[41]:=$01;
  defaultregs[42]:=$FF;
  defaultregs[43]:=$05;
  defaultregs[44]:=$05;
  defaultregs[45]:=$1E;
  defaultregs[46]:=$6E;
  defaultregs[47]:=$00;
  for i:=0 to 47 do
    writereg(i,defaultregs[i]);
end;

procedure SetGenLock;
var temp:byte;

begin
  readreg($00,temp);
  setbit(temp,0);
  writereg($00,temp);
end;

procedure ClrGenLock;
var temp:byte;

begin
  readreg($00,temp);
  clearbit(temp,0);
  writereg($00,temp);
end;

procedure capture(bitspointer:pointer);
var status2:byte;
    bitmap_seg,bitmap_ofs:word;

begin
  set_grab;
  repeat
    readreg($01,status2);
    status2:=status2 and $40;
  until status2=$40;
  setaddress($0000);
  bitmap_seg:=seg(bitspointer^);
  bitmap_ofs:=ofs(bitspointer^) + 65280;
  while bitmap_ofs > 0 do
  begin
    GetVram(256,bitmap_seg,bitmap_ofs);
    bitmap_ofs:=bitmap_ofs - 256;
  end;
end;{capture}
begin
end.
