unit mathutils;

Interface
function GetExponent(X1 : real) : integer;

implementation
function GetExponent(X1 : real) : integer;
begin
  GetExponent := 0;
  if X1 <> 0.0 then
    if abs(X1) >= 1.0 then
      GetExponent := trunc(Ln(abs(X1)) / Ln(10.0))
    else
      GetExponent := -trunc(abs(Ln(abs(X1))) / Ln(10.0) + 1.0);
end; { GetExponent }
end.