unit ostring;
{author unknown}
interface
uses    Objects,
        OWindows,
        ODialogs,
        OStdDlgs,
        OMemory,wintypes,winprocs,strings;

type
  postring=^tostring;
  tostring=object
    pstring:pchar;
    maxsize:word;
    constructor init(wmaxsize:word);
    destructor done;virtual;
    procedure addpchar(p:pchar);virtual;
    procedure addstring(s:string);virtual;
    procedure addostring(s:tostring);virtual;
    procedure addinteger(i,fieldsize:integer);virtual;
    procedure addreal(r:real;fieldsize,decimals:integer);virtual;
    procedure addhexbyte(b:byte);virtual;
    procedure addhexword(w:word);virtual;
    procedure clear;virtual;
    procedure newline;virtual;
    function len:word;virtual;
    function pchar:pchar;virtual;

 private
    function hex(b:byte):string;
  end;

implementation

function tostring.hex(b:byte):string;
const hexdigit:array[0..15] of char=
      ('0','1','2','3','4','5','6','7','8','9','A','B',
      'C','D','E','F');

begin
 hex:=hexdigit[(b shr 4) and $0f] + hexdigit[b and $0f];
end;

constructor tostring.init(wmaxsize:word);
begin
  getmem(pstring,wmaxsize+1);
  maxsize:=wmaxsize;
  pstring[0]:=#0;
end;

destructor tostring.done;
begin
  freemem(pstring,maxsize+1);
end;

procedure tostring.addpchar(p:pchar);
begin
  strlcat(pstring,p,maxsize);
end;

procedure tostring.addstring(s:string);
var p:tostring;
begin
  p.init(255);
  strPcopy(p.pstring,s);
  strlcat(pstring,p.pstring,maxsize);
  p.done;
end;

procedure tostring.addostring(s:tostring);
var p:tostring;
begin
  strlcat(pstring,s.pstring,maxsize);
end;

procedure tostring.addinteger(i,fieldsize:integer);
var s:string;
begin
  str(i:fieldsize,s);
  addstring(s);
end;

procedure tostring.addreal(r:real;fieldsize,decimals:integer);
var s:string;
begin
  str(r:fieldsize:decimals,s);
  addstring(s);
end;

procedure tostring.addhexbyte(b:byte);
begin
  addstring(hex(b));
end;

procedure tostring.addhexword(w:word);
begin
  addstring(hex(hi(w)));
  addstring(hex(lo(w)));
end;

procedure tostring.clear;
begin
  pstring[0]:=#0;
end;

function tostring.len:word;
begin
  len:=strlen(pstring);
end;

procedure tostring.newline;
begin
  addstring(#13#10);
end;

function tostring.pchar:pchar;
begin
  pchar:=pstring;
end;

end.
