Unit uprint;
{author unknown}
interface

{$R printer.res}
uses wintypes,winprocs,Objects,
        OWindows,ODialogs, OStdDlgs,OMemory,strings;

const abortID='ABORTDIAG';

type Pabort=^TAbort;
     TAbort=object(TDlgWindow)
     procedure WMInitDialog(var Msg:TMessage);
               virtual wm_first + wm_InitDialog;
     procedure WMCommand(var Msg:TMessage);
               virtual wm_first + wm_command;
     end;

function nexttoken(p:pchar;c:char):pchar;
function PrnStart(documentname:pchar):boolean;
procedure NewPage;
procedure PrnLine(p:pchar);
procedure PrnStop;

var
 Pdc:Hdc;
 Aborted:Boolean;


implementation

const
  leftmargin  = 10;
  linesAtTop  =  3;
  LinesAtBottom =3;
  MinimumLines  =LinesAtTop + LinesAtBottom + 1;

var
  printing:boolean;
  EscResult:integer;
  LineHeight:integer;
  CurrentLine:integer;
  LinesperPage:integer;
  AbortDiag:PAbort;
  HAbortDiag:Hwnd;
  PAbortProc:TFarProc;


function NextToken(p:pchar;c:char):Pchar;
const
  next:pchar=nil;

begin
  if p=nil then p:=next;
  next:=strscan(p,c);
  if next <> nil then
  begin
    next^:=#0;
    next:=@next[1];
  end;
  nexttoken:=p;
end;

function AbortProc(Pdc:hdc;code:integer):boolean;export;
var msg:Tmsg;
begin
  while (not aborted) and peekmessage(msg,0,0,0,pm_remove) do
   if (HabortDiag=0) or not IsDialogMessage(HAbortDiag,msg) then
   begin
     TranslateMessage(msg);
     DispatchMessage(msg)
   end;
 abortProc:=not aborted
end;

procedure InitPrintParams;
var tm:TTextMetric;
    pagewidth,pageheight:integer;
begin
    PageWidth:=GetDeviceCaps(Pdc,HorzRes);
    PageHeight:=GetDeviceCaps(Pdc,VertRes);
    LineHeight:=TM.tmHeight + TM.tmHeight div 2;
    if LineHeight <=0 then
      LineHeight:= 10;
    linesPerPage:=PageHeight div LineHeight;
    if LinesPerPage < minimumlines then
      linesPerPage:=minimumlines;
    currentline:=LinesAtTop;
end;

function PrnStart(documentname:pchar):boolean;
var buffer:array[0..80] of char;
    drivername,devicename,outputname:pchar;

begin
  GetProfileString('windows','device','',buffer,sizeof(buffer));
  devicename:=nexttoken(buffer,',');
  drivername:=nexttoken(nil,',');
  outputname:=nexttoken(nil,',');
  aborted:=false;
  Pdc:=CreateDC(drivername,devicename,outputname,nil);
  if Pdc <>0 then
  begin
    AbortDiag:=PAbort(Application^.makewindow(
               New(PAbort,init(Application^.mainwindow,abortid))));
    if AbortDiag=nil then
    begin
      Application^.error(em_outofmemory);
      printing:=false
    end else
    begin
      HAbortDiag:=AbortDiag^.Hwindow;
      PAbortProc:=MakeProcInstance(@AbortProc,HInstance);
      escresult:=Escape(Pdc,setabortproc,0,PAbortProc,nil);
      If escresult >=0 then
        escResult:=Escape(Pdc,startdoc,strlen(documentname),
                      documentname,nil);
    printing:=escResult >0
    end
  end;
  if not printing then
  begin
    if AbortDiag <> nil then
     AbortDiag^.CloseWindow;
    MessageBox(Application^.MainWindow^.Hwindow,
               'Printer initialization failed','error',
               mb_IconExclamation or mb_ok)
  end else
    InitPrintParams;

  prnstart:=printing;
end;

procedure NewPage;
begin
  if printing and (escResult > 0) then
  begin
    escResult:=escape(Pdc,NewFrame,0,nil,nil);
    currentline:=LinesAtTop
  end;
end;

procedure PrnLine(p:pchar);
begin
  inc(currentline);
  TextOut(Pdc,leftmargin,currentline*lineheight,p,strlen(p));
  if currentline >=linesperpage-linesAtBottom then
   newpage
 end;

 procedure PrnStop;
 begin
   if printing then
   begin
     if currentline > LinesAtTop then
       newpage;
     if escResult > 0 then
       escape(Pdc,enddoc,0,nil,nil);
     if AbortDiag <> nil then
       AbortDiag^.closeWindow;
      deleteDC(Pdc);
     printing:=false
   end;
 end;

 procedure TAbort.WMInitDialog(var msg:Tmessage);
 begin
   setfocus(hwindow)
 end;

 procedure TAbort.WMcommand(var msg:Tmessage);
 begin
   aborted:=true
 end;

 end.