#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "vga240.h"
#include "worx.h"

char str[5][255];
char *ding,*chord,*midi,*tada,*chimes;

typedef struct {
        
                                char *sound_x;
                                char *sound_y;
                                char *bit;
                                int x;
                                int y;
                                int in_x;
                                int in_y;
                                int bing;
                                int bop;
                                int active;
                        } Ball;
                                                
Ball B[8];                              

void BallDemo(void)
{
        char *backdrop,*ball;
        char *font,*logo;
        FILE *in;
        int text_y=0,p=0,i,j;
        long frame=0;

        
        
        logo=LoadOneShot("LOGO.MBI");
        /* These sound files can also be loaded into XMS by
           using LoadXMSOneShot */
        chimes=LoadOneShot("CHIMES.WAV");
        tada=LoadOneShot("TADA.WAV");
        chord=LoadOneShot("CHORD.WAV");
        ball=LoadOneShot("BALL.MBI");
        ding=LoadOneShot("DING.WAV");
        font=LoadOneShot("SCI_FI10.MBI");
        backdrop=LoadOneShot("CLOUDS.MBI");
        midi=LoadOneShot("TECHNO4.MID");
                
        B[0].sound_x=chord;
        B[0].sound_y=ding;
        B[0].bit=ball;
        B[0].x=100;
        B[0].y=-30;
        B[0].in_x=-3;
        B[0].in_y=0;
        B[0].bing=0;
        B[0].bop=0;
        B[0].active=1;
        
        B[1].sound_x=tada;
        B[1].sound_y=chimes;
        B[1].bit=ball;
        B[1].x=20;
        B[1].y=-30;
        B[1].in_x=-2;
        B[1].in_y=0;
        B[1].bing=0;
        B[1].bop=0;
        B[1].active=0;
        
        B[2].sound_x=chord;
        B[2].sound_y=ding;
        B[2].bit=ball;
        B[2].x=220;
        B[2].y=-30;
        B[2].in_x=-5;
        B[2].in_y=0;
        B[2].bing=0;
        B[2].bop=0;
        B[2].active=0;
        
        B[3].sound_x=chimes;
        B[3].sound_y=tada;
        B[3].bit=ball;
        B[3].x=10;
        B[3].y=-30;
        B[3].in_x=7;
        B[3].in_y=0;
        B[3].bing=0;
        B[3].bop=0;
        B[3].active=0;

        str[4][0]=0;
        str[3][0]=0;
        str[2][0]=0;
        str[1][0]=0;
        str[0][0]=0;
        LoadIBKFile("MT32.IBK");
        
        PlayMIDBlock(midi);
        in=fopen("WORX.TXT","rt");
        while(!kbhit())
        {
                usepage(p);
                box(0,190,260,239,0);
                putimage(260,0,logo,0);
                /* bump other strings */
                if (text_y==0) 
                {
                        text_y=10;
                        for (i=0;i<4;i++) strcpy(str[i],str[i+1]);
                        if (in!=NULL) 
                        {       if (fgets(str[4],255,in)==NULL) break;
                                /* remove end of line */
                                j=strlen(str[4]);
                                j--;
                                while((str[4][j]==0x0A)||(str[4][j]==0x0D))
                                {
                                        str[4][j]=0;
                                        j--;
                                }
                        }
                }
                /* show text */
                for (i=0;i<5;i++)
                {
                        for (j=0;j<strlen(str[i]);j++) 
                                drawchar(j*8,(i*10)+text_y+190,str[i][j],100,font);
                }
                putimage(0,0,backdrop,0);
                /* show ball */
                frame++;
                for (i=0;i<8;i++)
                {
                        if (frame==20) B[1].active=1;
                        if (frame==60) B[2].active=1;
                        if (frame==120) B[3].active=1;
                                                
                        if (B[i].active)
                        {
                                putimage(B[i].x,B[i].y,B[i].bit,0);
                                if (B[i].bing)
                                {       PlayWAVPoly(B[i].sound_y,i,57);
                                        B[i].bing=0;
                                }
                                if (B[i].bop)
                                {
                                        PlayWAVPoly(B[i].sound_x,i,57);
                                        B[i].bop=0;
                                }
                                B[i].x+=B[i].in_x;
                                B[i].y+=B[i].in_y;
                                if (B[i].y>(185-21)) 
                                {       B[i].in_y=-16;
                                        B[i].bing=1;
                                } else B[i].in_y++;
                                if (B[i].in_y>16) B[i].in_y=16;
                                if (B[i].x<0) 
                                {       B[i].in_x*=-1;
                                        B[i].x=0;
                                        B[i].bop=1;
                                }
                                if (B[i].x>(260-21)) 
                                {       B[i].in_x*=-1;
                                        B[i].x=260-21;
                                        B[i].bop=1;
                                }
                        }
                }                       
                text_y--;
                showpage(p);
                p=!p&1;
        }       
        fclose(in);
}

void main(void)
{
        int irq;
        
        StartWorx();
        irq=DSPReset();
        if (irq==-1)
        {
                printf("Sound Blaster DSP not found.\n");
                printf("You need to have a Sound Blaster installed to\n");
                printf("run this demo.\n");
                CloseWorx();
                exit(0);
        } else
        {
                /* run demo */
                printf("Sound Blaster compatible detected at IRQ %d.\n",irq);
                StartPoly();
                graphinit(0,0);
                LoadPalette("STANDARD.COL");
                
                BallDemo();

                textmode(3);
                DSPClose();
                CloseWorx();
                printf("For more information about Worx/Worx+ please contact Mystic Software\n");
                printf("at (510) 865-9189\n");
                printf("Call our BBS at (510) 865-3856 or fax us at (510) 865-9563\n");
        }
}
