/********************************************* 
 *   WORX Sound Blaster Developers Toolkit   * 
 *   Version 2.1     10/12/93                * 
 *   (c) 1993 by Mystic Software             * 
 *   All rights reserved.                    * 
 *********************************************/

#ifdef __cplusplus
extern "C" {
#endif

void StartWorx(void);
void CloseWorx(void);
int ForceConfig(int Port);
int AdlibDetect(void);

void DSPClose(void);
int DSPReset(void);
int DSPPortSetting(void);
int ResetMPU401(void);

void SelectInput(int mask);
void SetMicLevel(int lvl);
void SetLineLevel(int level); /* 0 .. 15 */
int SetMasterVolume(unsigned char left,unsigned char right);
int SetVOCVolume(unsigned char left,unsigned char right);
int SetFMVolume(unsigned char left,unsigned char right);

int StartResource(char far *f_name);
long OpenElement(char far *f_name);
char far *ElementGets(char far *data,unsigned char maxlen);
unsigned ElementRead(void far *buffer,unsigned int length);

void SetLoopMode(int m);
void GoNote(unsigned char midi_channel,unsigned char note,unsigned char velo);
void StopNote(unsigned char midi_channel,unsigned char note);

char far *GetSequence(char far *f_name);
char far *LoadOneShot(char far *f_name);
int LoadSBIFile(char far *f_name,char pnum);
void ProgramChange(int midi_channel,int program);
int LoadIBKFile(char far *f_name);
char far *LoadPWMBlock(char far *f_name);

int PlayPWMWAV(char far *pwm);
int PlayPWMBlock(char far *pwm);
int PlayVOCBlock(char far *voc);
void PlayCMFBlock(char far *seq);
void PlayMIDBlock(char far *seq);
int PlayVOCFile(char far *f_name);
int PlayWAVBlock(char far *wav);
int PlayWAVFile(char far *f_name);

void ResetRealTime(void);
int SetRealTime(int count);
int TimerDone(void);

void ContinueSequence(void);
void StopSequence(void);
void StopVOC(void);
void StopPWM(void);
void SetPWMRate(int rate);
unsigned GetLastVOCMarker(void);
void SetVOCIndex(unsigned x);

int SequencePlaying(void);
int VOCPlaying(void);
int PWMPlaying(void);
int GetMIDIBeat(void);

void SetAudioMode(unsigned char Mode);
void SetMIDISpeaker(unsigned char Channel);

int WorxPresent(void);
void CloseWorxDriver(void);

int JoyStickY(void);
int JoyStickX(void);
int JoyStickButton(int num);
void JoyStickUpdate(void);

int RecordFlatFile(char far *f_name,int samprate);
int StopFlatRecord(void);
int PlayFlatFile(char far *f_name,int samprate,int compr);
int ProcessFlatFile(void);

void VOCPoll(void);
void VOCHookSetting(int val);

/********************************************* 
 *   WORX+ Polyphonic Sample Player          * 
 *   Version 1.0(K)  08/14/93                * 
 *   (c) 1993 by Mystic Software             * 
 *   All rights reserved.                    * 
 *********************************************/

char far *LoadXMSOneShot(char far *f_name);
int GetXMSBlock(unsigned len);

int StartPoly(void);
void ClosePoly(void);
int PlayWAVPoly(char far *sample,int cell,int note);
int PlayVOCPoly(char far *sample,int cell,int note);
int PolyCellStatus(int cell);
void ReleasePolyChannel(int channel);
void KillPolyChannel(int channel);
void NewPitchPoly(int cell,int note);
void SetSMPVolume(int channel,int volume);

#ifdef __cplusplus
}
#endif

