//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1991,1993 by Borland International
//----------------------------------------------------------------------------
#include "iconbrow.h"


DEFINE_RESPONSE_TABLE1(IconBrowseDlg, GrayDialog)
  EV_LBN_SELCHANGE(IDC_FILES, IdcSelectFile),
  EV_LBN_DBLCLK(IDC_FILES, CmOk),
  EV_CHILD_NOTIFY(IDOK, BN_CLICKED, CmOk),
  EV_LBN_DBLCLK(IDC_DIRECTORIES, IdcSelectDir),
  EV_CBN_CLOSEUP(IDC_DRIVES, IdcSelectDrive),
  EV_CBN_CLOSEUP(IDC_FILTER, IdcSelectFilter),
  EV_SB_LINEUP(IDC_INDEXSPIN, IdcIndexUp),
  EV_SB_LINEDOWN(IDC_INDEXSPIN, IdcIndexDown),
  EV_WM_PAINT,
END_RESPONSE_TABLE;

IconBrowseDlg::IconBrowseDlg(TWindow *parent, IconInfo *icon, char *filter) :
		GrayDialog(parent, "ICON_BROWSER")
{
	Icon = icon;
	Temp.SetIcon(GetModule()->GetInstance(), (char *)Icon->IconPath.c_str(), Icon->IconIndex);

	DirPane = new TListBox(this, IDC_DIRECTORIES, 0);
	EditDir = new TEdit(this, IDC_DIRNAME, 256);
	FilePane = new TComboBox(this, IDC_FILES, 0);
	FilterPane = new TComboBox(this, IDC_FILTER, 0);
	DrivePane = new TComboBox(this, IDC_DRIVES, MAXDIR);
	EditIndex = new TEdit(this, IDC_INDEX, 256);
	IndexSpin = new TScrollBar(this, IDC_INDEXSPIN);

	if( filter )
		strcpy(Filter, filter);
	else
		strcpy(Filter, "*.ico;*.exe;*.dll");	// default file filter
}

void IconBrowseDlg::SetupWindow()
{
	GrayDialog::SetupWindow();

	// Find currently selected icon and change drive/direcory
	char *ptr1, *ptr2, path[256];
	strcpy(path, (char *)Temp.IconPath.c_str());
	if( ptr1 = strstr(path, ":") )
	{
		*ptr1 = 0;
		setdisk(path[0]-'a');
		ptr1++;
	}
	else
		ptr1 = path;
	ptr2 = ptr1 + strlen(ptr1);
	while( (ptr2 > ptr1) && (*ptr2 != '\\') ) ptr2--;
	if( ptr2 != ptr1 )
	{
		*ptr2 = 0;
		chdir(ptr1);
		ptr2++;
	}

	// Fill list box with drives
	DrivePane->DirectoryList(DDL_DRIVES | DDL_EXCLUSIVE, "*.*");
	char dirBuf[MAXDIR+1];
	dirBuf[0] = (char)(getdisk()+'A');
	dirBuf[1] = 0;
	DrivePane->SetSelString(dirBuf, 0);

	if( strcmp(Filter, "*.ico;*.exe;*.dll") )
		FilterPane->AddString(Filter);
	FilterPane->AddString("*.ico;*.exe;*.dll");
	FilterPane->AddString("*.exe");
	FilterPane->AddString("*.dll");
	FilterPane->AddString("*.ico");
	FilterPane->SetSelIndex(0);

	// Update file list & filter
	Update();
	FilePane->SetSelString(ptr2, 0);
	char str[20];
	sprintf(str, "%d", Temp.IconIndex);
	EditIndex->SetText(str);
}

//
// make sure comboboxes are not dropped when the window is re-sized or moved
// if they are, they'll be left floating
//
void IconBrowseDlg::EvPaint()
{
	if (DrivePane)
		DrivePane->HideList();
	GrayDialog::EvPaint();
	DrawIcon();
}

//
// make sure comboboxes are not dropped when the window is re-sized or moved
// if they are, they'll be left floating
//
void IconBrowseDlg::EvSize(UINT sizeType, TSize& size)
{
	if (DrivePane)
		DrivePane->HideList();

	GrayDialog::EvSize(sizeType, size);
}

void IconBrowseDlg::IdcSelectFile()
{
	Temp.IconIndex = 0;
	DrawIcon();
}

void IconBrowseDlg::IdcSelectDrive()
{
	char buf[256];    // Directory names look like [anydir]

	DrivePane->GetSelString(buf, sizeof buf);
	setdisk(buf[2]-'a');   // Directories are shown in list box as [-a-]

	Update();
}

void IconBrowseDlg::IdcSelectDir()
{
	char buf[256];     // Directory names look like [anydir]
	DirPane->GetSelString(buf, sizeof buf);
	char* ptr = buf+1;      // Strip leading [
	buf[strlen(buf)-1] = 0; // Strip trailing ]
	chdir(ptr);

	Update();
}

void IconBrowseDlg::IdcSelectFilter()
{
	FilterPane->GetText(Filter, sizeof(Filter));  // Get text from edit control

	Update();
}

void IconBrowseDlg::IdcIndexUp()
{
	char str[20];
	EditIndex->GetText(str, 20);
	int index = atoi(str)+1;
	IconInfo temp(Temp.Inst, (char *)Temp.IconPath.c_str(), index);
	if( temp.Icon )
		Temp.IconIndex = index;
	DrawIcon();
}

void IconBrowseDlg::IdcIndexDown()
{
	char str[20];
	EditIndex->GetText(str, 20);
	int index = atoi(str);
	if( index > 0 )
		Temp.IconIndex--;
	DrawIcon();
}

void IconBrowseDlg::Update()
{
	// Fill directory pane, add ".." entry if not supplied (happens with network drives)
	getcwd(strdir, sizeof(strdir));
	DirPane->ClearList();
	DirPane->DirectoryList(DDL_DIRECTORY|DDL_EXCLUSIVE, "*.*");
	if( (DirPane->FindString("[..]", 0) < 0) && (strlen(strdir) > 3) )
		DirPane->AddString("[..]"); 

	// Update file list with entries from selected directory
	FilePane->ClearList();
	char str[256], *ptr;
	strcpy(str, Filter);
	if( (ptr = strtok(str, ";")) )
		ptr = str;
	do {
		FilePane->DirectoryList(0, ptr);
	} while( ptr = strtok(NULL, ";") );

	DrawIcon();
}

void IconBrowseDlg::DrawIcon()
{
	char filestr[256];
	FilePane->GetSelString(filestr, sizeof(filestr));
	getcwd(strdir, sizeof(strdir));
	for( char *ptr=strdir; *ptr != 0; ptr++) *ptr = tolower(*ptr);
	EditDir->SetText(strdir);

	char str[20];
	sprintf(str, "%d", Temp.IconIndex);
	EditIndex->SetText(str);

	Temp.IconPath = strdir;
	Temp.IconPath += "\\";
	Temp.IconPath += filestr;

	Temp.SetIcon(Temp.Inst, (char *)Temp.IconPath.c_str(), Temp.IconIndex);

	// Draw Gray rectangle then draw icon
	TWindowDC dc(HWindow);
	dc.FillRect(TRect(358, 165, 358+36, 165+36), TBrush(hBkBrush));
	if( Temp.Icon )
		dc.DrawIcon(358, 165, *Temp.Icon);
}

void IconBrowseDlg::CmOk()
{
	char strfile[256], strindex[20];
	getcwd(strdir, sizeof(strdir));
	Temp.IconPath = strdir;
	FilePane->GetText(strfile, sizeof(strfile));
	Temp.IconPath += "\\";
	Temp.IconPath += strfile;
	EditIndex->GetText(strindex, sizeof(strindex));
	Temp.SetIcon(GetModule()->GetInstance(),
			(char *)Temp.IconPath.c_str(), atoi(strindex));

	// Only close dialog if icon was found
	if( Temp.Icon )
	{
		Icon->SetIcon(Temp.Inst, (char *)Temp.IconPath.c_str(), Temp.IconIndex);
		GrayDialog::CmOk();
	}
	else
	{
		if( strlen(strfile) )
			strcpy(Filter, strfile);
		else
			FilterPane->GetText(Filter, sizeof(Filter));

		Update();
	}
}



