//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1991,1993 by Borland International
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <stdio.h>

#include <owl\listbox.h>
#include <owl\static.h>
#include <owl\combobox.h>
#include <owl\edit.h>
#include <owl\scrollba.h>

#include <dir.h>

#include "graydlg.h"
#include "iconbrow.rh"

class IconInfo
{
public:
	string	IconPath;
	int		IconIndex;
	HINSTANCE Inst;
	TIcon	*Icon;

	IconInfo(HINSTANCE inst=0, char *iconpath=NULL, int iconindex=0)
	{ Icon=0; SetIcon(inst, iconpath, iconindex); };
	virtual ~IconInfo() { SetIcon(NULL); };

	virtual void SetIcon(HINSTANCE inst, char *iconpath, int iconindex=0)
	{
		Inst = inst;
		IconIndex = iconindex;
		SetIcon(NULL);

		if( iconpath )
		{
			IconPath = iconpath;
			HICON hicon;

			if( WORD(hicon = ::ExtractIcon(Inst, IconPath.c_str(), IconIndex)) > 1 )
				SetIcon(new TIcon(hicon, AutoDelete));
			else
				SetIcon(NULL);
		}
	};
	virtual void SetIcon(TIcon *icon)
	{
		if( Icon ) delete Icon;
		Icon = icon;
	};
};


class IconBrowseDlg : public GrayDialog
{
public:
	IconBrowseDlg(TWindow *parent, IconInfo *icon, char *filter=NULL);
	void EvSize(UINT sizeType, TSize& size);
	void EvPaint();
	void SetupWindow();
	void DrawIcon();
	void IdcSelectFile();
	void IdcSelectDir();
	void IdcSelectDrive();
	void IdcSelectFilter();
	void IdcIndexUp();
	void IdcIndexDown();
	void CmOk();

protected:
	TListBox	*DirPane;
	TComboBox	*DrivePane, *FilePane, *FilterPane;
	TEdit		*EditDir, *EditIndex;
	TScrollBar	*IndexSpin;
	char		Filter[256], strdir[256];
	IconInfo	*Icon, Temp;

private:
	void Update();

	DECLARE_RESPONSE_TABLE(IconBrowseDlg);
};


