(****************************************************)
(* Flags & Counters -- What they stand for          *)
(* Flags 0   Display CMD detail as being processed  *)
(*           enter DEBUG to toggle ON and OFF       *)
(* Flags 1   Player has paid woman for food         *)
(* Flags 2   Player has taken vase                  *)
(* Flags 3   Player pets cat                        *)
(* Flags 4   Flag to test answer to question        *)
(* Flags 5   Player has guessed cat's name          *)
(* Flags 6   Player has unlocked portal             *)
(* Flags 7   Player has been to law office          *)
(* Flags 8   Player has found treasure              *)
(* Flags 9   Player has given lily to ghost         *)
(* Flags 10  Player has entered rowboat             *)
(* Flags 11  Player and John have entered Flood     *)
(*           chamber                                *)
(* Flags 12  Ghost has appeared in attic            *)
(* Flags 13  Candle is lit                          *)
(* Flags 14  Lantern is lit                         *)
(* Counter 1 Number of turns player has been on     *)
(*           the train                              *)
(* Counter 2 Number of turns player has been        *)
(*           without light                          *)
(* Counter 3 Number of turns before tiger lily      *)
(*           begins to droop                        *)
(* Counter 4 Number of turns before tiger lily      *)
(*           dies                                   *)
(* Counter 5 Number of turns in rowboat             *)
(****************************************************)

(****************************************************)
(*  First -- Automatic commands executed each turn  *)
(*  Part     regardless of command's VERB etc       *)
(****************************************************)

(****************************************************)
(* Automatic commands to control time player is     *)
(* on the train (Room 2)                            *)
(*  -- Invisible conductor yells after 10 turns     *)
(*  -- Train stops after 15 turns                   *)
(*  -- Player goes on to next stop (quits game)     *)
(*     if not off train after 20 turns              *)
(****************************************************)

COMMAND ANY
AtLocation 2 (* on the train *)
CounterEquals 1 0 (* counter for turns on the train is not on *)
TurnCounterON 1
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterEquals 1 10 (* player has had ten turns *)
PrintMessage 1 (* invisible conductor yells *)
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterEquals 1 11 (* player has had more than 10 turns *)
PrintMessage 2 (* invisible conductor yells stop *)
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterGT 1 11 (* player has had more than 11 turns *)
CounterLT 1 15 (* player has had less than 15 turns *)
PrintMessage 113 (* train has stopped *)
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterEquals 1 15 (* train is preparing to depart *)
PrintMessage 3 (* conductor yells "all aboard" *)
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterGT 1 15 (* train is preparing to depart *)
CounterLT 1 20 (* player has had less than 20 turns *)
PrintMessage 4 (* train is preparing to depart for next stop *)
END_COMMAND

COMMAND ANY
AtLocation 2 (* on the train *)
CounterEquals 1 20 (* player has had 20 turns *)
GoToRoom 5 (* next stop *)
PrintMessage 5 (* player stays on train and goes to next stop *)
TurnCounterOFF 1 (* might as well, the player has ended the game anyway *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

(****************************************************)
(*  Automatic commands to control the life of the   *)
(*  tiger lily                                      *)
(****************************************************)

COMMAND ANY
IsCarrying 309 (* tiger lily *)
CounterEquals 3 200 (* player has had lily for 200 turns *)
PrintMessage 12 (* lily closes *)
END_COMMAND

COMMAND ANY
IsCarrying 309 (* tiger lily *)
CounterGT 3 200 (* player has had lily for more than 200 turns *)
CounterLT 3 275 (* player has had lily for less than 275 turns *)
PrintMessage 13 (* lily droops *)
END_COMMAND

COMMAND ANY
IsCarrying 309 (* tiger lily *)
CounterEquals 3 275 (* player has had lily for 275 turns *)
PrintMessage 14 (* lily is wilted, needs water *)
TurnCounterOFF 3 (* turn on the next counter *)
TurnCounterON 4 (* lily will not survive for more than 25 more turns *)
END_COMMAND

COMMAND ANY
IsCarrying 309 (* tiger lily *)
CounterGT 4 1  (* player has had lily more than 275 turns *)
CounterLT 4 25  (* player has had lily for less than 300 turns *)
PrintMessage 15 (* lily is almost dead *)
END_COMMAND

COMMAND ANY
IsCarrying 309 (* tiger lily *)
CounterEquals 4 25 (* player has had lily for 300 turns *)
Destroy 309 (* drop tiger lily *)
TurnCounterOFF 4 (* lily is dead *)
PrintMessage 16 (* player drops lily and it distintegrates *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

(****************************************************)
(*  Automatic commands to control amount of time    *)
(*  player is in darkness                           *)
(*  -- Player dies if he/she is in total darkness   *)
(*     for 3                                        *)
(****************************************************)

COMMAND ANY
RoomNeedsLight (* will be dark without light *)
NOT LightPresent (* no light in room *)
CounterEquals 2 0 (* darkness counter not currently on *)
PrintMessage 99 (* concerning darkness *)
TurnCounterON 2 (* start counter for darkness *)
END_COMMAND

COMMAND ANY
CounterGT 2 1 (* in total darkness *)
RoomNeedsLight (* will be dark without light *)
NOT LightPresent (* no light in room *)
CounterEquals 2 2
GoToRoom 82 (* Not Too Bright *)
DoneWithTurn (* no further action--get next input *)
END_COMMAND

(****************************************************)
(*  Automatic commands to control the hole in the   *)
(*  rowboat                                         *)
(*  -- Player dies if she is in rowboat fot three   *)
(*     turns                                        *)
(****************************************************)

COMMAND ANY
AtLocation 80 (* Center of Pond *)
CounterEquals 5 0 (* counter for rowboat is not on *) 
TurnCounterON 5 1 (* start counter for small hole *)
PutInCurrentRoom 406 (* small hole *)
PrintMessage 97 (* you look down and see *)
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
AtLocation 80 (* Center of Pond *)
Present 406 (* small hole *)
CounterEquals 5 2
SwapLocations 406 407 (* put gaping hole in boat *)
PrintMessage 97 (* you look down and see *)
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND 

COMMAND ANY
AtLocation 80 (* Center of Pond *)
Present 407 (* gaping hole *)
CounterEquals 5 3
PrintMessage 98 (* you panic *)
GoToRoom 81 (* drowned *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND 

(****************************************************)
(*  Last -- Specific VERB, NOUN & OBJECT commands   *)
(*  Part    executed only when VERB, NOUN, OBJECT   *)
(****************************************************)

COMMAND ANY
Chance 50
AtLocation 32 (* graveyard *)
NOT InRoom 502 (* ghost *)
FlagOFF 9 (* player has not given lily to ghost *)
PutInCurrentRoom 502 (* ghost *)
PrintMessage 90 (* "There is something you must know!" )
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
Chance 50
AtLocation 63 (* small bedroom *)
NOT InRoom 502 (* ghost *)
FlagOFF 9 (* player has not given lily to ghost *)
PutInCurrentRoom 502 (* ghost *)
PrintMessage 90 (* "There is something you must know!" )
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
Chance 75
AtLocation 72 (* attic *)
FlagOFF 12 (* ghost has not been in attic *)
NOT InRoom 502 (* ghost *)
PutInCurrentRoom 502 (* ghost *)
TurnFlagON 12 (* ghost has been in attic *)
PrintMessage 91 (* "Go to him!" )
SendToRoom 502 0 (* destroy Ghost *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
AtLocation 47 (* parlor *)
Present 504 (* cat *)
FlagON 3 (* player has petted cat *)
FlagOFF 5 (* player has not guessed cat's name *)
AskQuestion 1 (* ask it and get answer *)
TurnFlagON 4 (* temporary flag to test correctness of answer *)
AnswerIsCorrect (* tests if answer is correct *)
TurnFlagOFF 4 (* answer is right, so turn flag off *)
TurnFlagON 5 (* player has guessed cat's name *)
TurnFlagOFF 3 (* everything worked, so no need for this flag now *)
PutInCurrentRoom 367 (* hidden door *)
PrintMessage 52 (* cat goes to fireplace *)
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
AtLocation 47 (* parlor *)
Present 504 (* cat *)
FlagON 3 (* player has petted cat *)
AskQuestion 1 (* ask it and get answer *)
TurnFlagON 4 (* temporary flag to test correctness of answer *)
AnswerIsWrong (* tests if answer is correct *)
TurnFlagOFF 4 (* answer is wrong, so turn flag off *)
TurnFlagOFF 3 (* sequence is ended *)
PrintMessage 53 (* try again *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
AtLocation 60 (* balcony *)
NOT Present 311 (* horseshoe *)
PrintMessage 94 (* too close to edge *)
GoToRoom 79 (* dead in front yard *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ANY
AtLocation 38 (* tunnel *)
NOT Present 503 (* John Ryder *)
PrintMessage 109 (* water comes rushing in *)
GoToRoom 84 (* high tide *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BUY TICKET
AtLocation 6 (* Station *)
Present 442 (* ticket *)
NOT FirstVisitToRoom
FlagON 1 (* have paid woman for food *)
PrintMessage 89 (* not enough money *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND BUY TICKET
AtLocation 6 (* Station *)
Present 442 (* ticket *)
FirstVisitToRoom
PrintMessage 112 (* wait until you see if you like the house *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE DOOR
AtLocation 41 (* entry hall *)
InRoom 342 (* open front door *)
PrintMessage 36 (* door is now closed *)
SwapLocations 342 346 (* put closed door in room *)
PutInCurrentRoom 347 (* dead bolt *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE DOOR
AtLocation 34 (* front porch *)
InRoom 345 (* open front door [from outside] *)
IsCarrying 303 (* brass key *)
PrintMessage 41 (* door is now closed and locked *)
SwapLocations 345 337 (* put closed door in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE DOOR
AtLocation 34 (* front door *)
InRoom 345 (* open front door [from outside] *)
PrintMessage 34 (* get key first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE DOOR
AtLocation 47 (* parlor *)
Present 367 (* hidden door *)
FlagON 5 (* player has guessed cat's name *)
PrintMessage 57 (* you close the door *)
SwapLocations 367 360 (* put fireplace in place of hidden door *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE PORTAL
AtLocation 41 (* entry hall *)
InRoom 343 (* portal *)
IsOpen 343
FlagON 6 (* portal has been unlocked *) 
PrintMessage 131 (* player closes portal *)
CloseIt 343
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE TOYBOX
AtLocation 69 (* nursery *)
Present 424 (* toybox *)
PrintMessage 129 (* you close it *)
CloseIt 424
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND CLOSE WINDOW
AtLocation 76 (* servant room *)
Present 435 (* window *)
PrintMessage 126 (* it's drafty in here *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND COOK FISH
AtLocation 66 (* kitchen *)
Present 325 (* fish *)
Present 418 (* kettle *)
PrintMessage 82 (* can't--no fire *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DEBUG
ToggleFlag 0 (* toggle diagnostic mode *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DIG EARTH
AtLocation 17 (* village green *)
NOT Present 369 (* shovel *) 
PrintMessage 17 (* nothing to dig with *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DIG EARTH
AtLocation 17 (* village green *)
Present 369 (* shovel *) 
PrintMessage 60 (* player digs and uncovers gem *)
PutInCurrentRoom 334 (* bag *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DOWN
AtLocation 71 (* cellar stairs *)
NOT Present 311 (* horseshoe *)
PrintMessage 93 (* watch out! *)
GoToRoom 78 (* dead at bottom of cellar stairs *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DOWN
AtLocation 71 (* cellar stairs *)
Present 311 (* horseshoe *)
PrintMessage 93 (* watch out! *)
GoToRoom 74 (* cellar *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DRINK TEA
Present 323 (* tea *)
PrintMessage 119 (* you drink it! *)
Destroy 323
PlusScore 5
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DRINK WINE
Present 413 (* wine *)
Destroy 413
PrintMessage 78 (* you drink it! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP BREAD
Present 324 (* bread *)
NOT DropIt 324 
PrintMessage 125 (* don't litter! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND DROP FISH
Present 325 (* fish *)
NOT DropIt 325
PrintMessage 125 (* don't litter! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ENTER
AtLocation 39 (* Ring of Rocks *)
Present 503 (* John Ryder *)
TurnFlagON 11 (* player and John enter the Flood Chamber *)
PrintMessage 110
GoToRoom 45 (* Flood Chamber *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ENTER ROWBOAT
AtLocation 61 (* pond *)
Present 405 (* rowboat *)
PrintMessage 95 (* get in and drift to center of pond *)
GoToRoom 80 (* center of pond *)
SendToRoom 405 80 (* send rowboat to center of pond, too *)
TurnFlagOn 10 (* player has entered rowboat *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXAMINE COINS
FlagON 1 (* player has paid woman for food *)
Present 304 (* coins *)
PrintMessage 122 (* you have only 4 coins *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXAMINE SHELF
AtLocation 59 (* guest bedroom *)
Present 401 (* shelf in closet *)
PrintMessage 77 (* you find bankbook *)
PutInCurrentRoom 402 (* bankbook *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH CANDLE
Present 329 (* candle *)
FlagOFF 13
PrintMessage 148 (* it is already out *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH CANDLE
Present 439 (* lighted candle *)
FlagON 13
SwapLocations 439 329 (* put unlighted candle in room *)
TurnFlagOFF 13 
PrintMessage 149 (* candle is out *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH LANTERN
Present 370 (* lantern *)
FlagOFF 14
PrintMessage 148 (* already out *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND EXTINGUISH LANTERN
Present 445 (* lantern *)
FlagON 14
SwapLocations 445 370 (* put unlit lantern in room *)
TurnFlagOFF 14
PrintMessage 150 (* lantern is out *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FEED CAT
AtLocation 47 (* parlor *)
Present 504 (* cat *)
Present 325 (* fish *)
FlagON 2 (* player has taken vase *)
PrintMessage 50 (* cat eats and wraps around player's feet *)
SendToRoom 325 0 (* fish is eaten *)
DropIt 365 (* vase *)
PutInCurrentRoom 366 (* key *)
TurnFlagOFF 2 (* vase is gone *) 
LookAtRoom
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FEED CAT
AtLocation 47 (* parlor *)
Present 504 (* cat *)
Present 325 (* fish *)
FlagOFF 2 (* player has not taken vase *)
PrintMessage 55 (* cat eats and curls up to sleep *)
Destroy 325 (* fish is eaten *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FEED CAT
AtLocation 47 (* parlor *)
Present 504 (* cat *)
NOT Present 325 (* fish *)
PrintMessage 54 (* you have nothing to feed cat with *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FEED HORSE
AtLocation 51 (* stalls *)
Present 505 (* horse *)
Present 371 (* oats *)
PrintMessage 58 (* you feed oats to the horse *)
Destroy 371 (* oats *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FEED HORSE
AtLocation 51 (* stalls *)
Present 504 (* horse *)
NOT Present 371 (* oats *)
PrintMessage 62 (* you have no oats *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FIND JOHN
AtLocation 33 (* beach *)
FlagON 7 (* player has been to law office *)
NOT Present 433 (* marriage license *)
PrintMessage 107 (* you forgot the marriage license, he's not here *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND FIND JOHN
AtLocation 33 (* beach *)
FlagON 7 (* player has been to law office *)
Present 433 (* marriage license *)
PutInCurrentRoom 503 (* John Ryder *)
TurnFlagON 10 (* meets John Ryder at beach *)
PrintMessage 108 (* you see John, feel great, he says come with him*)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET BREAD
AtLocation 29 (* cottage kitchen *)
Present 324 (* bread *)
FlagOFF 1 (* player has not paid woman for food *)
PrintMessage 117 (* you should offer to pay for it first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET BREAD
AtLocation 29 (* cottage kitchen *)
IsCarrying 324 (* bread *)
FlagON 1 (* player has paid woman for food *)
PrintMessage 123 (* you already have it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET FISH
AtLocation 29 (* cottage kitchen *)
Present 325 (* fish *)
FlagOFF 1 (* player has not paid woman for food *)
PrintMessage 117 (* you should offer to pay for it first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET FISH
AtLocation 29 (* cottage kitchen *)
IsCarrying 325 (* fish *)
FlagON 1 (* player has paid woman for food *)
PrintMessage 123 (* you already have it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET LOCKET
AtLocation 53 (* tomb *)
Present 375 (* locket *)
PrintMessage 66 (* best to leave it alone *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET STATIONMASTER
AtLocation 6 (* station *)
Present 500 (* stationmaster *)
PrintMessage 115 (* too old and already married *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET TICKET
AtLocation 6 (* Station *)
Present 442 (* ticket *)
PrintMessage 114 (* nothing's for free *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET VASE
AtLocation 47 (* parlor *)
Present 365 (* vase *)
TurnFlagON 2 (* player has vase *)
PrintMessage 48 (* get vase *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GET WOMAN
AtLocation 29 (* cottage kitchen *)
Present 501 (* Portuguese woman *)
PrintMessage 121 (* mother complex *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GIVE GEM TO JOHN
Present 335 (* gem *)
Present 503 (* John Ryder *)
PrintMessage 104 (* not real *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GIVE LILY TO GHOST
Present 309 (* tiger lily *)
Present 502 (* ghost *)
PrintMessage 92 (* anagram *)
Destroy 309 (* tiger lily *)
Destroy 502 (* ghost *)
TurnFlagON 9 (* player has given lily to ghost *)
PlusScore 20
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GIVE LILY TO GHOST
NOT Present 309 (* tiger lily *)
Present 502 (* ghost *)
PrintMessage 127 (* she leaves *)
SendToRoom 502 0 (* ghost *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GIVE ANY TO GHOST
Present 502 (* ghost *)
PrintMessage 137 (* the ghost doesn't want what you offer *)
Destroy 502 (* ghost *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DOOR
AtLocation 2 (* on the train *)
Present 306 (* open door *)
CounterGT 1 1  (* player has had more than 1 turn *)
CounterLT 1 12 (* player has had less than 12 turns *)
PrintMessage 9 (* fall on rails *)
GoToRoom 3 (* certain death *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DOOR
AtLocation 2 (* on the train *)
Present 306 (* open door *)
CounterGT 1 12 (* player has had more than 12 turns *)
CounterLT 1 20 (* player has had less than 20 turns *) 
PrintMessage 8 (* you step out *)
GoToRoom 4 (* station platform *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DOOR
AtLocation 34 (* front porch *)
Present 345 (* open front door *)
PrintMessage 35 (* this leads to room 41 *)
GoToRoom 41 (* entry hall *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DOOR
AtLocation 41 (* entry hall *)
Present 342 (* open front door [from inside] *)
NOT IsLocated 503 34
PrintMessage 40 (* this leads to room 34 *)
GoToRoom 34 (* front porch *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND GO DOOR
AtLocation 41 (* entry hall *)
Present 342 (* open front door [from inside] *)
IsLocated 503 34
PrintMessage 136 (* this leads to room 34 where John Ryder is located*)
GoToRoom 34 (* front porch *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND HIT HORSE
AtLocation 51 (* stalls *)
Present 504 (* horse *)
PrintMessage 61 (* you must really hate animals *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND JUMP IN WATER
AtLocation 80 (* center of pond *)
Present 438 (* water *)
FlagON 10 (* player has entered rowboat *)
PrintMessage 96 (* you do it *)
TurnFlagOFF 10 (* player is no longer in rowboat *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KICK CAT
AtLocation 47 (* parlor *)
Present 504 (* cat *)
PrintMessage 51 (* cat looks hurt and departs *)
Destroy 504 (* cat is gone *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KILL ANY
PrintMessage 63 (* that's not nice *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KISS JOHN
AtLocation 33 (* beach *)
Present 503 (* John Ryder *)
FlagON 8 (* have found treasure *)
PrintMessage 111 (* the kiss *)
GoToRoom 85 (* infinite happiness--win game *)
PlusScore 55
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND KNEEL IN PEW
Present 327 (* pew *)
PrintMessage 30 (* you pray *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT CANDLE
Present 329 (* candle *)
FlagOFF 13
NOT Present 446 (* matches *)
PrintMessage 144 (* can't--no matches *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT CANDLE
Present 329 (* candle *)
FlagOFF 13
Present 446 (* matches *)
SwapLocations 329 439 (* put lighted candle in room *)
TurnFlagON 13 
PrintMessage 145 (* candle is lit *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT CANDLE
Present 439 (* candle *)
FlagON 13
Present 446 (* matches *)
PrintMessage 146 (* candle is already lit *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT KINDLING
Present 419 (* kindling *)
PrintMessage 80 (* can't--no matches *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT LAMP
Present 385 (* lamp *)
PrintMessage 70 (* can't--no oil *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT LANTERN
Present 370 (* lantern *)
FlagOFF 14
NOT Present 446 (* matches *)
PrintMessage 144 (* can't--no matches *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT LANTERN
Present 370 (* lantern *)
FlagOFF 14
Present 446 (* matches *)
SwapLocations 370 445 (* put glowing lantern in room *)
TurnFlagON 14
PrintMessage 147 (* lantern is glowing *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LIGHT LANTERN
Present 445 (* lantern *)
FlagON 14
Present 446 (* matches *)
PrintMessage 146 (* candle is already lit *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LISTEN TO SHELL
Present 336 (* conch shell *)
PrintMessage 32 (* player hears the roar of the sea *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LOCK PORTAL
AtLocation 41 (* entry *)
InRoom 343 (* unlocked portal *)
IsCarrying 431 (* nondescript key *)
FlagON 6 (* portal has been unlocked *)
PrintMessage 132 (* you lock portal *)
LockIt 343
TurnFlagOFF 6
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LOOK AT MIRROR
AtLocation 58 (* master bedroom *)
Present 392 (* mirror *)
PrintMessage 73 (* see reflection *)
PutInCurrentRoom 393 (* reflection *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LOOK THROUGH SPYGLASS
AtLocation 33 (* beach *)
Present 353 (* spyglass *)
PrintMessage 46 (* see the horizon *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND LOOK THROUGH SPYGLASS
AtLocation 75 (* widow's walk *)
Present 353 (* spyglass *)
PrintMessage 87 (* see John Ryder *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN BULKHEAD
AtLocation 42 (* back yard *)
InRoom 349 (* closed locked bulkhead *)
PrintMessage 44 (* it's locked *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN CHEST
AtLocation 52 (* crawlspace *)
InRoom 372 (* closed locked chest *)
PrintMessage 64 (* you do it *)
TurnFlagON 8
PlusScore 30
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 305 (* closed sliding door *)
CounterLT 1 12 (* player has had less than 12 turns *)
PrintMessage 6 (* why open door of moving train? *)
SwapLocations 305 306
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
InRoom 305 (* closed sliding door *)
CounterGT 1 12 (* player has had at least 12 turns *)
CounterLT 1 20 (* player has had less than 20 turns *)
SwapLocations 305 306
PrintMessage 7 (* player opens door *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 20 (* cottage *)
Present 314 (* cottage door *)
PrintMessage 116 (* not polite to open doors without knocking *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 24 (* law office *)
Present 318 (* office door *)
NOT Present 503 (* John Ryder *) 
PrintMessage 18 (* can't do it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 37 (* passageway *)
Present 339 (* door *)
NOT Present 310 (* spike *)
PrintMessage 124 (* you splinter the bar *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 37 (* passageway *)
Present 339 (* door *)
Present 310 (* spike *)
PrintMessage 124 (* you splinter the bar *)
GoToRoom 86 (* cave in *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 24 (* law office *)
Present 318 (* office door *)
Present 503 (* John Ryder *) 
PrintMessage 100 (* John Ryder opens the door *)
GoToRoom 83 (* inside Law Office *)
TurnFlagON 7
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 34 (* front porch *)
InRoom 337 (* closed and locked door *)
PrintMessage 42 (* can't--it's locked *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN DOOR
AtLocation 41 (* entry hall *)
InRoom 346 (* closed unlocked front door *)
PrintMessage 39 (* you open the inside front door *)
SwapLocations 346 342 (* put open inside door in room *)
SendToRoom 347 0 (* get rid of dead bolt *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN PORTAL
AtLocation 41 (* entry hall *)
InRoom 343 (* closed and locked portal *)
NOT FlagON 6 (* portal not unlocked *) 
PrintMessage 85 (* can't--it's locked *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN PORTAL
AtLocation 41 (* entry hall *)
InRoom 343 (* closed portal *)
FlagON 6 (* portal has been unlocked *) 
OpenIt 343 
PrintMessage 86 (* player opens portal *)
PlusScore 10
GoToRoom 77 (* enter shrine *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN LOCKET
AtLocation 53 (* tomb *)
Present 375 (* locket *)
PrintMessage 67 (* see picture and incription *)
OpenIt 375 (* locket *)
PlusScore 20
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN TOYBOX
AtLocation 69 (* nursery *)
Present 424 (* toybox *)
PrintMessage 128 (* you open it and see Hell *)
OpenIt 424
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND OPEN WINDOW
AtLocation 76 (* servant room *)
Present 435 (* window *)
PrintMessage 88 (* look outside *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PAY WOMAN
AtLocation 29 (* cottage kitchen *)
Present 304 (* coins *)
PrintMessage 24 (* you pay woman for food *)
TurnFlagON 1 (* player has now paid woman for food *)
GetIt 325 (* fish *)
GetIt 324 (* bread *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PET CAT
AtLocation 47 (* parlor *)
Present 504 (* cat *)
PrintMessage 49 (* cat purrs, player wonders about name *)
TurnFlagON 3 (* player has petted cat *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PET HORSE
AtLocation 51 (* stalls *)
Present 505 (* horse *)
PrintMessage 59 (* you pet the horse *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PICK LILY
AtLocation 9 (* marshes *)
Present 309 (* tiger lily *)
PrintMessage 11 (* put it in your hair *)
GetIt 309 (* tiger lily *)
TurnCounterON 3 (* start counting turns before lily droops *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PUSH DOOR
AtLocation 47 (* parlor *)
Present 367 (* hidden door *)
FlagON 5 (* player has guessed cat's name *)
PrintMessage 56 (* do it and get to sub-cellar *)
ChangePassageway 10 56 (* open passage Down(10) to Room 56 *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND PUT FISH IN KETTLE
Present 325 (* fish *)
Present 418 (* kettle *)
PrintMessage 81 (* you do it *)
DropIt 325 (* fish *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ DIARY
Present 395 (* closed locked diary *)
PrintMessage 76 (* it's locked *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ MAP
Present 384 (* map *)
IsWearing 383 (* glasses *)
PrintMessage 71 (* you read map *)
PlusScore 5
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ MAP
Present 384 (* map *)
NOT IsWearing 383 (* glasses *)
PrintMessage 72 (* you can't read map *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ POST
Present 338 (* cornerpost *)
PrintMessage 120 (* initials *)
PlusScore 5
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND READ SUNDIAL
Present 320 (* sundial *)
PrintMessage 118 (* the riddle *)
PlusScore 20
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND RIDE HORSE
Present 505 (* horse *)
PrintMessage 138 (* you think better of it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND ROW ROWBOAT
AtLocation 80 (* center of pond *)
Present 405 (* rowboat *)
PrintMessage 133 (* the oars break *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SHOOT ANY
Present 416 (* musket *)
PrintMessage 79 (* no violence *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SIT ON BENCH
AtLocation 26 (* garden *)
Present 319 (* stone bench *)
PrintMessage 19 (* you sit on bench, then get up *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SIT ON CHAIR
AtLocation 47 (* parlor *)
Present 359 (* chair *)
PrintMessage 47 (* you sit on chair, then get up *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SIT ON CHAIR
AtLocation 57 (* library *)
Present 381 (* Queen-Anne chair *)
PrintMessage 68 (* you sit on chair, then get up *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND SOUTH
AtLocation 83 (* inside law office *)
Present 503 (* John Ryder *)
PrintMessage 105 (* you leave, he stays *)
SendToRoom 503 33 (* send John Ryder to beach *)
GoToRoom 24 (* outside Law Office *)
TurnFlagOFF 9 (* John Ryder is no longer with you *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO GHOST
InRoom 502 (* ghost *)
PrintMessage 31 (* player converses with ghost *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
AtLocation 34 (* porch *)
InRoom 503 (* John Ryder *)
PrintMessage 103 (* he asks you to come with him *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
AtLocation 83 (* inside law office *)
InRoom 503 (* John Ryder *)
PrintMessage 106 (* he asks you to bring marriage license *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
AtLocation 33 (* beach *)
InRoom 503 (* John Ryder *)
FlagOFF 11 (* player and John have not entered Flood Chamber *)
PrintMessage 140 (* he suggests exploring *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
AtLocation 33 (* beach *)
InRoom 503 (* John Ryder *)
FlagON 11 (* player and John have entered Flood Chamber *)
PrintMessage 141 (* player thanks and gets urge to kiss him *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
InRoom 503 (* John Ryder *)
FlagOFF 11 (* player and John have not entered Flood Chamber *)
PrintMessage 142 (* it's fun to get to know each other *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO JOHN
InRoom 503 (* John Ryder *)
FlagON 11 (* player and John have entered Flood Chamber *)
PrintMessage 143 (* quiet! *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO STATIONMASTER
AtLocation 6 (* station *)
InRoom 500 (* old Stationmaster *)
FirstVisitToRoom (* player has just gotten off the train *)
PrintMessage 10 (* get directions *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TALK TO WOMAN
AtLocation 29 (* cottage kitchen *)
InRoom 501 (* Portuguese woman *)
FirstVisitToRoom (* player has not been here before *)
PrintMessage 20 (* she talks to you, kind of *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND THANK ANY
PrintMessage 139 (* you're welcome *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TOSS ANY 
AtLocation 69 (* nursery *)
NOUNIsCarrying (* player is carrying the $noun$ *)
IsOpen 424 (* toybox is open *)
DestroyNOUN (* the $noun$ disappears *)
PrintMessage 130 (* you do it *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TWIST BOLT
AtLocation 41 (* entry hall *)
InRoom 346 (* closed front door *)
InRoom 347 (* dead bolt *)
PrintMessage 37 (* closed door is now locked *)
SwapLocations 346 348 (* put closed locked door in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND TWIST BOLT
AtLocation 41 (* entry hall *)
InRoom 348 (* closed locked front door *)
InRoom 347 (* dead bolt *)
PrintMessage 38 (* you unlock door *)
SwapLocations 348 346 (* put unlocked door in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK BULKHEAD
AtLocation 42 (* back yard *)
InRoom 349 (* closed locked bulkhead *)
PrintMessage 45 (* it's locked from inside *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK CHEST
AtLocation 52 (* crawlspace *)
InRoom 372 (* closed locked chest *)
NOT Present 503 (* John Ryder *)
PrintMessage 64 (* only love *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK DIARY
Present 395 (* closed locked diary *)
NOT Present 366 (* tiny key *)
PrintMessage 74 (* you have no key *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK DIARY
Present 395 (* closed locked diary *)
Present 366 (* tiny key *)
PrintMessage 75 (* you unlock diary and it falls open*)
SwapLocations 395 397 (* put unlocked open diary in room *) 
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK DOOR
AtLocation 34 (* front porch *)
InRoom 337 (* closed locked front door *)
NOT IsCarrying 303 (* brass key *)
PrintMessage 43 (* can't--get key first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK DOOR
AtLocation 34 (* front porch *)
InRoom 337 (* closed locked front door *)
IsCarrying 303 (* brass key *)
PrintMessage 33 (* you unlock and open door *)
SwapLocations 337 345 (* put unlocked and open door in room *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK PORTAL
AtLocation 41 (* entry *)
InRoom 343 (* closed locked portal *)
NOT IsCarrying 431 (* nondescript key *)
PrintMessage 83 (* can't--get key first *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UNLOCK PORTAL
AtLocation 41 (* entry *)
InRoom 343 (* closed locked portal *)
IsCarrying 431 (* nondescript key *)
PrintMessage 84 (* you unlock door *)
UnlockIt 343
TurnFlagON 6
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UP
AtLocation 68 (* Attic Stairs *)
FlagON 7 (* player has been to law office *)
PrintMessage 101 (* you do it *)
GoToRoom 72 (* go to Attic *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND UP
AtLocation 68 (* Attic Stairs *)
FlagOFF 7 (* player has not been to law office *)
PrintMessage 102 (* you choose to answer door instead *)
GoToRoom 41 (* Entry *)
SendToRoom 503 34 (* porch *) 
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

COMMAND WEAR GLASSES
AtLocation 57 (* library *)
Present 383 (* glasses *)
PrintMessage 69 (* you put on glasses *)
WearIt 383 (* glasses *)
DoneWithTurn (* no further action -- get next input *)
END_COMMAND

