// ---------------------------------------------------------------------------
// Module:		FU_DRAW.C
//
// Description:	FreeUp's owner-drawn directory listbox drawing functions.
//				This is a modified version of a file called HIERDRAW.C by
//				Kyle Marsh.  I use variations of his owner-draw method
//				throughout this program in the files listbox, toolbar and
//				buttons.
//
// Last modified: 06/27/94
//
// (C) Copyright 1994 Thomas R. Grubbe, All Rights Reserved
// ---------------------------------------------------------------------------


#include <windows.h>
#include <windowsx.h>
#include <malloc.h>
#include <string.h>

#include "fu_draw.h"


void TreeDraw_DrawTerm(LPTREEDRAWSTRUCT lpTreeDrawStruct)
{
   if (lpTreeDrawStruct->hbmIcons) {
	   if (lpTreeDrawStruct->hbmMem)
		   SelectObject(lpTreeDrawStruct->hdcMem,lpTreeDrawStruct->hbmMem);
	   lpTreeDrawStruct->hbmMem = NULL;
	   DeleteObject(lpTreeDrawStruct->hbmIcons);
	   lpTreeDrawStruct->hbmIcons = NULL;
   }

   if ( lpTreeDrawStruct->hdcMem ) {
	  DeleteDC(lpTreeDrawStruct->hdcMem);
	  lpTreeDrawStruct->hdcMem = NULL;
   }
}

void TreeDraw_DrawCloseAll(LPTREEDRAWSTRUCT lpTreeDrawStruct )
{
   lpTreeDrawStruct->NumOpened= 0;
   if ( lpTreeDrawStruct->Opened ) {
	  _ffree(lpTreeDrawStruct->Opened);
   }
   lpTreeDrawStruct->Opened = NULL;
}


/*    PortTool v2.2     4/1/1993    1:2          */
/*      Found   : FAR          */
/*      Issue   : Win32 is non-segmented, thus FAR == NEAR == nothing!          */
#pragma argsused
void TreeDraw_OnMeasureItem(HWND hwnd, MEASUREITEMSTRUCT FAR* lpMeasureItem,
							LPTREEDRAWSTRUCT lpTreeDrawStruct)
{
   lpMeasureItem->itemHeight = max(lpTreeDrawStruct->nBitmapHeight,
								   lpTreeDrawStruct->nTextHeight);
}

void TreeDraw_DrawSetTextHeight (HWND hwndList, HFONT hFont, LPTREEDRAWSTRUCT lpTreeDrawStruct )
{
   TEXTMETRIC      TextMetrics;
   HANDLE          hOldFont=NULL;
   HDC             hdc;

   // This sure looks like a lot of work to find the character height
   hdc = GetDC(hwndList);

   hOldFont = SelectObject(hdc, hFont);
   GetTextMetrics(hdc, &TextMetrics);
   SelectObject(hdc, hOldFont);
   ReleaseDC(hwndList, hdc);

   lpTreeDrawStruct->nTextHeight = TextMetrics.tmHeight;

   lpTreeDrawStruct->nLineHeight =
		 max(lpTreeDrawStruct->nBitmapHeight, lpTreeDrawStruct->nTextHeight);

   if ( hwndList != NULL )
       SendMessage(hwndList, LB_SETITEMHEIGHT, 0,
				   MAKELPARAM(lpTreeDrawStruct->nLineHeight, 0));
}

static DWORD near RGB2BGR(DWORD rgb)
{
    return RGB(GetBValue(rgb),GetGValue(rgb),GetRValue(rgb));
}

/*
 *  Creates the objects used while drawing the tree.  This may be called
 *  repeatedly in the event of a WM_SYSCOLORCHANGED message.
 *
 *  WARNING: the Tree icons bitmap is assumed to be a 16 color DIB!
 */

BOOL TreeDraw_DrawInit(HINSTANCE hInstance,
                       int  nBitmap,
                       int  nRows,
                       int  nColumns,
                       BOOL bLines,
					   LPTREEDRAWSTRUCT lpTreeDrawStruct,
                       BOOL bInit)
{
    HANDLE hRes;
    HANDLE hResMem;
    LPBITMAPINFOHEADER lpbi;

/*    PortTool v2.2     4/1/1993    1:2          */
/*      Found   : FAR          */
/*      Issue   : Win32 is non-segmented, thus FAR == NEAR == nothing!          */
    DWORD FAR * lpColorTable;
    LPSTR lpBits;
    int bc;
    HDC hDC;


    if ( bInit ) {
	   lpTreeDrawStruct->NumOpened = 0;
	   lpTreeDrawStruct->Opened = NULL;
	   lpTreeDrawStruct->bLines = bLines;
    }

    //
    // If the Memory DC is not created yet do that first.
    //
	if (!lpTreeDrawStruct->hdcMem) {
        //
        // get a screen DC
        //
        hDC = GetDC(NULL);
        //
        // Create a memory DC compatible with the screen
        //
		lpTreeDrawStruct->hdcMem = CreateCompatibleDC(hDC);
        //
        // Release the Screen DC
        ReleaseDC(NULL,hDC);

		if (!lpTreeDrawStruct->hdcMem)	{
			MessageBox(NULL, "Error creating compatible memory DC",
						"Error", MB_OK);
			return FALSE;
        }

		lpTreeDrawStruct->hbmMem = NULL;
    }

    //
    // (Re)Load the Bitmap ( original from disk )
    //
    // Use the FindResource,LoadResource,LockResource since it makes
    // it easy to get the pointer to the BITMAPINFOHEADER we need.
    //
    //
    hRes = FindResource(hInstance, MAKEINTRESOURCE(nBitmap), RT_BITMAP);
	if (!hRes)	{
    	MessageBox(NULL, "Error finding resource bitmap", "Error", MB_OK);
		return FALSE;
    }

    hResMem = LoadResource(hInstance, hRes);
	if (!hResMem)	{
    	MessageBox(NULL, "Error loading bitmap resource", "Error", MB_OK);
		return FALSE;
    }

    //
    // Now figure out the bitmaps background color.
    // This code assumes the these are 16 color bitmaps
    // and that the lower left corner is a bit in the background
    // color.
    //
    //
    //
    lpbi = (LPBITMAPINFOHEADER)LockResource(hResMem);
	if (!lpbi)	{
    	MessageBox(NULL, "Error locking bitmap resource", "Error", MB_OK);
		return FALSE;
    }


/*    PortTool v2.2     4/1/1993    1:2          */
/*      Found   : FAR          */
/*      Issue   : Win32 is non-segmented, thus FAR == NEAR == nothing!          */
    lpColorTable = (DWORD FAR *)(lpbi + 1);

    lpBits = (LPSTR)(lpColorTable + 16);            // ASSUMES 16 COLOR

    bc = (lpBits[0] & 0xF0) >> 4;                   // ASSUMES 16 COLOR
                            // ALSO ASSUMES LOWER LEFT CORNER IS BG!!!

    lpColorTable[bc] = RGB2BGR(GetSysColor(COLOR_WINDOW));

    hDC = GetDC(NULL);

	lpTreeDrawStruct->hbmIcons = CreateDIBitmap(hDC,lpbi,(DWORD)CBM_INIT,lpBits,
                                    (LPBITMAPINFO)lpbi,DIB_RGB_COLORS);
    ReleaseDC(NULL,hDC);



/*    PortTool v2.2     4/1/1993    1:2          */
/*      Found   : (WORD)          */
/*      Issue   : Check if incorrect cast of 32-bit value          */
/*      Suggest : Replace 16-bit data types with 32-bit types where possible          */
/*      Help available, search for WORD in WinHelp file API32WH.HLP          */
	lpTreeDrawStruct->nBitmapHeight = (WORD)lpbi->biHeight / nRows;

/*    PortTool v2.2     4/1/1993    1:2          */
/*      Found   : (WORD)          */
/*      Issue   : Check if incorrect cast of 32-bit value          */
/*      Suggest : Replace 16-bit data types with 32-bit types where possible          */
/*      Help available, search for WORD in WinHelp file API32WH.HLP          */
	lpTreeDrawStruct->nBitmapWidth = (WORD)lpbi->biWidth / nColumns;

	lpTreeDrawStruct->nLineHeight =
		 max(lpTreeDrawStruct->nBitmapHeight, lpTreeDrawStruct->nTextHeight);

    UnlockResource(hResMem);
    FreeResource(hResMem);

	if (!lpTreeDrawStruct->hbmIcons)	{
    	MessageBox(NULL, "Error creating icons", "Error", MB_OK);
		return FALSE;
    }

	lpTreeDrawStruct->hbmMem = SelectObject(lpTreeDrawStruct->hdcMem,lpTreeDrawStruct->hbmIcons);
	if (!lpTreeDrawStruct->hbmMem)	{
    	MessageBox(NULL, "Error selecting icon object", "Error", MB_OK);
		return FALSE;
    }

    return TRUE;
}



void TreeDraw_OnDrawItem(HWND  hwnd,

/*    PortTool v2.2     4/1/1993    1:3          */
/*      Found   : FAR          */
/*      Issue   : Win32 is non-segmented, thus FAR == NEAR == nothing!          */
                         const DRAWITEMSTRUCT FAR* lpDrawItem,
                         int   nLevel,
                         DWORD dwConnectLevel,
						 LPSTR szText,
                         int   nRow,
                         int   nColumn,
						 LPTREEDRAWSTRUCT lpTreeDrawStruct,
						 LPSTR szRJust)
{
    HDC			hDC;
    WORD		wIndent, wTopBitmap, wTopText;
	RECT		rcTemp, rcList;
	DWORD		dwExtent;
	char		Text[80];
    int			dummy = 0;


    if ( lpDrawItem->itemID == (UINT)-1 )
       return ;

    hDC = lpDrawItem->hDC;
    CopyRect(&rcTemp, &lpDrawItem->rcItem);

	wIndent = rcTemp.left + ((int)(nLevel) * lpTreeDrawStruct->nBitmapWidth) + XBMPOFFSET;
	rcTemp.left = wIndent + lpTreeDrawStruct->nBitmapWidth;
	wTopText = rcTemp.top; // + ((rcTemp.bottom - rcTemp.top) / 2) - (lpTreeDrawStruct->nTextHeight / 2);
	wTopBitmap = rcTemp.top + ((rcTemp.bottom - rcTemp.top) / 2) - (lpTreeDrawStruct->nBitmapHeight / 2);

    if (lpDrawItem->itemAction == ODA_FOCUS)
        goto DealWithFocus;
    else if (lpDrawItem->itemAction == ODA_SELECT)
        goto DealWithSelection;

    //
    // Draw some lions, if we like lions
    //

	if (lpTreeDrawStruct->bLines && nLevel)
      {
        DWORD    dwMask = 1;
        int      nTempLevel;
		int      x,y;

        // draw lines in text color
		SetBkColor(hDC, GetSysColor(COLOR_WINDOWTEXT));
 
        //
        // Draw a series of | lines for outer levels
        //

		x = lpTreeDrawStruct->nBitmapWidth/2 + XBMPOFFSET;

        for ( nTempLevel = 0; nTempLevel < nLevel ; nTempLevel++)
          {
            if ( dwConnectLevel & dwMask )
                FastRect(hDC,x,rcTemp.top,1,rcTemp.bottom - rcTemp.top);

			x += lpTreeDrawStruct->nBitmapWidth;
            dwMask *= 2;
          }


        //
        // Draw the short vert line up towards the parent
        //
        nTempLevel = nLevel-1;
        dwMask *= 2;

		x = nTempLevel * lpTreeDrawStruct->nBitmapWidth + lpTreeDrawStruct->nBitmapWidth / 2 + XBMPOFFSET;

        if ( dwConnectLevel & dwMask )
            y = rcTemp.bottom;
        else
			y = rcTemp.bottom - lpTreeDrawStruct->nLineHeight / 2;

        FastRect(hDC,x,rcTemp.top,1,y-rcTemp.top);

        //
        // Draw short horiz bar to right
        //
		FastRect(hDC,x,rcTemp.bottom-lpTreeDrawStruct->nLineHeight/2,lpTreeDrawStruct->nBitmapWidth/2,1);
      }

    //
    // Draw the selected bitmap
    //

    BitBlt(hDC,
           wIndent,wTopBitmap,
		   lpTreeDrawStruct->nBitmapWidth,lpTreeDrawStruct->nBitmapHeight,
		   lpTreeDrawStruct->hdcMem,
		   nColumn*lpTreeDrawStruct->nBitmapWidth,
		   nRow*lpTreeDrawStruct->nBitmapHeight,
           SRCCOPY);

DealWithSelection:

    if (lpDrawItem->itemState & ODS_SELECTED)
      {
        SetBkColor(hDC, GetSysColor(COLOR_HIGHLIGHT));
		SetTextColor(hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));
      }
    else
      {
        SetBkColor(hDC, GetSysColor(COLOR_WINDOW));
        SetTextColor(hDC, GetSysColor(COLOR_WINDOWTEXT));
      }

    if (szRJust != NULL)	{
		// right justified text
		wsprintf(Text, "%s ", szRJust);
		dwExtent = GetTextExtent(hDC, Text, lstrlen(Text));
		GetClientRect(hwnd, &rcList);

		ExtTextOut(hDC, rcList.right - LOWORD(dwExtent), wTopText, ETO_CLIPPED|ETO_OPAQUE,
				   &rcTemp,(LPSTR)Text,lstrlen(Text), NULL);
	//	TextOut(hDC, rcList.right - LOWORD(dwExtent), wTopText, (LPSTR)Text, lstrlen(Text));
	}

 	// normal text
	wsprintf(Text, "%s ", szText);
	dwExtent = GetTextExtent(hDC, Text, lstrlen(Text));
    rcTemp.right = rcTemp.left + LOWORD(dwExtent) + 1;

    ExtTextOut(hDC, rcTemp.left + 1, wTopText, ETO_CLIPPED|ETO_OPAQUE,
			   &rcTemp,(LPSTR)Text,lstrlen(Text), NULL);
//	TextOut(hDC, rcTemp.left + 1, wTopText, (LPSTR)Text, lstrlen(Text));

    if (lpDrawItem->itemState & ODS_FOCUS && lpDrawItem->itemAction != ODA_SELECT) {
DealWithFocus:
        DrawFocusRect(hDC, &rcTemp);
    }
}
//
// draw a solid color rectangle quickly
//
static void near FastRect(HDC hDC, int x, int y, int cx, int cy)
{
    RECT rc;

    rc.left = x;
    rc.right = x+cx;
    rc.top = y;
    rc.bottom = y+cy;
    ExtTextOut(hDC,x,y,ETO_OPAQUE,&rc,NULL,0,NULL);
}


BOOL TreeDraw_IsOpened(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData)
{
   // For Now just a dumb  search
   //
   int Count;

   for ( Count = 0; Count < lpTreeDrawStruct->NumOpened; Count++ ) {
	 if ( lpTreeDrawStruct->Opened[Count] == dwData ) {
        return TRUE;
     }
   }

   return FALSE;

}


void TreeDraw_OpenItem(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData)
{
	lpTreeDrawStruct->NumOpened++;

	if (lpTreeDrawStruct->Opened == NULL )
	   lpTreeDrawStruct->Opened =
		(DWORD FAR *)_fmalloc(sizeof(DWORD)*lpTreeDrawStruct->NumOpened);
    else
	   lpTreeDrawStruct->Opened =
		(DWORD FAR *)_frealloc(lpTreeDrawStruct->Opened,
			   sizeof(DWORD)*lpTreeDrawStruct->NumOpened);

	lpTreeDrawStruct->Opened[lpTreeDrawStruct->NumOpened-1] = dwData;
}

void TreeDraw_CloseItem(LPTREEDRAWSTRUCT lpTreeDrawStruct, DWORD dwData)
{
   // For Now just a dumb  search
   //
   int Count;

   for ( Count = 0; Count < lpTreeDrawStruct->NumOpened; Count++ ) {
	 if ( lpTreeDrawStruct->Opened[Count] == dwData ) {
		if (--lpTreeDrawStruct->NumOpened == 0 ) {
			_ffree(lpTreeDrawStruct->Opened);
			lpTreeDrawStruct->Opened = NULL;
        }
        else {
			if ( Count < lpTreeDrawStruct->NumOpened ) {
			   _fmemmove(&(lpTreeDrawStruct->Opened[Count]),
					 &(lpTreeDrawStruct->Opened[Count+1]),
					 sizeof(DWORD)*(lpTreeDrawStruct->NumOpened-Count));
            }
			lpTreeDrawStruct->Opened =

/*    PortTool v2.2     4/1/1993    1:4          */
/*      Found   : FAR          */
/*      Issue   : Win32 is non-segmented, thus FAR == NEAR == nothing!          */
				  (DWORD FAR *)_frealloc(lpTreeDrawStruct->Opened,
					 sizeof(DWORD)*lpTreeDrawStruct->NumOpened);
        }
     }
   }
}


void TreeDraw_ShowKids(LPTREEDRAWSTRUCT lpTreeDrawStruct,
                       HWND hwndList, WORD wCurrentSelection, WORD wKids)
{
   WORD wBottomIndex;
   WORD wTopIndex;
   WORD wNewTopIndex;
   WORD wExpandInView;
   RECT rc;


/*    PortTool v2.2     4/1/1993    1:4          */
/*      Found   : (WORD)          */
/*      Issue   : Check if incorrect cast of 32-bit value          */
/*      Suggest : Replace 16-bit data types with 32-bit types where possible          */
/*      Help available, search for WORD in WinHelp file API32WH.HLP          */
   wTopIndex = (WORD)SendMessage(hwndList, LB_GETTOPINDEX, 0, 0L);
   GetClientRect(hwndList, &rc);
   wBottomIndex = wTopIndex + (rc.bottom+1) / lpTreeDrawStruct->nLineHeight;

   wExpandInView = (wBottomIndex - wCurrentSelection);

   if (wKids >= wExpandInView) {
        wNewTopIndex = min(wCurrentSelection, wTopIndex + wKids - wExpandInView + 1);

/*    PortTool v2.2     4/1/1993    1:4          */
/*      Found   : (WORD)          */
/*      Issue   : Check if incorrect cast of 32-bit value          */
/*      Suggest : Replace 16-bit data types with 32-bit types where possible          */
/*      Help available, search for WORD in WinHelp file API32WH.HLP          */
        SendMessage(hwndList, LB_SETTOPINDEX, (WORD)wNewTopIndex, 0L);
   }

}
