// FU_FONTS.C - ChooseFont common dialog implementation

#include <windowsx.h>
#include <stdio.h>
#include <commdlg.h>
#include <string.h>
#include "freeup.h"
#include "fu_util.h"


UINT CALLBACK _export ChooseFontHook(HWND, UINT, WPARAM, LPARAM);
void GetFont(HWND hWnd);

extern char szFontStyle[LF_FACESIZE];

#pragma argsused
UINT CALLBACK _export ChooseFontHook(HWND hDlg, UINT msg,
						 WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDOK:
					PostMessage(hDlg, WM_COMMAND, IDOK, (LONG)FALSE);
                    break;
				case IDCANCEL:
					PostMessage(hDlg, WM_COMMAND, IDABORT, (LONG)FALSE);
					break;
				case 1136:
				case 1137:
				case 1138:
//					InvalidateRect(GetParent(hDlg), NULL, TRUE);
					break;
			}
			break;
		case WM_INITDIALOG:
			return TRUE;
	}
	return FALSE;
}


void GetFont(HWND hWnd)
{
	CHOOSEFONT cf;   // Data structure for common dialog

   // We first initialize all elements to zero
	memset(&cf, 0, sizeof(CHOOSEFONT));

   // Now, we go through and initialize structure members
	cf.lStructSize		= sizeof(CHOOSEFONT);
	cf.hwndOwner		= hWnd;
	cf.hDC      		= NULL;
	cf.lpLogFont		= &logFont;
	cf.iPointSize 		= 0;
	cf.rgbColors		= NULL; // TxtColor;
	cf.lCustData		= 0L;
	cf.lpfnHook			= MakeProcInstance((FARPROC)ChooseFontHook, ghInstance);
	cf.lpTemplateName	= "Select Font";
	cf.Flags			= CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS |
						  CF_ENABLEHOOK | CF_USESTYLE;
	cf.hInstance		= ghInstance;
	cf.lpszStyle		= (LPSTR)szFontStyle;
	cf.nFontType		= 0;
	cf.nSizeMin  		= 0;
    cf.nSizeMax  		= 0;

	ChooseFont(&cf);

	FreeProcInstance((FARPROC)cf.lpfnHook);
	InvalidateRect(ghwndDirBox, NULL, TRUE);
	InvalidateRect(ghwndFileBox, NULL, TRUE);
}