// ---------------------------------------------------------------------------
// Module:		FU_PROF.C
//
// Description:	Private profile support for FREEUP.INI
//
// Last modified: 06/28/94
//
// (C) Copyright 1994 Thomas R. Grubbe, All Rights Reserved
// ---------------------------------------------------------------------------

#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include "freeup.h"
#include "fu_util.h"

void InitFreeUp(void);
void DeInitFreeUp(void);

void InitFreeUp(void)
{
	char WindowsDir[128];
	char WinDir[128];
	char INIPathName[128];

    LoadWaitCursor();
	getcwd(StartUpDir, 128);
	GetWindowsDirectory((LPSTR)WindowsDir, sizeof(WindowsDir));
	if (WindowsDir[lstrlen(WindowsDir)-1] != '\\')
		wsprintf(WinDir, "%s%c", WindowsDir, '\\');
	wsprintf(INIPathName, "%s%s", WinDir, "FREEUP.INI");

	GetPrivateProfileString("FreeUpDefaults", "StartUpDir", "",
			(LPSTR)StartUpDir, sizeof(StartUpDir), (LPSTR)INIPathName);
	GetPrivateProfileString("FreeUpDefaults", "DefaultEditor", "",
			(LPSTR)DefaultEditor, sizeof(DefaultEditor), (LPSTR)INIPathName);
	GetPrivateProfileString("FreeUpDefaults", "DefaultViewer", "",
			(LPSTR)DefaultViewer, sizeof(DefaultViewer), (LPSTR)INIPathName);
	SortBy    = (int)GetPrivateProfileInt("FreeUpDefaults", "SortBy",
			   							  310, (LPSTR)INIPathName);
	SortOrder = (int)GetPrivateProfileInt("FreeUpDefaults", "SortOrder",
										  -1, (LPSTR)INIPathName);
	Center    = (int)GetPrivateProfileInt("FreeUpDefaults", "CenterBar",
										  -1, (LPSTR)INIPathName);
	DirSizeInfo = (int)GetPrivateProfileInt("FreeUpDefaults", "DirSizeInfo",
										  TRUE, (LPSTR)INIPathName);
	UseCustomPathNames = (int)GetPrivateProfileInt("FreeUpDefaults", "UseCustomPathNames",
										  TRUE, (LPSTR)INIPathName);

	GetPrivateProfileString("Fonts", "FontName", "",
			(LPSTR)logFont.lfFaceName, sizeof(logFont.lfFaceName), (LPSTR)INIPathName);
	GetPrivateProfileString("Fonts", "FontStyleName", "",
			(LPSTR)szFontStyle, sizeof(szFontStyle), (LPSTR)INIPathName);
	logFont.lfWeight = (int)GetPrivateProfileInt("Fonts", "FontStyle",
												 0, (LPSTR)INIPathName);
	logFont.lfItalic = (int)GetPrivateProfileInt("Fonts", "ItalicStyle",
												 0, (LPSTR)INIPathName);
	logFont.lfHeight = (int)GetPrivateProfileInt("Fonts", "FontHeight",
												 0, (LPSTR)INIPathName);
	logFont.lfWidth  = (int)GetPrivateProfileInt("Fonts", "FontWidth",
												 0, (LPSTR)INIPathName);
	LowerCase        = (int)GetPrivateProfileInt("Fonts", "LowerCase",
												 0, (LPSTR)INIPathName);

	WindowRect.left   = (int)GetPrivateProfileInt("StartUp", "WindowLeft",
									DefRect.left, (LPSTR)INIPathName);
	WindowRect.top    = (int)GetPrivateProfileInt("StartUp", "WindowTop",
									DefRect.top, (LPSTR)INIPathName);
	WindowRect.right  = (int)GetPrivateProfileInt("StartUp", "WindowRight",
									DefRect.right, (LPSTR)INIPathName);
	WindowRect.bottom = (int)GetPrivateProfileInt("StartUp", "WindowBottom",
									DefRect.bottom, (LPSTR)INIPathName);
	WindowState       = (int)GetPrivateProfileInt("StartUp", "WindowState",
									SW_SHOW, (LPSTR)INIPathName);
    LoadArrowCursor();
}
void DeInitFreeUp(void)
{
	char WindowsDir[128];
	char WinDir[128];
	char INIPathName[128];
	char num[12];
    BOOL SaveWindowRect = TRUE;
	RECT r;

	if (IsIconic(ghwndMain))	{
		WindowState = SW_SHOW;
		SaveWindowRect = FALSE;
    }
	else if (IsZoomed(ghwndMain))	{
		WindowState = SW_SHOWMAXIMIZED;
		SaveWindowRect = FALSE;
    }
	else
		WindowState = SW_SHOW;

    if (SaveWindowRect)
		GetWindowRect(ghwndMain, &WindowRect);
    LoadWaitCursor();
	GetWindowsDirectory((LPSTR)WindowsDir, sizeof(WindowsDir));
	if (WindowsDir[lstrlen(WindowsDir)-1] != '\\')
		wsprintf(WinDir, "%s%c", WindowsDir, '\\');
	wsprintf(INIPathName, "%s%s", WinDir, "FREEUP.INI");

	WritePrivateProfileString("FreeUpDefaults", "StartUpDir",
							  (LPSTR)StartUpDir, (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "DefaultEditor",
							  (LPSTR)DefaultEditor, (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "DefaultViewer",
							  (LPSTR)DefaultViewer, (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "SortBy",
							  (LPSTR)itoa((int)SortBy, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "SortOrder",
							  (LPSTR)itoa((int)SortOrder, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "CenterBar",
							  (LPSTR)itoa((int)Center, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "DirSizeInfo",
							  (LPSTR)itoa((int)DirSizeInfo, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("FreeUpDefaults", "UseCustomPathNames",
							  (LPSTR)itoa((int)UseCustomPathNames, num, 10), (LPSTR)INIPathName);

	WritePrivateProfileString("Fonts", "FontName",
							  (LPSTR)logFont.lfFaceName,
							  (LPSTR)INIPathName);
	WritePrivateProfileString("Fonts", "FontStyle",
							  (LPSTR)itoa(logFont.lfWeight, num, 10),
							  (LPSTR)INIPathName);
	WritePrivateProfileString("Fonts", "ItalicStyle",
							  (LPSTR)itoa(logFont.lfItalic, num, 10),
							  (LPSTR)INIPathName);
	WritePrivateProfileString("Fonts", "FontHeight",
							  (LPSTR)itoa(logFont.lfHeight, num, 10),
							  (LPSTR)INIPathName);
	WritePrivateProfileString("Fonts", "FontWidth",
							  (LPSTR)itoa(logFont.lfWidth, num, 10),
							  (LPSTR)INIPathName);
	WritePrivateProfileString("Fonts", "LowerCase",
							  (LPSTR)itoa(LowerCase, num, 10),
							  (LPSTR)INIPathName);

	if (SaveWindowRect)	{
		WritePrivateProfileString("StartUp", "WindowLeft",
							  (LPSTR)itoa(WindowRect.left, num, 10),
							  (LPSTR)INIPathName);
		WritePrivateProfileString("StartUp", "WindowTop",
							  (LPSTR)itoa(WindowRect.top, num, 10),
							  (LPSTR)INIPathName);
		WritePrivateProfileString("StartUp", "WindowRight",
				  (LPSTR)itoa(WindowRect.right - WindowRect.left,
				  num, 10), (LPSTR)INIPathName);
		WritePrivateProfileString("StartUp", "WindowBottom",
				  (LPSTR)itoa(WindowRect.bottom - WindowRect.top,
				  num, 10), (LPSTR)INIPathName);
    }
	WritePrivateProfileString("StartUp", "WindowState",
				  (LPSTR)itoa(WindowState, num, 10), (LPSTR)INIPathName);

	LoadArrowCursor();
}