// FU_TYPES.H - File type definitions

#define NUMTYPES		5	// change this when adding more types
#define NUMEXTENSIONS	30

typedef struct tagTypesStruct	{
	char Ext[5];		// file extension
	int  FileType;		// One of the below types
}TypesStruct;

#define DEFAULTTYPE		0
#define EXECUTIBLE		1
#define DOCUMENT		2
#define GRAPHIC			3
#define ARCHIVE			4

TypesStruct Type[] = {
	".exe", EXECUTIBLE,
	".com", EXECUTIBLE,
	".pif", EXECUTIBLE,
	".bat", EXECUTIBLE,
	".txt", DOCUMENT,
	".doc", DOCUMENT,
	".wri", DOCUMENT,
	".ini", DOCUMENT,
	".c",   DOCUMENT,
	".cpp", DOCUMENT,
    ".rc",  DOCUMENT,
	".h",   DOCUMENT,
	".def", DOCUMENT,
	".pas", DOCUMENT,
	".1st", DOCUMENT,
	".now", DOCUMENT,
	".me",  DOCUMENT,
	".asm", DOCUMENT,
	".asc", DOCUMENT,
	".gif", GRAPHIC,
	".jpg", GRAPHIC,
	".bmp", GRAPHIC,
	".pcx", GRAPHIC,
	".mac", GRAPHIC,
    ".pic", GRAPHIC,
    ".ico", GRAPHIC,
	".zip", ARCHIVE,
	".lzh", ARCHIVE,
	".arc", ARCHIVE
};


