// ---------------------------------------------------------------------------
// Module:		FU_ZIP.C
//
// Description:	.ZIP & .LZH file functions and dialog for compressing
//				selected files and/or directories.
//
// Last modified: 06/28/94
//
// (C) Copyright 1994 Thomas R. Grubbe, All Rights Reserved
// ---------------------------------------------------------------------------

#include <windowsx.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <fcntl.h>
#include <ctl3d.h>
#include "freeup.h"
#include "fu_util.h"
#include "fu_file.h"
#include "fu_zip.h"


int ZipFiles(void);
BOOL CALLBACK _export ZipFilesDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL DoZIPCompression(void);
BOOL DoLZHCompression(void);
void BuildCmdLine(char *CmdLine);
void ChangeCompressionMethod(HWND, WORD);
void ReadZipOptions(void);
void WriteZipOptions(void);
void SetZipDlgOptions(HWND hDlg);
void SaveZipDlgOptions(HWND hDlg);


char *ZipOpt[] = {
	"Maximum Compression",
	"Normal Compression",
	"Fast Compression",
	"Super-fast Compression",
	"No Compression"
    };


static char ZipDestPath[128];
static int ZipMethod;
static BOOL StorePaths;
static BOOL RecurseSubDirs;
static BOOL MoveFiles;
static BOOL MakeSelfExtracting;
static BOOL No80386Usage;
static BOOL NoEMSUsage;
static BOOL NoXMSUsage;
static BOOL NoNetwork;
static BOOL No32BitUsage;
static BOOL SlowMemCpy;
static unsigned ZipMethodIndex;

static char CompressedFileName[80]; 


int ZipFiles(void)
{
	FARPROC ZipFilesProc;
	int nRet;
    char CurrPath[128];

    ReadZipOptions();
	ZipFilesProc = MakeProcInstance((FARPROC)ZipFilesDlgProc, ghInstance);
	nRet = DialogBox(ghInstance, "ZipFilesDlg", ghwndMain, (DLGPROC)ZipFilesProc);
	FreeProcInstance(ZipFilesProc);

	if (nRet != IDOK)
		return (nRet);

	FlushMsgLoop();
	WriteZipOptions();

	getcwd(CurrPath, 128);
	LogPath(StartUpDir);

	if (ZipMethod == IDC_USELHARADIO)
		DoLZHCompression();
	else
		DoZIPCompression();

    LogPath(CurrPath);
    return (IDOK);
}

void BuildCmdLine(char *CmdLine)
{
	if (MoveFiles)
		lstrcat(CmdLine, " -mu");
	else
		lstrcat(CmdLine, " -a");

	lstrcat(CmdLine, " -e");

	switch (ZipMethodIndex)
	{
		case 0: lstrcat(CmdLine, "x"); break;
		case 1: lstrcat(CmdLine, "n"); break;
		case 2: lstrcat(CmdLine, "f"); break;
		case 3: lstrcat(CmdLine, "s"); break;
		case 4: lstrcat(CmdLine, "0"); break;
		default:lstrcat(CmdLine, "x"); break;
	}

	if (RecurseSubDirs)
		lstrcat(CmdLine, " -r");
	if (StorePaths)
		lstrcat(CmdLine, " -p");

	lstrcat(CmdLine, " -^");	// Always echo command-line

	if (No80386Usage)
		lstrcat(CmdLine, " -3");
	if (NoEMSUsage)
		lstrcat(CmdLine, " -+");
	if (NoXMSUsage)
		lstrcat(CmdLine, " --");
	if (NoNetwork)
		lstrcat(CmdLine, " -~");
	if (No32BitUsage)
		lstrcat(CmdLine, " -)");
	if (SlowMemCpy)
		lstrcat(CmdLine, " -(");
}
BOOL DoZIPCompression(void)
{
	char CmdLine[256];
	char ZipDir[128];
	char DestDir[128];
	char CurPath[128];
	char FileName[15];
    char TmpFileName[128];
	FILE *fp;
	int i, NumFiles, Idx, FileCount;
	MSG messg;
    BOOL Quit = FALSE;

	NumFiles = GetTaggedFileCount();
	FileCount = GetTotalFilesCount();
	Idx = GetDirIndex();

	if (StartUpDir[lstrlen(StartUpDir)-1] != '\\')
		wsprintf(CmdLine, "%s\\FU_ZIP.PIF", StartUpDir);
	else
		wsprintf(CmdLine, "%sFU_ZIP.PIF", StartUpDir);

	BuildCmdLine(CmdLine);

	if (NumFiles > 0 && !StorePaths && !RecurseSubDirs)	{
		if ((fp = fopen("FREEUP.LST", "w")) == NULL)	{
			FreeUpMsgBox(MB_OK | MB_ICONEXCLAMATION, "File Error",
						 "Could not open temporary file.");
			return (FALSE);
		}


		lstrcpy(CurPath, Tree[Idx].Path);
		strupr(CurPath);

		if (CurPath[lstrlen(CurPath)-1] != '\\')
			lstrcat(CurPath, "\\");

		for (i=0; i<FileCount; i++)	{
			if (SendMessage(ghwndFileBox, LB_GETSEL, (WORD)i, 0L))	{
				lstrcpy(FileName, Files[i].FileName);
                strupr(FileName);
				fprintf(fp, "%s%s\n", CurPath, FileName);
			}
		}
		fclose(fp);
	}

	lstrcpy(ZipDir, ZipDestPath);
	if (ZipDir[lstrlen(ZipDir)-1] != '\\')
		lstrcat(ZipDir, "\\");

    if (NumFiles > 0 && !StorePaths && !RecurseSubDirs)	{
		if (StartUpDir[lstrlen(StartUpDir)-1] != '\\')
			wsprintf(DestDir, " %s%s @%s\\%s", ZipDir, CompressedFileName, StartUpDir, "FREEUP.LST");
		else
			wsprintf(DestDir, " %s%s @%s%s", ZipDir, CompressedFileName, StartUpDir, "FREEUP.LST");
    }

	if (StorePaths || RecurseSubDirs)	{
		Idx = GetDirIndex();
		lstrcpy(CurPath, Tree[Idx].Path);
		strupr(CurPath);

		if (CurPath[lstrlen(CurPath)-1] != '\\')
			lstrcat(CurPath, "\\");
		wsprintf(DestDir, " %s%s %s*.*", ZipDir, CompressedFileName, CurPath);
    }

	lstrcat(CmdLine, DestDir);

//	FreeUpMsgBox(MB_OK, "Testing ZIP Function", CmdLine);
//    FlushMsgLoop();
	WinExec(CmdLine, SW_SHOWNORMAL);

	do	{
		while (PeekMessage(&messg, NULL, 0, 0, PM_REMOVE) && !Quit)	{
			if (messg.message == WM_PAINT || messg.message == WM_CLOSE)
				Quit = TRUE;
			TranslateMessage(&messg);
			DispatchMessage(&messg);
		}
	}while (!Quit);

	if (MoveFiles)	{
		Idx = GetDirIndex();
		GetFiles(Tree[Idx].Path, "*.*");
    }
		
	return (TRUE);
}
BOOL DoLZHCompression(void)
{

	return (TRUE);
}

#pragma argsused
BOOL CALLBACK _export ZipFilesDlgProc(HWND hDlg, UINT msg,
									   WPARAM wParam, LPARAM lParam)
{
	HFONT	hFont;
	LOGFONT	lFont;
	int nRet, i, cbSel;
    static int Idx;

	switch (msg)
	{
		case WM_INITDIALOG:
        	CenterDialog(hDlg);
			hFont = (HFONT)NULL;
			if ((hFont = (HFONT)SendMessage(hDlg, WM_GETFONT, 0, 0L)) != 0)
            {
				if (GetObject(hFont, sizeof(LOGFONT), (LPSTR)&lFont))
                {
					lFont.lfWeight = FW_NORMAL;
					if ((hFont = CreateFontIndirect((LPLOGFONT)&lFont)) != 0)	{
						SendMessage(GetDlgItem(hDlg, IDC_USEPKZIPRADIO), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_USELHARADIO), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_STOREPATHS), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_RECURSE), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_MOVEFILES), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_MAKESELFEXE), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_NO80386), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_NOEMSUSAGE), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_NOXMSUSAGE), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_NONETWORK), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_NO32BIT), WM_SETFONT, (WPARAM)hFont, FALSE);
						SendMessage(GetDlgItem(hDlg, IDC_SLOWMEMCPY), WM_SETFONT, (WPARAM)hFont, FALSE);
                    }
				}
			}
            // Set up ComboBox
			for (i=0; i<5; i++)
				SendMessage(GetDlgItem(hDlg, IDC_ZIPOPTSCOMBO),
							CB_ADDSTRING, 0, (DWORD)(LPSTR)ZipOpt[i]);
			SendMessage(GetDlgItem(hDlg, IDC_ZIPOPTSCOMBO),
            			CB_SETCURSEL, ZipMethodIndex, 0L);

			SetZipDlgOptions(hDlg);
			ChangeCompressionMethod(hDlg, ZipMethod);

			Idx = GetDirIndex();
			return TRUE;
		case WM_COMMAND:
			switch (wParam)
			{
				case IDOK:
					SaveZipDlgOptions(hDlg);
                	DeleteObject(hFont);
                	EndDialog(hDlg, IDOK);
					break;
				case IDCANCEL:
					DeleteObject(hFont);
					EndDialog(hDlg, IDCANCEL);
					break;
				case IDC_STOREPATHS:
				case IDC_RECURSE:
				case IDC_MOVEFILES:
				case IDC_MAKESELFEXE:
				case IDC_NO80386:
				case IDC_NOEMSUSAGE:
				case IDC_NOXMSUSAGE:
				case IDC_NONETWORK:
				case IDC_NO32BIT:
				case IDC_SLOWMEMCPY:
					CheckDlgButton(hDlg, wParam,
						IsDlgButtonChecked(hDlg, wParam) ? 0 : 1);
					return TRUE;
				case IDC_ZIPOPTSCOMBO:
				{
					if (HIWORD(lParam) == CBN_SELCHANGE)	{
						ZipMethodIndex = SendMessage(GetDlgItem(hDlg, IDC_ZIPOPTSCOMBO),
											CB_GETCURSEL, 0, 0L);
                    }
                	return TRUE;
				}
				case IDC_USEPKZIPRADIO:
				case IDC_USELHARADIO:
					ChangeCompressionMethod(hDlg, wParam);
                    ZipMethod = wParam;
					return TRUE;
				case IDC_ZIPDIREDIT:
				{
                    if (HIWORD(lParam) == EN_SETFOCUS)	{
						SendMessage(GetDlgItem(hDlg, wParam), EM_SETSEL, 0, MAKELONG(0, -1));
                        SendMessage(GetDlgItem(hDlg, wParam), EM_SETMODIFY, TRUE, 0L);
                    }
					break;
				}   			
			}
			return TRUE;
		case WM_CTLCOLOR:
		{
			return Ctl3dCtlColorEx(msg, wParam, lParam);
		}
		case WM_PAINT:
			return (BOOL)NULL;
		case WM_CLOSE:
			DeleteObject(hFont);
			EndDialog(hDlg, IDCANCEL);
			return TRUE;
    }
	return FALSE;
}


void ChangeCompressionMethod(HWND hDlg, WORD CtlID)
{
	switch (CtlID)
	{
		case IDC_USEPKZIPRADIO:
			SetWindowText(GetDlgItem(hDlg, IDC_ZIPNAMEPRMPT), "Enter ZIP filename:");
			SetWindowText(GetDlgItem(hDlg, IDC_OPTSGROUPBOX), "ZIP Options:");
			EnableWindow(GetDlgItem(hDlg, IDC_DEBUGOPTSGRP), TRUE);

			EnableWindow(GetDlgItem(hDlg, IDC_NO80386),    TRUE);
			EnableWindow(GetDlgItem(hDlg, IDC_NOEMSUSAGE), TRUE);
			EnableWindow(GetDlgItem(hDlg, IDC_NOXMSUSAGE), TRUE);
			EnableWindow(GetDlgItem(hDlg, IDC_NONETWORK),  TRUE);
			EnableWindow(GetDlgItem(hDlg, IDC_NO32BIT),    TRUE);
			EnableWindow(GetDlgItem(hDlg, IDC_SLOWMEMCPY), TRUE);
			break;
		case IDC_USELHARADIO:
			SetWindowText(GetDlgItem(hDlg, IDC_ZIPNAMEPRMPT), "Enter LZH filename:");
			SetWindowText(GetDlgItem(hDlg, IDC_OPTSGROUPBOX), "LZH Options:");
			EnableWindow(GetDlgItem(hDlg, IDC_DEBUGOPTSGRP), FALSE);

			EnableWindow(GetDlgItem(hDlg, IDC_NO80386),    FALSE);
			EnableWindow(GetDlgItem(hDlg, IDC_NOEMSUSAGE), FALSE);
			EnableWindow(GetDlgItem(hDlg, IDC_NOXMSUSAGE), FALSE);
			EnableWindow(GetDlgItem(hDlg, IDC_NONETWORK),  FALSE);
			EnableWindow(GetDlgItem(hDlg, IDC_NO32BIT),    FALSE);
			EnableWindow(GetDlgItem(hDlg, IDC_SLOWMEMCPY), FALSE);
			break;
	}
}


void SetZipDlgOptions(HWND hDlg)
{
	SetWindowText(GetDlgItem(hDlg, IDC_ZIPDIREDIT), (LPSTR)ZipDestPath);

    if (ZipMethod == IDC_USELHARADIO)
		CheckDlgButton(hDlg, IDC_USELHARADIO, 1);
    else
		CheckDlgButton(hDlg, IDC_USEPKZIPRADIO, 1);
	if (StorePaths)
		CheckDlgButton(hDlg, IDC_STOREPATHS, 1);
	if (RecurseSubDirs)
		CheckDlgButton(hDlg, IDC_RECURSE, 1);
	if (MoveFiles)
		CheckDlgButton(hDlg, IDC_MOVEFILES, 1);
	if (MakeSelfExtracting)
		CheckDlgButton(hDlg, IDC_MAKESELFEXE, 1);
	if (No80386Usage)
		CheckDlgButton(hDlg, IDC_NO80386, 1);
	if (NoEMSUsage)
		CheckDlgButton(hDlg, IDC_NOEMSUSAGE, 1);
	if (NoXMSUsage)
		CheckDlgButton(hDlg, IDC_NOXMSUSAGE, 1);
	if (NoNetwork)
		CheckDlgButton(hDlg, IDC_NONETWORK, 1);
	if (No32BitUsage)
		CheckDlgButton(hDlg, IDC_NO32BIT, 1);
	if (SlowMemCpy)
		CheckDlgButton(hDlg, IDC_SLOWMEMCPY, 1);
}
void SaveZipDlgOptions(HWND hDlg)
{
	GetWindowText(GetDlgItem(hDlg, IDC_ZIPFILEEDIT), (LPSTR)CompressedFileName, sizeof(CompressedFileName));
	GetWindowText(GetDlgItem(hDlg, IDC_ZIPDIREDIT), (LPSTR)ZipDestPath, sizeof(ZipDestPath));
	StorePaths = (IsDlgButtonChecked(hDlg, IDC_STOREPATHS)) ? 1 : 0;
	RecurseSubDirs = (IsDlgButtonChecked(hDlg, IDC_RECURSE)) ? 1 : 0;
	MoveFiles = (IsDlgButtonChecked(hDlg, IDC_MOVEFILES)) ? 1 : 0;
	MakeSelfExtracting = (IsDlgButtonChecked(hDlg, IDC_MAKESELFEXE)) ? 1 : 0;
	No80386Usage = (IsDlgButtonChecked(hDlg, IDC_NO80386)) ? 1 : 0;
	NoEMSUsage = (IsDlgButtonChecked(hDlg, IDC_NOEMSUSAGE)) ? 1 : 0;
	NoXMSUsage = (IsDlgButtonChecked(hDlg, IDC_NOXMSUSAGE)) ? 1 : 0;
	NoNetwork = (IsDlgButtonChecked(hDlg, IDC_NONETWORK)) ? 1 : 0;
	No32BitUsage = (IsDlgButtonChecked(hDlg, IDC_NO32BIT)) ? 1 : 0;
	SlowMemCpy = (IsDlgButtonChecked(hDlg, IDC_SLOWMEMCPY)) ? 1 : 0;
}

void ReadZipOptions(void)
{
	char WindowsDir[128];
	char WinDir[128];
	char INIPathName[128];

	LoadWaitCursor();
//	getcwd(StartUpDir, 128);
	GetWindowsDirectory((LPSTR)WindowsDir, sizeof(WindowsDir));
	if (WindowsDir[lstrlen(WindowsDir)-1] != '\\')
		wsprintf(WinDir, "%s%c", WindowsDir, '\\');
	wsprintf(INIPathName, "%s%s", WinDir, "FREEUP.INI");

	GetPrivateProfileString("ZipOptions", "ZipDestPath", "",
			(LPSTR)ZipDestPath, sizeof(ZipDestPath), (LPSTR)INIPathName);

	ZipMethod = (int)GetPrivateProfileInt("ZipOptions", "ZipMethod",
			   							  2002, (LPSTR)INIPathName);
	StorePaths = (int)GetPrivateProfileInt("ZipOptions", "StorePaths",
										  0, (LPSTR)INIPathName);
	RecurseSubDirs = (int)GetPrivateProfileInt("ZipOptions", "RecurseSubDirs",
										  0, (LPSTR)INIPathName);
	MoveFiles = (int)GetPrivateProfileInt("ZipOptions", "MoveFiles",
										  0, (LPSTR)INIPathName);
	MakeSelfExtracting = (int)GetPrivateProfileInt("ZipOptions", "MakeSelfExtracting",
										  0, (LPSTR)INIPathName);
	No80386Usage = (int)GetPrivateProfileInt("ZipOptions", "No80386Usage",
												 0, (LPSTR)INIPathName);
	NoEMSUsage = (int)GetPrivateProfileInt("ZipOptions", "NoEMSUsage",
												 1, (LPSTR)INIPathName);
	NoXMSUsage = (int)GetPrivateProfileInt("ZipOptions", "NoXMSUsage",
												 0, (LPSTR)INIPathName);
	NoNetwork = (int)GetPrivateProfileInt("ZipOptions", "NoNetwork",
												 1, (LPSTR)INIPathName);
	No32BitUsage = (int)GetPrivateProfileInt("ZipOptions", "No32BitUsage",
												 0, (LPSTR)INIPathName);
	SlowMemCpy = (int)GetPrivateProfileInt("ZipOptions", "SlowMemCpy",
												 0, (LPSTR)INIPathName);
	ZipMethodIndex = (int)GetPrivateProfileInt("ZipOptions", "ZipMethodIndex",
												 0, (LPSTR)INIPathName);
    LoadArrowCursor();
}
void WriteZipOptions(void)
{
	char WindowsDir[128];
	char WinDir[128];
	char INIPathName[128];
	char num[12];

    LoadWaitCursor();
	GetWindowsDirectory((LPSTR)WindowsDir, sizeof(WindowsDir));
	if (WindowsDir[lstrlen(WindowsDir)-1] != '\\')
		wsprintf(WinDir, "%s%c", WindowsDir, '\\');
	wsprintf(INIPathName, "%s%s", WinDir, "FREEUP.INI");

	WritePrivateProfileString("ZipOptions", "ZipDestPath",
							  (LPSTR)ZipDestPath, (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "ZipMethod",
							  (LPSTR)itoa((int)ZipMethod, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "StorePaths",
							  (LPSTR)itoa((int)StorePaths, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "RecurseSubDirs",
							  (LPSTR)itoa((int)RecurseSubDirs, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "MoveFiles",
							  (LPSTR)itoa((int)MoveFiles, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "MakeSelfExtracting",
							  (LPSTR)itoa((int)MakeSelfExtracting, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "No80386Usage",
							  (LPSTR)itoa((int)No80386Usage, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "NoEMSUsage",
							  (LPSTR)itoa((int)NoEMSUsage, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "NoXMSUsage",
							  (LPSTR)itoa(NoXMSUsage, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "NoNetwork",
							  (LPSTR)itoa(NoNetwork, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "No32BitUsage",
							  (LPSTR)itoa(No32BitUsage, num, 10), (LPSTR)INIPathName);
	WritePrivateProfileString("ZipOptions", "SlowMemCpy",
							  (LPSTR)itoa(SlowMemCpy, num, 10), (LPSTR)INIPathName);

	WritePrivateProfileString("ZipOptions", "ZipMethodIndex",
							  (LPSTR)itoa(ZipMethodIndex, num, 10), (LPSTR)INIPathName);

	LoadArrowCursor();
}