// file_dialog()

#include <windows.h>
#include <string.h>
#include <commdlg.h>
#include "filedial.h"

/*-----------------------------------------------------------------------------
This function pops up a file dialog box by calling on COMMDLG.DLL.

    file_dialog(handle, title, specs, specs_size, types, defext, flags);

    HWND handle     handle of owner window
    char *title     title to be put on title bar of dialog box
    char *specs     specs to start with, including drive and directory path;
                      if file name and extension are omitted, specs must end
                      with \
    int specs_size  number of chars the specs buffer can hold
    char *types     types of files to be displayed, see below
    char *defext    default extension to be appended if file has no extension,
                      or "" if none is to be appended
    DWORD flags     flags

The flags word consists of the following bits, OR'ed together as required:

    FD_OPEN             open file (for input)
    FD_SAVE             save files (for output)
    FD_OVERWRITEPROMPT  when used with FD_SAVE, prompt user before returning
                          a file that already exists
    FD_HELP             show help button
    FD_MUSTEXIST        when used with FD_OPEN, require that file exist
    FD_CREATEPROMPT     when used with FD_SAVE, prompt user before returning
                          a file that does not already exist

The types string is a sequence of strings, one for each type of file to
be displayed in the files box. Each string has the format
<description>\0<ambiguous file specs>\0. The strings are run together, and the
last string is followed by two nulls (\0\0). The description does not have to
contain a copy of the ambiguous file specs, although this is a common
practice.

For example if types = "All files (*.*)\0*.*\0" then all files in the selected
directory are displayed in the box. (The compiler supplies the second
terminating \0.)

The return value is TRUE if a file was selected, or FALSE if the user clicked
the Cancel button or closed the dialog box.

The full specifications of the selected file are returned in the specs buffer,
which must be large enough to hold them.

If the function returns FALSE, the contents of the specs buffer are undefined.

-----------------------------------------------------------------------------*/

BOOL file_dialog(HWND handle, char *title, char *specs,
  int specs_size, char *types, char *defext, DWORD flags)
{
  OPENFILENAME f;
  char directory[MAX_DIR+1];
  // directory path -> directory
  // name.ext -> specs
  {
    char *s;
    char *t = specs;
    char *d = directory;
    char *dend = directory;
    int c;
    for (s = specs; (c = *s) != 0; s++)
    {
      if (c == '\\')
      {
        t = specs;
        dend = d;
        if (dend == directory + 2) dend++;
      }
      else if (c == ':')
      {
        t = specs;
        dend = d+1;
      }
      else *t++ = c;
      *d++ = c;
    }
    *t = 0;
    *dend = 0;
  }
  memset(&f, 0, sizeof(f));
  f.lStructSize = sizeof(f);
  f.hwndOwner = handle;
  // f.hInstance = 0;
  f.lpstrFilter = types;
  // f.lpstrCustomFilter = NULL;
  // f.nMaxCustFilter = 0;
  f.nFilterIndex = 1;
  f.lpstrFile = specs;
  f.nMaxFile = specs_size;
  // f.lpstrFileTitle = NULL;
  // f.nMaxFileTitle = 0;
  f.lpstrInitialDir = directory;
  f.lpstrTitle = title;
  f.Flags =  flags & ~FD_SAVE | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
  // f.nFileOffset = 0;
  // f.nFileExtension = 0;
  f.lpstrDefExt = defext;
  // f.lCustData = 0;
  // f.lpfnHook = NULL;
  // f.lpTemplateName = NULL;
  BOOL fd = flags & FD_SAVE ? GetSaveFileName(&f): GetOpenFileName(&f);
  InvalidateRect(handle, NULL, TRUE);
  return fd;
}

