/********************************************************************
 *                  EDI Install Pro for Windows                     *
 *                      Demo custom library                         *
 ********************************************************************
 *       Copyright 1994 Robert Salesas, All Rights Reserved         *
 ********************************************************************
 *      Version: 2.80             Author:  Robert Salesas           *
 *      Date:    13-Apr-1992                       *
 ********************************************************************/

#include <windows.h>


/* Procedure call codes */

#define  ICM_STARTINSTALL  0       /* Called when install is started.
#define  ICM_SETUP        10       /* Called before first dialog box.               */
#define  ICM_SETUP2       20       /* Called after first dialog box.                */
#define  ICM_COMPONENTS   30       /* Called before components dialog box.          */
#define  ICM_COMPONENTS2  40       /* Called after components dialog box.           */
#define  ICM_STARTCOPY    50       /* Called before files start getting copied.     */
#define  ICM_FILECOPY     60       /* Called for each file that needs to get copied.*/
#define  ICM_ENDCOPY      70       /* Called once all files have been copied.       */
#define  ICM_PMGROUP      80       /* Called before the PM group dialog box.        */
#define  ICM_PMGROUP2     90       /* Called after the PM group dialog box.         */
#define  ICM_EXTRASTUFF  100       /* Called once the installation is completed.    */
#define  ICM_ENDDLGGOOD  110       /* Called before the last dialog box.            */
#define  ICM_ENDDLGBAD   120       /* Called before the last dialog box.            */
#define  ICM_ENDINSTALL  130       /* Called before program terminates.             */


#define  IR_CONTINUE       0       /* Continue with normal execution.               */
#define  IR_SKIPSECTION    1       /* Skip this section.                            */
#define  IR_CUSTOMINSTALL  2       /* Valid only for icm_Setup and icm_Setup2.      */
#define  IR_ABORTINSTALL  -1       /* Abort the installation with proper messages.  */



/*

  Declaration:
  ~~~~~~~~~~~~

  int FAR PASCAL InstallDLLProc(HWND Window, int Code,
                                char *Src, char *Dest,
                                LONG *Components)

  *** note, you must export this function in your .DEF file as index 100. ***


  Description:
  ~~~~~~~~~~~~

  Allows custom modification of the installation.  You may use or change the values
  passed to your function.  By creating routines to handle special parts of your
  installation (such as extra setup information or copying specially encoded files),
  you can completely customize EDI Install Pro without having to write your own
  installer.  There's very little (if anything) that can't be handled through a
  custom DLL.  Since the DLL can be written in almost any language, you don't have
  to learn to program in some strange "installer" language.

  To add a DLL to an installation script simply add the following under the [APPLICATION]
  section, if it's not compressed:

      [APPLICATION]
      Install DLL=INSTLIB.DLL N

  and if it is:

      [APPLICATION]
      Install DLL=INSTLIB.DL$ Y


  Parameters:
  ~~~~~~~~~~~

  Window  The Window handle of the main installer window.  This will be either a bitmap,
          a dithered display, or an invisible top level window.  Use this as the parent
          of all your custom dialogs..


  Code    Specifies when the procedure is getting called.  Each code allows you to
          perform certain actions.  Note that you don't have to handle every code, only
          the ones you want.  Simply return ir_Continue for any code you don't want to
          handle.


                ICM_SETUP     	Src and Dest contain the default values for the
                        	      directories. Components are all turned on.

                        	      You may modify the default values of Src and Dest.
                        	      Override (return ir_SkipSection) this section if you want
                        	      to include your own "Get destination" dialog box.


                ICM_SETUP2    	Dest contains the value entered by the user.  Src and
                        	      Components are unchanged.

                        	      You may modify the value of Dest that the user entered.
                        	      If you require extra setup information from the user, this
                        	      is the place to get it.  Pop up whatever dialogs you need.
                       	        You can store the information in the DLL, since it will
                                always be accessed by only one instance.


                ICM_COMPONENTS  Src, Dest and Components are unchanged.

                        	      Override this section if you want to include your own
                        	      "Select Components" dialog box, or if you want to "force"
                        	      component selection.  For example you might want to use a
                        	      simple dialog box with radio buttons instead of the listbox.


                ICM_COMPONENTS2 Components contains the value selected by the user.
                       		      Src and Dest are unchanged.

                        	      You may modify the value of Components that the user
                        	      entered.  If you require extra component or setup
                        	      information from the user, this is the place to get it.
                        	      Pop up whatever dialogs you need.  You can store the
                        	      information in the DLL, since it will always be
                        	      accessed by only one instance.


                ICM_STARTCOPY   Src, Dest and Components are unchanged.

                        	      This call is made before any files get copied.  Use this
                        	      call for any setup procedure you need if you use
                        	      icm_FileCopy.  For example, if you wanted to display
                        	      small messages on a separate as files get copied, you
                        	      would open the window in this call.


                ICM_FILECOPY    Src and Dest contain the SOURCE FILE PATH and the
                        	      DESTINATION FILE PATH.  This differs from all the other
                        	      calls.  Note the file name of Src and Dest might not
                        	      be the same.  For example, a compressed file could be
                        	      named FILE.EX$ as the source, and FILE.EXE as the
                        	      destination.  Components are unchanged.

                        	      This call is made every time a file is about to be
                        	      copied.  Override this section if you want to display
                        	      messages in a window created by icm_startCopy or if you
                        	      want to use your own copying code.  For example, if you
                        	      encode your main .EXE, but not the rest of the files,
                        	      you can check to see if the current file is encoded, and
                        	      if it is, you decode it (and copy) and return
                        	      ir_SkipSection, and if it isn't encoded you ignore it and
                        	      return ir_Continue.  You can even do this:  decode the
                        	      source file to a temporary file (in Windows temp directory),
                        	      change Src to reflect this new source file, and return
                        	      ir_Continue.  EDI Install will then copy (decompressing if
                        	      needed) the file!  So you can have encoding without losing
                        	      the built-in compression!  This is also a good place to
                        	      add special version checking code if the default mechanisms
                        	      are not sufficient.  If you return ir_AbortInstall, you
                        	      should also display an error dialog box.


                ICM_ENDCOPY     Src, Dest and Components are unchanged.

                       		      This call is made after any files get copied.  Use this
                        	      call to clean up the setup procedure you accessed in
                        	      icm_StartCopy.


                ICM_PMGROUP     Src contains the default name for the Program Manager
                                group.  Dest and Components are unchanged.

                        	      This call is made before the PM Group dialog box is
                        	      displayed.  You may override it with your own dialog box
                        	      if you don't like the default dialog box.


                ICM_EXTRASTUFF  Src, Dest and Components are unchanged.

                                This call is made once the installation has successfully
                                been completed, but before the user has been informed.  You
                                may use it if you need to take care of extra stuff such as
                                modifying the CONFIG.SYS or AUTOEXEC.BAT files.


                ICM_ENDDLGGOOD  Src, Dest and Components are unchanged.
                ICM_ENDDLGBAD
                        	      These are called before the last dialog box ("Installation
                        	      complete/incomplete") is displayed.  You can override it
                        	      if you prefer to display your own dialog box or if you
                        	      need special "clean up" procedures depending on success
                        	      (icm_EndDlgGood) or failure (icm_EndDlgBad).  If you handle
                        	      the dialog, return ir_SkipSection.  If not, return
                        	      ir_Continue.  Note that these calls will NOT be made if
                        	      the installation was aborted BEFORE the file copy process
                        	      was started (prior to the first icm_FileCopy call).


                ICM_ENDINSTALL  Src, Dest and Components are unchanged.

                        	      This call is made before the installer quits.  You
                        	      can do your general cleanup here since it will always get
                        	      called, regardless of the success/failure/cancelled
                        	      situation.  Return values are ignored.


  Src    		    Points to a 256 byte buffer (including NULL terminater) containing the
          			source path or the source file, depending on the value of Code.  It contains
          			the source file if Code is equal to icm_FileCopy, and the source path for
          			everything else.  You may modify this value any time you like.  It could
          			potentially be changed every time EDI Install needs a new disk, since the
          			user is asked for an alternate path.


  Dest    			Points to a 256 byte buffer (including null terminater) containing the
          			destination path or the destination file, depending on the value of Code.
          			It contains the destination file if Code is equal to icm_FileCopy, and the
          			destination path for everything else.  You may modify this value any time you
                like, although that's not a very good idea.


  Components    Points to a 32-Bit value (a longint or double word) representing 32 separate
                values.  Technically it's a bitpacked array of 32, bit sized elements.  So each
                bit represents a component (up to a maximum of 32 components).  If the bit is
                on, the component is selected, if it's off, it is unselected.  For example,
                to determine if a particalur component is selected or not, in Turbo Pascal you
                would do:

                    If (MyComp In Components) Then

                Where "MyComp" is the component you want to check for.  You may modify
                this value any time you like.

                The first bit represents the zero component.  This component is always
                installed.


  Returns
  ~~~~~~~

  Possible return values are:

          IR_CONTINUE         Continues with the the installation.

          IR_SKIPSECTION      Skips the applicable section (icm_Setup, icm_Components,
                              icm_PMGroup, icm_EndDlgGood, icm_EndDlgBad).

          IR_ABORTINSTALL     Aborts the installation and displays a message box.



  Notes
  ~~~~~

  If you need to use new dialogs, add them to the DLL, not the installer.  If you add them to
  the installer you are likely to cause problems during multiple disk installations.  Also,
  you should attempt to maintain the same "look and feel" through the dialogs, and use the
  icons located in INSTALL.EXE whenever possible.  There aren't any restrictions on what you
  can and cannot do in the DLL provided you follow standard DLL rules.  You don't need to lock
  or fix the DLL since the installer will copy it to a temporary file on the hard disk.  It
  will be deleted once the installation is complete.

  If there's something you want to do but you can seem to be able to with the current codes,
  let us know and we'll see what we can do about.  If you aren't too sure about what you need
  to do or you don't want to write the DLL yourself, we can create a custom DLL for a reasonable
  fee.
*/


/* The following is a skeleton procedure.  Fill it in to handle your needs. */


int FAR PASCAL InstallDLLProc(HWND Window, int Code,
                              LPSTR Src, LPSTR Dest,
                              LONG FAR *Components)
{
  int rValue = IR_CONTINUE;

  switch(Code) {

    case ICM_STARTINSTALL:
      OutputDebugString("StartInstall\n");
      break;
    case ICM_SETUP:
      OutputDebugString("Setup\n");
      break;
    case ICM_SETUP2:
      OutputDebugString("Setup2\n");
      break;
    case ICM_COMPONENTS:
      OutputDebugString("Components\n");
      break;
    case ICM_COMPONENTS2:
      OutputDebugString("Components2\n");
      break;
    case ICM_STARTCOPY:
      OutputDebugString("StartCopy\n");
      break;
    case ICM_FILECOPY:
      OutputDebugString(Src);
      OutputDebugString("\n");
      break;
    case ICM_ENDCOPY:
      OutputDebugString("EndCopy\n");
      break;
    case ICM_PMGROUP:
      OutputDebugString(Src);
      OutputDebugString("\n");
      break;
    case ICM_PMGROUP2:
      OutputDebugString(Src);
      OutputDebugString("\n");
      break;
    case ICM_EXTRASTUFF:
      OutputDebugString("ExtraStuff\n");
      break;
    case ICM_ENDDLGGOOD:
      OutputDebugString("EndDlgGood\n");
      break;
    case ICM_ENDDLGBAD:
      OutputDebugString("EndDlgBad\n");
      break;
    case ICM_ENDINSTALL:
      OutputDebugString("EndInstall\n");
      break;
  }
  return rValue;
}


int FAR PASCAL _export LibMain(HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
  if(wHeapSize > 0) UnlockData(0);
    return 1;
}
