/* DISKREAD.C
   A simple disk throughput tester.
   Written by James Day, 12 September 1994.
   Comments to CIS ID 100276,3552 or Internet: 100276.3552@compuserve.com
   
   I know this is a benchmark, so please don't tell me how hoplessly inaccurate
   it is as a measure of real-world performance.
   
   If you feel a need to quote a performance number for some piece of
   equipment you should quote these things as a minimum:
   
       1) The number of repetitions (the first command-line parameter).
       2) The size of each read (the third parameter).
       3) The first of the performance numbers given in kBytes per second.
       4) The sizes of any disk caches in use.

	If you are able you should run the test first with a file on the outer
	cylinders of the hard disk and then with one on the inner cylinders. If the
	results are the same you've probably got a bus or controller limit
	affecting your results.

   Feel free to pick the best compiler and options you can find. Just don't
   change the source code unless you find that I've used something that
   your compiler can't handle. This is, I hope, ANSI C compliant as well as
   memory model and integer size independent. Let me know if I'm wrong.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <malloc.h>
#include <time.h>

#define MAX_BLOCK_SIZE 16384
static char IOBuffer[MAX_BLOCK_SIZE];
static char VBuffer[MAX_BLOCK_SIZE];
   
static void RunTest(FILE *fi, int Repeats, long ReadSize, size_t BlockSize, char *FileName )
	{
	register int Loop;
	long KBytesRead, TotalKBytesRead;
   time_t start, end;
	long mSecs;
	
   start = clock();
   TotalKBytesRead = 0L;
   for ( Loop = Repeats; Loop > 0; Loop-- )
   	{
   	if ( 0 != fseek(fi, 0L, SEEK_SET) )
   		{
   		printf("Unable to move to start of file.\n");
   		exit(1);
   		}
   	KBytesRead = 0L;
      while ( KBytesRead < ReadSize )
      	{
   		if ( 1 != fread(IOBuffer, BlockSize, 1, fi) )
			   {
			   printf("Error %d reading from file '%s'\n", errno, FileName);
			   exit(1);
			   }
		   KBytesRead += BlockSize/1024;
		   }
		TotalKBytesRead += KBytesRead;
		}
   end = clock();
	mSecs = (end - start) * 1000L / CLOCKS_PER_SEC;
	if ( mSecs < 1000 )
		printf("You gave a sample that is too small for meaningful results.\n");
	else
		{
		long Secs, dSecs, Rate;
		Secs = mSecs/1000L;
		dSecs = mSecs - Secs*1000L;
   	Rate = TotalKBytesRead * 1000L / mSecs;
	   printf("In %1d.", Secs);
	   printf("%lds read %ld kbytes in %ld byte chunks at %ld k/sec\n",
   	         dSecs, TotalKBytesRead, (long)BlockSize, Rate );
/* This version doesn't work correctly with Microsoft Visual C 1.0. Why ?
	   printf("In %1d.%lds read %ld kbytes at %ld k/sec\n",
   	         Secs, dSecs, TotalKBytesRead, Rate );
*/
   	}
   }

void main(int argc, char *argv[])
{
	FILE	*fi;
	register int	Repeats;
	long ReadSize, KBytesRead;
   time_t start, end;

	if ( argc != 4 )
		{
		printf("usage: diskread repeats filename readsize\n\n"
		       "Readsize is the portion of the file to read in megabytes.\n"
		       "You must pick a file that is bigger than readsize.\n");
		exit(0);
		}
		
	Repeats = atoi(argv[1]);
	if ( 0 >= Repeats )
 		{
		printf("A repeatsize of %d is too small. It must be positive.\n", Repeats);
		exit(1);
		}
		
	ReadSize = atol(argv[3]);
	if ( 0 >= ReadSize || 1000L < ReadSize )
		{
		printf("Readsize of %ld isn't allowed. Must be from 1 to 1,000 in megabytes\n",
				ReadSize);
		exit(1);
		}
	ReadSize = ReadSize * 1024L;

	if ( (fi=fopen(argv[2], "rb")) == NULL )
		{
		printf("diskread: unable to open %s\n", argv[2]);
		exit(1);
		}

   printf("Reading once to fill caches...\n");
   start = clock();
   KBytesRead = 0L;
   while ( KBytesRead < ReadSize )
   	{
		if ( 1 != fread(&IOBuffer, MAX_BLOCK_SIZE, 1, fi) )
			{
			printf("Error %d reading from file '%s'\n", errno, argv[2]);
			exit(1);
			}
		KBytesRead += MAX_BLOCK_SIZE/1024;
		}
   end = clock();
   printf("Starting real test. Estimated maximum duration %ds...\n",
          4 * (Repeats * (end - start)) / CLOCKS_PER_SEC);
          
	printf("No C buffering present...\n");
   setvbuf(fi, NULL, _IONBF, 0);
	RunTest(fi, Repeats, ReadSize, MAX_BLOCK_SIZE, argv[2] );   
	RunTest(fi, Repeats, ReadSize, 1024, argv[2] );   

	printf("With a %ld byte C buffer in use...\n", (long)MAX_BLOCK_SIZE);
   setvbuf(fi, VBuffer, _IOFBF, MAX_BLOCK_SIZE);
	RunTest(fi, Repeats, ReadSize, MAX_BLOCK_SIZE, argv[2] );
	RunTest(fi, Repeats, ReadSize, 1024, argv[2] );

	fclose(fi);
}
