
   **********************************************************************
   ***  Druckformular von KONTO - MANAGER   (Beispiel und Erklrung)  ***
   **********************************************************************

   Dies ist ein Beispiel-Formular zum Drucken Ihrer Buchungen.

   Auerdem finden Sie hier eine ausfhrliche Erklrung zum Aufbau der
   Druckformulare. Um eigene Formulare zu entwerfen lesen Sie sich diese
   Erklrungen bitte genau durch, Sie finden hier wichtige Informationen.

   Dieses Formular kann mit jedem beliebigen Editor gendert werden.
   Das Formular mu dabei aber unbedingt als ASCII-Datei abgespeichert
   werden, und NICHT in einem speziellen Format der diversen Textprogramme.

   Hier beginnt nun die Formular-Definition. Anschlieend finden Sie eine
   genaue Erluterung, wie Sie das Formular individuell anpassen und sich
   beliebig viele eigene Druck- und Export-Formulare gestalten knnen.



.A  Der ANFANGSBEREICH wird nur EINMAL am Anfang des Druckvorgangs gedruckt.





Druck von Kontendatei: !N               Datum: !D                  Seite:  !S
==============================================================================


Nr.:    Datum:     Verwendungszweck:            Ausgaben:       Einnahmen:
==============================================================================

.K  Der KOPFBEREICH wird am Anfang JEDER Seite gedruckt (auer erste Seite!).






                                                                   Seite:  !S


Nr.:    Datum:     Verwendungszweck:            Ausgaben:       Einnahmen:
==============================================================================

.D  Hier beginnt der DATENBEREICH fr die Buchungen auf jeder Seite.
[N  ]  [  D   ]  [           Z            ]  [    A     ] !W  [    E     ] !W
.F  Der FUSSBEREICH wird am Ende JEDER Seite gedruckt (auer letzte Seite!).


==============================================================================

Zwischensummen:                              [  SUM(A)  ] !W  [  SUM(E)  ] !W





.S  Der SCHLUSSBEREICH wird nur EINMAL am Ende des Druckvorgangs gedruckt.


==============================================================================

Gesamtsummen:                                [  SUM(A)  ] !W  [  SUM(E)  ] !W

Saldo der gedruckten Buchungen:              [  SALDO   ] !W



.E  Hier ENDET die Formular-Definition.





Dieser Bereich wird nicht mehr gedruckt. Hier knnen Sie die diversen
Druckbefehle schreiben, um z. B. zustzliche Angaben zur Lnge des
Papiers, zur Druckerschnittstelle oder anderen Optionen zu machen.

Auch knnen Sie hier beliebige Kommentare und Hinweise zu dem
jeweiligen Formular schreiben, dieser Text wird nicht gedruckt.

Druck- und Steuerbefehle werden hier jedoch noch ausgewertet, die
Auswertung geschieht aber nur bis zur Zeile 100 des Formulars.

Auerdem knnen hier die Definitionen fr die Druckersteuerzeichen
(Fettdruck, Schmalschrift etc.) stehen, doch dazu etwas spter mehr.










--> Zeile 100, ab hier werden keine Befehle mehr ausgewertet.



******************************************************************************



Hier folgt nun eine genaue Erklrung zum Aufbau des Formulars mit
den Feldkennungen, Formeln und sonstigen Punkt- und Druckbefehlen.



I Die Einteilung des Formulars in Bereiche:
===========================================

Ein Formular ist in verschiedene Bereiche eingeteilt. Jeder Bereich wird
durch eine eindeutige Kennung (einen Kennbuchstaben) eingeleitet. Dieser
Kennungbuchstabe steht am Anfang einer eigenen Zeile. Die Bereiche sind:


Kennung .A    Anfangsbereich     wird nur auf der ersten Seite gedruckt.

Kennung .K    Kopfbereich        wird am Anfang jeder Seite gedruckt, auer
                                 auf der ersten Seite.

Kennung .D    Datenbereich       hier werden die Buchungsdaten gedruckt.
                                 Der Datenbereich gilt fr jede Seite.

Kennung .F    Fubereich         wird am Ende jeder Seite gedruckt, auer
                                 auf der letzten Seite.

Kennung .S    Schlubereich      wird nur am Ende der letzten Seite gedruckt.

Kennung .E    Endekennung        ab hier wird nichts mehr gedruckt, danach
                                 stehende Befehle werden aber trotzdem noch
                                 bis zur Zeile 100 des Formulars ausgewertet.


Hinweise fr die Definition der Bereiche im Formular:
-----------------------------------------------------

- Gro- oder Kleinschreibung des Kennbuchstabens spielt keine Rolle,
  der Punkt vor dem Kennbuchstaben ist jedoch unbedingt ntig.

- Der Anfangs- und Schlubereich (.A und .S) sind optional. Ohne diese
  Bereiche wird statt dem Anfangsbereich auf Seite 1 der Kopfbereich und
  statt dem Schlubereich auf der letzten Seite der Fubereich gedruckt.

- Die Angaben fr Kopf-, Daten- und Fubereich, sowie die Endekennung (.K, .D,
  .F und .E) mssen aber auf jeden Fall in einem Druckformular vorhanden sein.
  Ohne diese Kennungen fr die einzelnen Bereiche kann ein Formular nicht
  korrekt ausgewertet werden.

- Der Anfangsbereich .A mu nicht in der ersten Zeile des Formulars
  beginnen, was Sie am obigen Beispiel sehen knnen. Alle Zeilen vor
  dem .A (oder auch vor dem .K bei einem Formular ohne Anfangsbereich)
  werden beim Druck ignoriert, hier kann ein beliebiger Text stehen.

- Die Reihenfolge der Bereiche mu stets dem obigen Beispiel entsprechen.
  Die Bereiche mssen immer in der Reihenfolge .A  .K  .D  .F  .S  .E im
  Formular angegeben werden. .A und .S knnen dabei weggelassen werden,
  da diese beiden Bereiche optional sind, wie Sie inzwischen ja wissen.

  Diese Reihenfolge der Plazierung im Formular ist mit der Reihenfolge
  des Drucks der verschiedenen Bereiche identisch, so da Sie eigentlich
  keine Schwierigkeiten haben drften, diese Reihenfolge zu verstehen.

  Bei falscher Reihenfolge erhalten Sie von KONTO-MANAGER einen Hinweis,
  da jedes Formular vor dem Druck auf seine Korrektheit berprft wird.

- Die Zeile, in welcher die Bereichskennung steht, zhlt NICHT mit fr
  diesen Bereich. Sie knnen also in die Zeile hinter der Kennung noch
  einen beliebigen Text schreiben, denn diese Zeile wird nicht gedruckt.

  Hierzu ein Beispiel:

       --> die letzte Zeile des Datenbereichs
  .F   --> Fukennung; diese Zeile wird nicht gedruckt
       --> die erste Zeile des Fubereichs


Beachten Sie bitte auch folgendes Problem:

Wenn Sie einen Schlubereich mit .S definieren und dieser lnger als
der Fubereich .F ist, so kann es vorkommen, da bei einem berraschenden
Ende des Drucks der Schlubereich nicht mehr auf diese Seite pat, da bei
der Berechnung des Platzbedarfs dieser Seite ja vom Fubereich ausgegangen
wurde. In diesem Fall wird vor dem Druck des Schlubereichs .S ein Vorschub
ausgefhrt und der Schlubereich anschlieend auf eine neue Seite gedruckt.



******************************************************************************



II Plazierung der Felder:
=========================

Ihre Buchungen werden stets im Datenbereich .D des Formulars gedruckt.
Jedes Feld einer Buchung hat einen Kennbuchstaben, welcher in eckigen
Klammern eingeschlossen geschrieben wird. Je nach der Datenart wird der
jeweilige Inhalt des Feldes darin rechts- oder linksbndig eingesetzt.


Feldkennung:       Bedeutung:               Formatierung:
---------------------------------------------------------

[ N ]              Nummer der Buchung       rechtsbndig
[ D ]              Datum der Buchung        linksbndig
[ G ]              Gruppenfeld              (variabel, s. u.)
[ Z ]              Verwendungszweck         linksbndig
[ A ]              Ausgaben                 rechtsbndig
[ E ]              Einnahmen                rechtsbndig
[ S ]              Kontostand               rechtsbndig


Hinweise zur Angabe der Felder:
-------------------------------

- Gro- oder Kleinschreibung des Kennbuchstabens spielt keine Rolle.

- Die Auswertung beginnt bei der offenen Klammer und endet bei der
  geschlossenen Klammer. Die Angabe [  Z  ] druckt also die ersten
  sieben Zeichen des Verwendungszwecks einer Buchung.

- Felder mit falschen Kennbuchstabem, z. B. [  U  ] werden ignoriert.

- Achten Sie bitte darauf, da Sie keine verschachtelten Felder angeben.
  Die Angabe [ D   [  Z  ]  ] fhrt zu keinem vernnftigen Ergebnis.

- Das Datum (Feld [ D ]) kann sowohl mit als auch ohne Jahrhundert gedruckt
  werden. Dies kann entweder in der Installation mit KOMAINST, oder mit dem
  Druckbefehl JH= (Erklrung folgt weiter unten) eingestellt werden.


******************************************************************************



III Folgende Formeln fr Berechnungen knnen verwendet werden:
==============================================================

[ SUM(A) ]       Summe der Ausgaben
[ SUM(E) ]       Summe der Einnahmen
[ SUM(S) ]       Summe der Kontostnde

[ MAX(A) ]       Hchste Ausgabe
[ MAX(E) ]       Hchste Einnahme
[ MAX(S) ]       Hchster Kontostand

[ MIN(A) ]       Kleinste Ausgabe
[ MIN(E) ]       Kleinste Einnahme
[ MIN(S) ]       Kleinster Kontostand

[ MIT(A) ]       Durchschnittl. Ausgabe
[ MIT(E) ]       Durchschnittl. Einnahme
[ MIT(S) ]       Durchschnittl. Kontostand

[ SALDO  ]       Saldo der gedruckten Buchungen

[ VORTRAG]       Saldovortrag des Kontos

[ LSTAND ]       Stand der letzten gedruckten Buchung

[ VSTAND ]       Stand der letzten NICHT gedruckten Buchung

[ STAND  ]       Saldo der gedruckten Buchungen abzglich
                 Stand der letzten NICHT gedruckten Buchung
[   K    ]       akt. Kontostand (siehe auch !K unten)

[   I    ]       Differenz der +/- Betrge einer Buchung

[   J    ]       Absolute Differenz der +/- Betrge einer Buchung




Zum besseren Verstndnis der Formeln [ I ] und [ J ] hier ein Beispiel:
-----------------------------------------------------------------------

KONTO-MANAGER erlaubt es, bei einer Buchung sowohl im Soll- als auch im
Haben-Feld einen Betrag einzutragen. Wenn Sie z. B. die Bezahlung einer
Rechnung ber 1000.- eintragen, bei der gleichzeitig eine Gutschrift in
Hhe von 200.- verrechnet wurde, so knnen Sie entweder

                 Ausgaben :  800.-
                 Einnahmen:    0.-

oder

                 Ausgaben : 1000.-
                 Einnahmen:  200.-

in Ihre Kontendatei eintragen. Im ersten Fall ist die Verrechnung der
Gutschrift nicht mehr ersichtlich, im zweiten Fall erkennen Sie dagegen
auch spter, da hier bei der Bezahlung eine Gutschrift verrechnet wurde.

Die beiden Formeln [ I ] und [ J ] sind fr diese zweite Mglichkeit der
Verbuchung wichtig. Im obigen Beispiel wrde die Formel [ I ] den Wert -800
ergeben, nmlich -1000 + 200 = -800. Die Formel [ J ] dagegen ergibt den
Differenzbetrag ohne Vorzeichen, in unserem Beispiel wre dies 800.


Dies kann auch fr ein Geschftskonto hilfreich sein, mit welchem Sie Ihre
laufenden Ausgaben erfassen und kontrollieren. Wenn Sie den Bruttobetrag
als Ausgabe, den MWSt.-Anteil dagegen als Einnahme in derselben Buchung
eintragen, haben Sie spter beim Drucken Zugriff auf alle wichtigen Daten:

   [   A    ]  Bruttobetrag einer Buchung
   [   E    ]  MWSt.-Anteil einer Buchung
   [   J    ]  Nettobetrag  einer Buchung
   [ SUM(A) ]  Summe brutto
   [ SUM(E) ]  Summe MWSt.
   [ SALDO  ]  Summe netto



Hinweise zu den Formeln:
------------------------

- Wie auch schon die Feldkennungen mssen auch die Formeln in eckige
  Klammern eingeschlossen werden. Der entsprechende Wert wird dabei
  rechtsbndig innerhalb dieser Klammern gedruckt.

- Erscheint bei der Ausgabe einer Formel wieder Erwarten der Betrag 0,00
  oder wird die Formel als normaler Text ausgegeben, so sollten Sie die
  Schreibweise der Formel in Ihrem Formular kontrollieren. Wahrscheinlich
  haben Sie sich bei der Eingabe vertippt oder eine der Klammern vergessen.

- Gro- oder Kleinschreibung spielen wie immer keine Rolle.


Ein Tip zur Eingabe der eckigen Klammern [ und ]:
-------------------------------------------------

Falls Sie die eckigen Klammern auf Ihrer Tastatur nicht finden,
was z. B. bei alten XT's der Fall sein kann, so knnen Sie diese
Zeichen auch ber ihren entsprechenden ASCII-Code eingeben.

Halten Sie dazu die Taste <Alt> gedrckt und geben Sie anschlieend
auf dem numerischen Block rechts an Ihrer Tastatur die jeweiligen
Zahlenwerte ein. Erst danach lassen Sie die Taste <Alt> wieder los.

  <Alt> - 91  -->  [
  <Alt> - 93  -->  ]



******************************************************************************



IV Weitere Druckbefehle:
========================

Die folgenden Befehle knnen an beliebiger Stelle im Formular geschrieben
werden. Die Auswertung erfolgt stets beim Druck der jeweiligen Zeile.

Smtliche Befehle werden mit einem ! eingeleitet. Der nachfolgende Buchstabe
gibt die genaue Art des Befehls an. Um tatschlich nur ein ! zu drucken mu
daher im Formular !! geschrieben werden. Gro- und Kleinschreibung beliebig.

Beachten Sie bitte auch, da Sie rechts neben den Befehlen noch gengend
freien Platz lassen, damit der betreffende Text hier eingefgt werden kann.

Beispiel:  "Seite: !S" druckt den Text "Seite: 1", "Seite: 2" etc.


Befehl   Bedeutung                                         Platzbedarf
-----------------------------------------------------------------------

!W       Whrungssymbol laut Installation                     3 Spalten
!D       Datum in der Form TT.MM.JJ, z. B. "18.04.92"         8 Spalten
!T       Tag, evtl. mit vorangestellter 0                     2 Spalten
!M       Monat als Zahl, evtl. mit vorangestellter 0          2 Spalten
!O       Monat als Text, z. B. "August"                       variabel
!J       Jahr (incl. Jahrhundert), z. B. "1992"               4 Spalten
!Q       laufendes Quartal                                    2 Spalten
!U       akt. Uhrzeit, Form HH:MM:SS                          8 Spalten
!H       akt. Uhrzeit, Form HH:MM                             5 Spalten
!N       Dateiname (ohne Pfad, ohne Endung), z. B. "GIRO"     max. 8 Spalten
!P       Dateiname mit Pfad, z. B. "C:\KOMA\GIRO.KTO"         variabel
!S       aktuelle Seitennummer                                variabel
!K       aktueller Kontostand                                 variabel
!A       Anzahl der gedruckten Ausgaben-Buchungen             variabel
!E       Anzahl der gedruckten Einnahmen-Buchungen            variabel
!B       Anzahl aller gedruckten Buchungen                    variabel
!!       normales Ausrufezeichen


Hinweis:

Einige dieser Befehle knnen auch in den Optionstexten (Krzel, Lastschriften,
Dauerauftrge etc.) verwendet werden, z. B. die Befehle !W, !D, !Q u. a.



******************************************************************************



V Sonstige Befehle in den Formularen:
=====================================


Bevor Sie jetzt erschrecken, alle nun erklrten Befehle sind optional,
Sie mssen sich nicht damit beschftigen, aber es bieten sich Ihnen
dadurch sehr viele Mglichkeiten zur Gestaltung der Druckformulare.



LPT=            gibt an, auf welche parallele Schnittstelle die Ausgabe
                erfolgen soll. 0 oder keine Angabe ergibt stets LPT1.

ZEILEN=         gibt an, wieviele Zeilen pro Seite gedruckt werden sollen.
                Die Mindestangabe ist 30 Zeilen, die (wohl nur theoretische)
                Grenze fr KONTO-MANAGER liegt bei 9999 Zeilen pro Seite.

                Falls Sie nicht wissen wieviele Zeilen pro Seite Ihr Drucker
                verwendet, so helfen Ihnen vielleicht die folgenden Hinweise:

                Bei Endlospapier der Standardgre 12" (Zoll) werden meist
                72 Zeilen verwendet, bei Papier im DIN A4 Format sind es nur
                68 Zeilen. Bei Laserdruckern knnen aus techn. Grnden oft nur
                64 Zeilen bedruckt werden. Dies drei Angaben (64, 68 und 72)
                sind die am hufigsten verwendeten Papiergren.

FF=             gibt an, ob nach jeder Seite zustzlich ein FormFeed
                (Seitenvorschub) an den Drucker geschickt werden soll.
                Dies kann ntig sein, wenn Sie beim Befehl ZEILEN=
                weniger Zeilen angegeben haben, als tatschlich auf
                eine Seite gedruckt werden knnen.

FFA=            gibt an, ob vor dem Druck ein FormFeed ausgefhrt
                werden soll. Dies kann bei Einzelblatt-Einzgen
                ntzlich sein, um ein neues Blatt einzufhren.

FFE=            gibt an, ob am Ende des gesamten Drucks zustzlich
                ein FormFeed an den Drucker geschickt werden soll.
                Diese Angabe ist unabhngig vom Befehl FF=. Sie
                knnen damit angeben, da erst nach dem Druck der
                letzten Seite ein Vorschub ausgefhrt werden soll.

                Beachten Sie in diesem Zusammenhang bitte auch den
                Befehl LEERENDE=, der weiter unten erklrt wird.

ENDLOS=         gibt an, ob Sie mit Endlospapier oder Einzelblttern
                arbeiten. Bei Einzelblttern erfolgt nach jeder Seite
                eine Pause, mit dem Hinweis, da Sie ein neues Blatt
                einlegen sollen. Bei einem autom. Einzelblatteinzug
                sollte diese Angabe auf "j" gesetzt sein, da hier
                die Bltter ja autom. vom Drucker eingezogen werden,
                und somit keine Pause vor dem nchsten Blatt ntig ist.

RESET=          gibt an, ob vor dem Druckbeginn ein Reset an den
                Drucker geschickt werden soll. Damit ist der Reset
                ber die BIOS-Funktion gemeint und nicht eine evtl.
                weitere Initialisierung ber spezielle Steuerbefehle.

NULL=           gibt an, ob der Betrag 0,00 gedruckt werden soll, oder
                ob stattdessen Leerzeichen ausgegeben werden sollen.

JH=             gibt an, ob das Buchungsdatum mit oder ohne Jahrhundert
                ausgegeben werden soll (Format TT.MM.JJ oder TT.MM.JJJJ).

GRUPPE=         gibt an, ob das Gruppenfeld  [  G  ]  linksbndig oder
                rechtsbndig gedruckt werden soll (Vorgabe linksbndig).

KOMMA=          gibt das Dezimalzeichen an, das fr diesen Druckvorgang
                verwendet werden soll. Ist ntzlich, um bei einem Formular
                ein anderes Dezimalzeichen als installiert zu verwenden.
                Varianten: KOMMA=,  oder  KOMMA=.

TAUSEND=        gibt das Tausender-Trennzeichen an, das fr den Druckvorgang
                verwendet werden soll. Ist ntzlich, um bei einem Formular
                ein anderes Trennzeichen als installiert zu verwenden.
                Varianten: TAUSEND=,  oder  TAUSEND=.  oder  TAUSEND=0
                Die Angabe TAUSEND=0 bedeutet kein Tausender-Trennzeichen.

KOPIEN=         gibt die Anzahl der zu druckenden Kopien (1 - 9999) an.

LEERENDE=       gibt an, da der Fu- oder Schubereich eines Formulars
                beim Ausdruck der letzten Seite gleich nach der letzten
                Buchung gedruckt wird, statt dieses letzte Blatt bei Bedarf
                mit Leerzeilen am Ende aufzufllen, damit der Fu- oder
                Schlubereich erst am Blattende erscheint.

                Die Standard-Vorgabe ist 'ja', es werden also also bei Bedarf
                einige Leerzeilen auf der letzten Seite gedruckt, so der Fu-
                oder Schlubereich erst am Ende des Blattes gedruckt wird.
                Die Umschaltung geschieht mit dem LEERENDE=N, damit wird der
                Fu- oder Schlubereich gleich nach der zuletzt gedruckten
                Buchung auf dem letzten Blatt ausgegeben.

                Wird der Befehl LEERENDE=N eingesetzt, so sollte gleichzeitig
                der Befehl FFE=J verwendet werden, damit nach dem vorzeitigen
                Druck des Fu- oder Schlubereichs auf dem letzten Blatt ein
                Seitenvorschub ausgefhrt wird.

EXPORT=         Definiert eine Export-Datei, in welche die Druckausgabe
                umgeleitet wird. Damit haben Sie die Mglichkeit, Ihre
                Buchungen in eine Datei mit beliebigem Aufbau auszugeben,
                welche dann wiederum von anderen Programmen gelesen wird.

                Hinter dem Gleichheitszeichen steht der Dateiname, wobei
                die Angabe eines Laufwerks und/oder Suchpfads mglich ist.
                Ist diese Datei schon vorhanden wird sie berschrieben.
                Das Formular EXPORT.FOR enthlt hierzu ein Beispiel.

CRLF=           Damit knnen Sie die Ausgabe von CR/LF (CarrigeReturn /
                LineFeed, ASCII 13/10) am Ende jeder Zeile der Export-Datei
                unterdrcken. Dieser Befehl wird nur fr die Export-Funktion
                ausgewertet und spielt bei normaler Druckausgabe keine Rolle.
                Die Vorgabe ist CRLF=J, wenn der Befehl nicht vorhanden ist.

BIN=            Damit knnen Sie angeben, da alle im Formular angegeben
                Steuerzeichen fr den Drucker auch in die Export-Datei
                geschrieben werden (binr). Fr den Export von Buchungen in
                andere Programme ist dies wenig sinnvoll, aber Sie haben
                damit die Mglichkeit, den gesamten Druck vollstndig mit
                allen Steuerbefehlen in eine Datei umzuleiten. Diese Datei
                knnen Sie dann z. B. auf einem anderen PC mit dem Befehl
                'copy dateiname lpt1 /b' auf den Drucker ausgeben, genauso
                als wrde der Druck direkt von KONTO-MANAGER aus erfolgen.

                Der Befehl BIN= mu auch eingeschaltet sein, wenn ein FF
                (FormFeed) in die Exportdatei geschrieben werden soll.
                Dieser Befehl wird nur fr die Export-Funktion ausgewertet.
                Die Vorgabe ist BIN=N, wenn der Befehl nicht vorhanden ist.

BIT7=           Wird dieser Befehl ausgeschaltet, so wird bei jedem Zeichen
                das 7. Bit zurckgesetzt, es werden also ausschlielich die
                Zeichen bis ASCII-Wert 127 in die Exportdatei ausgegeben.

                Dies kann in Ausnahmefllen ntig sein, wenn das Programm,
                das die Exportdaten aufnehmen soll, Zeichen ber ASCII-127
                falsch oder garnicht interpretiert. Die Umlaute und einige
                andere Sonderzeichen gehen hierbei jedoch verloren und werden
                beim Lschen des 7. Bits evtl. in Steuerzeichen umgewandelt!

                Dieser Befehl ist nur fr die Export-Funktion sinnvoll.
                Die Vorgabe ist BIT7=J, wenn der Befehl nicht vorhanden ist.

G_SUMME=        Berechnung und Druck von Gruppensummen.
                Ein Beispiel hierzu ist das Druckformular SUMGRUPP.FOR.
                Dieses Druckformular summiert alle Buchungen mit dem
                gleichen Eintrag im Gruppenfeld intern auf und druckt
                dann nur jeweils die Summen der einzelnen Gruppen aus.

                Diese Berechnung der Gruppensummen bezieht sich stets
                auf das gesamte Konto, daher erfolgt bei der Auswahl
                dieses Formulars keine weitere Abfrage der Suchbegriffe.

Z_SUMME=        Berechnung und Druck von Zwecksummen
                Ein Beispiel hierzu ist das Druckformular SUMZWECK.FOR.
                Dieses Druckformular summiert alle Buchungen mit dem
                gleichen Eintrag im Zweckfeld intern auf und druckt
                dann nur jeweils die Summen der einzelnen Zwecke aus.

                Diese Berechnung der Zwecksummen bezieht sich stets
                auf das gesamte Konto, daher erfolgt bei der Auswahl
                dieses Formulars keine weitere Abfrage der Suchbegriffe.

VERGLEICH=      Die vollstndige Schreibweise dieses Befehls lautet

                VERGLEICH=feld : von : bis

                Sie knnen damit bestimmte Suchbegriffe fr den Druck
                gleich direkt ins Formular schreiben. Diese Suchbegriffe
                werden Ihnen beim Druck mit diesem Formular vorgeschlagen.

                Bei 'feld' kann angegeben werden:  N = Nummer
                                                   D = Datum
                                                   G = Gruppe
                                                   Z = Zweck
                                                   E = Einnahmen
                                                   A = Ausgaben
                                                   S = Kontostand

                Die Angaben 'von' und 'bis' sind optional und knnen auch
                weggelassen werden. Die Leerzeichen vor und nach den beiden
                Doppelpunkten knnen auch weggelassen werden, sie dienen nur
                der besseren bersicht bei der Beschreibung dieses Befehls.

                Die beiden Doppelpunkte selbst, sowie die Angabe des Felds
                nach dem Gleichheitszeichen mssen dagegen angegeben werden.

                Es sind bis zu 10 VERGLEICH= Befehle pro Formular mglich.

                Hier ein paar Beispiele:

                VERGLEICH=D : 01.01.1994 : 31.12.1994   das Jahr 1994
                VERGLEICH=E : 1000 : 10000              Einnahmen zwischen
                                                        1.000 und 10.000

                VERGLEICH=E :      : 1000               Einnahmen <= 1.000

                VERGLEICH=E : 1000 :                    Einnahmen >= 1.000

                Weitere ntzliche Hinweise und Beispiele zur korrekten
                Angabe der Suchbegriffen beim Drucken finden Sie in der
                Hilfe unter dem Menupunkt 'Buchungen drucken'.



Beachten Sie bitte folgende Hinweise zu den obigen Befehlen:
------------------------------------------------------------

- Diese Befehle sollten Sie stets an das Ende Ihres Formulars, also
  unterhalb der Zeile mit dem .E-Befehl schreiben. Beachten Sie aber,
  da die Auswertung der Befehle nur bis Zeile 100 des Formulars erfolgt.

- Vor und nach den Gleichheitszeichen sollten keine Leerzeichen stehen.

- bei ja/nein-Befehlen bedeutet ein "J" oder "j" nach dem Gleichheitszeichen
  JA, jedes andere Zeichen oder kein Zeichen bedeutet dagegen NEIN.

- Gro- oder Kleinschreibung der Befehle spielt keine Rolle.

- jeder Befehl mu stets in einer eigenen Zeile stehen.


Auerdem sind alle oben aufgefhrten Befehle optional, sie mssen nicht
vorhanden sein. Werden die Befehle im Formular nicht gefunden oder ist
eine korrekte Auswertung nicht mglich, so werden die Angaben aus Ihrer
Installation von KONTO-MANAGER mit dem Programm KOMAINST herangezogen.

Mit Hilfe dieser Befehle haben Sie aber die Mglichkeit, Angaben in
Ihren Formularen unabhngig von den Installationsdaten zu machen.
So knnen Sie damit z. B. ein Formular entwerfen, welches stets Ihren
Laserdrucker an LPT2 mit 64 Zeilen anspricht, und ein weiteres, welches
eine Ausgabe auf Ihren alten Nadeldrucker an LPT1 mit 72 Zeilen bewirkt.
Hierbei ist es dann vollkommen unerheblich, welche Schnittstelle und
Seitenlnge Sie bei der Installation von KONTO-MANAGER angegeben haben!


Hier nun nochmals eine Tabelle der Befehle (Befehl), der erlaubten Werte
(Parameter), sowie der Standard-Vorgabe (Standard), falls der Befehl nicht
im Formular vorhanden ist. Ist bei Standard 'Installation' angegeben, so
ist die Einstellung von Ihrer Angabe in der Installlation mit dem Programm
KOMAINST abhngig. Die nderung einer Angabe im Formular ndert nicht die
Einstellung der Installation, sondern ist nur fr dieses Formular gltig.

Hinter der Angabe "Installation" ist auch noch der Menupunkt in KOMAINST
angegeben, unter dem Sie diesen Wert dauerhaft einstellen knnen.


  Befehl          Parameter                  Standard
  -----------------------------------------------------------

  LPT=            1, 2, 3 oder 4             Installation (Drucker)
  ZEILEN=         (je nach Drucker)          Installation (Drucker)
  FF=             j=ja, sonst nein           Installation (Drucker)
  FFA=            j=ja, sonst nein           Installation (Drucker)
  FFE=            j=ja, sonst nein           Installation (Drucker)
  ENDLOS=         j=ja, sonst nein           Installation (Drucker)
  RESET=          j=ja, sonst nein           Installation (Drucker)
  NULL=           j=ja, sonst nein           Installation (Drucker)
  JH=             j=ja, sonst nein           Installation (Drucker)
  KOMMA=          , oder .                   Installation (Sonstiges)
  TAUSEND=        , oder . oder 0            Installation (Sonstiges)
  KOPIEN=         1 bis 9999                 1
  LEERENDE=       j=ja, sonst nein           ja
  GRUPPE=         r=rechtsbndig             linksbndig
  EXPORT=         Name der Exportdatei       keine Exportdatei
  CRLF=           j=ja, sonst nein           ja
  BIN=            j=ja, sonst nein           nein
  BIT7=           j=ja, sonst nein           ja
  Z_SUMME=        j=ja, sonst nein           nein
  G_SUMME=        j=ja, sonst nein           nein
  VERGLEICH=      feld:von:bis               kein Vergleich



******************************************************************************



VI Schriftarten und beliebige andere Druckerbefehle:
====================================================


Als letztes nun eine Erklrung, wie Sie in Ihren Formularen verschiedene
Schriftarten und Attribute wie Fettdruck, Unterstreichen, Schmalschrift
und beliebige andere Funktionen Ihres Druckers ansteuern knnen.

Hierzu ist ein weiteres Kennzeichen ntig, damit KONTO-MANAGER erkennt,
da jetzt ein Steuerbefehl an den Drucker geschickt werden soll. Dieses
Zeichen ist das '@', von einigen Zeitgenossen auch Klammeraffe genannt.

Sie finden dieses Zeichen auf Ihrer Tastatur evtl. bei der <2> oder beim
<Q>. Meist mssen Sie diese Taste dann gleichzeitig mit <AltGr> und/oder
mit <Ctrl> drcken, damit das Zeichen '@' ausgegeben wird.

Alternativ dazu ist, wie auch schon bei den eckigen Klammern, die Eingabe
des ASCII-Codes ber den numerischen Block Ihrer Tastatur mglich. Dazu
halten Sie die Taste <Alt> gedrckt und geben dann die Zahl 64 ein.


Mit dem Zeichen '@' wird also ein Steuerbefehl fr den Drucker eingeleitet.
Welchen Befehl Sie damit nun genau meinen geben Sie als zweites Zeichen
hinter dem '@' an. Dieses zweite Zeichen knnen Sie vllig frei whlen.
Ich empfehle Ihnen aber, stets sinnvolle und selbsterklrende Zeichen zu
verwenden, so z. B. '@F' fr Fettdruck, '@U' fr Unterstreichen etc.

Zuerst mssen Sie dem Programm aber erst einmal mitteilen, welche Codes
Ihr Drucker fr einen Befehl bentigt. Die folgenden Beispiele beziehen
sich auf Epson Esc/P Befehle, welche die meisten Drucker beherrschen.
Bei einigen Druckern, insbesondere bei Laserdruckern, sind diese Befehle
jedoch unterschiedlich. Im Zweifelsfall mu ich Sie hier deshalb auf Ihr
Druckerhandbuch verweisen, in welchem die ntigen Befehle erlutert sind.

Um einen Steuercode zu definieren schreiben Sie unterhalb der Endekennung
Ihres Formulars, also unterhalb des .E-Befehls, die dezimalen Werte des
gewnschten Druckbefehls. Keine Angst, das ist einfacher als es sich anhrt!
                      
Nehmen wird das Beispiel Fettdruck:

@f=27,69            legt die Steuercodes fr 'Fettdruck ein' fest
@F=27,70            legt die Steuercodes fr 'Fettdruck aus' fest


Damit haben Sie dem Befehl '@f' die Codes 27 und 69 zugewiesen. Mit diesen
beiden Codes wird bei den meisten Nadeldruckern der Fettdruck eingeschaltet.
Mit '@F' dagegen schalten Sie den Fettdruck wieder ab, die Entsprechung
dazu sind die beiden Zahlen 27 und 70, wie Sie oben sehen knnen.

Sie sehen auch, da die einzelnen Zahlen jeweils durch ein Komma getrennt
werden mssen. Sie knnen auch noch Leerzeichen dazwischen schreiben, aber
die drei Zeichen "@x=" mssen auf jeden Fall zusammen geschrieben werden.
Die Befehle "@f=27,69" und "@f= 27, 69" sind also identisch und korrekt.

Das Beispiel oben zeigt auerdem, da die Definitionen der Befehle jeweils
am Anfang einer Zeile stehen mssen. Zwar nicht unbedingt gleich in der
ersten Spalte, aber links davon drfen hchstens Leerzeichen stehen.

Rechts neben den Definitionen knnen Sie dagegen beliebige Bemerkungen
zu den jeweiligen Befehlen schreiben, denn dieser Text wird ignoriert.
Aber Vorsicht! Eine Zeile wie z. B.

@f=27,69            27 und 69 schaltet den Fettdruck ein

kann bei der Auswertung zu Fehlern fhren, da der Kommentar rechts neben
der Befehlsdefinition ebenfalls mit einer Zahl beginnt. Schreiben Sie in
diesem Fall die obige Zeile lieber folgendermaen:

@f=27,69            mit 27 und 69 wird der Fettdruck eingeschaltet

Hier beginnt der Kommentar mit einem Buchstaben, und damit ist jede
Verwechslungsgefahr bei der Auswertung von vornherein ausgeschlossen.

                      
Um nun eine beliebige Zeile in Ihrem Formular fett drucken zu lassen
schreiben Sie diese Zeile einfach folgendermaen in Ihrem Formular:


Beispiel:   @fdiese Zeile wird in Fettdruck ausgegeben.@F
                                                      
             Befehl fr Fettdruck ein                
                                                       
                             Befehl fr Fettdruck aus 


Analog dazu ist auch ein einzelnes Wort in Fettdruck mglich:

Beispiel:   Hier wird ein einzelnes Wort in @fFettdruck@F ausgegeben.

                      
Damit drfte Ihnen das Prinzip der Steuerbefehle klar sein. Sie knnen
nun fr jedes Ihrer Formulare beliebige Steuerbefehle definieren, welche
Sie fr dieses Formular und den dabei verwendeten Drucker bentigen.

Der Umfang der Befehle ist nur durch die Mglichkeiten Ihres Druckers
beschrnkt. Durch diese beraus flexible Gestaltung von Steuerbefehlen haben
Sie die Mglichkeit, SMTLICHE Funktionen Ihrer Drucker in den Formularen
von KONTO-MANAGER ohne jegliche Einschrnkungen ausnutzen zu knnen!

Die Auswertung von Befehls-Definitionen geschieht dabei, wie die Auswertung
aller Befehle in den Formularen, bis zur Zeile 100 in Ihren Formularen. Damit
haben Sie gengend Platz, um alle ntigen Befehle im Formular anzugeben.


Aber ist es nicht etwas umstndlich, fr jedes Formular die Befehle neu zu
definieren? Jain. Es ist sicherlich mit etwas mehr Arbeit verbunden, aber
Sie haben damit die Mglichkeit, fr verschiedene Drucker mit verschiedenen
Befehlsstzen eigene Formulare mit den korrekten Befehlen anzulegen.

Falls Sie immer mit denselben Befehlsdefinitionen arbeiten, da Sie nur
einen Drucker besitzen, so schreiben Sie diese einfach in eine separate
Datei und laden diese dann als Block in Ihre Formulare ein.


Sie werden sicherlich auch bemerkt haben, da hier ausnahmsweise einmal
Gro- und Kleinschreibung unterschieden werden. Der Befehl '@f' ist also
ein anderer Befehl als '@F', wie es im obigen Beispiel auch gezeigt wird.

Dies hat aber den Vorteil, da Sie beispielsweise die Kleinbuchstaben fr
das Einschalten und die Grobuchstaben fr das Ausschalten von Schriften
verwenden knnen. So knnen Sie z. B. mit '@s' Schmalschrift einschalten
und mit '@S' wieder ausschalten. Das ist dann auch sehr einfach zu merken.

Sie knnen jedes Zeichen (auer dem '@') als Befehl definieren. Wenn Sie
also die Schmalschrift lieber mit '@' ein- und mit '@+' wieder ausschalten
wollen, so ist das natrlich auch mglich, das liegt ganz an Ihnen.

Innerhalb des Formulars knnen die Steuerbefehle dann beliebig kombiniert
werden. Die Angabe "@f@k fett und kursiv @F@K" druckt den Text fett und
kursiv, vorausgesetzt Sie haben die Befehle korrekt im Formular definiert.


Hier nun nochmal eine kurze Zusammenfassung zu den Steuerbefehlen:

 - Die Definition einer Steuersequenz erfolgt mittels '@x=' unterhalb
   des .E-Befehls in Ihren Formularen, wobei 'x' fr ein beliebiges und
   von Ihnen frei whlbares Zeichen steht (auer dem '@').

 - Die drei Zeichen '@x=' mssen stets zusammen geschrieben werden.

 - Die einzelnen Zahlen des Befehls werden durch Kommas getrennt.

 - Innerhalb des Formulars werden die Befehle mit '@x' angewendet, wobei
   'x' wiederum fr das jeweils von Ihnen definierte Zeichen steht.

 - Wie alle Befehle in einem Formular beginnt jede Definition eines
   Steuerbefehls in einer eigenen Zeile.

 - Beachten Sie hier die Unterscheidung von Gro- und Kleinschreibung.
 

                     
Im obigen Standard-Formular werden diese Steuerbefehle nicht verwendet, um
das Ganze fr Sie nicht zu kompliziert zu machen. Sie finden aber ein Formular
mit dem Namen SCHMAL.FOR auf Ihrer Original-Diskette, bzw. im Verzeichnis
FORMULAR, wenn Sie das Programm vollstndig nach Anleitung installiert haben.
Dieses Formular zeigt Ihnen sehr anschaulich, wie Sie Ihre Buchungen fett
gedruckt und in Schmalschrift auf Nadeldruckern ausgeben knnen. HP2LASER.FOR
enthlt auerdem ein Beispiel mit Befehlen fr HP-kompatible Laserdrucker.


          
Abschlieend zwei Tips zu zwei kleinen 'Fallen' bei den Steuerbefehlen:


1. Falle: Steuerbefehle in Formularbereichen, die nicht gedruckt werden
-----------------------------------------------------------------------

Beachten Sie bitte, da eine Schriftart meist solange eingeschaltet bleibt,
bis Sie auch wieder durch den entsprechenden Steuercode ausgeschaltet wird.

Wenn Sie also z. B. im Kopfbereich (.K) Ihres Formulars Fettdruck einschalten
und diesen nur im Fubereich (.F) wieder ausschalten, so kann es durchaus
passieren, da der Fettdruck berhaupt nicht mehr ausgeschaltet wird.

Wie das? Nun, wenn Sie in diesem Formular neben dem Fubereich (.F) auch noch
einen Schlubereich (.S) definiert haben, so wird auf der letzten Seite dieser
Schlubereich statt dem Fubereich gedruckt. Werden jetzt aber nur so wenig
Buchungen gedruckt, da alle auf eine Seite passen, so wird in diesem Fall
der Schlubereich am Ende dieser einen Seite gedruckt und der Fubereich kommt
berhaupt nicht zum Einsatz. Damit wird auch die Fettschrift nicht wieder
abgeschaltet, da dieser Befehl ja im nicht gedruckten Fubereich steht!

Sie lsen dieses Problem aber sehr einfach, indem Sie im Zweifelsfall eine
Schriftart nicht nur im Fubereich, sondern eben auch im Schlubereich
wieder abschalten. Da auf jeder Seite entweder ein Fubereich oder ein
Schlubereich gedruckt wird ist die Abschaltung des Fettdrucks gesichert.

Mit dem Anfangs- und Kopfbereich verhlt es sich in diesem Fall hnlich.



2. Falle: Steuerbefehle, die von anderen Druckbefehlen berschrieben werden
---------------------------------------------------------------------------

Betrachten Sie dazu bitte einmal die folgende Zeile:

Beispiel:   Das Datum in Fettschrift: @f !D @F        (das geht schief!)


In diesem Fall wird nicht nur das Datum, sondern auch alle nachfolgenden
Zeilen in Fettschrift gedruckt werden, da die Fettschrift nicht wieder
ausgeschaltet wird. Der Befehl '@F' wird hier berhaupt nicht ausgewertet.

Wenn Sie ein paar Seiten zurckblttern finden Sie bei der Erluterung
des Befehls !D auch den Hinweis, da dieser 8 Spalten bentigt, da das
Datum ja in der Form TT.MM.JJ ausgegeben wird. Da aber im obigen Beispiel
rechts neben dem !D-Befehl zuwenig Freiraum ist wird der Steuerbefehl zur
Abschaltung des Fettdrucks vom eingesetzten Datum berschrieben und kann
damit auch nicht mehr ausgewertet werden!

Und hier nun die korrekte Form des obigen Beispiels:

Beispiel:   Das Datum in Fettschrift: @f !D      @F   (so ist's richtig!)



******************************************************************************


                  
Puh, nun haben Sie die gesamte Erklrung zur Gestaltung der Druckformulare
durchgearbeitet. Ich nehme an, da Ihnen nun der Kopf genauso raucht wie
mir, nachdem ich diese nicht gerade kurze Beschreibung geschrieben habe.

Ich habe versucht, bei der Gestaltung der Druckformulare Ihnen als Anwender
soviel Freiraum wie mglich zu geben. Da Sie dabei trotzdem ein paar Dinge
beachten und sich an gewisse Regeln halten mssen liegt daran, da Computer
schlicht und einfach zu dumm sind, um einen Befehl wie "schreibe mir die
Buchungen ab der 10 Zeile und gib am Ende die Summen aus" zu verstehen.

Ich hoffe aber, Ihnen mit den Beispiel-Formularen und den Erluterungen
das ntige Wissen vermittelt zu haben, damit Sie sich die Formulare jetzt
nach Ihren eigenen Wnschen anpassen und auch eigene Formulare entwerfen
knnen. Eine Reihe von Probedrucken bis endlich jede Seite das gewnschte
Aussehen hat ist dabei unvermeidlich, das blieb auch mir nicht erspart.

brigens: Die von mir mitgelieferten Formulare sollten Sie nicht ndern,
sondern kopieren und dann diese Kopie unter einem anderen Namen ndern.
Warum? Nun, diese Formulare (z. B. STANDARD.FOR) werden von mir bei Updates
stets in einer aktualisierten Form mitgeliefert, und es wre doch schade,
wenn bei der Installation des Updates Ihre nderungen verloren gehen.

                        
Falls Sie weitere Wnsche und Vorschlge zur Gestaltung der Formulare
haben, so lassen Sie es mich wissen. Anregungen fr weitere Funktionen,
andere Punktbefehle, weitere !-Befehle etc. nehme ich gerne entgegen.

Und wenn einmal ein Formular nicht das tut was es eigentlich sollte und
Sie sicher sind, da Sie keinen Fehler gemacht haben, so schicken Sie mir
dieses Formular auf Disk zu, denn Fehler sind da um behoben zu werden!
Sie helfen damit nicht nur Ihnen bei der Lsung des Problems, sondern auch
mir und allen anderen registrierten Anwendern von KONTO-MANAGER. Merci.

                           
                     ***  Ende des Formulars  ***
