#include <stdio.h>
#include <graphics.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include "svga32k.h"

   unsigned cursor[3][32] = 
	{{0xe01f,0xe01f,0xe01f,0xc00f,0x8007,0x3,0x3,0x1,
	0x3,0x3,0x8007,0xc00f,0xe01f,0xe01f,0xe01f,0xffff,
	0x0,0xfc0,0xfc0,0x1020,0x2110,0x4108,0x4108,0x410c,
	0x4208,0x4408,0x2010,0x1020,0xfc0,0xfc0,0x0,0x0},

	{0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0,0x1c70,0x280,0x100,0x100,0x100,0x100,0x100,
	0x100,0x100,0x100,0x7c0,0x100,0x280,0x1c70,0x0},

	{0x8001,0x8001,0x8001,0x8001,0xc003,0xe007,0xf00f,0xf81f,
	0xf81f,0xf00f,0xe007,0xc003,0x8001,0x8001,0x8001,0x8001,
	0x0,0x3ffc,0x3ffc,0x2004,0x1008,0x810,0x420,0x240,
	0x240,0x420,0x9d0,0x17e8,0x2ff4,0x3ffc,0x3ffc,0x0}};


void setpointer(char far *ptr)
{
  struct REGPACK regs;

  regs.r_ax = 9;	/* set mouse pointer shape */
  regs.r_bx = 8;
  regs.r_cx = 1;
  regs.r_dx = FP_OFF(ptr);
  regs.r_es = FP_SEG(ptr);
  intr(0x33,&regs);
}

void setmousepage(int z)
{
  union REGS regs;

  regs.x.ax = 0x1d;	/* Set mouse pointer page */
  regs.x.bx = z;
  int86(0x33,&regs,&regs);
}

int initmouse()
{
  union REGS reg;

  reg.x.ax = 0x0;	/* reset mouse */
  int86(0x33,&reg,&reg);
  return reg.x.ax;
}

void showmouse()
{
  union REGS reg;

  reg.x.ax = 0x1;	/* show mouse cursor */
  int86(0x33,&reg,&reg);
}

int huge Detect256(void)
{
  return 0;
}

char *drivers[] = {"svga256m","svga32km","svga16m","twk16m","twk256m","egavga"};

main()
{
  int gd,gm;
  int z;
  char c;
  int mod,mp,cp;
  char buf[60];
  int isMs;

  gd = DETECT;
  printf("0:Svga256   1:Svga32k   2:Svga16   3:Twk16  4:Twk256  5:EGAVGA\n");
  printf("dr>");
  scanf("%d",&z);
  if (z > 5) z = 5;
  if (z != 5) gd = installuserdriver(drivers[z],Detect256);
  printf("Enter mode (-1 detects max mode):\n>");
  scanf("%d",&gm);
  if (gm < 0) {
    gm = 6;
    do {
      initgraph(&gd,&gm,"");
      gm--;
    } while (graphresult() != grOk);
  }
  else
    initgraph(&gd,&gm,"");
  gd = graphresult();
  if (gd != grOk) {
    printf("Error initializing driver! (%s)\n",grapherrormsg((char)gd));
    exit(1);
  }
  mod = 0;
  mp = 0;
  cp = 0;
  isMs = initmouse();
  if (getmaxcolor() > 256) {
    setfillstyle(BKSLASH_FILL,RealFillColor(RGB(24,0,0)));
    setcolor(RealDrawColor(RGB(0,20,0)));
  } else {
    setrgbpalette(4,63,0,0);
    setrgbpalette(15,63,63,63);
    setrgbpalette(2,0,63,0);
    setrgbpalette(1,0,0,63);
    setfillstyle(BKSLASH_FILL,4);
    setcolor(15);
  }
  setactivepage(1);
  bar(0,0,getmaxx(),getmaxy());
   if (getmaxcolor() > 256) {
    setfillstyle(XHATCH_FILL,RealFillColor(RGB(0,24,0)));
    setcolor(RealDrawColor(RGB(31,31,31)));
  } else {
    setfillstyle(XHATCH_FILL,2);
    setcolor(15);
  }
  setactivepage(0);
  bar(0,0,getmaxx(),getmaxy());
  line(0,0,getmaxx(),getmaxy());
  if (getmaxcolor() > 256) {
    setfillstyle(SOLID_FILL,RealFillColor(RGB(0,0,0)));
    setcolor(RealDrawColor(RGB(30,30,30)));
  }
  else {
    setfillstyle(SOLID_FILL,0);
    setcolor(15);
  }
  sprintf(buf,"Mode: %ux%ux%u",getmaxx()+1,getmaxy()+1,getmaxcolor()+1);
  bar(0,0,188,60);
  outtextxy(0,0,buf);
  outtextxy(0,10,"Commands: ");
  outtextxy(0,20,"p: Change visual page");
  outtextxy(0,30,"c: Change mouse pointer");
  outtextxy(0,40,"g: Change pointer page");
  outtextxy(0,50,"q: Quit");
  if (getmaxcolor() > 256)
    setfillstyle(SOLID_FILL,RealFillColor(RGB(28,17,10)));
  else
    setfillstyle(SOLID_FILL,1);
  bar(0,getmaxy()/2,getmaxx(),getmaxy());
  if (isMs) {
    showmouse();
    z = 0;
    while(!z) {
      c = getch();
      switch(c) {
	case 'p':
	  mod++;
	  mod %= 2;
	  setvisualpage(mod);
	  break;
	case 'c':
	  setpointer((char far *)cursor[cp]);
	  showmouse();
	  cp++;
	  cp %= 3;
	  break;
	case 'g':
	  mp++;
	  mp %= 2;
	  setmousepage(mp);
	  break;
	case 'q':
	  z = 1;
	  break;
      }
    }
  }
  closegraph();
}