ideal
P286
model   Huge
jumps

stack   1024

segment MyCode

include         "gusmod.inc"

NumNotes        = 36
NoteX1          = 4
NoteY1          = 7
NoteX2          = 73
NoteY2          = 7
StartLine       = 7
StartX          = 8
EfxX            = 8
EfxY            = 2
Spacing         = 5
freek_Line      = 24
freek_Col       = 69

struc   SampleRec
sname           db      16h dup (?)
length          dw      ?
volume          dw      ?
repeat          dw      ?
replen          dw      ?
ends    SampleRec

struc   HS
songname        db      20 dup (?)
samples         db      31*size SampleRec dup (?)
songlen         db      ?
restart         db      ?
sequences       db      128 dup (?)
mk              dd      ?
ends    HS



                assume  cs:MyCode,ds:MyData

MMus            SMus    <>
Music           dw      0,BlankMusicSeg
P               PM      <>

PspAddress      dw      0
SizeOfProg      dw      0

Num             db      '00',13,10,'$'

include "display.asm"
include "modload2.asm"
include "files.asm"
include "sd.asm"
include "env.asm"

proc            Terminate near
                mov     bx,5
                call    [dword ptr cs:Music]
                mov     bx,6            ; Kill music.
                call    [dword ptr cs:Music]
                call    MUS_KillModule
                mov     bx,1            ; Close down player.
                call    [dword ptr cs:Music]
                mov     ax,MyData
                mov     ds,ax
                mov     ah,0Eh
                mov     dl,[OldDrive]
                int     21h
                mov     ah,3Bh
                mov     dx,offset HomeDirectory - 1
                int     21h
                mov     es,[Word FileSeg+2]
                mov     ah,49h
                int     21h
                mov     es,[Word cs:ScreenFix]
                mov     ah,49h
                int     21h
                call    FreeSoundDriver
                call    RestoreMode
                mov     ax,4C00h
                int     21h
endp            Terminate

proc            Error near
                mov     ax,MyData
                mov     ds,ax
                mov     ah,9
                int     21h
                mov     ah,0
                int     16h
                call    Terminate
endp            Error

; si - Filename offset
proc            PutName
                push    ds es
                mov     ax,MyData
                mov     es,ax
                mov     di,[es:PutFilename]
                mov     ax,cs
                mov     ds,ax
                mov     cx,12
                rep     movsb
                mov     al,0
                stosb
                pop     es ds
                ret
endp            PutName

assume          ds:MyData

proc            DrawDots
                mov     ax,[cs:ScreenFix]
                mov     es,ax
                mov     di,StartLine*160+StartX*2
                mov     bx,36
                mov     si,0
@@LineLoop:     push    di
                cmp     si,Spacing
                jnz     @@DrawIt
                mov     ax,07F9h
                mov     cx,64
                rep     stosw
                mov     si,0
                jmp     @@Bottom
@@DrawIt:       mov     cx,64
                mov     dx,0
@@PutLoop:      mov     ax,03FAh
                cmp     dx,Spacing
                jnz     @@JustPut
                mov     ax,07F9h
                mov     dx,0
@@JustPut:      stosw
                inc     dx
                loop    @@PutLoop
@@Bottom:       inc     si
                pop     di
                add     di,160
                dec     bx
                jnz     @@LineLoop
                ret
endp            DrawDots

proc            DrawNotes near
                push    ds
                mov     ax,MyData
                mov     ds,ax
                mov     ax,[cs:ScreenFix]
                mov     es,ax
                mov     si,offset Notes
                mov     di,NoteY1*160+NoteX1*2
                mov     bx,offset KeyName
                mov     bp,-4
                call    DrawNotes1
                mov     si,offset Notes
                mov     di,NoteY2*160+NoteX2*2
                mov     bx,offset KeyName
                mov     bp,8
                call    DrawNotes1
                pop     ds
                ret
DrawNotes1:     mov     cx,36
                mov     dx,0
@@DrawThem:     mov     ah,0Bh
                cmp     dx,Spacing
                jnz     @@DLoop
                mov     dx,0
                mov     ah,0Fh
@@DLoop:        push    cx di
                mov     cx,3
@@DrawLoop:     lodsb
                stosw
                loop    @@DrawLoop
                pop     di cx
                mov     al,[cs:bx]
                mov     [es:di+bp],ax
                inc     bx
                add     di,160
                inc     dx
                loop    @@DrawThem
                ret
endp            DrawNotes

Matcher         dw      113,120,127,135,143,151,160,170,180,190,202,214
                dw      226,240,254,269,285,302,320,339,360,381,404,428
                dw      453,480,508,538,570,604,640,678,720,762,808,856
proc            NoteMatch
                mov     ax,[si]
                xchg    ah,al
                and     ax,0FFFh
                or      ax,ax
                jz      @@Done
                mov     bx,offset Matcher
                mov     cx,0
@@NoteMatcher:  inc     cx
                add     bx,2
                cmp     ax,[cs:bx]
                jge     @@NoteMatcher
                mov     ax,cx
@@Done:         ret
endp            NoteMatch

; AX - Attribute
; DX - Attribute New Note
; BX - Pattern
; CX - Channel to draw (0-15)
Line            dw      0
OldOne          dw      0
Attr            dw      0
AttrNew         dw      0
proc            DrawPattern
                push    ds es bx
                mov     [cs:Attr],ax
                mov     [cs:AttrNew],dx
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     si,0
                shl     cx,2
                add     si,cx
                mov     ax,[cs:ScreenFix]
                mov     es,ax
                mov     di,StartLine*160+StartX*2
                mov     [Word cs:Line],0
                mov     [Word cs:OldOne],0
@@DrawNotes:    call    NoteMatch
                or      ax,ax
                jz      @@DrawNext
                mov     [cs:OldOne],ax
                dec     ax
                mov     bx,160
                mul     bx
                add     ax,[cs:Line]
                add     ax,[cs:Line]
                mov     di,StartLine*160+StartX*2
                add     di,ax
                mov     ax,[cs:AttrNew]
                stosw
                jmp     @@Skip
@@DrawNext:     cmp     [Word cs:OldOne],0
                jz      @@Skip
                mov     ax,[cs:Attr]
                stosw
@@Skip:         add     si,16
                inc     [Word cs:Line]
                cmp     [Word cs:Line],64
                jnz     @@DrawNotes
                pop     bx es ds
                ret
endp            DrawPattern

InsDisp         db      ' 0123456789ABCDEFGHIJKLMNOPQRSTU'
EfxDisp         db      ' 0123456789ABCDEF'
proc            DrawEfx
                push    ds es bx
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     si,0
                shl     cx,2
                add     si,cx
                mov     ax,[cs:ScreenFix]
                mov     es,ax
                mov     di,EfxY*160+EfxX*2
                mov     [Word cs:Line],0
@@DrawIns:      push    di
                mov     bl,[si+2]
                and     bl,0F0h
                shr     bl,4
                mov     bh,[si]
                and     bh,0F0h
                or      bl,bh
                xor     bh,bh
                mov     al,[cs:bx+InsDisp]
                mov     ah,0Fh
                mov     [es:di],ax
                add     di,160
                xor     bh,bh
                mov     bl,[si+2]
                and     bx,0Fh
                mov     cl,[si+3]
                or      bl,bl
                jnz     @@OKEfx
                or      cx,cx
                jz      @@ClrEfx
@@OKEfx:        mov     al,[cs:bx+EfxDisp+1]
                mov     [es:di],ax
                add     di,160
                mov     bl,cl
                shr     bl,4
                mov     al,[cs:bx+EfxDisp+1]
                mov     [es:di],ax
                add     di,160
                mov     bl,cl
                and     bl,0Fh
                mov     al,[cs:bx+EfxDisp+1]
                mov     [es:di],ax
                add     di,160
                jmp     @@EndLoop
@@ClrEfx:       mov     cx,3
                mov     al,' '
@@ClrEfxLoop:   mov     [es:di],ax
                add     di,160
                loop    @@ClrEfxLoop
@@EndLoop:      add     si,16
                pop     di
                add     di,2
                inc     [Word cs:Line]
                cmp     [Word cs:Line],64
                jnz     @@DrawIns
                pop     bx es ds
                ret
endp            DrawEfx

proc            DrawAllTop
                call    DrawAll
                mov     cx,1
                call    PlotXYTop
                ret
endp            DrawAllTop

proc            DrawAllBot
                call    DrawAll
                mov     cx,1
                call    PlotXYBot
                ret
endp            DrawAllBot

proc            DrawAll
                call    DrawDots
                mov     bx,[cs:CurPat]
                mov     cx,[cs:CurChannel]
                call    DrawEfx
                mov     cx,0
@@ChannelWrite: cmp     cx,[cs:CurChannel]
                jz      @@BottomLoop
                mov     ax,07DCh
                mov     dx,07DCh
                push    cx
                call    DrawPattern
                pop     cx
@@BottomLoop:   inc     cx
                cmp     cx,4
                jnz     @@ChannelWrite
                mov     dx,4F20h
                mov     ax,0FDBh
                mov     bx,[cs:CurPat]
                mov     cx,[cs:CurChannel]
                call    DrawPattern
                push    ds es
                mov     ds,[cs:ScreenFix]
                mov     es,[cs:Screen]
                mov     si,0
                mov     di,0
                mov     cx,4000
                rep     movsw
                pop     es ds
                ret
endp            DrawAll

OldAttr         dw      0
OldCoord        dw      8002
OldCoordBot2    dw      8002
OffBot          db      0
proc            PlotXYBot
                mov     ax,[cs:CurY]
                mov     bx,160
                mul     bx
                add     ax,[cs:CurX]
                add     ax,[cs:CurX]
                mov     bx,[cs:Screen]
                mov     es,bx
                mov     di,StartLine*160+StartX*2
                add     di,ax
                or      cx,cx
                jnz     @@Skip
                mov     bx,[cs:OldCoordBot2]
                add     bx,2*160+8*2+1
                mov     cx,4
@@RowLoop:      xor     [Byte es:bx],00010000b
                add     bx,160
                loop    @@RowLoop
                mov     bx,[cs:OldCoord]
                mov     ax,[cs:OldAttr]
                mov     [es:bx],ax
@@Skip:         mov     ax,[es:di]
                mov     [cs:OldAttr],ax
                mov     [cs:OldCoord],di
                mov     ax,[cs:CurX]
                add     ax,[cs:CurX]
                mov     [cs:OldCoordBot2],ax
                cmp     [Byte cs:OffBot],1
                jz      @@Below
                mov     bx,ax
                add     bx,2*160+8*2+1
                mov     cx,4
@@RowLoop2:     xor     [Byte es:bx],00010000b
                add     bx,160
                loop    @@RowLoop2
                mov     [Word es:di],9ADBh
@@Below:        ret
endp            PlotXYBot

OldAttrTop      dw      0
OldCoordTop     dw      8002
OldCoordTop2    dw      8002
OffTop          db      0
proc            PlotXYTop
                mov     ax,[cs:CurYTop]
                mov     bx,160
                mul     bx
                add     ax,[cs:CurX]
                add     ax,[cs:CurX]
                mov     bx,[cs:Screen]
                mov     es,bx
                mov     di,EfxY*160+EfxX*2
                add     di,ax
                or      cx,cx
                jnz     @@Skip
                mov     bx,[cs:OldCoordTop2]
                add     bx,7*160+8*2+1
                mov     cx,36
@@RowLoop:      xor     [Byte es:bx],00010000b
                add     bx,160
                loop    @@RowLoop
                mov     bx,[cs:OldCoordTop]
                mov     ax,[cs:OldAttrTop]
                mov     [es:bx],ax
@@Skip:         mov     ax,[es:di]
                mov     [cs:OldAttrTop],ax
                mov     [cs:OldCoordTop],di
                mov     ax,[cs:CurX]
                add     ax,[cs:CurX]
                mov     [cs:OldCoordTop2],ax
                cmp     [Byte cs:OffTop],1
                jz      @@Below
                mov     bx,ax
                add     bx,7*160+8*2+1
                mov     cx,36
@@RowLoop2:     xor     [Byte es:bx],00010000b
                add     bx,160
                loop    @@RowLoop2
                mov     [Word es:di],9ADBh
@@Below:        ret
endp            PlotXYTop

proc            SetNote
                push    ds
                mov     bx,[cs:CurPat]
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     si,0
                mov     cx,[cs:CurChannel]
                shl     cx,2
                add     si,cx
                mov     cx,[cs:CurX]
                shl     cx,4
                add     si,cx
                mov     bx,[cs:CurY]
                shl     bx,1
                mov     ax,[cs:bx+Matcher]
                xchg    ah,al
                and     [Word si],00F0h
                or      [Word si],ax
                pop     ds
                ret
endp            SetNote

proc            DelNote
                push    ds
                mov     bx,[cs:CurPat]
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     si,[cs:CurChannel]
                shl     si,2
                mov     cx,[cs:CurX]
                shl     cx,4
                add     si,cx
                and     [Word si],00F0h
                pop     ds
                ret
endp            DelNote

proc            InsertCol
                push    ds es
                std
                mov     bx,[cs:CurPat]
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     es,ax
                mov     cx,[cs:CurChannel]
                shl     cx,2
                mov     di,1024-16
                add     di,cx
                mov     si,1024-32
                add     si,cx
                mov     cx,63
                sub     cx,[cs:CurX]
@@CopyLoop:     mov     ax,[si]
                mov     [di],ax
                mov     ax,[si+2]
                mov     [di+2],ax
                sub     di,16
                sub     si,16
                loop    @@CopyLoop
                mov     si,[cs:CurChannel]
                shl     si,2
                mov     cx,[cs:CurX]
                shl     cx,4
                add     si,cx
                mov     [Word si],0
                mov     [Word si+2],0
                cld
                pop     es ds
                ret
endp            InsertCol

proc            DeleteCol
                push    ds es
                cld
                mov     bx,[cs:CurPat]
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     es,ax
                mov     di,[cs:CurChannel]
                shl     di,2
                mov     cx,[cs:CurX]
                shl     cx,4
                add     di,cx
                mov     si,di
                add     si,16
                mov     cx,63
                sub     cx,[cs:CurX]
@@CopyLoop:     mov     ax,[si]
                mov     [di],ax
                mov     ax,[si+2]
                mov     [di+2],ax
                add     di,16
                add     si,16
                loop    @@CopyLoop
                mov     [Word di],0
                mov     [Word di+2],0
                pop     es ds
                ret
endp            DeleteCol

proc            UpcaseKey
                cmp     al,'a'
                jb      @@NoKey
                cmp     al,'z'
                ja      @@NoKey
                and     al,01011111b
@@NoKey:        ret
endp            UpcaseKey

proc            GetAddr
                mov     bx,[cs:CurPat]
                xor     bh,bh
                mov     bl,[cs:bx+sequences]
                shl     bx,1
                mov     ax,[cs:bx+PatternLoc]
                mov     ds,ax
                mov     si,[cs:CurChannel]
                shl     si,2
                mov     cx,[cs:CurX]
                shl     cx,4
                add     si,cx
                ret
endp            GetAddr

proc            CheckOtherKeys near
                push    ds
                call    UpcaseKey
                cmp     [Word cs:CurYTop],0
                jnz     @@Row2
                mov     bx,0
@@ScanKey1:     cmp     al,[cs:bx+InsDisp]
                jz      @@FoundKey1
                inc     bx
                cmp     bx,32
                jnz     @@ScanKey1
                jmp     @@NoFind
@@FoundKey1:    mov     dx,bx
                call    GetAddr
                and     [Word si],0FF0Fh
                and     [Byte si+2],0Fh
                mov     ax,dx
                shr     al,4
                or      [Byte si],al
                shl     dl,4
                or      [Byte si+2],dl
                jmp     @@Find
;
@@Row2:         cmp     [Word cs:CurYTop],1
                jnz     @@Row3
                call    ScanKeys
                or      bx,bx
                jz      @@Clear
                dec     bx
@@JustNormal:   mov     dx,bx
                call    GetAddr
                and     [Byte si+2],0F0h
                or      [Byte si+2],dl
                jmp     @@Find
@@Clear:        call    GetAddr
                and     [Byte si+2],0F0h
                mov     [Byte si+3],0
                jmp     @@Find
;
@@Row3:         cmp     [Word cs:CurYTop],2
                jnz     @@Row4
                call    ScanKeys
                or      bx,bx
                jz      @@JustNormal2
                dec     bx
@@JustNormal2:  mov     dx,bx
                call    GetAddr
                and     [Byte si+3],0Fh
                shl     dl,4
                or      [Byte si+3],dl
                jmp     @@Find
;
@@Row4:         call    ScanKeys
                or      bx,bx
                jz      @@JustNormal3
                dec     bx
@@JustNormal3:  mov     dx,bx
                call    GetAddr
                and     [Byte si+3],0F0h
                or      [Byte si+3],dl
                jmp     @@Find
@@Find:         cmp     [Byte cs:CurX],63
                jz      @@JustDraw
                inc     [Byte cs:CurX]
@@JustDraw:     call    DrawAllTop
@@NoFind:       pop     ds
                ret
ScanKeys:       mov     bx,0
ScanKeyLoop:    cmp     al,[cs:bx+EfxDisp]
                jz      FoundKey
                inc     bx
                cmp     bx,17
                jnz     ScanKeyLoop
                pop     ax
                jmp     @@NoFind
FoundKey:       ret
endp            CheckOtherKeys

proc            PlayMusic
                mov     ax,-1
                mov     [Word cs:offset P+(offset (PM).mt_speed)],ax
                mov     ax,-1
                mov     [Word cs:offset P+(offset (PM).mt_counter)],ax
                mov     ax,[cs:CurX]
                shl     ax,4
                mov     [Word cs:offset P+(offset (PM).mt_PatternPos)],ax
                mov     ax,[cs:CurPat]
                mov     [Word cs:offset P+(offset (PM).mt_SongPos)],ax
                mov     cx,cs
                mov     si,offset P
                mov     bx,4
                call    [dword ptr cs:Music]
                mov     [cs:OldPos],0FFFFh
                ret
endp            PlayMusic


CurYTop         dw      0
proc            DoItTop
TopPart:        mov     cx,0
                call    PlotXYTop
TopLooper:      mov     ah,0
                int     16h
;
@@Key_AltL:     cmp     ax,2600h
                jne     @@Key_Tab
                call    LoadFile
                call    DrawAllBot
                jmp     @@End
;
@@Key_Tab:      cmp     al,9
                jne     @@Key_Up
                mov     [Byte cs:OffTop],1
                call    DrawAllBot
                mov     [Byte cs:OffTop],0
                jmp     BottomPart
;
@@Key_Up:       cmp     ah,72
                jne     @@Key_Down
                cmp     [Word cs:CurYTop],0
                je      @@Key_Up_1
                dec     [Word cs:CurYTop]
                mov     cx,0
                call    PlotXYTop
@@Key_Up_1:     jmp     @@End
;
@@Key_Down:     cmp     ah,80
                jne     @@Key_Left
                cmp     [Word cs:CurYTop],3
                je      @@Key_Down_1
                inc     [Word cs:CurYTop]
                mov     cx,0
                call    PlotXYTop
@@Key_Down_1:   jmp     @@End
;
@@Key_Left:     cmp     ah,75
                jne     @@Key_Right
                cmp     [Word cs:CurX],0
                je      @@Key_Left_1
                dec     [Word cs:CurX]
                mov     cx,0
                call    PlotXYTop
@@Key_Left_1:   jmp     @@End
;
@@Key_Right:    cmp     ah,77
                jne     @@Key_Del
                cmp     [Word cs:CurX],63
                je      @@Key_Right_1
                inc     [Word cs:CurX]
                mov     cx,0
                call    PlotXYTop
@@Key_Right_1:  jmp     @@End
;
@@Key_Del:      cmp     ah,83
                jnz     @@Key_PgUp
                mov     al,32
                jmp     @@CheckOther
;
@@Key_PgUp:     cmp     ah,73
                jnz     @@Key_PgDn
                cmp     [Word cs:CurYTop],0
                je      @@Key_PgUp_1
                mov     [Word cs:CurYTop],0
                mov     cx,0
                call    PlotXYTop
@@Key_PgUp_1:   jmp     @@End
;
@@Key_PgDn:     cmp     ah,81
                jnz     @@Key_Home
                cmp     [Word cs:CurYTop],3
                je      @@Key_PgDn_1
                mov     [Word cs:CurYTop],3
                mov     cx,0
                call    PlotXYTop
@@Key_PgDn_1:   jmp     @@End
;
@@Key_Home:     cmp     ah,71
                jnz     @@Key_End
                cmp     [Word cs:CurX],0
                je      @@Key_Home_1
                mov     [Word cs:CurX],0
                mov     cx,0
                call    PlotXYTop
@@Key_Home_1:   jmp     @@End
;
@@Key_End:      cmp     ah,79
                jnz     @@Key_CLeft
                cmp     [Word cs:CurX],63
                je      @@Key_End_1
                mov     [Word cs:CurX],63
                mov     cx,0
                call    PlotXYTop
@@Key_End_1:    jmp     @@End
;
@@Key_CLeft:    cmp     ah,115
                jnz     @@Key_CRight
                call    DeleteCol
                call    DrawAllTop
                jmp     @@End
;
@@Key_CRight:   cmp     ah,116
                jnz     @@Key_F9
                call    InsertCol
                call    DrawAllTop
                jmp     @@End
;
@@Key_F9:       cmp     ah,67
                jnz     @@Key_F10
                cmp     [Word cs:CurPat],0
                jz      @@Key_F9_1
                dec     [Word cs:CurPat]
                call    DrawAllTop
@@Key_F9_1:     jmp     @@End
;
@@Key_F10:      cmp     ah,68
                jnz     @@Key_1
                xor     ah,ah
                mov     al,[cs:songlen]
                dec     ax
                cmp     [cs:CurPat],ax
                jz      @@Key_F10_1
                inc     [Word cs:CurPat]
                call    DrawAllTop
@@Key_F10_1:    jmp     @@End
;
@@Key_1:        cmp     ah,3Bh
                jnz     @@Key_2
                mov     [Word cs:CurChannel],0
                call    DrawAllTop
                jmp     @@End
;
@@Key_2:        cmp     ah,3Ch
                jnz     @@Key_3
                mov     [Word cs:CurChannel],1
                call    DrawAllTop
                jmp     @@End
;
@@Key_3:        cmp     ah,3Dh
                jnz     @@Key_4
                mov     [Word cs:CurChannel],2
                call    DrawAllTop
                jmp     @@End
;
@@Key_4:        cmp     ah,3Eh
                jnz     @@Key_Enter
                mov     [Word cs:CurChannel],3
                call    DrawAllTop
                jmp     @@End
;
@@Key_Enter:    cmp     al,13
                jnz     @@Key_Esc
                call    PlayMusic
                call    DoItTrack
                call    DrawAllTop
                jmp     @@End
;
@@Key_Esc:      cmp     ah,1
                jnz     @@CheckOther
                ret
;
@@CheckOther:   call    CheckOtherKeys
@@End:          jmp     TopLooper
endp            DoItTop

OldPos          dw      0FFFFh
; CX - 1  Erase and Draw
; CX - 0  Erase
proc            PlotTrack
@@AAA:          mov     ax,[cs:offset MMus+(offset (SMus).EditOfs)]
                cmp     [cs:OldPos],ax
                jne     @@OKTrack
                ret
@@OKTrack:      mov     [cs:OldPos],ax
                mov     ax,[cs:offset MMus+(offset (SMus).EditOfs)]
                shr     ax,4
                mov     [cs:CurX],ax
                mov     [cs:CurX],ax
                mov     ax,[cs:offset MMus+(offset (SMus).EditPat)]
                mov     [cs:CurPat],ax
                call    DrawAll
@@NoRedraw:     mov     ax,[cs:offset MMus+(offset (SMus).EditOfs)]
                shr     ax,4
                add     ax,ax
                mov     bx,[cs:Screen]
                mov     es,bx
                mov     di,EfxY*160+EfxX*2+1
                add     di,ax
                mov     cx,41
@@RowLoop:      xor     [Byte es:di],00010000b
                add     di,160
                loop    @@RowLoop
@@Below:        ret
endp            PlotTrack

proc            GetInfo
                mov     bx,9
                mov     cx,1
                mov     si,seg MMus
                mov     di,offset MMus
                call    [dword cs:Music]
                ret
endp            GetInfo

proc            SetInfo
                mov     bx,0Ah
                mov     si,seg MMus
                mov     di,offset MMus
                call    [dword cs:Music]
                ret
endp            SetInfo

proc            DoItTrack
                call    GetInfo
                mov     cx,00000010b
                call    SetInfo
TrackLooper:    call    GetInfo
                call    PlotTrack
                mov     ah,1
                int     16h
                jnz     @@KeyHit
                jmp     TrackLooper
@@KeyHit:       mov     ah,0
                int     16h
;
@@Key_AltL:     cmp     ax,2600h
                jne     @@Key_Home
                call    LoadFile
                call    PlayMusic
                jmp     @@End
;
@@Key_Home:     cmp     ah,71
                jnz     @@Key_End
                mov     [Word cs:offset MMus+(offset (SMus).mt_PatternPos)],0
                mov     cx,00000010b
                call    SetInfo
                call    PlotTrack
                jmp     @@End
;
@@Key_End:      cmp     ah,79
                jnz     @@Key_F9
                mov     [Word cs:offset MMus+(offset (SMus).mt_PatternPos)],3F0h
                mov     cx,00000010b
                call    SetInfo
                call    PlotTrack
                jmp     @@End
;
@@Key_F9:       cmp     ah,67
                jnz     @@Key_F10
                cmp     [Byte cs:MMus+(offset (SMus).mt_SongPos)],0
                je      @@Key_F9_1
                dec     [Byte cs:offset MMus+(offset (SMus).mt_SongPos)]
@@Key_F9_1:     mov     [Word cs:offset MMus+(offset (SMus).mt_PatternPos)],0
                mov     cx,00000010b
                call    SetInfo
                call    PlotTrack
                jmp     @@End
;
@@Key_F10:      cmp     ah,68
                jnz     @@Key_1
                mov     al,[cs:songlen]
                dec     al
                cmp     [cs:offset MMus+(offset (SMus).mt_SongPos)],al
                je      @@Key_F10_1
                inc     [Byte cs:offset MMus+(offset (SMus).mt_SongPos)]
@@Key_F10_1:    mov     [Word cs:offset MMus+(offset (SMus).mt_PatternPos)],0
                mov     cx,00000010b
                call    SetInfo
                call    PlotTrack
                jmp     @@End
;
@@Key_1:        cmp     ah,3Bh
                jnz     @@Key_2
                mov     [Word cs:CurChannel],0
                call    DrawAllBot
                jmp     @@End
;
@@Key_2:        cmp     ah,3Ch
                jnz     @@Key_3
                mov     [Word cs:CurChannel],1
                call    DrawAllBot
                jmp     @@End
;
@@Key_3:        cmp     ah,3Dh
                jnz     @@Key_4
                mov     [Word cs:CurChannel],2
                call    DrawAllBot
                jmp     @@End
;
@@Key_4:        cmp     ah,3Eh
                jnz     @@Key_Enter
                mov     [Word cs:CurChannel],3
                call    DrawAllBot
                jmp     @@End
;
@@Key_Enter:    cmp     al,13
                jnz     @@Key_Esc
@@Key_Quit:     mov     cx,cs
                mov     si,offset P
                mov     bx,5
                call    [dword ptr cs:Music]
                ret
;
@@Key_Esc:      cmp     ah,1
                jnz     @@End
                jmp     @@Key_Quit
;
@@End:          jmp     TrackLooper
endp            DoItTrack



;2 1111111 111
;0 9876543 21098 7654321
;E F#G#A#B C#D#E F#G#A#B
;   3 4 5   7 8   0 - =
;Q W E R T Y U I O P [ ]
;33333 3322222 2222
;65432 1098765 4321
;C#D#E F#G#A#B C#D#
; S D   G H J   L ;
;Z X C V B N M , .
KeyName         db      ']=[-P0OI8U7YT5R4E3WQ;.L,MJNHBGVCDXSZ'
                        ;ES  1  2  3  4  5  6  7  8  9  0  -  =  BSTB
Keys            db     0, 0, 0, 0,18,16,14, 0,11, 9, 0, 6, 4, 2, 0, 0
                       ; Q  W  E  R  T  Y  U  I  O  P  [  ] EN CT
                db      20,19,17,15,13,12,10, 8, 7, 5, 3, 1, 0, 0
                       ; A  S  D  F  G  H  J  K  L  ;  '  ` LS
                db       0,35,33, 0,30,28,26, 0,23,21, 0, 0, 0
                       ; \  Z  X  C  V  B  N  M  ,  .  /
                db       0,36,34,32,31,29,27,25,24,22, 0
                db       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

proc            CheckKeys
                xor     bh,bh
                mov     bl,ah
                mov     al,[cs:bx+Keys]
                or      al,al
                jz      @@Exit
                xor     ah,ah
                dec     ax
                mov     [cs:CurY],ax
                call    SetNote
                call    DrawAllBot
@@Exit:         ret
endp            CheckKeys

CurPat          dw      0
CurChannel      dw      0
CurX            dw      0
CurY            dw      0
DefaultIns      db      0
proc            DoIt
                call    DrawAllBot
BottomPart:     mov     cx,0
                call    PlotXYBot
BottomLooper:   mov     ah,0
                int     16h
;
@@Key_AltL:     cmp     ax,2600h
                jne     @@Key_Tab
                call    LoadFile
                call    DrawAllBot
                jmp     @@End
;
@@Key_Tab:      cmp     al,9
                jne     @@Key_Up
                mov     [Byte cs:OffBot],1
                call    DrawAllTop
                mov     [Byte cs:OffBot],0
                jmp     TopPart
;
@@Key_Up:       cmp     ah,72
                jne     @@Key_Down
                cmp     [Word cs:CurY],0
                je      @@Key_Up_1
                dec     [Word cs:CurY]
                mov     cx,0
                call    PlotXYBot
@@Key_Up_1:     jmp     @@End
;
@@Key_Down:     cmp     ah,80
                jne     @@Key_Left
                cmp     [Word cs:CurY],35
                je      @@Key_Down_1
                inc     [Word cs:CurY]
                mov     cx,0
                call    PlotXYBot
@@Key_Down_1:   jmp     @@End
;
@@Key_Left:     cmp     ah,75
                jne     @@Key_Right
                cmp     [Word cs:CurX],0
                je      @@Key_Left_1
                dec     [Word cs:CurX]
                mov     cx,0
                call    PlotXYBot
@@Key_Left_1:   jmp     @@End
;
@@Key_Right:    cmp     ah,77
                jne     @@Key_Space
                cmp     [Word cs:CurX],63
                je      @@Key_Right_1
                inc     [Word cs:CurX]
                mov     cx,0
                call    PlotXYBot
@@Key_Right_1:  jmp     @@End
;
@@Key_Space:    cmp     al,' '
                jnz     @@Key_Del
                call    SetNote
                call    DrawAllBot
                jmp     @@End
;
@@Key_Del:      cmp     ah,83
                jnz     @@Key_PgUp
                call    DelNote
                call    DrawAllBot
                jmp     @@End
;
@@Key_PgUp:     cmp     ah,73
                jnz     @@Key_PgDn
                cmp     [Word cs:CurY],0
                je      @@Key_PgUp_1
                mov     [Word cs:CurY],0
                mov     cx,0
                call    PlotXYBot
@@Key_PgUp_1:   jmp     @@End
;
@@Key_PgDn:     cmp     ah,81
                jnz     @@Key_Home
                cmp     [Word cs:CurY],35
                je      @@Key_PgDn_1
                mov     [Word cs:CurY],35
                mov     cx,0
                call    PlotXYBot
@@Key_PgDn_1:   jmp     @@End
;
@@Key_Home:     cmp     ah,71
                jnz     @@Key_End
                cmp     [Word cs:CurX],0
                je      @@Key_Home_1
                mov     [Word cs:CurX],0
                mov     cx,0
                call    PlotXYBot
@@Key_Home_1:   jmp     @@End
;
@@Key_End:      cmp     ah,79
                jnz     @@Key_CLeft
                cmp     [Word cs:CurX],63
                je      @@Key_End_1
                mov     [Word cs:CurX],63
                mov     cx,0
                call    PlotXYBot
@@Key_End_1:    jmp     @@End
;
@@Key_CLeft:    cmp     ah,115
                jnz     @@Key_CRight
                call    DeleteCol
                call    DrawAllBot
                jmp     @@End
;
@@Key_CRight:   cmp     ah,116
                jnz     @@Key_F9
                call    InsertCol
                call    DrawAllBot
                jmp     @@End
;
@@Key_F9:       cmp     ah,67
                jnz     @@Key_F10
                cmp     [Word cs:CurPat],0
                jz      @@Key_F9_1
                dec     [Word cs:CurPat]
                call    DrawAllBot
@@Key_F9_1:     jmp     @@End
;
@@Key_F10:      cmp     ah,68
                jnz     @@Key_1
                xor     ah,ah
                mov     al,[cs:songlen]
                dec     ax
                cmp     [cs:CurPat],ax
                jz      @@Key_F10_1
                inc     [Word cs:CurPat]
                call    DrawAllBot
@@Key_F10_1:    jmp     @@End
;
@@Key_1:        cmp     ah,3Bh
                jnz     @@Key_2
                mov     [Word cs:CurChannel],0
                call    DrawAllBot
                jmp     @@End
;
@@Key_2:        cmp     ah,3Ch
                jnz     @@Key_3
                mov     [Word cs:CurChannel],1
                call    DrawAllBot
                jmp     @@End
;
@@Key_3:        cmp     ah,3Dh
                jnz     @@Key_4
                mov     [Word cs:CurChannel],2
                call    DrawAllBot
                jmp     @@End
;
@@Key_4:        cmp     ah,3Eh
                jnz     @@Key_Enter
                mov     [Word cs:CurChannel],3
                call    DrawAllBot
                jmp     @@End
;
@@Key_Enter:    cmp     al,13
                jnz     @@Key_Esc
                call    PlayMusic
                call    DoItTrack
                call    DrawAllBot
                jmp     @@End
;
@@Key_Esc:      cmp     ah,1
                jnz     @@CheckKeys
                ret
;
@@CheckKeys:    call    CheckKeys
@@End:          jmp     BottomLooper
endp            DoIt


proc            LoadFile
                call    FileSelect
                jb      @@EndError
                mov     cx,cs
                mov     si,offset P
                mov     bx,5
                call    [dword ptr cs:Music]
                push    es dx
                call    MUS_KillModule
                pop     dx cx
                call    MUS_LoadModule
                call    GetInfo
                mov     [Byte cs:offset MMus+(offset (SMus).mt_speed)],6
                mov     [Byte cs:offset MMus+(offset (SMus).mt_counter)],5
                mov     cx,0
                call    SetInfo
                mov     [Word cs:CurPat],0
                mov     [Word cs:CurX],0
                mov     [Word cs:CurY],0
                mov     [Word cs:CurYTop],0
                mov     [Word cs:CurChannel],0
@@End:          clc
                ret
@@EndError:     stc
                ret
endp            LoadFile

proc            FileSelect
                mov     di,55
                mov     bx,0
                mov     ah,1Fh
                mov     al,1
                mov     cx,24
                mov     dx,50
                call    DrawBox
                call    DisplayAll
                mov     ax,MyData
                mov     ds,ax
@@TopLoop:      mov     ah,0
                int     16h
;
@@Key_AltL:     cmp     ax,2600h
                jne     @@Key_Up
                call    FileSelect

;
@@Key_Up:       cmp     ah,72
                jne     @@Key_Down
                cmp     [Word CurFile],0
                jz      @@Beep
                dec     [Word CurFile]
                mov     bx,[CurFile]
                sub     bx,[TopFile]
                jns     @@PrintIt
                dec     [Word TopFile]
                jmp     @@PrintIt
;
@@Key_Down:     cmp     ah,80
                jne     @@Key_Home
                mov     bx,[NumFiles]
                dec     bx
                cmp     [CurFile],bx
                jz      @@Beep
                inc     [Word CurFile]
                mov     bx,[CurFile]
                sub     bx,[TopFile]
                cmp     bx,47
                jl      @@PrintIt
                inc     [Word TopFile]
                jmp     @@PrintIt
;
@@Key_Home:     cmp     ah,71
                jne     @@Key_End
                cmp     [Word CurFile],0
                jnz     @@SetTop
                cmp     [Word TopFile],0
                jz      @@Beep
@@SetTop:       mov     [Word CurFile],0
                mov     [Word TopFile],0
                jmp     @@PrintIt
;
@@Key_End:      cmp     ah,79
                jne     @@Key_PgUp
                mov     bx,[NumFiles]
                dec     bx
                cmp     [CurFile],bx
                jnz     @@SetBottom
                sub     bx,[TopFile]
                cmp     bx,47
                jl      @@Beep
@@SetBottom:    mov     bx,[NumFiles]
                dec     bx
                mov     [CurFile],bx
                sub     bx,46
                js      @@FixBottom
                mov     [TopFile],bx
                jmp     @@PrintIt
@@FixBottom:    mov     [Word TopFile],0
                jmp     @@PrintIt
;
@@Key_PgUp:     cmp     ah,73
                jne     @@Key_PgDn
                cmp     [Word CurFile],0
                jz      @@Beep
                sub     [Word CurFile],47
                js      @@FixPgUp
                sub     [Word TopFile],47
                js      @@FixPgUp2
                jmp     @@PrintIt
@@FixPgUp:      mov     [Word CurFile],0
@@FixPgUp2:     mov     [Word TopFile],0
                jmp     @@PrintIt
;
@@Key_PgDn:     cmp     ah,81
                jne     @@Key_Enter
                mov     dx,[NumFiles]
                dec     dx
                cmp     [CurFile],dx
                jz      @@Beep
                add     [Word CurFile],47
                cmp     [CurFile],dx
                jg      @@FixPgDn
                add     [Word TopFile],47
                cmp     [Word TopFile],dx
                jg      @@FixPgDn2
                jmp     @@PrintIt
@@FixPgDn:      mov     [Word CurFile],dx
@@FixPgDn2:     sub     dx,46
                js      @@FixPgDn3
                mov     [TopFile],dx
                jmp     @@PrintIt
@@FixPgDn3:     mov     [Word TopFile],0
                jmp     @@PrintIt
;
@@Key_Enter:    cmp     al,13
                jnz     @@Key_Esc
                call    SelectFile
                jnb     @@End
                clc
                ret
;
@@Key_Esc:      cmp     ah,1
                jnz     @@End
                stc
                ret
;
@@Beep:         clc
                jmp     @@End
;
@@PrintIt:      call    DisplayAll
                clc
                jmp     @@End
;
@@End:          jmp     @@TopLoop
endp            FileSelect

proc            SelectFile
                push    ds
                mov     ax,size FStruc
                mul     [CurFile]
                lds     di,[FileSeg]
                add     di,ax
                mov     dx,di
                cmp     [di+FStruc.TypeOfFile],F_Directory
                jnz     @@MustBeAModule
                mov     AH,3Bh
                int     21h             ;2-Change_Directory
                call    ReadFiles
                call    DisplayAll
                pop     ds
                clc
                ret
@@MustBeAModule:
                mov     ax,ds
                mov     es,ax
                pop     ds
                stc
                ret
endp            SelectFile

;                Mode    =  0    -->  Outline
;                           1    -->  Fill
; cx - SizeX
; dx - SizeY
; ah - Color
; al - Mode
; di - X
; bx - Y
                mov     di,55
                mov     bx,0
                mov     ah,1Fh
                mov     al,1
                mov     cx,24
                mov     dx,50
proc            DrawBox
                push    es ax dx
                mov     ax,[cs:Screen]
                mov     es,ax
                add     di,di
                mov     ax,160
                mul     bx
                add     di,ax

                mov     bx,160
                sub     bx,cx
                sub     bx,cx

                cld
                pop     dx ax
                cmp     al,1
                jne     @@OutlineTop
                mov     al,' '
@@FillLoop:     push    cx
                rep     stosw
                add     di,bx
                pop     cx
                dec     dx
                jnz     @@FillLoop
                jmp     @@Done

@@OutlineTop:   push    cx
                rep     stosb
                add     di,bx
                pop     cx
@@OutlineSides: stosb
                add     di,cx
                sub     di,2
                stosb
                add     di,bx
                dec     dx
                cmp     dx,2
                jne     @@OutlineSides

@@OutlineBottom:pop     cx
                rep     stosb

@@Done:         pop     es
                ret
endp            DrawBox


proc            Main
Start:          mov     [cs:PspAddress],es
                mov     ax,es
                mov     bx,zzzzzseg
                sub     bx,ax
                add     bx,2
                mov     [cs:SizeOfProg],bx
                mov     ah, 4ah
                int     21h

                call    HowMuchMemory
                call    DetermineDisplay
                mov     ax,MyData
                mov     ds,ax
                mov     ah,47h
                mov     dl,0
                mov     si,offset HomeDirectory
                int     21h
                mov     ah,19h
                int     21h
                mov     [OldDrive],al

                call    SetEnv
@@LoadDriver:   mov     si,offset SoundFile
                call    PutName
		mov	dx,offset GDirectory
                mov     cx,seg GDirectory
                call    LoadSoundDriver
                jnb     @@DriverLoaded
                mov     dx,offset NoDriverFound
                call    Error
@@DriverLoaded: mov     ax,[cs:GUSIRQ]
                mov     bx,0
                mov     cx,[cs:GUSMIDI]
                mov     dx,[cs:GUSPort]
                mov     si,[cs:DMAIn]
                mov     di,[cs:DMAOut]
                call    [dword ptr cs:Music]
                jnb     @@FoundCard
                mov     ah,9
                mov     dx,offset NoGUS
                int     21h
                jmp     @@Quit
@@FoundCard:    mov     [cs:GUSIRQ],si
                mov     [cs:GUSPort],di

                call    SetMode
                mov     ax,1112h
                mov     bl,0
                int     10h

                mov     [Word cs:offset P+(offset (PM).Header)],offset Header
                mov     [Word cs:offset P+(offset (PM).Header)+2],cs
                mov     [Word cs:offset P+(offset (PM).PatternLoc)],offset PatternLoc
                mov     [Word cs:offset P+(offset (PM).PatternLoc)+2],cs
                mov     [Word cs:offset P+(offset (PM).InsLoc)],offset InsLoc
                mov     [Word cs:offset P+(offset (PM).InsLoc)+2],cs

                mov     ax,MyData
                mov     ds,ax
                xor     dx,dx
                mov     ax,size FStruc
                mov     bx,[MaxFiles]
                mul     bx
                mov     bx,ax
                shr     bx,4
                add     bx,1
                mov     ah,48h
                int     21h
                mov     [Word FileSeg+2],ax
                mov     [Word FileSeg],0
                call    ReadFiles

                mov     ah,48h
                mov     bx,8000/16+1
                int     21h
                mov     [cs:ScreenFix],ax
                mov     ax,MyData
                mov     ds,ax
                mov     dx,offset ScreenFilename
                mov     ax,3D00h
                int     21h
                mov     bx,ax
                mov     ax,[cs:ScreenFix]
                mov     ds,ax
                mov     dx,0
                mov     cx,8000
                mov     ax,3F00h
                int     21h
                mov     ax,3E00h
                int     21h
                call    DrawNotes
                call    LoadFile
                jb      @@Quit
                call    DoIt
                call    MUS_KillModule

@@Quit:         call    Terminate
endp            Main

ends            MyCode

segment         BlankMusicSeg
                stc
                retf
ends            BlankMusicSeg

segment         MyData

ScreenFilename  db      'SCREEN.BIN',0
Notes           db      'B-3A#3A-3G#3G-3F#3F-3E-3D#3D-3C#3C-3'
                db      'B-2A#2A-2G#2G-2F#2F-2E-2D#2D-2C#2C-2'
                db      'B-1A#1A-1G#1G-1F#1F-1E-1D#1D-1C#1C-1'

NoGUS           db      'Could not detect a Gravis Ultrasound card.',13,10,'$'
NoFileName      db      'Usage: GUSMOD filename<.mod>',13,10,'$'
NoFileFound     db      'File not found.',13,10,'$'
NoDriverFound   db      'Sound driver not found.',13,10,'$'
NoEnvFound      db      'The environment variable GUSMOD was not found.  Please add it to your',13,10
                db      'AUTOEXEC.BAT file.  Please read GUSMOD.DOC for more information.',13,10,'$'
IllegalEnv      db      'Illegal environment variable.',13,10,'$'

GDirectory      db      120 dup (0)
GEnv            db      6,"GUSMOD"
PutFilename     dw      0

db  '\'
HomeDirectory   db      80 dup (0)
OldDrive        db      0

NewDTA          DTA     <>

MaxFiles        dw      500
NumFiles        dw      0
FileSeg         dd      0

WildDir         db      "*.*",0
WildMod         db      "*.MOD",0
DriveLetter     db      "-:\"
CurPath         db      65 dup (0)

DriveStr        db      "-:",0
DriveList       db      26 dup (0)

MKLine          db      9 dup (0)
Ext             db      4 dup (0)
ExtBlank        db      "~ ",0
DesBlank        db      "~ ",0

FileDigits      db      "0000",0

CurFile         dw      0
TopFile         dw      0

ends            MyData

segment         zzzzzseg
                db      16 dup (?)
ends            zzzzzseg

        end     Start


