/***************************************************************************
*	NAME:  VOCALOC.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	03/21/93		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "ultraerr.h"

extern ULTRA_DATA _gf1_data;

void 
UltraClearVoices(void)
{
_gf1_data.used_voices = 0L;
}

int
UltraAllocVoice(int voice_num,int *new_num)
{
unsigned long i;

if (voice_num >= _gf1_data.voices)
	return(VOICE_OUT_OF_RANGE);

if (voice_num != -1)
	{
	if (!(_gf1_data.used_voices & (1L<<voice_num)))
		{
		;	/* do nothing, allocate it below */
		}
	else
		{
		return (VOICE_NOT_FREE);
		}
	}
else
	{
	voice_num = 99;
	for (i=0;i<(unsigned long)_gf1_data.voices;i++)
		{
		if (!(_gf1_data.used_voices & (1L<<i)))
			{
			voice_num = i;
			break;
			}
		}
	}

if (voice_num >= _gf1_data.voices)
	return(NO_FREE_VOICES);

_gf1_data.used_voices |= (1L << voice_num);

*new_num = voice_num;

return(ULTRA_OK);
}

void
UltraFreeVoice(int voice_num)
{
_gf1_data.used_voices &= ~(1L<<voice_num);
}


