/***************************************************************************
*	NAME:  VOL0RAMP.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraRampVolume(int voice,unsigned int start,unsigned int end,unsigned char rate,unsigned char mode)
// int voice;					/* voice to use */
// unsigned int start;			/* start value (0-511) */
// unsigned int end;			/* end value (0-511) */
// unsigned char rate;			/* range/rate value to stuff */
// unsigned char mode;			/* mode to run the volume (loop etc) */
{
unsigned int begin;
unsigned char vmode;

	if (start == end)
		return;
/*********************************************************************
 * If the start volume is greater than the end volume, flip them and
 * turn on decreasing volume. Note that the GF1 requires that the
 * programmed start volume MUST be less than or equal to the end
 * volume.
 *********************************************************************/
	/* Don't let bad bits thru ... */
	mode &= ~(VL_IRQ_PENDING|VC_ROLLOVER|STOP_VOLUME|VOLUME_STOPPED);

	begin = start;

	if (start > end)
		{
		/* flip start & end if decreasing numbers ... */
		start = end;
		end = begin;
		mode |= VC_DIRECT;		/* decreasing volumes */
		}

	/* looping below 64 or greater that 4032 can cause strange things */
	if (start < 64)
		start = 64;

	if (end > 4032)
		end = 4032;

	ENTER_CRITICAL;

	outp(_gf1_data.voice_select,voice);
	outp(_gf1_data.reg_select,SET_VOLUME_RATE);
	outp(_gf1_data.data_hi,rate);
	outp(_gf1_data.reg_select,SET_VOLUME_START);
	outp(_gf1_data.data_hi,(unsigned char)(start>>4));
	outp(_gf1_data.reg_select,SET_VOLUME_END);
	outp(_gf1_data.data_hi,(unsigned char)(end>>4));

	/* Also MUST set the current volume to the start volume ... */
	UltraSetVolume(voice,begin);

	outp(_gf1_data.reg_select,GET_VOLUME_CONTROL);
	vmode = inp(_gf1_data.data_hi);
	if (vmode & VC_ROLLOVER)
		mode |= VC_ROLLOVER;

	/* start 'er up !!! */
	outp(_gf1_data.reg_select,SET_VOLUME_CONTROL);
	outp(_gf1_data.data_hi,mode);

	gf1_delay();

	outp(_gf1_data.data_hi,mode);

	LEAVE_CRITICAL;
}


