; Copyright 1993 Apteryx Lisp Ltd

;;; Lesson 1

; Welcome to Apteryx Lisp, the easy-to-use Lisp system for Windows (TM).

Lisp is a computer programming language, i.e. a language that tells a
computer how to process information.

Information processing generally involves input information and output
information. The input information is what we already know, the output
information is something that we would like to know, which can be calculated
in some way from the input information.

This general concept of information processing can be identified with the
mathematical concept of a function. A function is something that takes an
input argument or arguments (i.e. the input information) and returns a
result (i.e. the output information).

To clarify the concept further we must know what information. We can define
a piece of information to be a particular value that comes from a certain 
set of values. For example a natural number is a particular value from the
set of natural numbers i.e. {0, 1, 2, 3 ... etc.}. The set of possible values
is sometimes called a data-type (particularly in computer science).

The data value might tell us something about the real world, for example a 
number might be the number of apples in a barrel.

A simple and familiar example of a function is addition, which we can 
represent with the symbol +. Its required input is two numbers, and the
output returned is the sum of those two numbers.

The following is a Lisp program that adds two numbers -

(+ 23 145)

To execute, first choose Tile with Output from the Window menu so that
you can see this window and the LispOutput window,
then place the text cursor after the right bracket, and press the key F4
(or choose the menu option Lisp:Eval). The result of executing this function
should appear in the LispOutput window. If you like, try changing the 
numbers and re-execute the function, seeing what result you get.

We can make the output of one program the input to another, simply by
writing the first program where the required input for the second program
goes. For example -

(* 10 (+ 23 145))

where * represents multiplication. Try evaluating this expression (using F4).
The result of (+ 23 145) = 168 becomes one of the inputs to the function *,
so that the final result returned is 168 * 10 = 1680.

One thing about Lisp that distinguishes it from virtually all other computer
programming languages is that the programs themselves are data, i.e. values
from a set of possible values. For example the expression (* 10 (+ 23 145))
describes a list of three elements which are the symbol *, the number 10
and (+ 23 145) which is itself a list of three elements - the symbol +,
the number 23 and the number 145. (Because the numbers don't have decimal
points they are regarded as integers, which are distinguished from floating
point numbers.)

There are Lisp functions that take lists as arguments. To pass a list as
an argument to a function we must put a quote character ' in front of it,
so that it is not interpreted as a function. For example, length is the name
of a function that takes a list as input and returns the number of elements
in the list. Try executing the following -

(length '(Sam jim fred tom))

If the quote were left out, Lisp would first try to calculate the result of 
(Sam jim fred tom) but would fail because there is no function called 
Sam. The process of calculating the final result of an expression is
called evaluation. We can say that the quote suppresses evaluation.

There is a function called eval which evaluates its argument. Here is an
example which also uses a function called append, which sticks two or more
lists together -

(eval (append '(+) '(4 5)))

The final result should be 9. What happens is that first the expression
(append '(+) '(4 5)) returns the result (+ 4 5), and then the function
eval evaluates this list to return the final result 9.

Apteryx Lisp has a facility that lets you evaluate partial expressions. Simply
select the desired selection using the mouse, for example
 (append '(+) '(4 5)) in the expression above, and then press F4. The 
selected expression will then be evaluated. A failure to select the 
sub-expression properly may result in an error of some sort. One way to 
avoid this sort of error is to let Apteryx Lisp help you select the expression.
For example, put the text cursor just before the second bracket, and
press Shift-Ctrl right arrow, i.e. hold down the Shift and Ctrl keys and
press the right arrow key. You should see the required sub-expression 
selected. You can then press F4 to evaluate it.

;;; Top-level expressions and indentation.

When you press F4 and there isn't a current text selection, Apteryx Lisp uses
special rules to decide which is the expression to be executed. Basically,
Apteryx Lisp looks for a top-level expression that the text cursor is in or 
after. A top-level expression is one that is not contained in any other 
expression. To avoid long searches up and down a file to determine if an
expression is actually contained in a larger expression, Apteryx Lisp makes the
assumption that an open bracket (or one of various other characters that
can start an expression), which is hard up against the left margin, is
the start of a top level expression. To be consistent with this convention,
it is desirable that any sub-expression does not start at the beginning of
a line. For example, the following expression takes up more than one line -

(+ 3
  (* 5 6) )

We can place the cursor at the end of the expression, and press F2, which
will select the whole expression.

We notice that the sub-expression (* 5 6) is indented. Indentation is 
desirable because it helps us to read complex nested lists. Apteryx Lisp
has various automatic indentation facilities that help us indent 
expressions. These are -

Ctrl-Enter  Starts a new line that is correctly indented.
Tab         Correctly indents the current line.
F5          Corrects the indentation for the top-level expression selected
            or implied by the text cursor.

It should be noted that these facilities use the same convention as F4
and F2 to determine what is a top-level expression.

(+ 3 4
(* 5 6) )

If we put the text cursor after the last bracket above, and press F5, to
correct indentation, we actually get a syntax error, because Apteryx Lisp finds
a non-indented open bracket at the beginning of (* 5 6), and parses
forward, eventually finding an unbalanced right bracket at the end of the
line, which causes the error. For the above example we can avoid the error
by using Tab, which assumes that the current line might not be the
start of a top-level expression, even if it is indented. If we've got
a whole lot of unindented lines, we have to go to the first line and from
there use F5.

(put cursor on this line
(and
(see
(these lines
(move left when you press F5) ) ) )

Apteryx Lisp will keep telling you that it's found a non-indented non-top-level
expression, and you have to use Tab to indent each one. This seems a bit
annoying, but avoids the problems caused by leaving out one right bracket,
and having Apteryx Lisp interpret the whole of the rest of your program file
as part of one expression (eventually failing when it gets to the bottom
of the file still missing a required right bracket).

The best strategy is always use Ctrl-Enter to start a new line while typing
Lisp expressions, and use Tab immediately if you forget to do so. F5 is 
useful when you do something that changes the nested depth of part of
an expression.




