{ Program:   Zoom
  Version:   1.00
  Purpose:   zooms part of the desktop
  Date:      08.10.1992

  Developer: Peter Sawatzki (PS)
             Buchenhof 3, D-5800 Hagen 1, Germany
 CompuServe: 100031,3002
       FIDO: 2:245/5800.17

  Date:     Author:
  08.10.92  PS       written

  Copyright (c) 1993 Peter Sawatzki. All Rights Reserved.
}
Program Zoom;

{$R Zoom!.Res}
Uses
  oWindows,
  WinTypes,
  WinProcs,
  Strings,
  CustomWn,
  DialogWn;

Type
  pZoomWindow = ^tZoomWindow;
  tZoomWindow = Object(tCustomWindow)
    StayOnTop: Boolean;
    UpdateTime,
    DrawGrid: Integer;
    FocPoint: tPoint;
    DraggingW,
    DraggingH,
    MagFactor: Integer;
    Constructor Init (aParent: pWindowsObject; aTitle: pChar);
    Destructor Done; Virtual;
    Procedure SetupWindow; Virtual;
    Procedure GetWindowClass(var WndClass: TWndClass); virtual;
    Procedure Paint (PaintDC: hDC; Var PaintInfo: tPaintStruct); Virtual;
    Procedure wmSysCommand (Var Msg: tMessage); Virtual wm_First+wm_SysCommand;

    Procedure wmTimer       (Var Msg: tMessage); Virtual wm_First+wm_Timer;
    Procedure wmLButtonDown (Var Msg: tMessage); Virtual wm_First+wm_LButtonDown;
    Procedure wmMouseMove   (Var Msg: tMessage); Virtual wm_First+wm_MouseMove;
    Procedure wmLButtonUp   (Var Msg: tMessage); Virtual wm_First+wm_LButtonUp;
    Procedure wmRButtonUp   (Var Msg: tMessage); Virtual wm_First+wm_RButtonUp;
    Procedure wmEraseBkGnd  (Var Msg: tMessage); Virtual wm_First+wm_EraseBkGnd;
    Procedure GetFocusPoint (aPoint: LongInt);
    Procedure DragRect;
  End;

  pAboutWindow = ^tAboutWindow;
  tAboutWindow = Object(tJanusDialogWindow)
    Procedure wmLButtonUp (Var Msg: tMessage); Virtual wm_First+wm_LButtonUp;
  End;

Const
  ProgName   = 'Zoom!';
  sc_About   = $100;

{----------- tZoomWindow}

Constructor tZoomWindow.Init (aParent: pWindowsObject; aTitle: pChar);
Begin
  Inherited Init(aParent, aTitle);
  Attr.Style:= ws_ThickFrame+ws_Caption+ws_Popup+ws_SysMenu;
  DraggingW:= 0;
  DraggingH:= 0;

  StayOnTop:= Boolean(GetProfileInt(ProgName, 'StayOnTop', 1));
  UpdateTime:= GetProfileInt(ProgName, 'Time', 1500);
  Attr.w:= GetProfileInt(ProgName, 'Width', 150);
  Attr.h:= GetProfileInt(ProgName, 'Height', 100);
  Attr.x:= GetProfileInt(ProgName, 'xPos', GetSystemMetrics(sm_CxScreen)-Attr.w);
  Attr.y:= GetProfileInt(ProgName, 'yPos', GetSystemMetrics(sm_CyScreen)-Attr.h);
  FocPoint.x:= GetProfileInt(ProgName, 'xFocus', 0);
  FocPoint.y:= GetProfileInt(ProgName, 'yFocus', 0);
  MagFactor:=  GetProfileInt(ProgName, 'Magnification', 4);
  DrawGrid:=   GetProfileInt(ProgName, 'DrawGrid', 4);

  If StayOnTop Then
    Attr.ExStyle:= 8; {ws_ExTopMost}
End;

Destructor tZoomWindow.Done;
  Function WriteProfileInt (AppName, KeyName: pChar; anInt: Integer): Boolean;
  Var
    aTmp: Array[0..30] Of Char;
  Begin
    Str(anInt, aTmp);
    WriteProfileInt:= WriteProfileString(AppName, KeyName, aTmp)
  End;
Begin
  KillTimer(hWindow, 1);
  WriteProfileInt(ProgName, 'StayOnTop', Integer(StayOnTop));
  WriteProfileInt(ProgName, 'Time', UpdateTime);
  WriteProfileInt(ProgName, 'Width',  Attr.w);
  WriteProfileInt(ProgName, 'Height', Attr.h);
  WriteProfileInt(ProgName, 'xPos',   Attr.x);
  WriteProfileInt(ProgName, 'yPos',   Attr.y);
  WriteProfileInt(ProgName, 'xFocus', FocPoint.x);
  WriteProfileInt(ProgName, 'yFocus', FocPoint.y);
  WriteProfileInt(ProgName, 'Magnification', MagFactor);
  WriteProfileInt(ProgName, 'DrawGrid', DrawGrid);
  Ancestor.Done
End;

Procedure tZoomWindow.SetupWindow;
Var
  SysMenu: hMenu;
  i: Integer;
Begin
  Ancestor.SetupWindow;
  SysMenu:= GetSystemMenu(hWindow, False);
  RemoveMenu(SysMenu, sc_Restore,  mf_ByCommand);
  RemoveMenu(SysMenu, sc_Minimize, mf_ByCommand);
  RemoveMenu(SysMenu, sc_Maximize, mf_ByCommand);
  RemoveMenu(SysMenu, 2, mf_ByPosition);
  RemoveMenu(SysMenu, sc_TaskList, mf_ByCommand);
  AppendMenu(SysMenu, mf_String, sc_About,   '&About...');
  If UpdateTime<>0 Then
    SetTimer(hWindow, 1, UpdateTime, Nil)
End;

Procedure tZoomWindow.GetWindowClass(Var WndClass: TWndClass);
Begin
  Ancestor.GetWindowClass(WndClass);
  WndClass.lpszMenuName:= Nil
End;

Procedure tZoomWindow.Paint (PaintDC: hDC; Var PaintInfo: tPaintStruct);
Var
  DisplayDC,
  MemDC: hDC;
  OldBmp, MemBmp: hBitmap;
  SrcRect, DstRect: tRect;
  i: Integer;
  Grid: Boolean;
Begin
  DisplayDC:= GetDC(0);
  If DisplayDC=0 Then
    Exit;
  Grid:= (DraggingW=0) And (DrawGrid<>0) And (MagFactor>DrawGrid);
  DstRect:= PaintInfo.rcPaint;
  With DstRect Do Begin
    Dec(left, left Mod MagFactor);
    Dec(top, top Mod MagFactor);
    right:= ((right+MagFactor-1) Div MagFactor)* MagFactor;
    bottom:= ((bottom+MagFactor-1) Div MagFactor)* MagFactor
  End;
  SrcRect.left:=   FocPoint.x+ DstRect.left   Div MagFactor;
  SrcRect.right:=  FocPoint.x+ DstRect.right  Div MagFactor;
  SrcRect.top:=    FocPoint.y+ DstRect.top    Div MagFactor;
  SrcRect.bottom:= FocPoint.y+ DstRect.bottom Div MagFactor;

  If Grid Then With DstRect Do Begin
    MemDC:= CreateCompatibleDC(DisplayDC);
    MemBmp:= CreateCompatibleBitmap(DisplayDC, right-left, bottom-top);
    OldBmp:= SelectObject(MemDC, MemBmp);
    StretchBlt(MemDC, left, top, right-left, bottom-top,
               DisplayDC, SrcRect.left, SrcRect.top,
               SrcRect.right-SrcRect.left, SrcRect.bottom-SrcRect.top,
               SrcCopy);
    i:= left+MagFactor-1;
    While i<right Do Begin
      PatBlt(MemDC, i, top, 1, bottom-top, Blackness);
      Inc(i, MagFactor)
    End;
    i:= top+MagFactor-1;
    While i<bottom Do Begin
      PatBlt(MemDC, left, i, right-left, 1, Blackness);
      Inc(i, MagFactor)
    End;
    BitBlt(PaintDC, left, top, right-left, bottom-top, MemDC, left, top, SrcCopy);
    SelectObject(MemDC, OldBmp);
    DeleteObject(MemBmp);
    DeleteDC(MemDC)
  End Else
    StretchBlt(PaintDC,   DstRect.left, DstRect.top, DstRect.right-DstRect.left, DstRect.bottom-DstRect.top,
               DisplayDC, SrcRect.left, SrcRect.top, SrcRect.right-SrcRect.left, SrcRect.bottom-SrcRect.top,
               SrcCopy);
  ReleaseDC(0, DisplayDC)
End;

Procedure tZoomWindow.wmSysCommand (Var Msg: tMessage);
Begin
  Case Msg.wParam Of
    sc_About:   ExecDialogWindow(New(pAboutWindow,Init(@Self, 'About', True)));
  Else
    Inherited wmSysCommand(Msg)
  End
End;

Procedure tZoomWindow.wmTimer (Var Msg: tMessage);
Begin
  If DraggingW=0 Then
    InvalidateRect(hWindow, Nil, False)
End;

Procedure tZoomWindow.wmLButtonDown (Var Msg: tMessage);
Var
  aRect: tRect;
Begin
  SetCapture(hWindow);
  GetClientRect(hWindow, aRect);
  With aRect Do Begin
    DraggingW:= (right-left) Div MagFactor;
    DraggingH:= (bottom-top) Div MagFactor
  End;
  GetFocusPoint(Msg.lParam);
  DragRect;
  InvalidateRect(hWindow, Nil, False)
End;

Procedure tZoomWindow.wmMouseMove (Var Msg: tMessage);
Begin
  If DraggingW<>0 Then Begin
    DragRect;
    GetFocusPoint(Msg.lParam);
    DragRect;
    InvalidateRect(hWindow, Nil, False)
  End
End;

Procedure tZoomWindow.wmLButtonUp (Var Msg: tMessage);
Begin
  If DraggingW<>0 Then Begin
    ReleaseCapture;
    DragRect;
    GetFocusPoint(Msg.lParam);
    InvalidateRect(hWindow, Nil, False)
  End;
  DraggingW:= 0;
End;

Procedure tZoomWindow.wmRButtonUp (Var Msg: tMessage);
Begin
  Inc(MagFactor);
  If MagFactor>30 Then
    MagFactor:= 1;
  InvalidateRect(hWindow, Nil, False)
End;

Procedure tZoomWindow.wmEraseBkGnd (Var Msg: tMessage);
Begin
End;

Procedure tZoomWindow.GetFocusPoint (aPoint: LongInt);
Begin
  FocPoint:= tPoint(aPoint);
  ClientToScreen(hWindow, FocPoint);
  Dec(FocPoint.x, DraggingW Div 2);
  Dec(FocPoint.y, DraggingH Div 2)
End;

Procedure tZoomWindow.DragRect;
Var
  DisplayDC: hDC;
  aRect: tRect;
Begin
  DisplayDC:= GetDC(0);
  If DisplayDC=0 Then Exit;
  With aRect, FocPoint Do Begin
    left:= x;
    top:= y;
    right:= left+DraggingW;
    bottom:= top+DraggingH;
    InflateRect(aRect, 1, 1)
  End;
  DrawFocusRect(DisplayDC, aRect);
  ReleaseDC(0, DisplayDC)
End;

{----------- tAboutWindow}

Procedure tAboutWindow.wmLButtonUp (Var Msg: tMessage);
Begin
  CloseWindow
End;

{-------------------- the Application part }
Type
  tZoomApp = Object(TApplication)
    Procedure InitMainWindow; Virtual;
  End;

Procedure tZoomApp.InitMainWindow;
Begin
  MainWindow:= New(pZoomWindow, Init(Nil, ProgName))
End;

Var
  App: tZoomApp;
Begin With App Do Begin
  Init(ProgName);
  Run;
  Done
End End.
