//*****************************************************************************
//*****************************************************************************

#ifndef _OTAPI_H
#define _OTAPI_H

//------------------------------------------------------------------------------
// Min/Max bounds
//
#define MAX_PROPERTIES     128
#define MAX_STR_OBJECTNAME 128
#define MAX_CTLTEXT        128
#define MAX_STR_TEXT       255

//------------------------------------------------------------------------------
// Stock property ids
//
#define PROPID_BOOLEAN          1   
#define PROPID_FONT             2   
#define PROPID_NAME             3
#define PROPID_LISTSINGLE       4
#define PROPID_LISTSINGLEBMP    5
#define PROPID_COMPOUND         6
#define PROPID_LISTMULTIPLE     7
#define PROPID_INTEGER          8
#define PROPID_COLORREF         9

#define PROPID_LAST            255 

// Minimum value for custom property ids
#define PROPID_CUSTOM          PROPID_LAST + 1   


//------------------------------------------------------------------------------
// Inspector dlg ctrl ids
//
#define IDC_PROPLIST     101  // Listbox of properties
#define IDC_PROPAREA     102  // Statec area contains the property dlgs
#define IDC_PROPHELP     103  // Static text containing help text
#define IDC_PROPLABEL    104  // Static text containing prop label (same as list item)
#define IDC_PROPUNDO     105  // Button for undo
#define IDC_PROPREDO     106  // Button for redo
#define IDC_PROPUNDOALL  107  // Button for undo all
#define IDC_PROPCLOSE    108  // Button for closing window
#define IDC_PROPDEFAULT  109  // Button for default

extern "C" BOOL FAR PASCAL _export SInspectDlgProc( HWND, UINT, WPARAM, LPARAM );
extern "C" BOOL FAR PASCAL _export SPropGroupDlgProc( HWND, UINT, WPARAM, LPARAM );

//------------------------------------------------------------------------------
// SInspect interface messages
//
#define PI_GETOBJECTNAME   1
#define PI_GETPROPERTIES   2
#define PI_GETVALUE        3
#define PI_SETVALUE        4
#define PI_SETDEFAULT      5
#define PI_GETCUSTOMPROP   7
#define PI_INITPROP        8
#define PI_KILLSELECT      9
#define PI_CREATECUSTOMPG 10
#define PI_GONE           11


//------------------------------------------------------------------------------
// SInspect Property flags
//

// Presentation style flags
#define PPF_CTL3D             0x00000001L // Use CTL3D for 3D effects
#define PPF_BWCC              0x00000002L // Use BWCC for 3D effects 
#define PPF_3DLIST            0x00000004L // Use a 3D list for properties
#define PPF_TABS              0x00000008L // Use a tabs instead of list

// Generic flags
#define PIF_MULTPROP          0x00000001L // Property exposed during multiple object inspection
#define PIF_DEFVALUE          0x00000002L // Property has a default value
#define PIF_COMPOUND          0x00000004L // Property is compound (PIF_DEFVALUE ignored)


// Property specific flags

//PROPID_NAME
#define PIF_NAME_MANUAL          0x00010000L // Updates only after Apply btn is clicked
#define PIF_NAME_MULTILINE       0x00020000L // Use multiline edit

//PROPID_LISTSINGLE
#define PIF_LISTSINGLE_ORD       0x00000000L // Selected ordinal as value (default)
#define PIF_LISTSINGLE_STR       0x00010000L // Selected string as value

//PROPID_INTEGER
#define PIF_INTEGER_UNSIGNED     0x00010000L // Integer value is unsigned

//PROPID_LISTSINGLEBITMAP
#define PIF_LISTBITMAP_NOMATRIX  0x00000000L // Supply separate bitmaps for each item (default)
#define PIF_LISTBITMAP_HMATRIX   0x00010000L // Using a bitmap matrix, horizontally oriented
#define PIF_LISTBITMAP_VMATRIX   0x00020000L // Using a bitmap matrix, vertically oriented

//------------------------------------------------------------------------------
// Struct used for Inspector/Object interface
//
struct SInspectStruct
{
   UINT uMessage;  // One of the PI_xxx messages
   UINT uProperty; // The property index
   
   union           // The value in and out
   {
      void  *pValue;  
      int   iValue;  
      UINT  uValue;
      LONG  lValue;  
      DWORD dwValue; 
      LPSTR pszValue;
   };
};

//------------------------------------------------------------------------------
// List of objects to inspect (NULL terminated)
//
struct SInspectObjList
{
   void *pObj;         // Ptr to an object you want to inspect
   SInspectObjList *next;
};


//------------------------------------------------------------------------------
// Callback typedefs
//
typedef BOOL (CALLBACK *SINSPECTPROC)( void *pSelf, SInspectStruct *pstSInspect );
typedef BOOL (CALLBACK *CUSTOMDLGPROC)( SInspectObjList *objList, HWND, UINT, WPARAM, LPARAM );

// Callback type for adding strings to the PROPID_LISTxxx properties
typedef void (CALLBACK *ADDSTRINGPROC)( LPSTR pszListItem );


//------------------------------------------------------------------------------
// Info used to construct an SPropGroup derivative (or a custom property)
//
struct stPropGroup
{
   UINT uID;          // Identifier for property type
   HINSTANCE hInst;   // Instance containing the dlg resource   
   char szDlgRes[16]; // Dlg resource
   
   CUSTOMDLGPROC pfPropDlg; // Dlg handler for custom properties (NULL if stock property)
};

//------------------------------------------------------------------------------
// Struct used by client to register properties
//
struct stPropInfo
{
   UINT uID;            // ID used by client to distinguish the property
   UINT uPropTypeID;    // Identifies the built-in or custom property type to use (e.g., PROPID_xxx)
   UINT uIDStringName;  // ID for string name client provides for the property (e.g., "Eye Color")
   UINT uIDStringHelp;  // ID for help text string client provides for the property
   HINSTANCE hInst;     // Where the string resources are found
   LONG lPropFlags;     // One or more of the PIF_xxx flags
   UINT uGroupID;       // Identifies a compound property group (or NULL if leaf node)
};

//------------------------------------------------------------------------------
// Property specific data types
//

// PROPID_FONT
struct FONTINFOSTRUCT
{
   char     szFace[LF_FACESIZE+1];
   UINT     uPoints;
   unsigned bBold      :  1,
            bItalic    :  1,
            bUnderline :  1,
            bPrinter   :  1,
            UNUSED1    : 12;
};

// PROPID_DATAFILE
struct BITMAPFILESTRUCT
{
   char szDataFile[255]; // File name
   BOOL bStretch;        // Stretch bitmap?
};

// PROPID_MARGINS
struct MARGINSSTRUCT
{
   int iLeft;
   int iTop;
   int iRight;
   int iBottom;   
};

// PROPID_LISTSINGLEBITMAP
struct LISTSINGLEBITMAPSTRUCT
{
   UINT uIdBmp;  // Id of bitmap matrix
   UINT uItems;  // Number of items in matrix
};

// PROPID_COMPOUND
struct COMPOUNDSTRUCT
{
   UINT uIdIcon;         // Id of icon or bitmap
   char *pszDescription; // Description of property
};


//------------------------------------------------------------------------------
// Exported functions
//

BOOL FAR PASCAL OTCompInspectLists( SInspectObjList *Source1, SInspectObjList *Source2 );

BOOL FAR PASCAL OTIsInspectMessage( MSG *pMsg );

HWND FAR PASCAL OTInspect( SINSPECTPROC     pfInspectProc, 
                           SInspectObjList *pObj, 
                           LONG             lStyle,
                           BOOL             bForce = TRUE );

#endif // _OTAPI_H