//*****************************************************************************
//*****************************************************************************

#ifndef _OTCUSTOM_H
#define _OTCUSTOM_H

#include "popup.h"
#include "otapi.h"

//
// Custom dialog control IDs must be between IDC_FIRST_CNTL and IDC_LAST_CNTL
//
#define IDC_FIRST_CNTL                        100
#define IDC_LAST_CNTL                         999

//
// Forware decl' classes
//
class _export SPropGroup;

// Struct used by client to create an instance of its custom property
struct stCustomPG
{
   SWindow *    inspector;    // Ptr to the SInspector obj needed for construction
   stPropGroup *pstPropGroup; // Prop group info needed for construction
   stPropInfo * pstPropInfo;  // Registration info needed for construction      
   SPropGroup * propGroup;    // Ptr to the instance of custom prop group
};

// Union describes an undo/redo value
union UndoRedoValue
{
   void  *pValue;  
   int   iValue;  
   UINT  uValue;
   LONG  lValue;  
   DWORD dwValue; 
   LPSTR pszValue;
};

// Struct defines the undo/redo stacks
struct UndoRedoStack
{
   UndoRedoValue urValue;   
   UndoRedoStack *next;
};

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//
// class SPropGroup represents a property grouping (maps to
// an item in the Properties listbox/tab box).  This class serves as
// the base class for all property groups.  This is an abstract
// class.
//
//-------------------------------------------------------------------------
class OTCLASS SPropGroup : public SWindow
{
public:
   SPropGroup( SWindow *parent, stPropGroup *pstProp, stPropInfo *pstInfo );
   ~SPropGroup();
   
   virtual BOOL CreateWin( LPSTR pszTitle = NULL );
   
   virtual void ShowGroup();
   virtual void DisplayValue( UndoRedoValue &urValue ) = 0;
   
   virtual void Update();
   
protected:
   virtual LONG HandleMessage( UINT, WPARAM, LPARAM );   
   virtual BOOL HandlePropMessage( UINT uMessage, WPARAM wParam, LPARAM );
   
   // Methods for setting property values
   void SetProp_iValue( int iValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   void SetProp_pValue( void *pValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   void SetProp_uValue( UINT uValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   void SetProp_lValue( LONG lValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   void SetProp_dwValue( DWORD dwValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   void SetProp_pszValue( LPSTR pszValue, BOOL bAll = TRUE, BOOL bUndoStack = TRUE );
   // Methods for getting property values
   int   GetProp_iValue( BOOL bAll = TRUE, BOOL bInit = FALSE );
   void *GetProp_pValue( BOOL bAll = TRUE, BOOL bInit = FALSE );
   void  GetProp_pValue( void *pValue, BOOL bAll, BOOL bInit = FALSE );
   UINT  GetProp_uValue( BOOL bAll = TRUE, BOOL bInit = FALSE );
   LONG  GetProp_lValue( BOOL bAll = TRUE, BOOL bInit = FALSE );
   DWORD GetProp_dwValue( BOOL bAll = TRUE, BOOL bInit = FALSE );
   LPSTR GetProp_pszValue( BOOL bAll = TRUE, BOOL bInit = FALSE );

   //
   // UndoRedo stack/list operations
   //
   void URStackPush( UndoRedoStack *&urStack, UndoRedoValue urValue );
   BOOL URStackPop( UndoRedoStack *&urStack, UndoRedoValue &urValue );    
   void URListAppend( UndoRedoStack *&urList, UndoRedoValue urValue );
   BOOL URListRemove( UndoRedoStack *&urList, UndoRedoValue &urValue );
   void URStackDelete( UndoRedoStack *&urStack );
   
   virtual void UndoStackPush( UndoRedoValue urValue ); 
   virtual BOOL UndoStackPop( UndoRedoValue &urValue ); 
   virtual void RedoStackPush( UndoRedoValue urValue ); 
   virtual BOOL RedoStackPop( UndoRedoValue &urValue ); 
   virtual void InitListAppend( UndoRedoValue urValue ); 
   virtual BOOL InitListRemove( UndoRedoValue &urValue );
   
   virtual void AllocStackData( UndoRedoValue &urValue ) {};
   virtual void DeallocStackData( UndoRedoValue &urValue ) {};
   
   virtual BOOL AllocData( UndoRedoValue &urValue, BOOL bInitValue = FALSE );      
   
   //
   // Undo/Redo methods
   //
   virtual void Undo();
   virtual void Redo();

   virtual void Reset();
   virtual void Default();

protected:
   UINT      uPropID;
   UINT      uClientPropID;
   HINSTANCE hInstDlgRes;
   HINSTANCE hInstStringRes;   
   LPSTR     pszDlgRes;   
   UINT      uIDStringName;
   UINT      uIDStringHelp;
   LONG      lPropFlags;     
   UINT      uGroupID;       
   
   BOOL      bExpanded;

   SINSPECTPROC pfSInspectProc;
   
   SInspectObjList *pObj;                   
   UINT uNumObjs;      
   
   BOOL bDirty;               
   UndoRedoStack *initList;  // A list of initial values for each of the selected object[s]
   
   UndoRedoStack *undoStack; // A stack containing all value changes
   UndoRedoStack *redoStack; // A stack containing all undone value changes

   static char szHelp[255];   
   static FARPROC pfPropGroupDlgProc;   
   static stPropGroup *pgArray;      
};

#endif //_OTCUSTOM_H

