/*****************************************************************************
*****************************************************************************/

#ifndef _POPUP_H
#define _POPUP_H

#include "swin.h"

#define POPUP_WINCLASS "SPopupClass"
#define POPUPCLIENT_WINCLASS "SPopupClientClass"

// SPopup window artificial system menu
#define IDM_POPUP_SYSMOVE  100
#define IDM_POPUP_SYSSIZE  101
#define IDM_POPUP_SYSCLOSE 102

// Forward decl classes
class OTCLASS SPopupClient;

//-------------------------------------------------------------------------
//
class OTCLASS SPopup : public SWindow
{
   friend SPopupClient;
   
public:
   SPopupClient *pClientWin; // Client window (child of frame)
   
public:
   SPopup( LPSTR pszClassName = POPUP_WINCLASS );
   virtual ~SPopup();

   BOOL CreateWin( LPSTR pszTitle = NULL );
   
protected:
   virtual LONG Other( UINT, WPARAM, LPARAM );
   virtual void Refresh( void ) {};

   // Client window message handlers
   virtual void ClientPaint( HDC hDC ) {}; // do nothing
   virtual LONG ClientOther( UINT, WPARAM, LPARAM, BOOL &bHandled )
   { bHandled = FALSE; return 0L; } // do nothing

protected:
   DWORD dwClientStyle;
   char  szClientClass[128];
   
protected:
   void AlignClient();   
};

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
class _export SPopupClient : public SWindow
{
   friend SPopup;
      
public:
   SPopupClient( SPopup *parent,
                 DWORD dwClientStyle = WS_CHILD | WS_CLIPCHILDREN, 
                 LPSTR pszClassName = POPUPCLIENT_WINCLASS );
                  
   ~SPopupClient();
   
protected:   
   virtual LONG Other( UINT, WPARAM, LPARAM );
   
   // Let owner handle client painting
   virtual void Paint( HDC hDC ) { pOwner->ClientPaint( hDC ); }

protected:
   SPopup *pOwner;
};

#endif //_POPUP_H
