/*****************************************************************************
*****************************************************************************/

#ifndef _SWIN_H
#define _SWIN_H

#define S_WINCLASS "SWindowClass"

// Window property strings for storing SWindow object ptr
#define HIWORDUSERDATA "HI"
#define LOWORDUSERDATA "LO"

#define CLASSNAMELEN 128

#ifdef __DLL__
   #define OTCLASS _export
#else
   #define OTCLASS huge
#endif

//-------------------------------------------------------------------------
//
class OTCLASS SWindow
{
public:
   HWND hWindow;
   
public:
   SWindow( LPSTR pszClassName = S_WINCLASS);
   virtual ~SWindow(); // MUST be virtual (see implementation notes in SWin.c).

   virtual BOOL CreateWin( LPSTR pszTitle = NULL );
   virtual BOOL DestroyWin();
   static SWindow *GetObj( HWND hwnd );

   static LONG FAR PASCAL _export SWinProc( HWND, UINT, WPARAM, LPARAM );
   
protected:
   virtual LONG HandleMessage( UINT, WPARAM, LPARAM );
   
protected:      
   virtual void LinkWindow( HWND hwnd );
   virtual void UnlinkWindow();

   // Message handlers
   virtual void Paint( HDC hDC ) {} // do nothing
   virtual LONG Other( UINT uMessage, WPARAM wParam, LPARAM lParam );

public:
   SWindow *pParent;
   
   char szClassName[CLASSNAMELEN];

   struct
   {
      WNDCLASS wndclass;
      LPSTR    pszTitle;
      DWORD    dwStyle;
      DWORD    dwExStyle;
      RECT     rcPos;
      HMENU    hMenu;
      void     *plParam;
   }createArgs;
   
   FARPROC pfOldWinProc;
   HCURSOR hCursor;
};

#endif //_SWIN_H
